.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XGrabPointer 3X11 "Release 6.4" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XGrabPointer, XUngrabPointer, XChangeActivePointerGrab \- grab the pointer
.SH SYNTAX
int XGrabPointer\^(\^\fIdisplay\fP, \fIgrab_window\fP\^, \fIowner_events\fP\^, \fIevent_mask\fP\^, \fIpointer_mode\fP\^,
               \fIkeyboard_mode\fP\^, \fIconfine_to\fP\^, \fIcursor\fP\^, \fItime\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIgrab_window\fP\^;
.br
      Bool \fIowner_events\fP\^;
.br
      unsigned int \fIevent_mask\fP\^;	
.br
      int \fIpointer_mode\fP\^, \fIkeyboard_mode\fP\^; 
.br
      Window \fIconfine_to\fP\^; 
.br
      Cursor \fIcursor\fP\^; 
.br
      Time \fItime\fP\^; 
.LP
XUngrabPointer\^(\^\fIdisplay\fP, \fItime\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Time \fItime\fP\^;
.LP
XChangeActivePointerGrab\^(\^\fIdisplay\fP, \fIevent_mask\fP\^, \fIcursor\fP\^, \fItime\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      unsigned int \fIevent_mask\fP\^;
.br
      Cursor \fIcursor\fP\^;
.br
      Time \fItime\fP\^;
.SH ARGUMENTS
.IP \fIconfine_to\fP 1i
Specifies the window to confine the pointer in or
.ZN None .
.IP \fIcursor\fP 1i
Specifies the cursor that is to be displayed during the grab or
.ZN None . 
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIevent_mask\fP 1i
Specifies which pointer events are reported to the client.
The mask is the bitwise inclusive OR of the valid pointer event mask bits.
.IP \fIgrab_window\fP 1i
Specifies the grab window.
.IP \fIkeyboard_mode\fP 1i
Specifies further processing of keyboard events.
You can pass 
.ZN GrabModeSync 
or
.ZN GrabModeAsync .
.IP \fIowner_events\fP 1i
Specifies a Boolean value that indicates whether the pointer 
events are to be reported as usual or reported with respect to the grab window 
if selected by the event mask.
.IP \fIpointer_mode\fP 1i
Specifies further processing of pointer events.
You can pass 
.ZN GrabModeSync 
or
.ZN GrabModeAsync .
.IP \fItime\fP 1i
Specifies the time.
You can pass either a timestamp or
.ZN CurrentTime .
.SH DESCRIPTION
The
.ZN XGrabPointer
function actively grabs control of the pointer and returns
.ZN GrabSuccess
if the grab was successful.
Further pointer events are reported only to the grabbing client.
.ZN XGrabPointer
overrides any active pointer grab by this client.
If owner_events is 
.ZN False , 
all generated pointer events
are reported with respect to grab_window and are reported only if
selected by event_mask.
If owner_events is 
.ZN True
and if a generated
pointer event would normally be reported to this client, 
it is reported as usual. 
Otherwise, the event is reported with respect to the
grab_window and is reported only if selected by event_mask.
For either value of owner_events, unreported events are discarded.
.LP
If the pointer_mode is 
.ZN GrabModeAsync , 
pointer event processing continues as usual.
If the pointer is currently frozen by this client, 
the processing of events for the pointer is resumed.
If the pointer_mode is 
.ZN GrabModeSync , 
the state of the pointer, as seen by
client applications,
appears to freeze, and the X server generates no further pointer events
until the grabbing client calls 
.ZN XAllowEvents
or until the pointer grab is released.
Actual pointer changes are not lost while the pointer is frozen;
they are simply queued in the server for later processing.
.LP
If the keyboard_mode is 
.ZN GrabModeAsync , 
keyboard event processing is unaffected by activation of the grab.
If the keyboard_mode is 
.ZN GrabModeSync , 
the state of the keyboard, as seen by
client applications,
appears to freeze, and the X server generates no further keyboard events
until the grabbing client calls 
.ZN XAllowEvents
or until the pointer grab is released.
Actual keyboard changes are not lost while the pointer is frozen;
they are simply queued in the server for later processing.
.LP
If a cursor is specified, it is displayed regardless of what
window the pointer is in.  
If 
.ZN None
is specified,
the normal cursor for that window is displayed
when the pointer is in grab_window or one of its subwindows;
otherwise, the cursor for grab_window is displayed.
.LP
If a confine_to window is specified,
the pointer is restricted to stay contained in that window.
The confine_to window need have no relationship to the grab_window.
If the pointer is not initially in the confine_to window, 
it is warped automatically to the closest edge 
just before the grab activates and enter/leave events are generated as usual. 
If the confine_to window is subsequently reconfigured, 
the pointer is warped automatically, as necessary, 
to keep it contained in the window.
.LP
The time argument allows you to avoid certain circumstances that come up
if applications take a long time to respond or if there are long network
delays.
Consider a situation where you have two applications, both
of which normally grab the pointer when clicked on.
If both applications specify the timestamp from the event, 
the second application may wake up faster and successfully grab the pointer
before the first application. 
The first application then will get an indication that the other application 
grabbed the pointer before its request was processed.
.LP
.ZN XGrabPointer 
generates
.ZN EnterNotify 
and
.ZN LeaveNotify 
events.
.LP
Either if grab_window or confine_to window is not viewable
or if the confine_to window lies completely outside the boundaries of the root
window,
.ZN XGrabPointer
fails and returns
.ZN GrabNotViewable .
If the pointer is actively grabbed by some other client,
it fails and returns
.ZN AlreadyGrabbed .
If the pointer is frozen by an active grab of another client,
it fails and returns
.ZN GrabFrozen .
If the specified time is earlier than the last-pointer-grab time or later 
than the current X server time, it fails and returns
.ZN GrabInvalidTime .
Otherwise, the last-pointer-grab time is set to the specified time
.Pn ( CurrentTime 
is replaced by the current X server time).
.LP
.ZN XGrabPointer
can generate
.ZN BadCursor ,
.ZN BadValue ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XUngrabPointer
function releases the pointer and any queued events
if this client has actively grabbed the pointer from
.ZN XGrabPointer ,
.ZN XGrabButton ,
or from a normal button press.
.ZN XUngrabPointer
does not release the pointer if the specified
time is earlier than the last-pointer-grab time or is later than the
current X server time.
It also generates 
.ZN EnterNotify 
and 
.ZN LeaveNotify 
events.
The X server performs an 
.ZN UngrabPointer 
request automatically if the event window or confine_to window 
for an active pointer grab becomes not viewable
or if window reconfiguration causes the confine_to window to lie completely
outside the boundaries of the root window.
.LP
The
.ZN XChangeActivePointerGrab
function changes the specified dynamic parameters if the pointer is actively
grabbed by the client and if the specified time is no earlier than the
last-pointer-grab time and no later than the current X server time.
This function has no effect on the passive parameters of a
.ZN XGrabButton .
The interpretation of event_mask and cursor is the same as described in
.ZN XGrabPointer .
.LP
.ZN XChangeActivePointerGrab
can generate a
.ZN BadCursor 
and
.ZN BadValue
error.
.SH DIAGNOSTICS
.TP 1i
.ZN BadCursor
A value for a Cursor argument does not name a defined Cursor.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllowEvents(3X11),
XGrabButton(3X11),
XGrabKey(3X11),
XGrabKeyboard(3X11)
.br
\fI\*(xL\fP
