/* $XConsortium: xkbdebug.c /main/8 1996/02/05 11:44:35 kaleb $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBproto.h>

static	char		*dpyName = NULL;
static	unsigned	 flags = 0;
static	unsigned	 mask = 0;
static	unsigned	 ctrls_mask = 0;
static	unsigned	 ctrls = 0;
static 	char		*msg= NULL;

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int i;
unsigned on= 0;
unsigned off= 0;

    if ((argc>1)&&(isdigit(argv[1][0]))) {
	unsigned int tmp;
	if (sscanf(argv[1],"%i",&tmp)!=1) {
	    fprintf(stderr,"Flag specification must be an integer\n");
	    return 0;
	}
	mask= ~0;
	flags= tmp;
	if (argc>2)
	    msg= argv[2];
	if (argc>3) {
	    fprintf(stderr,"Warning! Extra options on command line\n");
	    for (tmp=3;tmp<argc;tmp++) {
		fprintf(stderr,"         %s ignored\n",argv[tmp]);
	    }
	}
	return 1;
    }
    for (i=1;i<argc;i++) {
	if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-on")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&on)!=1) {
		    fprintf(stderr,"Flag specification must be an integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify flags with -on option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-off")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&off)!=1) {
		    fprintf(stderr,"Flag specification must be an integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify flags with -off option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-msg")==0 ) {
	    if ( ++i<argc )
		msg= argv[i];
	}
	else if ( strcmp(argv[i],"-nolock")==0 ) {
	    ctrls_mask|= XkbDF_DisableLocks;
	    ctrls|= XkbDF_DisableLocks;
	}
	else if ( strcmp(argv[i],"-lock")==0 ) {
	    ctrls_mask|= XkbDF_DisableLocks;
	    ctrls&= ~XkbDF_DisableLocks;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    if (on&off) {
	fprintf(stderr,"Warning! On and off (0x%x and 0x%x) overlap\n",on,off);
	fprintf(stderr,"         Conflicting flags will be turned on\n");
    }
    flags= on;
    mask= (on|off);
    return 1;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
Display	*	dpy;
int		major,minor,why;
unsigned int	rtrnFlags;
unsigned int	rtrnCtrls;

  
    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s [<options>] or %s <flags> [ <message> ]\n",
								argv[0]);
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display <dpy>     specifies display to use\n");
	fprintf(stderr,"-on      <flags>   debugging flags to turn on\n");
	fprintf(stderr,"-off     <flags>   debugging flags to turn off\n");
	fprintf(stderr,"-msg     <message> message to print in log\n");
	fprintf(stderr,"-nolock            disable locking and latching\n");
	fprintf(stderr,"If no options are specified, %s prints the current\n",
								argv[0]);
	fprintf(stderr,"value of the server debugging flags and returns.\n");
	fprintf(stderr,"The second form sets the server debugging flags to\n");
	fprintf(stderr,"exactly <flags> and prints <message>, if specified,\n");
	fprintf(stderr,"to the log file.\n");
	return 1;
    }
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    XSynchronize(dpy,1);
    XkbSetDebuggingFlags(dpy,mask,flags,msg,ctrls_mask,ctrls,&rtrnFlags,
								&rtrnCtrls);
    if (mask)
	 fprintf(stderr,"Debugging flags set to 0x%x\n",rtrnFlags);
    else fprintf(stderr,"Current debuggging flags: 0x%x\n",rtrnFlags);
    if (ctrls_mask)
	 fprintf(stderr,"Debugging controls set to: 0x%x\n",rtrnCtrls);
    else fprintf(stderr,"Current debugging controls: 0x%x\n",rtrnCtrls);

    fprintf(stderr,"Locks are %sabled\n",
				((rtrnCtrls&XkbDF_DisableLocks)?"dis":"en"));
    XCloseDisplay(dpy);
    return 0;
}
