.TH XCLOCK 1 "1 March 1988" "X Version 11"
.SH NAME
xclock - analog / digital clock for X
.SH SYNOPSIS
.B xclock
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The
.I xclock 
program displays the time in analog or digital form.  The time is continuously
updated at a frequency which may be specified by the user.  This program is
nothing more than a wrapper around the Athena Clock widget.
.SH OPTIONS
.I Xclock
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on the standard error.
.TP 8
.B \-analog 
This option indicates that a conventional 12 hour clock face with ticks marks
and hands should be used.  This is the default.
.TP 8
.B \-digital
This option indicates that a 24 hour digital clock should be used.
.TP 8
.B \-chime
This option indicates that the clock should chime 
once on the half hour and twice on the hour.
.TP 8
.B \-hd \fIcolor\fP
This option specifies the color of the hands on an analog clock.  The default
is ``black''.
.TP 8
.B \-hl \fIcolor\fP
This option specifies the color of the edges of the hands on an analog clock,
and is only useful on color displays.  The default is ``black''.
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which \fIxclock\fP
should update its display.  If the clock is obscured and then exposed,
it will be updated immediately.  A value of less than 30 seconds will enable a
second hand on an analog clock.  The default is 60 seconds.
.TP 8
.B \-padding \fInumber\fP
This option specifies the width in pixels of the padding 
between the window border and clock text or picture.  The default is 10
on a digital clock and 8 on an analog clock.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xclock:
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is ``white.''
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is ``black.''
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text.  The default is 
``black''.
.TP 8
.B \-fn \fIfont\fP
This option specifies the font to be used for displaying normal text.  The
default is ``6x10.''
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the prefered size and position of the clock window.
.TP 8
.B \-display \fIhost\fP:\fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH X DEFAULTS
This program uses the 
.I Clock
widget in the X Toolkit.  It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the clock.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the clock.
.TP 8
.B update (\fPclass\fB Interval)
Specifies the frequency in seconds at which the time should be redisplayed.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the tic marks.  Using the class specifies the
color for all things that normally would appear in the foreground color.
The default is ``black'' since the core default for background is ``white.''
.TP 8
.B hand (\fPclass\fB Foreground)
Specifies the color of the insides of the clock's hands.
.TP 8
.B high (\fPclass\fB Foreground)
Specifies the color used to highlight the clock's hands.
.TP 8
.B analog (\fPclass\fB Boolean)
Specifies whether or not an analog clock should be used instead of a digital
one.  The default is True.
.TP 8
.B chime (\fPclass\fB Boolean)
Specifies whether or not a bell should be rung on the hour and half hour.
.TP 8
.B padding (\fPclass\fB Margin)
Specifies the amount of internal padding in pixels to be used.  The default is
8.
.TP 8
.B font (\fPclass\fB Font)
Specifies the font to be used for the digital clock.  Note that variable width
fonts currently will not always display correctly.
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background colors should be reversed.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1), xrdb(1), time(3C), Athena Clock widget
.SH BUGS
.I Xclock
believes the system clock.
.PP
When in digital mode, the string should be centered automatically.
.PP
When specifying an offset, the grammar requires an hours field but if
only minutes are given they will be quietly ignored.  A negative offset
of less than 1 hour is treated as a positive offset.
.PP
Digital clock windows default to the analog clock size.
.PP
Border color has to be explicitly specified when reverse video is used.
.PP
When the update is an even divisor of 60 seconds, the second hand should
always be on a multiple of the update time.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Tony Della Fera (MIT-Athena, DEC)
.br
Dave Mankins (MIT-Athena, BBN)
.br
Ed Moy (UC Berkeley)

