" Vim completion script
" Language:	PHP
" Maintainer:	Mikolaj Machowski ( mikmach AT wp DOT pl )
" Last Change:	2006 Mar 9
"
"
"  - outside of <?php?> getting parent tag may cause problems. Heh, even in
"    perfect conditions GetLastOpenTag doesn't cooperate... Inside of
"    phpStrings this can be even a bonus but outside of <?php?> it is not the
"    best situation
" - Switching to HTML completion (SQL) inside of phpStrings

function! phpcomplete#CompletePHP(findstart, base)
	if a:findstart
		unlet! b:php_menu
		" Check if we are inside of PHP markup
		let pos = getpos('.')
		let phpbegin = searchpairpos('<?', '', '?>', 'bWn','synIDattr(synID(line("."), col("."), 0), "name") =~? "string\|comment"')
		let phpend = searchpairpos('<?', '', '?>', 'Wn','synIDattr(synID(line("."), col("."), 0), "name") =~? "string\|comment"')
		" TODO: deal with opened <? but without closing ?>

		if phpbegin == [0,0] && phpend == [0,0]
			" We are outside of any PHP markup. Complete HTML
			let htmlbegin = htmlcomplete#CompleteTags(1, '')
			let cursor_col = pos[2]
			let base = getline('.')[htmlbegin : cursor_col]
			let b:php_menu = htmlcomplete#CompleteTags(0, base)
			return htmlbegin
		else
			" locate the start of the word
			let line = getline('.')
			let start = col('.') - 1
			let curline = line('.')
			let compl_begin = col('.') - 2
			while start >= 0 && line[start - 1] =~ '[a-zA-Z_0-9\x7f-\xff$]'
				let start -= 1
			endwhile
			let b:compl_context = getline('.')[0:compl_begin]
			return start

			" We can be also inside of phpString with HTML tags. Deal with
			" it later (time, not lines).
		endif
	else
		" If exists b:php_menu it means completion was already constructed we
		" don't need to do anything more
		if exists("b:php_menu")
			return b:php_menu
		endif
		" Initialize base return lists
		let res = []
		let res2 = []
		" a:base is very short - we need context
		if exists("b:compl_context")
			let context = b:compl_context
			unlet! b:compl_context
		endif

		let scontext = substitute(context, '\$\?[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*$', '', '')

		if scontext =~ 'new\s*$'
			" Complete class name
			" Internal solution for finding classes in current file.
			let file = getline(1, '$')
			call filter(file, 'v:val =~ "class\\s\\+[a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*\\s*("')
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			let jfile = join(file, ' ')
			let int_values = split(jfile, 'class\s\+')
			let int_classes = {}
			for i in int_values
				let c_name = matchstr(i, '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
				let int_classes[c_name] = ''
			endfor

			" Prepare list of functions from tags file
			let ext_classes = {}
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			if fnames != ''
				exe 'silent! vimgrep /^'.a:base.'.*\tc\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				for field in qflist
					let item = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
					" Don't show name - in PHP classes usually are in their
					" own files, showing names will only add clutter
					" let fname = matchstr(field['text'], 
					" \ '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					let ext_classes[item] = ''
				endfor
			endif

			call extend(int_classes, ext_classes)

			for m in sort(keys(int_classes))
				if m =~ '^'.a:base
					call add(res, m)
				elseif m =~ a:base
					call add(res2, m)
				endif
			endfor

			let int_list = res + res2

			let final_menu = []
			for i in int_list
				let final_menu += [{'word':i, 'menu':int_classes[i]}, 'kind':'c']
			endfor

			return final_menu

		elseif scontext =~ '\(->\|::\)$'
			" Complete user functions and variables
			" Internal solution for current file.
			" That seems as unnecessary repeating of functions but there are
			" few not so subtle differences as not appeding of $ and addition
			" of 'kind' tag (not necessary in regular completion)
			let file = getline(1, '$')
			let jfile = join(file, ' ')
			let int_vals = split(jfile, '\$')
			"call map(int_values, 'matchstr(v:val, "^[a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*")')
			let int_values = []
			for i in int_vals
				if i =~ '^\$[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*=\s*new'
					let val = matchstr(i, '^\$[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*').'->'
				else
					let val = matchstr(i, '^\$[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
				endif
				let int_values += [val]
			endfor
			
			let int_vars = {}
			for i in int_values
				if i != ''
					let int_vars[i] = ''
				endif
			endfor

			" ctags has good support for PHP, use tags file for external
			" variables
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			let ext_vars = {}
			if fnames != ''
				let sbase = substitute(a:base, '^\$', '', '')
				exe 'silent! vimgrep /^'.sbase.'.*\tv\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				for field in qflist
					" Add space to make more space between 'word' and 'menu'
					let item = matchstr(field['text'], '^\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
					" Filename is unnecessary - and even darkens situation
					" let fname = ' '.matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					" Add -> if it is possible object declaration
					if field['text'] =~ item.'\s*=\s*new\s*'
						let item = item.'->'
						let classname = matchstr(field['text'], 
									\ '=\s*new\s*\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
					endif
					let ext_vars[item] = classname
				endfor
			endif

			" Now we have all variables in int_vars dictionary
			call extend(int_vars, ext_vars)

			" Internal solution for finding functions in current file.
			let file = getline(1, '$')
			call filter(file, 'v:val =~ "function\\s\\+&\\?[a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*\\s*("')
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			let jfile = join(file, ' ')
			let int_values = split(jfile, 'function\s\+')
			let int_functions = {}
			for i in int_values
				let f_name = matchstr(i, '^&\?\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
				let f_args = matchstr(i, '^&\?[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*(\zs.\{-}\ze)')
				let int_functions[f_name.'('] = f_args
			endfor

			" Prepare list of functions from tags file
			let ext_functions = {}
			if fnames != ''
				exe 'silent! vimgrep /^'.a:base.'.*\tf\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				let ext_functions = {}
				for field in qflist
					" File name
					let item = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
					let fname = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					let prototype = matchstr(field['text'], 'function\s\+[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*(\zs.\{-}\ze)')
					if prototype == ''
						let prototype = '()'
					endif
					let ext_functions[item.'('] = prototype.' - '.fname
				endfor
			endif

			let all_values = {}
			call extend(all_values, int_functions)
			call extend(all_values, ext_functions)
			call extend(all_values, int_vars)

			for m in sort(keys(all_values))
				if m =~ '^'.a:base
					call add(res, m)
				elseif m =~ a:base
					call add(res2, m)
				endif
			endfor

			let start_list = res + res2

			let final_list = []
			for i in start_list
				if has_key(int_vars, i)
					let final_list += [{'word':i, 'menu':all_values[i], 'kind':'v'}]
				else
					let final_list += [{'word':i, 'menu':all_values[i], 'kind':'f'}]
				endif
			endfor

			return final_list
		endif

		if a:base =~ '^\$'
			" Complete variables
			let b:php_builtin_vars = ['$GLOBALS', '$_SERVER', '$_GET', '$_POST', '$_COOKIE', 
				\ '$_FILES', '$_ENV', '$_REQUEST', '$_SESSION', '$HTTP_SERVER_VARS',
				\ '$HTTP_ENV_VARS', '$HTTP_COOKIE_VARS', '$HTTP_GET_VARS', '$HTTP_POST_VARS',
				\ '$HTTP_POST_FILES', '$HTTP_SESSION_VARS', '$php_errormsg', '$this',
				\ ]

			" Internal solution for current file.
			let file = getline(1, '$')
			let jfile = join(file, ' ')
			let int_vals = split(jfile, '\ze\$')
			" call map(int_values, 'matchstr(v:val, "^\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*")')
			let int_values = []
			for i in int_vals
				if i =~ '^\$[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*=\s*new'
					let val = matchstr(i, '^\$[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*').'->'
				else
					let val = matchstr(i, '^\$[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
				endif
				let int_values += [val]
			endfor


			"call map(int_values, '"$".v:val')
			"
			let int_values += b:php_builtin_vars

			
			for m in sort(int_values)
				if m =~ '^'.a:base
					call add(res, m)
				elseif m =~ a:base
					call add(res2, m)
				endif
			endfor

			let int_list = res + res2

			let int_dict = []
			for i in int_list
				let int_dict += [{'word':i, 'kind':'v'}]
			endfor

			" ctags has good support for PHP, use tags file for external
			" variables
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			if fnames != ''
				let sbase = substitute(a:base, '^\$', '', '')
				exe 'silent! vimgrep /^'.sbase.'.*\tv\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				let ext_dict = []
				for field in qflist
					" Filename is unnecessary - and even darkens situation
					" let m_menu = matchstr(field['text'], 
					" \ '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					let m_menu = ''
					let item = '$'.matchstr(field['text'], 
								\ '^\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
					" Add -> if it is possible object declaration
					if field['text'] =~ item.'\s*=\s*new\s*'
						let item = item.'->'
						let classname = matchstr(field['text'], 
									\ '=\s*new\s*\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
						let m_menu = classname
					endif
					
					let ext_dict += [{'word':item, 'menu':m_menu, 'kind':'v'}]
				endfor
			else
				let ext_dict = []
			endif

			let b:php_menu = int_dict + ext_dict

			return b:php_menu

		else
			" Complete everything else - 
			"  + functions,  DONE
			"  + keywords of language DONE
			"  + defines (constant definitions), DONE
			"  + extend keywords for predefined constants, DONE
			"  + classes (after new), DONE
			"  - limit choice after -> and :: to funcs and vars
			if !exists('b:php_builtin_functions')
				call phpcomplete#LoadData()
			endif

			" Internal solution for finding functions in current file.
			let file = getline(1, '$')
			call filter(file, 'v:val =~ "function\\s\\+&\\?[a-zA-Z_\\x7f-\\xff][a-zA-Z_0-9\\x7f-\\xff]*\\s*("')
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			let jfile = join(file, ' ')
			let int_values = split(jfile, 'function\s\+')
			let int_functions = {}
			for i in int_values
				let f_name = matchstr(i, '^&\?\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze')
				let f_args = matchstr(i, '^&\?[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*(\zs.\{-}\ze)')
				let int_functions[f_name.'('] = f_args
			endfor

			" Prepare list of functions from tags file
			let ext_functions = {}
			if fnames != ''
				exe 'silent! vimgrep /^'.a:base.'.*\tf\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				for field in qflist
					" File name
					let item = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
					let fname = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					let prototype = matchstr(field['text'], 'function\s\+[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s*(\zs.\{-}\ze)')
					if prototype == ''
						let prototype = '()'
					endif
					let ext_functions[item.'('] = prototype.' - '.fname
				endfor
			endif

			" All functions
			call extend(int_functions, ext_functions)
			call extend(int_functions, b:php_builtin_functions)

			" Internal solution for finding constants in current file
			let file = getline(1, '$')
			call filter(file, 'v:val =~ "define\\s*("')
			let jfile = join(file, ' ')
			let int_values = split(jfile, 'define\s*(\s*')
			let int_constants = {}
			for i in int_values
				let c_name = matchstr(i, '\(["'']\)\zs[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\ze\1')
				" let c_value = matchstr(i, 
				" \ '\(["'']\)[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\1\s*,\s*\zs.\{-}\ze\s*)')
				let int_constants[c_name] = '' " c_value
			endfor

			" Prepare list of constants from tags file
			let fnames = join(map(tagfiles(), 'escape(v:val, " \\")'))
			let ext_constants = {}
			if fnames != ''
				exe 'silent! vimgrep /^'.a:base.'.*\td\(\t\|$\)/j '.fnames
				let qflist = getqflist()
				let ext_constants = {}
				for field in qflist
					" File name
					let item = matchstr(field['text'], '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*')
					" Origin of definition and value only are only darkening
					" image - drop it but leave regexps. They may be needed in
					" future.
					" let fname = matchstr(field['text'], 
					" \ '^[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\s\+\zs\f\+\ze')
					" let cvalue = matchstr(field['text'], 
					" \ 'define\s*(\s*\(["'']\)[a-zA-Z_\x7f-\xff][a-zA-Z_0-9\x7f-\xff]*\1\s*,\s*\zs.\{-}\ze\s*)')
					let ext_constants[item] = ''
				endfor
			endif

			" All constants
			call extend(int_constants, ext_constants)
			" Treat keywords as constants
			call extend(int_constants, b:php_keywords)

			let all_values = {}

			" One big dictionary of functions
			call extend(all_values, int_functions)

			" Add constants
			call extend(all_values, int_constants)

			for m in sort(keys(all_values))
				if m =~ '^'.a:base
					call add(res, m)
				elseif m =~ a:base
					call add(res2, m)
				endif
			endfor

			let int_list = res + res2

			let final_list = []
			for i in int_list
				if has_key(int_functions, i)
					let final_list += [{'word':i, 'menu':int_functions[i], 'kind':'f'}]
				elseif has_key(int_constants, i)
					let final_list += [{'word':i, 'menu':int_constants[i], 'kind':'d'}]
				else
					let final_list += [{'word':i}]
				endif
			endfor

			return final_list

		endif

	endif
endfunction

function! phpcomplete#LoadData() " {{{
" Keywords/reserved words, all other special things {{{
" Later it is possible to add some help to values, or type of
" defined variable
let b:php_keywords = {
\ 'PHP_SELF':'',
\ 'argv':'',
\ 'argc':'',
\ 'GATEWAY_INTERFACE':'',
\ 'SERVER_ADDR':'',
\ 'SERVER_NAME':'',
\ 'SERVER_SOFTWARE':'',
\ 'SERVER_PROTOCOL':'',
\ 'REQUEST_METHOD':'',
\ 'REQUEST_TIME':'',
\ 'QUERY_STRING':'',
\ 'DOCUMENT_ROOT':'',
\ 'HTTP_ACCEPT':'',
\ 'HTTP_ACCEPT_CHARSET':'',
\ 'HTTP_ACCEPT_ENCODING':'',
\ 'HTTP_ACCEPT_LANGUAGE':'',
\ 'HTTP_CONNECTION':'',
\ 'HTTP_POST':'',
\ 'HTTP_REFERER':'',
\ 'HTTP_USER_AGENT':'',
\ 'HTTPS':'',
\ 'REMOTE_ADDR':'',
\ 'REMOTE_HOST':'',
\ 'REMOTE_PORT':'',
\ 'SCRIPT_FILENAME':'',
\ 'SERVER_ADMIN':'',
\ 'SERVER_PORT':'',
\ 'SERVER_SIGNATURE':'',
\ 'PATH_TRANSLATED':'',
\ 'SCRIPT_NAME':'',
\ 'REQUEST_URI':'',
\ 'PHP_AUTH_DIGEST':'',
\ 'PHP_AUTH_USER':'',
\ 'PHP_AUTH_PW':'',
\ 'AUTH_TYPE':'',
\ 'and':'',
\ 'or':'',
\ 'xor':'',
\ '__FILE__':'',
\ 'exception':'',
\ '__LINE__':'',
\ 'as':'',
\ 'break':'',
\ 'case':'',
\ 'class':'',
\ 'const':'',
\ 'continue':'',
\ 'declare':'',
\ 'default':'',
\ 'do':'',
\ 'echo':'',
\ 'else':'',
\ 'elseif':'',
\ 'enddeclare':'',
\ 'endfor':'',
\ 'endforeach':'',
\ 'endif':'',
\ 'endswitch':'',
\ 'endwhile':'',
\ 'extends':'',
\ 'for':'',
\ 'foreach':'',
\ 'function':'',
\ 'global':'',
\ 'if':'',
\ 'new':'',
\ 'static':'',
\ 'switch':'',
\ 'use':'',
\ 'var':'',
\ 'while':'',
\ '__FUNCTION__':'',
\ '__CLASS__':'',
\ '__METHOD__':'',
\ 'final':'',
\ 'php_user_filter':'',
\ 'interface':'',
\ 'implements':'',
\ 'public':'',
\ 'private':'',
\ 'protected':'',
\ 'abstract':'',
\ 'clone':'',
\ 'try':'',
\ 'catch':'',
\ 'throw':'',
\ 'cfunction':'',
\ 'old_function':'',
\ 'this':'',
\ 'PHP_VERSION': '',
\ 'PHP_OS': '',
\ 'PHP_SAPI': '',
\ 'PHP_EOL': '',
\ 'PHP_INT_MAX': '',
\ 'PHP_INT_SIZE': '',
\ 'DEFAULT_INCLUDE_PATH': '',
\ 'PEAR_INSTALL_DIR': '',
\ 'PEAR_EXTENSION_DIR': '',
\ 'PHP_EXTENSION_DIR': '',
\ 'PHP_PREFIX': '',
\ 'PHP_BINDIR': '',
\ 'PHP_LIBDIR': '',
\ 'PHP_DATADIR': '',
\ 'PHP_SYSCONFDIR': '',
\ 'PHP_LOCALSTATEDIR': '',
\ 'PHP_CONFIG_FILE_PATH': '',
\ 'PHP_CONFIG_FILE_SCAN_DIR': '',
\ 'PHP_SHLIB_SUFFIX': '',
\ 'PHP_OUTPUT_HANDLER_START': '',
\ 'PHP_OUTPUT_HANDLER_CONT': '',
\ 'PHP_OUTPUT_HANDLER_END': '',
\ 'E_ERROR': '',
\ 'E_WARNING': '',
\ 'E_PARSE': '',
\ 'E_NOTICE': '',
\ 'E_CORE_ERROR': '',
\ 'E_CORE_WARNING': '',
\ 'E_COMPILE_ERROR': '',
\ 'E_COMPILE_WARNING': '',
\ 'E_USER_ERROR': '',
\ 'E_USER_WARNING': '',
\ 'E_USER_NOTICE': '',
\ 'E_ALL': '',
\ 'E_STRICT': '',
\ '__COMPILER_HALT_OFFSET__': '',
\ 'EXTR_OVERWRITE': '',
\ 'EXTR_SKIP': '',
\ 'EXTR_PREFIX_SAME': '',
\ 'EXTR_PREFIX_ALL': '',
\ 'EXTR_PREFIX_INVALID': '',
\ 'EXTR_PREFIX_IF_EXISTS': '',
\ 'EXTR_IF_EXISTS': '',
\ 'SORT_ASC': '',
\ 'SORT_DESC': '',
\ 'SORT_REGULAR': '',
\ 'SORT_NUMERIC': '',
\ 'SORT_STRING': '',
\ 'CASE_LOWER': '',
\ 'CASE_UPPER': '',
\ 'COUNT_NORMAL': '',
\ 'COUNT_RECURSIVE': '',
\ 'ASSERT_ACTIVE': '',
\ 'ASSERT_CALLBACK': '',
\ 'ASSERT_BAIL': '',
\ 'ASSERT_WARNING': '',
\ 'ASSERT_QUIET_EVAL': '',
\ 'CONNECTION_ABORTED': '',
\ 'CONNECTION_NORMAL': '',
\ 'CONNECTION_TIMEOUT': '',
\ 'INI_USER': '',
\ 'INI_PERDIR': '',
\ 'INI_SYSTEM': '',
\ 'INI_ALL': '',
\ 'M_E': '',
\ 'M_LOG2E': '',
\ 'M_LOG10E': '',
\ 'M_LN2': '',
\ 'M_LN10': '',
\ 'M_PI': '',
\ 'M_PI_2': '',
\ 'M_PI_4': '',
\ 'M_1_PI': '',
\ 'M_2_PI': '',
\ 'M_2_SQRTPI': '',
\ 'M_SQRT2': '',
\ 'M_SQRT1_2': '',
\ 'CRYPT_SALT_LENGTH': '',
\ 'CRYPT_STD_DES': '',
\ 'CRYPT_EXT_DES': '',
\ 'CRYPT_MD5': '',
\ 'CRYPT_BLOWFISH': '',
\ 'DIRECTORY_SEPARATOR': '',
\ 'SEEK_SET': '',
\ 'SEEK_CUR': '',
\ 'SEEK_END': '',
\ 'LOCK_SH': '',
\ 'LOCK_EX': '',
\ 'LOCK_UN': '',
\ 'LOCK_NB': '',
\ 'HTML_SPECIALCHARS': '',
\ 'HTML_ENTITIES': '',
\ 'ENT_COMPAT': '',
\ 'ENT_QUOTES': '',
\ 'ENT_NOQUOTES': '',
\ 'INFO_GENERAL': '',
\ 'INFO_CREDITS': '',
\ 'INFO_CONFIGURATION': '',
\ 'INFO_MODULES': '',
\ 'INFO_ENVIRONMENT': '',
\ 'INFO_VARIABLES': '',
\ 'INFO_LICENSE': '',
\ 'INFO_ALL': '',
\ 'CREDITS_GROUP': '',
\ 'CREDITS_GENERAL': '',
\ 'CREDITS_SAPI': '',
\ 'CREDITS_MODULES': '',
\ 'CREDITS_DOCS': '',
\ 'CREDITS_FULLPAGE': '',
\ 'CREDITS_QA': '',
\ 'CREDITS_ALL': '',
\ 'STR_PAD_LEFT': '',
\ 'STR_PAD_RIGHT': '',
\ 'STR_PAD_BOTH': '',
\ 'PATHINFO_DIRNAME': '',
\ 'PATHINFO_BASENAME': '',
\ 'PATHINFO_EXTENSION': '',
\ 'PATH_SEPARATOR': '',
\ 'CHAR_MAX': '',
\ 'LC_CTYPE': '',
\ 'LC_NUMERIC': '',
\ 'LC_TIME': '',
\ 'LC_COLLATE': '',
\ 'LC_MONETARY': '',
\ 'LC_ALL': '',
\ 'LC_MESSAGES': '',
\ 'ABDAY_1': '',
\ 'ABDAY_2': '',
\ 'ABDAY_3': '',
\ 'ABDAY_4': '',
\ 'ABDAY_5': '',
\ 'ABDAY_6': '',
\ 'ABDAY_7': '',
\ 'DAY_1': '',
\ 'DAY_2': '',
\ 'DAY_3': '',
\ 'DAY_4': '',
\ 'DAY_5': '',
\ 'DAY_6': '',
\ 'DAY_7': '',
\ 'ABMON_1': '',
\ 'ABMON_2': '',
\ 'ABMON_3': '',
\ 'ABMON_4': '',
\ 'ABMON_5': '',
\ 'ABMON_6': '',
\ 'ABMON_7': '',
\ 'ABMON_8': '',
\ 'ABMON_9': '',
\ 'ABMON_10': '',
\ 'ABMON_11': '',
\ 'ABMON_12': '',
\ 'MON_1': '',
\ 'MON_2': '',
\ 'MON_3': '',
\ 'MON_4': '',
\ 'MON_5': '',
\ 'MON_6': '',
\ 'MON_7': '',
\ 'MON_8': '',
\ 'MON_9': '',
\ 'MON_10': '',
\ 'MON_11': '',
\ 'MON_12': '',
\ 'AM_STR': '',
\ 'PM_STR': '',
\ 'D_T_FMT': '',
\ 'D_FMT': '',
\ 'T_FMT': '',
\ 'T_FMT_AMPM': '',
\ 'ERA': '',
\ 'ERA_YEAR': '',
\ 'ERA_D_T_FMT': '',
\ 'ERA_D_FMT': '',
\ 'ERA_T_FMT': '',
\ 'ALT_DIGITS': '',
\ 'INT_CURR_SYMBOL': '',
\ 'CURRENCY_SYMBOL': '',
\ 'CRNCYSTR': '',
\ 'MON_DECIMAL_POINT': '',
\ 'MON_THOUSANDS_SEP': '',
\ 'MON_GROUPING': '',
\ 'POSITIVE_SIGN': '',
\ 'NEGATIVE_SIGN': '',
\ 'INT_FRAC_DIGITS': '',
\ 'FRAC_DIGITS': '',
\ 'P_CS_PRECEDES': '',
\ 'P_SEP_BY_SPACE': '',
\ 'N_CS_PRECEDES': '',
\ 'N_SEP_BY_SPACE': '',
\ 'P_SIGN_POSN': '',
\ 'N_SIGN_POSN': '',
\ 'DECIMAL_POINT': '',
\ 'RADIXCHAR': '',
\ 'THOUSANDS_SEP': '',
\ 'THOUSEP': '',
\ 'GROUPING': '',
\ 'YESEXPR': '',
\ 'NOEXPR': '',
\ 'YESSTR': '',
\ 'NOSTR': '',
\ 'CODESET': '',
\ 'LOG_EMERG': '',
\ 'LOG_ALERT': '',
\ 'LOG_CRIT': '',
\ 'LOG_ERR': '',
\ 'LOG_WARNING': '',
\ 'LOG_NOTICE': '',
\ 'LOG_INFO': '',
\ 'LOG_DEBUG': '',
\ 'LOG_KERN': '',
\ 'LOG_USER': '',
\ 'LOG_MAIL': '',
\ 'LOG_DAEMON': '',
\ 'LOG_AUTH': '',
\ 'LOG_SYSLOG': '',
\ 'LOG_LPR': '',
\ 'LOG_NEWS': '',
\ 'LOG_UUCP': '',
\ 'LOG_CRON': '',
\ 'LOG_AUTHPRIV': '',
\ 'LOG_LOCAL0': '',
\ 'LOG_LOCAL1': '',
\ 'LOG_LOCAL2': '',
\ 'LOG_LOCAL3': '',
\ 'LOG_LOCAL4': '',
\ 'LOG_LOCAL5': '',
\ 'LOG_LOCAL6': '',
\ 'LOG_LOCAL7': '',
\ 'LOG_PID': '',
\ 'LOG_CONS': '',
\ 'LOG_ODELAY': '',
\ 'LOG_NDELAY': '',
\ 'LOG_NOWAIT': '',
\ 'LOG_PERROR': '',
\ }
" }}}
" PHP builtin functions {{{
" To create from scratch list of functions:
" 1. Download multi html file PHP documentation
" 2. run for i in `ls | grep "^function\."`; do grep -A4 Description $i >> funcs; done 
" 3. Open funcs in Vim and 
"    a) g/Description/normal! 5J
"    b) remove all html tags (it will require few s/// and g//)
"    c) :%s/^\([^[:space:]]\+\) \([^[:space:]]\+\) ( \(.*\))/\\ '\2(': '\3| \1',
"       This will create Dictionary
"    d) remove all /^[^\\] lines
let b:php_builtin_functions = {
\ 'abs(': 'mixed number | number',
\ 'acosh(': 'float arg | float',
\ 'acos(': 'float arg | float',
\ 'addcslashes(': 'string str, string charlist | string',
\ 'addslashes(': 'string str | string',
\ 'aggregate(': 'object object, string class_name | void',
\ 'aggregate_info(': 'object object | array',
\ 'aggregate_methods_by_list(': 'object object, string class_name, array methods_list [, bool exclude] | void',
\ 'aggregate_methods_by_regexp(': 'object object, string class_name, string regexp [, bool exclude] | void',
\ 'aggregate_methods(': 'object object, string class_name | void',
\ 'aggregate_properties_by_list(': 'object object, string class_name, array properties_list [, bool exclude] | void',
\ 'aggregate_properties_by_regexp(': 'object object, string class_name, string regexp [, bool exclude] | void',
\ 'aggregate_properties(': 'object object, string class_name | void',
\ 'apache_child_terminate(': 'void  | bool',
\ 'apache_getenv(': 'string variable [, bool walk_to_top] | string',
\ 'apache_get_modules(': 'void  | array',
\ 'apache_get_version(': 'void  | string',
\ 'apache_lookup_uri(': 'string filename | object',
\ 'apache_note(': 'string note_name [, string note_value] | string',
\ 'apache_request_headers(': 'void  | array',
\ 'apache_reset_timeout(': 'void  | bool',
\ 'apache_response_headers(': 'void  | array',
\ 'apache_setenv(': 'string variable, string value [, bool walk_to_top] | bool',
\ 'apc_cache_info(': '[string cache_type] | array',
\ 'apc_clear_cache(': '[string cache_type] | bool',
\ 'apc_define_constants(': 'string key, array constants [, bool case_sensitive] | bool',
\ 'apc_delete(': 'string key | bool',
\ 'apc_fetch(': 'string key | mixed',
\ 'apc_load_constants(': 'string key [, bool case_sensitive] | bool',
\ 'apc_sma_info(': 'void  | array',
\ 'apc_store(': 'string key, mixed var [, int ttl] | bool',
\ 'apd_breakpoint(': 'int debug_level | bool',
\ 'apd_callstack(': 'void  | array',
\ 'apd_clunk(': 'string warning [, string delimiter] | void',
\ 'apd_continue(': 'int debug_level | bool',
\ 'apd_croak(': 'string warning [, string delimiter] | void',
\ 'apd_dump_function_table(': 'void  | void',
\ 'apd_dump_persistent_resources(': 'void  | array',
\ 'apd_dump_regular_resources(': 'void  | array',
\ 'apd_echo(': 'string output | bool',
\ 'apd_get_active_symbols(': ' | array',
\ 'apd_set_pprof_trace(': '[string dump_directory] | void',
\ 'apd_set_session(': 'int debug_level | void',
\ 'apd_set_session_trace(': 'int debug_level [, string dump_directory] | void',
\ 'apd_set_socket_session_trace(': 'string ip_address_or_unix_socket_file, int socket_type, int port, int debug_level | bool',
\ 'array_change_key_case(': 'array input [, int case] | array',
\ 'array_chunk(': 'array input, int size [, bool preserve_keys] | array',
\ 'array_combine(': 'array keys, array values | array',
\ 'array_count_values(': 'array input | array',
\ 'array_diff_assoc(': 'array array1, array array2 [, array ...] | array',
\ 'array_diff(': 'array array1, array array2 [, array ...] | array',
\ 'array_diff_key(': 'array array1, array array2 [, array ...] | array',
\ 'array_diff_uassoc(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_diff_ukey(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_fill(': 'int start_index, int num, mixed value | array',
\ 'array_filter(': 'array input [, callback callback] | array',
\ 'array_flip(': 'array trans | array',
\ 'array(': '[mixed ...] | array',
\ 'array_intersect_assoc(': 'array array1, array array2 [, array ...] | array',
\ 'array_intersect(': 'array array1, array array2 [, array ...] | array',
\ 'array_intersect_key(': 'array array1, array array2 [, array ...] | array',
\ 'array_intersect_uassoc(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'array_intersect_ukey(': 'array array1, array array2 [, array ..., callback key_compare_func] | array',
\ 'ArrayIterator::current(': 'void  | mixed',
\ 'ArrayIterator::key(': 'void  | mixed',
\ 'ArrayIterator::next(': 'void  | void',
\ 'ArrayIterator::rewind(': 'void  | void',
\ 'ArrayIterator::seek(': 'int position | void',
\ 'ArrayIterator::valid(': 'void  | bool',
\ 'array_key_exists(': 'mixed key, array search | bool',
\ 'array_keys(': 'array input [, mixed search_value [, bool strict]] | array',
\ 'array_map(': 'callback callback, array arr1 [, array ...] | array',
\ 'array_merge(': 'array array1 [, array array2 [, array ...]] | array',
\ 'array_merge_recursive(': 'array array1 [, array ...] | array',
\ 'array_multisort(': 'array ar1 [, mixed arg [, mixed ... [, array ...]]] | bool',
\ 'ArrayObject::append(': 'mixed newval | void',
\ 'ArrayObject::__construct(': 'mixed input | ArrayObject',
\ 'ArrayObject::count(': 'void  | int',
\ 'ArrayObject::getIterator(': 'void  | ArrayIterator',
\ 'ArrayObject::offsetExists(': 'mixed index | bool',
\ 'ArrayObject::offsetGet(': 'mixed index | bool',
\ 'ArrayObject::offsetSet(': 'mixed index, mixed newval | void',
\ 'ArrayObject::offsetUnset(': 'mixed index | void',
\ 'array_pad(': 'array input, int pad_size, mixed pad_value | array',
\ 'array_pop(': 'array &#38;array | mixed',
\ 'array_product(': 'array array | number',
\ 'array_push(': 'array &#38;array, mixed var [, mixed ...] | int',
\ 'array_rand(': 'array input [, int num_req] | mixed',
\ 'array_reduce(': 'array input, callback function [, int initial] | mixed',
\ 'array_reverse(': 'array array [, bool preserve_keys] | array',
\ 'array_search(': 'mixed needle, array haystack [, bool strict] | mixed',
\ 'array_shift(': 'array &#38;array | mixed',
\ 'array_slice(': 'array array, int offset [, int length [, bool preserve_keys]] | array',
\ 'array_splice(': 'array &#38;input, int offset [, int length [, array replacement]] | array',
\ 'array_sum(': 'array array | number',
\ 'array_udiff_assoc(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_udiff(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_udiff_uassoc(': 'array array1, array array2 [, array ..., callback data_compare_func, callback key_compare_func] | array',
\ 'array_uintersect_assoc(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_uintersect(': 'array array1, array array2 [, array ..., callback data_compare_func] | array',
\ 'array_uintersect_uassoc(': 'array array1, array array2 [, array ..., callback data_compare_func, callback key_compare_func] | array',
\ 'array_unique(': 'array array | array',
\ 'array_unshift(': 'array &#38;array, mixed var [, mixed ...] | int',
\ 'array_values(': 'array input | array',
\ 'array_walk(': 'array &#38;array, callback funcname [, mixed userdata] | bool',
\ 'array_walk_recursive(': 'array &#38;input, callback funcname [, mixed userdata] | bool',
\ 'arsort(': 'array &#38;array [, int sort_flags] | bool',
\ 'ascii2ebcdic(': 'string ascii_str | int',
\ 'asinh(': 'float arg | float',
\ 'asin(': 'float arg | float',
\ 'asort(': 'array &#38;array [, int sort_flags] | bool',
\ 'aspell_check(': 'int dictionary_link, string word | bool',
\ 'aspell_check_raw(': 'int dictionary_link, string word | bool',
\ 'aspell_new(': 'string master [, string personal] | int',
\ 'aspell_suggest(': 'int dictionary_link, string word | array',
\ 'assert(': 'mixed assertion | bool',
\ 'assert_options(': 'int what [, mixed value] | mixed',
\ 'atan2(': 'float y, float x | float',
\ 'atanh(': 'float arg | float',
\ 'atan(': 'float arg | float',
\ 'base64_decode(': 'string encoded_data | string',
\ 'base64_encode(': 'string data | string',
\ 'base_convert(': 'string number, int frombase, int tobase | string',
\ 'basename(': 'string path [, string suffix] | string',
\ 'bcadd(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bccomp(': 'string left_operand, string right_operand [, int scale] | int',
\ 'bcdiv(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bcmod(': 'string left_operand, string modulus | string',
\ 'bcmul(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bcompiler_load_exe(': 'string filename | bool',
\ 'bcompiler_load(': 'string filename | bool',
\ 'bcompiler_parse_class(': 'string class, string callback | bool',
\ 'bcompiler_read(': 'resource filehandle | bool',
\ 'bcompiler_write_class(': 'resource filehandle, string className [, string extends] | bool',
\ 'bcompiler_write_constant(': 'resource filehandle, string constantName | bool',
\ 'bcompiler_write_exe_footer(': 'resource filehandle, int startpos | bool',
\ 'bcompiler_write_file(': 'resource filehandle, string filename | bool',
\ 'bcompiler_write_footer(': 'resource filehandle | bool',
\ 'bcompiler_write_function(': 'resource filehandle, string functionName | bool',
\ 'bcompiler_write_functions_from_file(': 'resource filehandle, string fileName | bool',
\ 'bcompiler_write_header(': 'resource filehandle [, string write_ver] | bool',
\ 'bcpow(': 'string x, string y [, int scale] | string',
\ 'bcpowmod(': 'string x, string y, string modulus [, int scale] | string',
\ 'bcscale(': 'int scale | bool',
\ 'bcsqrt(': 'string operand [, int scale] | string',
\ 'bcsub(': 'string left_operand, string right_operand [, int scale] | string',
\ 'bin2hex(': 'string str | string',
\ 'bindec(': 'string binary_string | number',
\ 'bind_textdomain_codeset(': 'string domain, string codeset | string',
\ 'bindtextdomain(': 'string domain, string directory | string',
\ 'bzclose(': 'resource bz | int',
\ 'bzcompress(': 'string source [, int blocksize [, int workfactor]] | mixed',
\ 'bzdecompress(': 'string source [, int small] | mixed',
\ 'bzerrno(': 'resource bz | int',
\ 'bzerror(': 'resource bz | array',
\ 'bzerrstr(': 'resource bz | string',
\ 'bzflush(': 'resource bz | int',
\ 'bzopen(': 'string filename, string mode | resource',
\ 'bzread(': 'resource bz [, int length] | string',
\ 'bzwrite(': 'resource bz, string data [, int length] | int',
\ 'CachingIterator::hasNext(': 'void  | bool',
\ 'CachingIterator::next(': 'void  | void',
\ 'CachingIterator::rewind(': 'void  | void',
\ 'CachingIterator::__toString(': 'void  | string',
\ 'CachingIterator::valid(': 'void  | bool',
\ 'CachingRecursiveIterator::getChildren(': 'void  | CachingRecursiveIterator',
\ 'CachingRecursiveIterator::hasChildren(': 'void  | bolean',
\ 'cal_days_in_month(': 'int calendar, int month, int year | int',
\ 'cal_from_jd(': 'int jd, int calendar | array',
\ 'cal_info(': '[int calendar] | array',
\ 'call_user_func_array(': 'callback function, array param_arr | mixed',
\ 'call_user_func(': 'callback function [, mixed parameter [, mixed ...]] | mixed',
\ 'call_user_method_array(': 'string method_name, object &#38;obj, array paramarr | mixed',
\ 'call_user_method(': 'string method_name, object &#38;obj [, mixed parameter [, mixed ...]] | mixed',
\ 'cal_to_jd(': 'int calendar, int month, int day, int year | int',
\ 'ccvs_add(': 'string session, string invoice, string argtype, string argval | string',
\ 'ccvs_auth(': 'string session, string invoice | string',
\ 'ccvs_command(': 'string session, string type, string argval | string',
\ 'ccvs_count(': 'string session, string type | int',
\ 'ccvs_delete(': 'string session, string invoice | string',
\ 'ccvs_done(': 'string sess | string',
\ 'ccvs_init(': 'string name | string',
\ 'ccvs_lookup(': 'string session, string invoice, int inum | string',
\ 'ccvs_new(': 'string session, string invoice | string',
\ 'ccvs_report(': 'string session, string type | string',
\ 'ccvs_return(': 'string session, string invoice | string',
\ 'ccvs_reverse(': 'string session, string invoice | string',
\ 'ccvs_sale(': 'string session, string invoice | string',
\ 'ccvs_status(': 'string session, string invoice | string',
\ 'ccvs_textvalue(': 'string session | string',
\ 'ccvs_void(': 'string session, string invoice | string',
\ 'ceil(': 'float value | float',
\ 'chdir(': 'string directory | bool',
\ 'checkdate(': 'int month, int day, int year | bool',
\ 'checkdnsrr(': 'string host [, string type] | int',
\ 'chgrp(': 'string filename, mixed group | bool',
\ 'chmod(': 'string filename, int mode | bool',
\ 'chown(': 'string filename, mixed user | bool',
\ 'chr(': 'int ascii | string',
\ 'chroot(': 'string directory | bool',
\ 'chunk_split(': 'string body [, int chunklen [, string end]] | string',
\ 'class_exists(': 'string class_name [, bool autoload] | bool',
\ 'class_implements(': 'mixed class [, bool autoload] | array',
\ 'classkit_import(': 'string filename | array',
\ 'classkit_method_add(': 'string classname, string methodname, string args, string code [, int flags] | bool',
\ 'classkit_method_copy(': 'string dClass, string dMethod, string sClass [, string sMethod] | bool',
\ 'classkit_method_redefine(': 'string classname, string methodname, string args, string code [, int flags] | bool',
\ 'classkit_method_remove(': 'string classname, string methodname | bool',
\ 'classkit_method_rename(': 'string classname, string methodname, string newname | bool',
\ 'class_parents(': 'mixed class [, bool autoload] | array',
\ 'clearstatcache(': 'void  | void',
\ 'closedir(': 'resource dir_handle | void',
\ 'closelog(': 'void  | bool',
\ 'com_addref(': 'void  | void',
\ 'com_create_guid(': 'void  | string',
\ 'com_event_sink(': 'variant comobject, object sinkobject [, mixed sinkinterface] | bool',
\ 'com_get_active_object(': 'string progid [, int code_page] | variant',
\ 'com_get(': 'resource com_object, string property | mixed',
\ 'com_invoke(': 'resource com_object, string function_name [, mixed function_parameters] | mixed',
\ 'com_isenum(': 'variant com_module | bool',
\ 'com_load(': 'string module_name [, string server_name [, int codepage]] | resource',
\ 'com_load_typelib(': 'string typelib_name [, bool case_insensitive] | bool',
\ 'com_message_pump(': '[int timeoutms] | bool',
\ 'compact(': 'mixed varname [, mixed ...] | array',
\ 'com_print_typeinfo(': 'object comobject [, string dispinterface [, bool wantsink]] | bool',
\ 'com_release(': 'void  | void',
\ 'com_set(': 'resource com_object, string property, mixed value | void',
\ 'connection_aborted(': 'void  | int',
\ 'connection_status(': 'void  | int',
\ 'connection_timeout(': 'void  | bool',
\ 'constant(': 'string name | mixed',
\ 'convert_cyr_string(': 'string str, string from, string to | string',
\ 'convert_uudecode(': 'string data | string',
\ 'convert_uuencode(': 'string data | string',
\ 'copy(': 'string source, string dest | bool',
\ 'cosh(': 'float arg | float',
\ 'cos(': 'float arg | float',
\ 'count_chars(': 'string string [, int mode] | mixed',
\ 'count(': 'mixed var [, int mode] | int',
\ 'cpdf_add_annotation(': 'int pdf_document, float llx, float lly, float urx, float ury, string title, string content [, int mode] | bool',
\ 'cpdf_add_outline(': 'int pdf_document, int lastoutline, int sublevel, int open, int pagenr, string text | int',
\ 'cpdf_arc(': 'int pdf_document, float x_coor, float y_coor, float radius, float start, float end [, int mode] | bool',
\ 'cpdf_begin_text(': 'int pdf_document | bool',
\ 'cpdf_circle(': 'int pdf_document, float x_coor, float y_coor, float radius [, int mode] | bool',
\ 'cpdf_clip(': 'int pdf_document | bool',
\ 'cpdf_close(': 'int pdf_document | bool',
\ 'cpdf_closepath_fill_stroke(': 'int pdf_document | bool',
\ 'cpdf_closepath(': 'int pdf_document | bool',
\ 'cpdf_closepath_stroke(': 'int pdf_document | bool',
\ 'cpdf_continue_text(': 'int pdf_document, string text | bool',
\ 'cpdf_curveto(': 'int pdf_document, float x1, float y1, float x2, float y2, float x3, float y3 [, int mode] | bool',
\ 'cpdf_end_text(': 'int pdf_document | bool',
\ 'cpdf_fill(': 'int pdf_document | bool',
\ 'cpdf_fill_stroke(': 'int pdf_document | bool',
\ 'cpdf_finalize(': 'int pdf_document | bool',
\ 'cpdf_finalize_page(': 'int pdf_document, int page_number | bool',
\ 'cpdf_global_set_document_limits(': 'int maxpages, int maxfonts, int maximages, int maxannotations, int maxobjects | bool',
\ 'cpdf_import_jpeg(': 'int pdf_document, string file_name, float x_coor, float y_coor, float angle, float width, float height, float x_scale, float y_scale, int gsave [, int mode] | bool',
\ 'cpdf_lineto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_moveto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_newpath(': 'int pdf_document | bool',
\ 'cpdf_open(': 'int compression [, string filename [, array doc_limits]] | int',
\ 'cpdf_output_buffer(': 'int pdf_document | bool',
\ 'cpdf_page_init(': 'int pdf_document, int page_number, int orientation, float height, float width [, float unit] | bool',
\ 'cpdf_place_inline_image(': 'int pdf_document, int image, float x_coor, float y_coor, float angle, float width, float height, int gsave [, int mode] | bool',
\ 'cpdf_rect(': 'int pdf_document, float x_coor, float y_coor, float width, float height [, int mode] | bool',
\ 'cpdf_restore(': 'int pdf_document | bool',
\ 'cpdf_rlineto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_rmoveto(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_rotate(': 'int pdf_document, float angle | bool',
\ 'cpdf_rotate_text(': 'int pdfdoc, float angle | bool',
\ 'cpdf_save(': 'int pdf_document | bool',
\ 'cpdf_save_to_file(': 'int pdf_document, string filename | bool',
\ 'cpdf_scale(': 'int pdf_document, float x_scale, float y_scale | bool',
\ 'cpdf_set_action_url(': 'int pdfdoc, float xll, float yll, float xur, float xur, string url [, int mode] | bool',
\ 'cpdf_set_char_spacing(': 'int pdf_document, float space | bool',
\ 'cpdf_set_creator(': 'int pdf_document, string creator | bool',
\ 'cpdf_set_current_page(': 'int pdf_document, int page_number | bool',
\ 'cpdf_setdash(': 'int pdf_document, float white, float black | bool',
\ 'cpdf_setflat(': 'int pdf_document, float value | bool',
\ 'cpdf_set_font_directories(': 'int pdfdoc, string pfmdir, string pfbdir | bool',
\ 'cpdf_set_font(': 'int pdf_document, string font_name, float size, string encoding | bool',
\ 'cpdf_set_font_map_file(': 'int pdfdoc, string filename | bool',
\ 'cpdf_setgray_fill(': 'int pdf_document, float value | bool',
\ 'cpdf_setgray(': 'int pdf_document, float gray_value | bool',
\ 'cpdf_setgray_stroke(': 'int pdf_document, float gray_value | bool',
\ 'cpdf_set_horiz_scaling(': 'int pdf_document, float scale | bool',
\ 'cpdf_set_keywords(': 'int pdf_document, string keywords | bool',
\ 'cpdf_set_leading(': 'int pdf_document, float distance | bool',
\ 'cpdf_setlinecap(': 'int pdf_document, int value | bool',
\ 'cpdf_setlinejoin(': 'int pdf_document, int value | bool',
\ 'cpdf_setlinewidth(': 'int pdf_document, float width | bool',
\ 'cpdf_setmiterlimit(': 'int pdf_document, float value | bool',
\ 'cpdf_set_page_animation(': 'int pdf_document, int transition, float duration, float direction, int orientation, int inout | bool',
\ 'cpdf_setrgbcolor_fill(': 'int pdf_document, float red_value, float green_value, float blue_value | bool',
\ 'cpdf_setrgbcolor(': 'int pdf_document, float red_value, float green_value, float blue_value | bool',
\ 'cpdf_setrgbcolor_stroke(': 'int pdf_document, float red_value, float green_value, float blue_value | bool',
\ 'cpdf_set_subject(': 'int pdf_document, string subject | bool',
\ 'cpdf_set_text_matrix(': 'int pdf_document, array matrix | bool',
\ 'cpdf_set_text_pos(': 'int pdf_document, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_set_text_rendering(': 'int pdf_document, int rendermode | bool',
\ 'cpdf_set_text_rise(': 'int pdf_document, float value | bool',
\ 'cpdf_set_title(': 'int pdf_document, string title | bool',
\ 'cpdf_set_viewer_preferences(': 'int pdfdoc, array preferences | bool',
\ 'cpdf_set_word_spacing(': 'int pdf_document, float space | bool',
\ 'cpdf_show(': 'int pdf_document, string text | bool',
\ 'cpdf_show_xy(': 'int pdf_document, string text, float x_coor, float y_coor [, int mode] | bool',
\ 'cpdf_stringwidth(': 'int pdf_document, string text | float',
\ 'cpdf_stroke(': 'int pdf_document | bool',
\ 'cpdf_text(': 'int pdf_document, string text [, float x_coor, float y_coor [, int mode [, float orientation [, int alignmode]]]] | bool',
\ 'cpdf_translate(': 'int pdf_document, float x_coor, float y_coor | bool',
\ 'crack_check(': 'resource dictionary, string password | bool',
\ 'crack_closedict(': '[resource dictionary] | bool',
\ 'crack_getlastmessage(': 'void  | string',
\ 'crack_opendict(': 'string dictionary | resource',
\ 'crc32(': 'string str | int',
\ 'create_function(': 'string args, string code | string',
\ 'crypt(': 'string str [, string salt] | string',
\ 'ctype_alnum(': 'string text | bool',
\ 'ctype_alpha(': 'string text | bool',
\ 'ctype_cntrl(': 'string text | bool',
\ 'ctype_digit(': 'string text | bool',
\ 'ctype_graph(': 'string text | bool',
\ 'ctype_lower(': 'string text | bool',
\ 'ctype_print(': 'string text | bool',
\ 'ctype_punct(': 'string text | bool',
\ 'ctype_space(': 'string text | bool',
\ 'ctype_upper(': 'string text | bool',
\ 'ctype_xdigit(': 'string text | bool',
\ 'curl_close(': 'resource ch | void',
\ 'curl_copy_handle(': 'resource ch | resource',
\ 'curl_errno(': 'resource ch | int',
\ 'curl_error(': 'resource ch | string',
\ 'curl_exec(': 'resource ch | mixed',
\ 'curl_getinfo(': 'resource ch [, int opt] | mixed',
\ 'curl_init(': '[string url] | resource',
\ 'curl_multi_add_handle(': 'resource mh, resource ch | int',
\ 'curl_multi_close(': 'resource mh | void',
\ 'curl_multi_exec(': 'resource mh, int &#38;still_running | int',
\ 'curl_multi_getcontent(': 'resource ch | string',
\ 'curl_multi_info_read(': 'resource mh | array',
\ 'curl_multi_init(': 'void  | resource',
\ 'curl_multi_remove_handle(': 'resource mh, resource ch | int',
\ 'curl_multi_select(': 'resource mh [, float timeout] | int',
\ 'curl_setopt(': 'resource ch, int option, mixed value | bool',
\ 'curl_version(': '[int version] | array',
\ 'current(': 'array &#38;array | mixed',
\ 'cybercash_base64_decode(': 'string inbuff | string',
\ 'cybercash_base64_encode(': 'string inbuff | string',
\ 'cybercash_decr(': 'string wmk, string sk, string inbuff | array',
\ 'cybercash_encr(': 'string wmk, string sk, string inbuff | array',
\ 'cybermut_creerformulairecm(': 'string url_cm, string version, string tpe, string price, string ref_command, string text_free, string url_return, string url_return_ok, string url_return_err, string language, string code_company, string text_button | string',
\ 'cybermut_creerreponsecm(': 'string sentence | string',
\ 'cybermut_testmac(': 'string code_mac, string version, string tpe, string cdate, string price, string ref_command, string text_free, string code_return | bool',
\ 'cyrus_authenticate(': 'resource connection [, string mechlist [, string service [, string user [, int minssf [, int maxssf [, string authname [, string password]]]]]]] | void',
\ 'cyrus_bind(': 'resource connection, array callbacks | bool',
\ 'cyrus_close(': 'resource connection | bool',
\ 'cyrus_connect(': '[string host [, string port [, int flags]]] | resource',
\ 'cyrus_query(': 'resource connection, string query | array',
\ 'cyrus_unbind(': 'resource connection, string trigger_name | bool',
\ 'date_default_timezone_get(': 'void  | string',
\ 'date_default_timezone_set(': 'string timezone_identifier | bool',
\ 'date(': 'string format [, int timestamp] | string',
\ 'date_sunrise(': 'int timestamp [, int format [, float latitude [, float longitude [, float zenith [, float gmt_offset]]]]] | mixed',
\ 'date_sunset(': 'int timestamp [, int format [, float latitude [, float longitude [, float zenith [, float gmt_offset]]]]] | mixed',
\ 'db2_autocommit(': 'resource connection [, bool value] | mixed',
\ 'db2_bind_param(': 'resource stmt, int parameter-number, string variable-name [, int parameter-type [, int data-type [, int precision [, int scale]]]] | bool',
\ 'db2_client_info(': 'resource connection | object',
\ 'db2_close(': 'resource connection | bool',
\ 'db2_column_privileges(': 'resource connection [, string qualifier [, string schema [, string table-name [, string column-name]]]] | resource',
\ 'db2_columns(': 'resource connection [, string qualifier [, string schema [, string table-name [, string column-name]]]] | resource',
\ 'db2_commit(': 'resource connection | bool',
\ 'db2_connect(': 'string database, string username, string password [, array options] | resource',
\ 'db2_conn_error(': '[resource connection] | string',
\ 'db2_conn_errormsg(': '[resource connection] | string',
\ 'db2_cursor_type(': 'resource stmt | int',
\ 'db2_exec(': 'resource connection, string statement [, array options] | resource',
\ 'db2_execute(': 'resource stmt [, array parameters] | bool',
\ 'db2_fetch_array(': 'resource stmt [, int row_number] | array',
\ 'db2_fetch_assoc(': 'resource stmt [, int row_number] | array',
\ 'db2_fetch_both(': 'resource stmt [, int row_number] | array',
\ 'db2_fetch_object(': 'resource stmt [, int row_number] | object',
\ 'db2_fetch_row(': 'resource stmt [, int row_number] | bool',
\ 'db2_field_display_size(': 'resource stmt, mixed column | int',
\ 'db2_field_name(': 'resource stmt, mixed column | string',
\ 'db2_field_num(': 'resource stmt, mixed column | int',
\ 'db2_field_precision(': 'resource stmt, mixed column | int',
\ 'db2_field_scale(': 'resource stmt, mixed column | int',
\ 'db2_field_type(': 'resource stmt, mixed column | string',
\ 'db2_field_width(': 'resource stmt, mixed column | int',
\ 'db2_foreign_keys(': 'resource connection, string qualifier, string schema, string table-name | resource',
\ 'db2_free_result(': 'resource stmt | bool',
\ 'db2_free_stmt(': 'resource stmt | bool',
\ 'db2_next_result(': 'resource stmt | resource',
\ 'db2_num_fields(': 'resource stmt | int',
\ 'db2_num_rows(': 'resource stmt | int',
\ 'db2_pconnect(': 'string database, string username, string password [, array options] | resource',
\ 'db2_prepare(': 'resource connection, string statement [, array options] | resource',
\ 'db2_primary_keys(': 'resource connection, string qualifier, string schema, string table-name | resource',
\ 'db2_procedure_columns(': 'resource connection, string qualifier, string schema, string procedure, string parameter | resource',
\ 'db2_procedures(': 'resource connection, string qualifier, string schema, string procedure | resource',
\ 'db2_result(': 'resource stmt, mixed column | mixed',
\ 'db2_rollback(': 'resource connection | bool',
\ 'db2_server_info(': 'resource connection | object',
\ 'db2_special_columns(': 'resource connection, string qualifier, string schema, string table_name, int scope | resource',
\ 'db2_statistics(': 'resource connection, string qualifier, string schema, string table-name, bool unique | resource',
\ 'db2_stmt_error(': '[resource stmt] | string',
\ 'db2_stmt_errormsg(': '[resource stmt] | string',
\ 'db2_table_privileges(': 'resource connection [, string qualifier [, string schema [, string table_name]]] | resource',
\ 'db2_tables(': 'resource connection [, string qualifier [, string schema [, string table-name [, string table-type]]]] | resource',
\ 'dba_close(': 'resource handle | void',
\ 'dba_delete(': 'string key, resource handle | bool',
\ 'dba_exists(': 'string key, resource handle | bool',
\ 'dba_fetch(': 'string key, resource handle | string',
\ 'dba_firstkey(': 'resource handle | string',
\ 'dba_handlers(': '[bool full_info] | array',
\ 'dba_insert(': 'string key, string value, resource handle | bool',
\ 'dba_key_split(': 'mixed key | mixed',
\ 'dba_list(': 'void  | array',
\ 'dba_nextkey(': 'resource handle | string',
\ 'dba_open(': 'string path, string mode [, string handler [, mixed ...]] | resource',
\ 'dba_optimize(': 'resource handle | bool',
\ 'dba_popen(': 'string path, string mode [, string handler [, mixed ...]] | resource',
\ 'dba_replace(': 'string key, string value, resource handle | bool',
\ 'dbase_add_record(': 'int dbase_identifier, array record | bool',
\ 'dbase_close(': 'int dbase_identifier | bool',
\ 'dbase_create(': 'string filename, array fields | int',
\ 'dbase_delete_record(': 'int dbase_identifier, int record_number | bool',
\ 'dbase_get_header_info(': 'int dbase_identifier | array',
\ 'dbase_get_record(': 'int dbase_identifier, int record_number | array',
\ 'dbase_get_record_with_names(': 'int dbase_identifier, int record_number | array',
\ 'dbase_numfields(': 'int dbase_identifier | int',
\ 'dbase_numrecords(': 'int dbase_identifier | int',
\ 'dbase_open(': 'string filename, int mode | int',
\ 'dbase_pack(': 'int dbase_identifier | bool',
\ 'dbase_replace_record(': 'int dbase_identifier, array record, int record_number | bool',
\ 'dba_sync(': 'resource handle | bool',
\ 'dblist(': 'void  | string',
\ 'dbmclose(': 'resource dbm_identifier | bool',
\ 'dbmdelete(': 'resource dbm_identifier, string key | bool',
\ 'dbmexists(': 'resource dbm_identifier, string key | bool',
\ 'dbmfetch(': 'resource dbm_identifier, string key | string',
\ 'dbmfirstkey(': 'resource dbm_identifier | string',
\ 'dbminsert(': 'resource dbm_identifier, string key, string value | int',
\ 'dbmnextkey(': 'resource dbm_identifier, string key | string',
\ 'dbmopen(': 'string filename, string flags | resource',
\ 'dbmreplace(': 'resource dbm_identifier, string key, string value | int',
\ 'dbplus_add(': 'resource relation, array tuple | int',
\ 'dbplus_aql(': 'string query [, string server [, string dbpath]] | resource',
\ 'dbplus_chdir(': '[string newdir] | string',
\ 'dbplus_close(': 'resource relation | mixed',
\ 'dbplus_curr(': 'resource relation, array &#38;tuple | int',
\ 'dbplus_errcode(': '[int errno] | string',
\ 'dbplus_errno(': 'void  | int',
\ 'dbplus_find(': 'resource relation, array constraints, mixed tuple | int',
\ 'dbplus_first(': 'resource relation, array &#38;tuple | int',
\ 'dbplus_flush(': 'resource relation | int',
\ 'dbplus_freealllocks(': 'void  | int',
\ 'dbplus_freelock(': 'resource relation, string tname | int',
\ 'dbplus_freerlocks(': 'resource relation | int',
\ 'dbplus_getlock(': 'resource relation, string tname | int',
\ 'dbplus_getunique(': 'resource relation, int uniqueid | int',
\ 'dbplus_info(': 'resource relation, string key, array &#38;result | int',
\ 'dbplus_last(': 'resource relation, array &#38;tuple | int',
\ 'dbplus_lockrel(': 'resource relation | int',
\ 'dbplus_next(': 'resource relation, array &#38;tuple | int',
\ 'dbplus_open(': 'string name | resource',
\ 'dbplus_prev(': 'resource relation, array &#38;tuple | int',
\ 'dbplus_rchperm(': 'resource relation, int mask, string user, string group | int',
\ 'dbplus_rcreate(': 'string name, mixed domlist [, bool overwrite] | resource',
\ 'dbplus_rcrtexact(': 'string name, resource relation [, bool overwrite] | mixed',
\ 'dbplus_rcrtlike(': 'string name, resource relation [, int overwrite] | mixed',
\ 'dbplus_resolve(': 'string relation_name | array',
\ 'dbplus_restorepos(': 'resource relation, array tuple | int',
\ 'dbplus_rkeys(': 'resource relation, mixed domlist | mixed',
\ 'dbplus_ropen(': 'string name | resource',
\ 'dbplus_rquery(': 'string query [, string dbpath] | resource',
\ 'dbplus_rrename(': 'resource relation, string name | int',
\ 'dbplus_rsecindex(': 'resource relation, mixed domlist, int type | mixed',
\ 'dbplus_runlink(': 'resource relation | int',
\ 'dbplus_rzap(': 'resource relation | int',
\ 'dbplus_savepos(': 'resource relation | int',
\ 'dbplus_setindexbynumber(': 'resource relation, int idx_number | int',
\ 'dbplus_setindex(': 'resource relation, string idx_name | int',
\ 'dbplus_sql(': 'string query [, string server [, string dbpath]] | resource',
\ 'dbplus_tcl(': 'int sid, string script | string',
\ 'dbplus_tremove(': 'resource relation, array tuple [, array &#38;current] | int',
\ 'dbplus_undo(': 'resource relation | int',
\ 'dbplus_undoprepare(': 'resource relation | int',
\ 'dbplus_unlockrel(': 'resource relation | int',
\ 'dbplus_unselect(': 'resource relation | int',
\ 'dbplus_update(': 'resource relation, array old, array new | int',
\ 'dbplus_xlockrel(': 'resource relation | int',
\ 'dbplus_xunlockrel(': 'resource relation | int',
\ 'dbx_close(': 'object link_identifier | bool',
\ 'dbx_compare(': 'array row_a, array row_b, string column_key [, int flags] | int',
\ 'dbx_connect(': 'mixed module, string host, string database, string username, string password [, int persistent] | object',
\ 'dbx_error(': 'object link_identifier | string',
\ 'dbx_escape_string(': 'object link_identifier, string text | string',
\ 'dbx_fetch_row(': 'object result_identifier | mixed',
\ 'dbx_query(': 'object link_identifier, string sql_statement [, int flags] | mixed',
\ 'dbx_sort(': 'object result, string user_compare_function | bool',
\ 'dcgettext(': 'string domain, string message, int category | string',
\ 'dcngettext(': 'string domain, string msgid1, string msgid2, int n, int category | string',
\ 'deaggregate(': 'object object [, string class_name] | void',
\ 'debug_backtrace(': 'void  | array',
\ 'debugger_off(': 'void  | int',
\ 'debugger_on(': 'string address | int',
\ 'debug_print_backtrace(': 'void  | void',
\ 'debug_zval_dump(': 'mixed variable | void',
\ 'decbin(': 'int number | string',
\ 'dechex(': 'int number | string',
\ 'decoct(': 'int number | string',
\ 'defined(': 'string name | bool',
\ 'define(': 'string name, mixed value [, bool case_insensitive] | bool',
\ 'define_syslog_variables(': 'void  | void',
\ 'deg2rad(': 'float number | float',
\ 'delete(': 'string file | void',
\ 'dgettext(': 'string domain, string message | string',
\ 'dio_close(': 'resource fd | void',
\ 'dio_fcntl(': 'resource fd, int cmd [, mixed args] | mixed',
\ 'dio_open(': 'string filename, int flags [, int mode] | resource',
\ 'dio_read(': 'resource fd [, int len] | string',
\ 'dio_seek(': 'resource fd, int pos [, int whence] | int',
\ 'dio_stat(': 'resource fd | array',
\ 'dio_tcsetattr(': 'resource fd, array options | bool',
\ 'dio_truncate(': 'resource fd, int offset | bool',
\ 'dio_write(': 'resource fd, string data [, int len] | int',
\ 'DirectoryIterator::__construct(': 'string path | DirectoryIterator',
\ 'DirectoryIterator::current(': 'void  | DirectoryIterator',
\ 'DirectoryIterator::getATime(': 'void  | int',
\ 'DirectoryIterator::getChildren(': 'void  | RecursiveDirectoryIterator',
\ 'DirectoryIterator::getCTime(': 'void  | int',
\ 'DirectoryIterator::getFilename(': 'void  | string',
\ 'DirectoryIterator::getGroup(': 'void  | int',
\ 'DirectoryIterator::getInode(': 'void  | int',
\ 'DirectoryIterator::getMTime(': 'void  | int',
\ 'DirectoryIterator::getOwner(': 'void  | int',
\ 'DirectoryIterator::getPath(': 'void  | string',
\ 'DirectoryIterator::getPathname(': 'void  | string',
\ 'DirectoryIterator::getPerms(': 'void  | int',
\ 'DirectoryIterator::getSize(': 'void  | int',
\ 'DirectoryIterator::getType(': 'void  | string',
\ 'DirectoryIterator::isDir(': 'void  | bool',
\ 'DirectoryIterator::isDot(': 'void  | bool',
\ 'DirectoryIterator::isExecutable(': 'void  | bool',
\ 'DirectoryIterator::isFile(': 'void  | bool',
\ 'DirectoryIterator::isLink(': 'void  | bool',
\ 'DirectoryIterator::isReadable(': 'void  | bool',
\ 'DirectoryIterator::isWritable(': 'void  | bool',
\ 'DirectoryIterator::key(': 'void  | string',
\ 'DirectoryIterator::next(': 'void  | void',
\ 'DirectoryIterator::rewind(': 'void  | void',
\ 'DirectoryIterator::valid(': 'void  | string',
\ 'dirname(': 'string path | string',
\ 'disk_free_space(': 'string directory | float',
\ 'disk_total_space(': 'string directory | float',
\ 'dl(': 'string library | int',
\ 'dngettext(': 'string domain, string msgid1, string msgid2, int n | string',
\ 'dns_check_record(': 'string host [, string type] | bool',
\ 'dns_get_mx(': 'string hostname, array &#38;mxhosts [, array &#38;weight] | bool',
\ 'dns_get_record(': 'string hostname [, int type [, array &#38;authns, array &#38;addtl]] | array',
\ 'DomDocument-&#62;add_root(': 'string name | domelement',
\ 'DomDocument-&#62;create_attribute(': 'string name, string value | domattribute',
\ 'DomDocument-&#62;create_cdata_section(': 'string content | domcdata',
\ 'DomDocument-&#62;create_comment(': 'string content | domcomment',
\ 'DomDocument-&#62;create_element(': 'string name | domelement',
\ 'DomDocument-&#62;create_element_ns(': 'string uri, string name [, string prefix] | domelement',
\ 'DomDocument-&#62;create_entity_reference(': 'string content | domentityreference',
\ 'DomDocument-&#62;create_processing_instruction(': 'string content | domprocessinginstruction',
\ 'DomDocument-&#62;create_text_node(': 'string content | domtext',
\ 'DomDocument-&#62;doctype(': 'void  | domdocumenttype',
\ 'DomDocument-&#62;document_element(': 'void  | domelement',
\ 'DomDocument-&#62;dump_file(': 'string filename [, bool compressionmode [, bool format]] | string',
\ 'DomDocument-&#62;dump_mem(': '[bool format [, string encoding]] | string',
\ 'DomDocument-&#62;get_element_by_id(': 'string id | domelement',
\ 'DomDocument-&#62;get_elements_by_tagname(': 'string name | array',
\ 'DomDocument-&#62;html_dump_mem(': 'void  | string',
\ 'DomDocument-&#62;xinclude(': 'void  | int',
\ 'dom_import_simplexml(': 'SimpleXMLElement node | DOMElement',
\ 'DomNode-&#62;append_sibling(': 'domelement newnode | domelement',
\ 'DomNode-&#62;attributes(': 'void  | array',
\ 'DomNode-&#62;child_nodes(': 'void  | array',
\ 'DomNode-&#62;clone_node(': 'void  | domelement',
\ 'DomNode-&#62;dump_node(': 'void  | string',
\ 'DomNode-&#62;first_child(': 'void  | domelement',
\ 'DomNode-&#62;get_content(': 'void  | string',
\ 'DomNode-&#62;has_attributes(': 'void  | bool',
\ 'DomNode-&#62;has_child_nodes(': 'void  | bool',
\ 'DomNode-&#62;insert_before(': 'domelement newnode, domelement refnode | domelement',
\ 'DomNode-&#62;is_blank_node(': 'void  | bool',
\ 'DomNode-&#62;last_child(': 'void  | domelement',
\ 'DomNode-&#62;next_sibling(': 'void  | domelement',
\ 'DomNode-&#62;node_name(': 'void  | string',
\ 'DomNode-&#62;node_type(': 'void  | int',
\ 'DomNode-&#62;node_value(': 'void  | string',
\ 'DomNode-&#62;owner_document(': 'void  | domdocument',
\ 'DomNode-&#62;parent_node(': 'void  | domnode',
\ 'DomNode-&#62;prefix(': 'void  | string',
\ 'DomNode-&#62;previous_sibling(': 'void  | domelement',
\ 'DomNode-&#62;remove_child(': 'domtext oldchild | domtext',
\ 'DomNode-&#62;replace_child(': 'domelement oldnode, domelement newnode | domelement',
\ 'DomNode-&#62;replace_node(': 'domelement newnode | domelement',
\ 'DomNode-&#62;set_content(': 'string content | bool',
\ 'DomNode-&#62;set_name(': 'void  | bool',
\ 'DomNode-&#62;set_namespace(': 'string uri [, string prefix] | void',
\ 'DomNode-&#62;unlink_node(': 'void  | void',
\ 'domxml_new_doc(': 'string version | DomDocument',
\ 'domxml_open_file(': 'string filename [, int mode [, array &#38;error]] | DomDocument',
\ 'domxml_open_mem(': 'string str [, int mode [, array &#38;error]] | DomDocument',
\ 'domxml_version(': 'void  | string',
\ 'domxml_xmltree(': 'string str | DomDocument',
\ 'domxml_xslt_stylesheet_doc(': 'DomDocument xsl_doc | DomXsltStylesheet',
\ 'domxml_xslt_stylesheet_file(': 'string xsl_file | DomXsltStylesheet',
\ 'domxml_xslt_stylesheet(': 'string xsl_buf | DomXsltStylesheet',
\ 'domxml_xslt_version(': 'void  | int',
\ 'dotnet_load(': 'string assembly_name [, string datatype_name [, int codepage]] | int',
\ 'each(': 'array &#38;array | array',
\ 'easter_date(': '[int year] | int',
\ 'easter_days(': '[int year [, int method]] | int',
\ 'ebcdic2ascii(': 'string ebcdic_str | int',
\ 'echo(': 'string arg1 [, string ...] | void',
\ 'empty(': 'mixed var | bool',
\ 'end(': 'array &#38;array | mixed',
\ 'ereg(': 'string pattern, string string [, array &#38;regs] | int',
\ 'eregi(': 'string pattern, string string [, array &#38;regs] | int',
\ 'eregi_replace(': 'string pattern, string replacement, string string | string',
\ 'ereg_replace(': 'string pattern, string replacement, string string | string',
\ 'error_log(': 'string message [, int message_type [, string destination [, string extra_headers]]] | bool',
\ 'error_reporting(': '[int level] | int',
\ 'escapeshellarg(': 'string arg | string',
\ 'escapeshellcmd(': 'string command | string',
\ 'eval(': 'string code_str | mixed',
\ 'exec(': 'string command [, array &#38;output [, int &#38;return_var]] | string',
\ 'exif_imagetype(': 'string filename | int',
\ 'exif_read_data(': 'string filename [, string sections [, bool arrays [, bool thumbnail]]] | array',
\ 'exif_tagname(': 'string index | string',
\ 'exif_thumbnail(': 'string filename [, int &#38;width [, int &#38;height [, int &#38;imagetype]]] | string',
\ 'exit(': '[string status] | void',
\ 'expect_expectl(': 'resource expect, array cases, string &#38;match | mixed',
\ 'expect_popen(': 'string command | resource',
\ 'exp(': 'float arg | float',
\ 'explode(': 'string separator, string string [, int limit] | array',
\ 'expm1(': 'float number | float',
\ 'extension_loaded(': 'string name | bool',
\ 'extract(': 'array var_array [, int extract_type [, string prefix]] | int',
\ 'ezmlm_hash(': 'string addr | int',
\ 'fam_cancel_monitor(': 'resource fam, resource fam_monitor | bool',
\ 'fam_close(': 'resource fam | void',
\ 'fam_monitor_collection(': 'resource fam, string dirname, int depth, string mask | resource',
\ 'fam_monitor_directory(': 'resource fam, string dirname | resource',
\ 'fam_monitor_file(': 'resource fam, string filename | resource',
\ 'fam_next_event(': 'resource fam | array',
\ 'fam_open(': '[string appname] | resource',
\ 'fam_pending(': 'resource fam | int',
\ 'fam_resume_monitor(': 'resource fam, resource fam_monitor | bool',
\ 'fam_suspend_monitor(': 'resource fam, resource fam_monitor | bool',
\ 'fbsql_affected_rows(': '[resource link_identifier] | int',
\ 'fbsql_autocommit(': 'resource link_identifier [, bool OnOff] | bool',
\ 'fbsql_blob_size(': 'string blob_handle [, resource link_identifier] | int',
\ 'fbsql_change_user(': 'string user, string password [, string database [, resource link_identifier]] | resource',
\ 'fbsql_clob_size(': 'string clob_handle [, resource link_identifier] | int',
\ 'fbsql_close(': '[resource link_identifier] | bool',
\ 'fbsql_commit(': '[resource link_identifier] | bool',
\ 'fbsql_connect(': '[string hostname [, string username [, string password]]] | resource',
\ 'fbsql_create_blob(': 'string blob_data [, resource link_identifier] | string',
\ 'fbsql_create_clob(': 'string clob_data [, resource link_identifier] | string',
\ 'fbsql_create_db(': 'string database_name [, resource link_identifier [, string database_options]] | bool',
\ 'fbsql_database(': 'resource link_identifier [, string database] | string',
\ 'fbsql_database_password(': 'resource link_identifier [, string database_password] | string',
\ 'fbsql_data_seek(': 'resource result_identifier, int row_number | bool',
\ 'fbsql_db_query(': 'string database, string query [, resource link_identifier] | resource',
\ 'fbsql_db_status(': 'string database_name [, resource link_identifier] | int',
\ 'fbsql_drop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'fbsql_errno(': '[resource link_identifier] | int',
\ 'fbsql_error(': '[resource link_identifier] | string',
\ 'fbsql_fetch_array(': 'resource result [, int result_type] | array',
\ 'fbsql_fetch_assoc(': 'resource result | array',
\ 'fbsql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'fbsql_fetch_lengths(': 'resource result | array',
\ 'fbsql_fetch_object(': 'resource result [, int result_type] | object',
\ 'fbsql_fetch_row(': 'resource result | array',
\ 'fbsql_field_flags(': 'resource result [, int field_offset] | string',
\ 'fbsql_field_len(': 'resource result [, int field_offset] | int',
\ 'fbsql_field_name(': 'resource result [, int field_index] | string',
\ 'fbsql_field_seek(': 'resource result [, int field_offset] | bool',
\ 'fbsql_field_table(': 'resource result [, int field_offset] | string',
\ 'fbsql_field_type(': 'resource result [, int field_offset] | string',
\ 'fbsql_free_result(': 'resource result | bool',
\ 'fbsql_get_autostart_info(': '[resource link_identifier] | array',
\ 'fbsql_hostname(': 'resource link_identifier [, string host_name] | string',
\ 'fbsql_insert_id(': '[resource link_identifier] | int',
\ 'fbsql_list_dbs(': '[resource link_identifier] | resource',
\ 'fbsql_list_fields(': 'string database_name, string table_name [, resource link_identifier] | resource',
\ 'fbsql_list_tables(': 'string database [, resource link_identifier] | resource',
\ 'fbsql_next_result(': 'resource result_id | bool',
\ 'fbsql_num_fields(': 'resource result | int',
\ 'fbsql_num_rows(': 'resource result | int',
\ 'fbsql_password(': 'resource link_identifier [, string password] | string',
\ 'fbsql_pconnect(': '[string hostname [, string username [, string password]]] | resource',
\ 'fbsql_query(': 'string query [, resource link_identifier [, int batch_size]] | resource',
\ 'fbsql_read_blob(': 'string blob_handle [, resource link_identifier] | string',
\ 'fbsql_read_clob(': 'string clob_handle [, resource link_identifier] | string',
\ 'fbsql_result(': 'resource result [, int row [, mixed field]] | mixed',
\ 'fbsql_rollback(': '[resource link_identifier] | bool',
\ 'fbsql_select_db(': '[string database_name [, resource link_identifier]] | bool',
\ 'fbsql_set_lob_mode(': 'resource result, string database_name | bool',
\ 'fbsql_set_password(': 'resource link_identifier, string user, string password, string old_password | bool',
\ 'fbsql_set_transaction(': 'resource link_identifier, int Locking, int Isolation | void',
\ 'fbsql_start_db(': 'string database_name [, resource link_identifier [, string database_options]] | bool',
\ 'fbsql_stop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'fbsql_tablename(': 'resource result, int i | string',
\ 'fbsql_username(': 'resource link_identifier [, string username] | string',
\ 'fbsql_warnings(': '[bool OnOff] | bool',
\ 'fclose(': 'resource handle | bool',
\ 'fdf_add_doc_javascript(': 'resource fdfdoc, string script_name, string script_code | bool',
\ 'fdf_add_template(': 'resource fdfdoc, int newpage, string filename, string template, int rename | bool',
\ 'fdf_close(': 'resource fdf_document | void',
\ 'fdf_create(': 'void  | resource',
\ 'fdf_enum_values(': 'resource fdfdoc, callback function [, mixed userdata] | bool',
\ 'fdf_errno(': 'void  | int',
\ 'fdf_error(': '[int error_code] | string',
\ 'fdf_get_ap(': 'resource fdf_document, string field, int face, string filename | bool',
\ 'fdf_get_attachment(': 'resource fdf_document, string fieldname, string savepath | array',
\ 'fdf_get_encoding(': 'resource fdf_document | string',
\ 'fdf_get_file(': 'resource fdf_document | string',
\ 'fdf_get_flags(': 'resource fdfdoc, string fieldname, int whichflags | int',
\ 'fdf_get_opt(': 'resource fdfdof, string fieldname [, int element] | mixed',
\ 'fdf_get_status(': 'resource fdf_document | string',
\ 'fdf_get_value(': 'resource fdf_document, string fieldname [, int which] | mixed',
\ 'fdf_get_version(': '[resource fdf_document] | string',
\ 'fdf_header(': 'void  | void',
\ 'fdf_next_field_name(': 'resource fdf_document [, string fieldname] | string',
\ 'fdf_open(': 'string filename | resource',
\ 'fdf_open_string(': 'string fdf_data | resource',
\ 'fdf_remove_item(': 'resource fdfdoc, string fieldname, int item | bool',
\ 'fdf_save(': 'resource fdf_document [, string filename] | bool',
\ 'fdf_save_string(': 'resource fdf_document | string',
\ 'fdf_set_ap(': 'resource fdf_document, string field_name, int face, string filename, int page_number | bool',
\ 'fdf_set_encoding(': 'resource fdf_document, string encoding | bool',
\ 'fdf_set_file(': 'resource fdf_document, string url [, string target_frame] | bool',
\ 'fdf_set_flags(': 'resource fdf_document, string fieldname, int whichFlags, int newFlags | bool',
\ 'fdf_set_javascript_action(': 'resource fdf_document, string fieldname, int trigger, string script | bool',
\ 'fdf_set_on_import_javascript(': 'resource fdfdoc, string script, bool before_data_import | bool',
\ 'fdf_set_opt(': 'resource fdf_document, string fieldname, int element, string str1, string str2 | bool',
\ 'fdf_set_status(': 'resource fdf_document, string status | bool',
\ 'fdf_set_submit_form_action(': 'resource fdf_document, string fieldname, int trigger, string script, int flags | bool',
\ 'fdf_set_target_frame(': 'resource fdf_document, string frame_name | bool',
\ 'fdf_set_value(': 'resource fdf_document, string fieldname, mixed value [, int isName] | bool',
\ 'fdf_set_version(': 'resource fdf_document, string version | bool',
\ 'feof(': 'resource handle | bool',
\ 'fflush(': 'resource handle | bool',
\ 'fgetc(': 'resource handle | string',
\ 'fgetcsv(': 'resource handle [, int length [, string delimiter [, string enclosure]]] | array',
\ 'fgets(': 'resource handle [, int length] | string',
\ 'fgetss(': 'resource handle [, int length [, string allowable_tags]] | string',
\ 'fileatime(': 'string filename | int',
\ 'filectime(': 'string filename | int',
\ 'file_exists(': 'string filename | bool',
\ 'file_get_contents(': 'string filename [, bool use_include_path [, resource context [, int offset [, int maxlen]]]] | string',
\ 'filegroup(': 'string filename | int',
\ 'file(': 'string filename [, int use_include_path [, resource context]] | array',
\ 'fileinode(': 'string filename | int',
\ 'filemtime(': 'string filename | int',
\ 'fileowner(': 'string filename | int',
\ 'fileperms(': 'string filename | int',
\ 'filepro_fieldcount(': 'void  | int',
\ 'filepro_fieldname(': 'int field_number | string',
\ 'filepro_fieldtype(': 'int field_number | string',
\ 'filepro_fieldwidth(': 'int field_number | int',
\ 'filepro(': 'string directory | bool',
\ 'filepro_retrieve(': 'int row_number, int field_number | string',
\ 'filepro_rowcount(': 'void  | int',
\ 'file_put_contents(': 'string filename, mixed data [, int flags [, resource context]] | int',
\ 'filesize(': 'string filename | int',
\ 'filetype(': 'string filename | string',
\ 'FilterIterator::current(': 'void  | mixed',
\ 'FilterIterator::getInnerIterator(': 'void  | Iterator',
\ 'FilterIterator::key(': 'void  | mixed',
\ 'FilterIterator::next(': 'void  | void',
\ 'FilterIterator::rewind(': 'void  | void',
\ 'FilterIterator::valid(': 'void  | bool',
\ 'floatval(': 'mixed var | float',
\ 'flock(': 'resource handle, int operation [, int &#38;wouldblock] | bool',
\ 'floor(': 'float value | float',
\ 'flush(': 'void  | void',
\ 'fmod(': 'float x, float y | float',
\ 'fnmatch(': 'string pattern, string string [, int flags] | bool',
\ 'fopen(': 'string filename, string mode [, bool use_include_path [, resource zcontext]] | resource',
\ 'fpassthru(': 'resource handle | int',
\ 'fprintf(': 'resource handle, string format [, mixed args [, mixed ...]] | int',
\ 'fputcsv(': 'resource handle [, array fields [, string delimiter [, string enclosure]]] | int',
\ 'fread(': 'resource handle, int length | string',
\ 'frenchtojd(': 'int month, int day, int year | int',
\ 'fribidi_log2vis(': 'string str, string direction, int charset | string',
\ 'fscanf(': 'resource handle, string format [, mixed &#38;...] | mixed',
\ 'fseek(': 'resource handle, int offset [, int whence] | int',
\ 'fsockopen(': 'string target [, int port [, int &#38;errno [, string &#38;errstr [, float timeout]]]] | resource',
\ 'fstat(': 'resource handle | array',
\ 'ftell(': 'resource handle | int',
\ 'ftok(': 'string pathname, string proj | int',
\ 'ftp_alloc(': 'resource ftp_stream, int filesize [, string &#38;result] | bool',
\ 'ftp_cdup(': 'resource ftp_stream | bool',
\ 'ftp_chdir(': 'resource ftp_stream, string directory | bool',
\ 'ftp_chmod(': 'resource ftp_stream, int mode, string filename | int',
\ 'ftp_close(': 'resource ftp_stream | bool',
\ 'ftp_connect(': 'string host [, int port [, int timeout]] | resource',
\ 'ftp_delete(': 'resource ftp_stream, string path | bool',
\ 'ftp_exec(': 'resource ftp_stream, string command | bool',
\ 'ftp_fget(': 'resource ftp_stream, resource handle, string remote_file, int mode [, int resumepos] | bool',
\ 'ftp_fput(': 'resource ftp_stream, string remote_file, resource handle, int mode [, int startpos] | bool',
\ 'ftp_get(': 'resource ftp_stream, string local_file, string remote_file, int mode [, int resumepos] | bool',
\ 'ftp_get_option(': 'resource ftp_stream, int option | mixed',
\ 'ftp_login(': 'resource ftp_stream, string username, string password | bool',
\ 'ftp_mdtm(': 'resource ftp_stream, string remote_file | int',
\ 'ftp_mkdir(': 'resource ftp_stream, string directory | string',
\ 'ftp_nb_continue(': 'resource ftp_stream | int',
\ 'ftp_nb_fget(': 'resource ftp_stream, resource handle, string remote_file, int mode [, int resumepos] | int',
\ 'ftp_nb_fput(': 'resource ftp_stream, string remote_file, resource handle, int mode [, int startpos] | int',
\ 'ftp_nb_get(': 'resource ftp_stream, string local_file, string remote_file, int mode [, int resumepos] | int',
\ 'ftp_nb_put(': 'resource ftp_stream, string remote_file, string local_file, int mode [, int startpos] | int',
\ 'ftp_nlist(': 'resource ftp_stream, string directory | array',
\ 'ftp_pasv(': 'resource ftp_stream, bool pasv | bool',
\ 'ftp_put(': 'resource ftp_stream, string remote_file, string local_file, int mode [, int startpos] | bool',
\ 'ftp_pwd(': 'resource ftp_stream | string',
\ 'ftp_raw(': 'resource ftp_stream, string command | array',
\ 'ftp_rawlist(': 'resource ftp_stream, string directory [, bool recursive] | array',
\ 'ftp_rename(': 'resource ftp_stream, string oldname, string newname | bool',
\ 'ftp_rmdir(': 'resource ftp_stream, string directory | bool',
\ 'ftp_set_option(': 'resource ftp_stream, int option, mixed value | bool',
\ 'ftp_site(': 'resource ftp_stream, string command | bool',
\ 'ftp_size(': 'resource ftp_stream, string remote_file | int',
\ 'ftp_ssl_connect(': 'string host [, int port [, int timeout]] | resource',
\ 'ftp_systype(': 'resource ftp_stream | string',
\ 'ftruncate(': 'resource handle, int size | bool',
\ 'func_get_arg(': 'int arg_num | mixed',
\ 'func_get_args(': 'void  | array',
\ 'func_num_args(': 'void  | int',
\ 'function_exists(': 'string function_name | bool',
\ 'fwrite(': 'resource handle, string string [, int length] | int',
\ 'gd_info(': 'void  | array',
\ 'getallheaders(': 'void  | array',
\ 'get_browser(': '[string user_agent [, bool return_array]] | mixed',
\ 'get_cfg_var(': 'string varname | string',
\ 'get_class(': '[object obj] | string',
\ 'get_class_methods(': 'mixed class_name | array',
\ 'get_class_vars(': 'string class_name | array',
\ 'get_current_user(': 'void  | string',
\ 'getcwd(': 'void  | string',
\ 'getdate(': '[int timestamp] | array',
\ 'get_declared_classes(': 'void  | array',
\ 'get_declared_interfaces(': 'void  | array',
\ 'get_defined_constants(': '[mixed categorize] | array',
\ 'get_defined_functions(': 'void  | array',
\ 'get_defined_vars(': 'void  | array',
\ 'getenv(': 'string varname | string',
\ 'get_extension_funcs(': 'string module_name | array',
\ 'get_headers(': 'string url [, int format] | array',
\ 'gethostbyaddr(': 'string ip_address | string',
\ 'gethostbyname(': 'string hostname | string',
\ 'gethostbynamel(': 'string hostname | array',
\ 'get_html_translation_table(': '[int table [, int quote_style]] | array',
\ 'getimagesize(': 'string filename [, array &#38;imageinfo] | array',
\ 'get_included_files(': 'void  | array',
\ 'get_include_path(': 'void  | string',
\ 'getlastmod(': 'void  | int',
\ 'get_loaded_extensions(': 'void  | array',
\ 'get_magic_quotes_gpc(': 'void  | int',
\ 'get_magic_quotes_runtime(': 'void  | int',
\ 'get_meta_tags(': 'string filename [, bool use_include_path] | array',
\ 'getmxrr(': 'string hostname, array &#38;mxhosts [, array &#38;weight] | bool',
\ 'getmygid(': 'void  | int',
\ 'getmyinode(': 'void  | int',
\ 'getmypid(': 'void  | int',
\ 'getmyuid(': 'void  | int',
\ 'get_object_vars(': 'object obj | array',
\ 'getopt(': 'string options | array',
\ 'get_parent_class(': '[mixed obj] | string',
\ 'getprotobyname(': 'string name | int',
\ 'getprotobynumber(': 'int number | string',
\ 'getrandmax(': 'void  | int',
\ 'get_resource_type(': 'resource handle | string',
\ 'getrusage(': '[int who] | array',
\ 'getservbyname(': 'string service, string protocol | int',
\ 'getservbyport(': 'int port, string protocol | string',
\ 'gettext(': 'string message | string',
\ 'gettimeofday(': '[bool return_float] | mixed',
\ 'gettype(': 'mixed var | string',
\ 'glob(': 'string pattern [, int flags] | array',
\ 'gmdate(': 'string format [, int timestamp] | string',
\ 'gmmktime(': '[int hour [, int minute [, int second [, int month [, int day [, int year [, int is_dst]]]]]]] | int',
\ 'gmp_abs(': 'resource a | resource',
\ 'gmp_add(': 'resource a, resource b | resource',
\ 'gmp_and(': 'resource a, resource b | resource',
\ 'gmp_clrbit(': 'resource &#38;a, int index | void',
\ 'gmp_cmp(': 'resource a, resource b | int',
\ 'gmp_com(': 'resource a | resource',
\ 'gmp_divexact(': 'resource n, resource d | resource',
\ 'gmp_div_q(': 'resource a, resource b [, int round] | resource',
\ 'gmp_div_qr(': 'resource n, resource d [, int round] | array',
\ 'gmp_div_r(': 'resource n, resource d [, int round] | resource',
\ 'gmp_fact(': 'int a | resource',
\ 'gmp_gcdext(': 'resource a, resource b | array',
\ 'gmp_gcd(': 'resource a, resource b | resource',
\ 'gmp_hamdist(': 'resource a, resource b | int',
\ 'gmp_init(': 'mixed number [, int base] | resource',
\ 'gmp_intval(': 'resource gmpnumber | int',
\ 'gmp_invert(': 'resource a, resource b | resource',
\ 'gmp_jacobi(': 'resource a, resource p | int',
\ 'gmp_legendre(': 'resource a, resource p | int',
\ 'gmp_mod(': 'resource n, resource d | resource',
\ 'gmp_mul(': 'resource a, resource b | resource',
\ 'gmp_neg(': 'resource a | resource',
\ 'gmp_or(': 'resource a, resource b | resource',
\ 'gmp_perfect_square(': 'resource a | bool',
\ 'gmp_popcount(': 'resource a | int',
\ 'gmp_pow(': 'resource base, int exp | resource',
\ 'gmp_powm(': 'resource base, resource exp, resource mod | resource',
\ 'gmp_prob_prime(': 'resource a [, int reps] | int',
\ 'gmp_random(': 'int limiter | resource',
\ 'gmp_scan0(': 'resource a, int start | int',
\ 'gmp_scan1(': 'resource a, int start | int',
\ 'gmp_setbit(': 'resource &#38;a, int index [, bool set_clear] | void',
\ 'gmp_sign(': 'resource a | int',
\ 'gmp_sqrt(': 'resource a | resource',
\ 'gmp_sqrtrem(': 'resource a | array',
\ 'gmp_strval(': 'resource gmpnumber [, int base] | string',
\ 'gmp_sub(': 'resource a, resource b | resource',
\ 'gmp_xor(': 'resource a, resource b | resource',
\ 'gmstrftime(': 'string format [, int timestamp] | string',
\ 'gnupg_adddecryptkey(': 'resource identifier, string fingerprint, string passphrase | bool',
\ 'gnupg_addencryptkey(': 'resource identifier, string fingerprint | bool',
\ 'gnupg_addsignkey(': 'resource identifier, string fingerprint [, string passphrase] | bool',
\ 'gnupg_cleardecryptkeys(': 'resource identifier | bool',
\ 'gnupg_clearencryptkeys(': 'resource identifier | bool',
\ 'gnupg_clearsignkeys(': 'resource identifier | bool',
\ 'gnupg_decrypt(': 'resource identifier, string text | string',
\ 'gnupg_decryptverify(': 'resource identifier, string text, string plaintext | array',
\ 'gnupg_encrypt(': 'resource identifier, string plaintext | string',
\ 'gnupg_encryptsign(': 'resource identifier, string plaintext | string',
\ 'gnupg_export(': 'resource identifier, string fingerprint | string',
\ 'gnupg_geterror(': 'resource identifier | string',
\ 'gnupg_getprotocol(': 'resource identifier | int',
\ 'gnupg_import(': 'resource identifier, string keydata | array',
\ 'gnupg_keyinfo(': 'resource identifier, string pattern | array',
\ 'gnupg_setarmor(': 'resource identifier, int armor | bool',
\ 'gnupg_seterrormode(': 'resource identifier, int errormode | void',
\ 'gnupg_setsignmode(': 'resource identifier, int signmode | bool',
\ 'gnupg_sign(': 'resource identifier, string plaintext | string',
\ 'gnupg_verify(': 'resource identifier, string signed_text, string signature [, string plaintext] | array',
\ 'gopher_parsedir(': 'string dirent | array',
\ 'gregoriantojd(': 'int month, int day, int year | int',
\ 'gzclose(': 'resource zp | bool',
\ 'gzcompress(': 'string data [, int level] | string',
\ 'gzdeflate(': 'string data [, int level] | string',
\ 'gzencode(': 'string data [, int level [, int encoding_mode]] | string',
\ 'gzeof(': 'resource zp | int',
\ 'gzfile(': 'string filename [, int use_include_path] | array',
\ 'gzgetc(': 'resource zp | string',
\ 'gzgets(': 'resource zp, int length | string',
\ 'gzgetss(': 'resource zp, int length [, string allowable_tags] | string',
\ 'gzinflate(': 'string data [, int length] | string',
\ 'gzopen(': 'string filename, string mode [, int use_include_path] | resource',
\ 'gzpassthru(': 'resource zp | int',
\ 'gzread(': 'resource zp, int length | string',
\ 'gzrewind(': 'resource zp | bool',
\ 'gzseek(': 'resource zp, int offset | int',
\ 'gztell(': 'resource zp | int',
\ 'gzuncompress(': 'string data [, int length] | string',
\ 'gzwrite(': 'resource zp, string string [, int length] | int',
\ '__halt_compiler(': 'void  | void',
\ 'hash_algos(': 'void  | array',
\ 'hash_file(': 'string algo, string filename [, bool raw_output] | string',
\ 'hash_final(': 'resource context [, bool raw_output] | string',
\ 'hash_hmac_file(': 'string algo, string filename, string key [, bool raw_output] | string',
\ 'hash_hmac(': 'string algo, string data, string key [, bool raw_output] | string',
\ 'hash(': 'string algo, string data [, bool raw_output] | string',
\ 'hash_init(': 'string algo [, int options, string key] | resource',
\ 'hash_update_file(': 'resource context, string filename [, resource context] | bool',
\ 'hash_update(': 'resource context, string data | bool',
\ 'hash_update_stream(': 'resource context, resource handle [, int length] | int',
\ 'header(': 'string string [, bool replace [, int http_response_code]] | void',
\ 'headers_list(': 'void  | array',
\ 'headers_sent(': '[string &#38;file [, int &#38;line]] | bool',
\ 'hebrevc(': 'string hebrew_text [, int max_chars_per_line] | string',
\ 'hebrev(': 'string hebrew_text [, int max_chars_per_line] | string',
\ 'hexdec(': 'string hex_string | number',
\ 'highlight_file(': 'string filename [, bool return] | mixed',
\ 'highlight_string(': 'string str [, bool return] | mixed',
\ 'htmlentities(': 'string string [, int quote_style [, string charset]] | string',
\ 'html_entity_decode(': 'string string [, int quote_style [, string charset]] | string',
\ 'htmlspecialchars_decode(': 'string string [, int quote_style] | string',
\ 'htmlspecialchars(': 'string string [, int quote_style [, string charset]] | string',
\ 'http_build_query(': 'array formdata [, string numeric_prefix] | string',
\ 'hw_api_attribute(': '[string name [, string value]] | HW_API_Attribute',
\ 'hw_api_attribute-&#62;key(': 'void  | string',
\ 'hw_api_attribute-&#62;langdepvalue(': 'string language | string',
\ 'hw_api_attribute-&#62;value(': 'void  | string',
\ 'hw_api_attribute-&#62;values(': 'void  | array',
\ 'hw_api-&#62;checkin(': 'array parameter | bool',
\ 'hw_api-&#62;checkout(': 'array parameter | bool',
\ 'hw_api-&#62;children(': 'array parameter | array',
\ 'hw_api-&#62;content(': 'array parameter | HW_API_Content',
\ 'hw_api_content-&#62;mimetype(': 'void  | string',
\ 'hw_api_content-&#62;read(': 'string buffer, int len | string',
\ 'hw_api-&#62;copy(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;dbstat(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;dcstat(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;dstanchors(': 'array parameter | array',
\ 'hw_api-&#62;dstofsrcanchor(': 'array parameter | hw_api_object',
\ 'hw_api_error-&#62;count(': 'void  | int',
\ 'hw_api_error-&#62;reason(': 'void  | HW_API_Reason',
\ 'hw_api-&#62;find(': 'array parameter | array',
\ 'hw_api-&#62;ftstat(': 'array parameter | hw_api_object',
\ 'hwapi_hgcsp(': 'string hostname [, int port] | HW_API',
\ 'hw_api-&#62;hwstat(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;identify(': 'array parameter | bool',
\ 'hw_api-&#62;info(': 'array parameter | array',
\ 'hw_api-&#62;insertanchor(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;insertcollection(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;insertdocument(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;insert(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;link(': 'array parameter | bool',
\ 'hw_api-&#62;lock(': 'array parameter | bool',
\ 'hw_api-&#62;move(': 'array parameter | bool',
\ 'hw_api_content(': 'string content, string mimetype | HW_API_Content',
\ 'hw_api_object-&#62;assign(': 'array parameter | bool',
\ 'hw_api_object-&#62;attreditable(': 'array parameter | bool',
\ 'hw_api-&#62;objectbyanchor(': 'array parameter | hw_api_object',
\ 'hw_api_object-&#62;count(': 'array parameter | int',
\ 'hw_api-&#62;object(': 'array parameter | hw_api_object',
\ 'hw_api_object-&#62;insert(': 'HW_API_Attribute attribute | bool',
\ 'hw_api_object(': 'array parameter | hw_api_object',
\ 'hw_api_object-&#62;remove(': 'string name | bool',
\ 'hw_api_object-&#62;title(': 'array parameter | string',
\ 'hw_api_object-&#62;value(': 'string name | string',
\ 'hw_api-&#62;parents(': 'array parameter | array',
\ 'hw_api_reason-&#62;description(': 'void  | string',
\ 'hw_api_reason-&#62;type(': 'void  | HW_API_Reason',
\ 'hw_api-&#62;remove(': 'array parameter | bool',
\ 'hw_api-&#62;replace(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;setcommittedversion(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;srcanchors(': 'array parameter | array',
\ 'hw_api-&#62;srcsofdst(': 'array parameter | array',
\ 'hw_api-&#62;unlock(': 'array parameter | bool',
\ 'hw_api-&#62;user(': 'array parameter | hw_api_object',
\ 'hw_api-&#62;userlist(': 'array parameter | array',
\ 'hw_array2objrec(': 'array object_array | string',
\ 'hw_changeobject(': 'int link, int objid, array attributes | bool',
\ 'hw_children(': 'int connection, int objectID | array',
\ 'hw_childrenobj(': 'int connection, int objectID | array',
\ 'hw_close(': 'int connection | bool',
\ 'hw_connect(': 'string host, int port [, string username, string password] | int',
\ 'hw_connection_info(': 'int link | void',
\ 'hw_cp(': 'int connection, array object_id_array, int destination_id | int',
\ 'hw_deleteobject(': 'int connection, int object_to_delete | bool',
\ 'hw_docbyanchor(': 'int connection, int anchorID | int',
\ 'hw_docbyanchorobj(': 'int connection, int anchorID | string',
\ 'hw_document_attributes(': 'int hw_document | string',
\ 'hw_document_bodytag(': 'int hw_document [, string prefix] | string',
\ 'hw_document_content(': 'int hw_document | string',
\ 'hw_document_setcontent(': 'int hw_document, string content | bool',
\ 'hw_document_size(': 'int hw_document | int',
\ 'hw_dummy(': 'int link, int id, int msgid | string',
\ 'hw_edittext(': 'int connection, int hw_document | bool',
\ 'hw_error(': 'int connection | int',
\ 'hw_errormsg(': 'int connection | string',
\ 'hw_free_document(': 'int hw_document | bool',
\ 'hw_getanchors(': 'int connection, int objectID | array',
\ 'hw_getanchorsobj(': 'int connection, int objectID | array',
\ 'hw_getandlock(': 'int connection, int objectID | string',
\ 'hw_getchildcoll(': 'int connection, int objectID | array',
\ 'hw_getchildcollobj(': 'int connection, int objectID | array',
\ 'hw_getchilddoccoll(': 'int connection, int objectID | array',
\ 'hw_getchilddoccollobj(': 'int connection, int objectID | array',
\ 'hw_getobjectbyquerycoll(': 'int connection, int objectID, string query, int max_hits | array',
\ 'hw_getobjectbyquerycollobj(': 'int connection, int objectID, string query, int max_hits | array',
\ 'hw_getobjectbyquery(': 'int connection, string query, int max_hits | array',
\ 'hw_getobjectbyqueryobj(': 'int connection, string query, int max_hits | array',
\ 'hw_getobject(': 'int connection, mixed objectID [, string query] | mixed',
\ 'hw_getparents(': 'int connection, int objectID | array',
\ 'hw_getparentsobj(': 'int connection, int objectID | array',
\ 'hw_getrellink(': 'int link, int rootid, int sourceid, int destid | string',
\ 'hw_getremotechildren(': 'int connection, string object_record | mixed',
\ 'hw_getremote(': 'int connection, int objectID | int',
\ 'hw_getsrcbydestobj(': 'int connection, int objectID | array',
\ 'hw_gettext(': 'int connection, int objectID [, mixed rootID/prefix] | int',
\ 'hw_getusername(': 'int connection | string',
\ 'hw_identify(': 'int link, string username, string password | string',
\ 'hw_incollections(': 'int connection, array object_id_array, array collection_id_array, int return_collections | array',
\ 'hw_info(': 'int connection | string',
\ 'hw_inscoll(': 'int connection, int objectID, array object_array | int',
\ 'hw_insdoc(': 'resource connection, int parentID, string object_record [, string text] | int',
\ 'hw_insertanchors(': 'int hwdoc, array anchorecs, array dest [, array urlprefixes] | bool',
\ 'hw_insertdocument(': 'int connection, int parent_id, int hw_document | int',
\ 'hw_insertobject(': 'int connection, string object_rec, string parameter | int',
\ 'hw_mapid(': 'int connection, int server_id, int object_id | int',
\ 'hw_modifyobject(': 'int connection, int object_to_change, array remove, array add [, int mode] | bool',
\ 'hw_mv(': 'int connection, array object_id_array, int source_id, int destination_id | int',
\ 'hw_new_document(': 'string object_record, string document_data, int document_size | int',
\ 'hw_objrec2array(': 'string object_record [, array format] | array',
\ 'hw_output_document(': 'int hw_document | bool',
\ 'hw_pconnect(': 'string host, int port [, string username, string password] | int',
\ 'hw_pipedocument(': 'int connection, int objectID [, array url_prefixes] | int',
\ 'hw_root(': ' | int',
\ 'hw_setlinkroot(': 'int link, int rootid | int',
\ 'hw_stat(': 'int link | string',
\ 'hw_unlock(': 'int connection, int objectID | bool',
\ 'hw_who(': 'int connection | array',
\ 'hypot(': 'float x, float y | float',
\ 'i18n_loc_get_default(': 'void  | string',
\ 'i18n_loc_set_default(': 'string name | bool',
\ 'ibase_add_user(': 'resource service_handle, string user_name, string password [, string first_name [, string middle_name [, string last_name]]] | bool',
\ 'ibase_affected_rows(': '[resource link_identifier] | int',
\ 'ibase_backup(': 'resource service_handle, string source_db, string dest_file [, int options [, bool verbose]] | mixed',
\ 'ibase_blob_add(': 'resource blob_handle, string data | void',
\ 'ibase_blob_cancel(': 'resource blob_handle | bool',
\ 'ibase_blob_close(': 'resource blob_handle | mixed',
\ 'ibase_blob_create(': '[resource link_identifier] | resource',
\ 'ibase_blob_echo(': 'resource link_identifier, string blob_id | bool',
\ 'ibase_blob_get(': 'resource blob_handle, int len | string',
\ 'ibase_blob_import(': 'resource link_identifier, resource file_handle | string',
\ 'ibase_blob_info(': 'resource link_identifier, string blob_id | array',
\ 'ibase_blob_open(': 'resource link_identifier, string blob_id | resource',
\ 'ibase_close(': '[resource connection_id] | bool',
\ 'ibase_commit(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_commit_ret(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_connect(': '[string database [, string username [, string password [, string charset [, int buffers [, int dialect [, string role [, int sync]]]]]]]] | resource',
\ 'ibase_db_info(': 'resource service_handle, string db, int action [, int argument] | string',
\ 'ibase_delete_user(': 'resource service_handle, string user_name | bool',
\ 'ibase_drop_db(': '[resource connection] | bool',
\ 'ibase_errcode(': 'void  | int',
\ 'ibase_errmsg(': 'void  | string',
\ 'ibase_execute(': 'resource query [, mixed bind_arg [, mixed ...]] | resource',
\ 'ibase_fetch_assoc(': 'resource result [, int fetch_flag] | array',
\ 'ibase_fetch_object(': 'resource result_id [, int fetch_flag] | object',
\ 'ibase_fetch_row(': 'resource result_identifier [, int fetch_flag] | array',
\ 'ibase_field_info(': 'resource result, int field_number | array',
\ 'ibase_free_event_handler(': 'resource event | bool',
\ 'ibase_free_query(': 'resource query | bool',
\ 'ibase_free_result(': 'resource result_identifier | bool',
\ 'ibase_gen_id(': 'string generator [, int increment [, resource link_identifier]] | mixed',
\ 'ibase_maintain_db(': 'resource service_handle, string db, int action [, int argument] | bool',
\ 'ibase_modify_user(': 'resource service_handle, string user_name, string password [, string first_name [, string middle_name [, string last_name]]] | bool',
\ 'ibase_name_result(': 'resource result, string name | bool',
\ 'ibase_num_fields(': 'resource result_id | int',
\ 'ibase_num_params(': 'resource query | int',
\ 'ibase_param_info(': 'resource query, int param_number | array',
\ 'ibase_pconnect(': '[string database [, string username [, string password [, string charset [, int buffers [, int dialect [, string role [, int sync]]]]]]]] | resource',
\ 'ibase_prepare(': 'string query | resource',
\ 'ibase_query(': '[resource link_identifier, string query [, int bind_args]] | resource',
\ 'ibase_restore(': 'resource service_handle, string source_file, string dest_db [, int options [, bool verbose]] | mixed',
\ 'ibase_rollback(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_rollback_ret(': '[resource link_or_trans_identifier] | bool',
\ 'ibase_server_info(': 'resource service_handle, int action | string',
\ 'ibase_service_attach(': 'string host, string dba_username, string dba_password | resource',
\ 'ibase_service_detach(': 'resource service_handle | bool',
\ 'ibase_set_event_handler(': 'callback event_handler, string event_name1 [, string event_name2 [, string ...]] | resource',
\ 'ibase_timefmt(': 'string format [, int columntype] | int',
\ 'ibase_trans(': '[int trans_args [, resource link_identifier]] | resource',
\ 'ibase_wait_event(': 'string event_name1 [, string event_name2 [, string ...]] | string',
\ 'icap_close(': 'int icap_stream [, int flags] | int',
\ 'icap_create_calendar(': 'int stream_id, string calendar | string',
\ 'icap_delete_calendar(': 'int stream_id, string calendar | string',
\ 'icap_delete_event(': 'int stream_id, int uid | string',
\ 'icap_fetch_event(': 'int stream_id, int event_id [, int options] | int',
\ 'icap_list_alarms(': 'int stream_id, array date, array time | int',
\ 'icap_list_events(': 'int stream_id, int begin_date [, int end_date] | array',
\ 'icap_open(': 'string calendar, string username, string password, string options | resource',
\ 'icap_rename_calendar(': 'int stream_id, string old_name, string new_name | string',
\ 'icap_reopen(': 'int stream_id, string calendar [, int options] | int',
\ 'icap_snooze(': 'int stream_id, int uid | string',
\ 'icap_store_event(': 'int stream_id, object event | string',
\ 'iconv_get_encoding(': '[string type] | mixed',
\ 'iconv(': 'string in_charset, string out_charset, string str | string',
\ 'iconv_mime_decode_headers(': 'string encoded_headers [, int mode [, string charset]] | array',
\ 'iconv_mime_decode(': 'string encoded_header [, int mode [, string charset]] | string',
\ 'iconv_mime_encode(': 'string field_name, string field_value [, array preferences] | string',
\ 'iconv_set_encoding(': 'string type, string charset | bool',
\ 'iconv_strlen(': 'string str [, string charset] | int',
\ 'iconv_strpos(': 'string haystack, string needle [, int offset [, string charset]] | int',
\ 'iconv_strrpos(': 'string haystack, string needle [, string charset] | int',
\ 'iconv_substr(': 'string str, int offset [, int length [, string charset]] | string',
\ 'id3_get_frame_long_name(': 'string frameId | string',
\ 'id3_get_frame_short_name(': 'string frameId | string',
\ 'id3_get_genre_id(': 'string genre | int',
\ 'id3_get_genre_list(': 'void  | array',
\ 'id3_get_genre_name(': 'int genre_id | string',
\ 'id3_get_tag(': 'string filename [, int version] | array',
\ 'id3_get_version(': 'string filename | int',
\ 'id3_remove_tag(': 'string filename [, int version] | bool',
\ 'id3_set_tag(': 'string filename, array tag [, int version] | bool',
\ 'idate(': 'string format [, int timestamp] | int',
\ 'ifx_affected_rows(': 'int result_id | int',
\ 'ifx_blobinfile_mode(': 'int mode | void',
\ 'ifx_byteasvarchar(': 'int mode | void',
\ 'ifx_close(': '[int link_identifier] | int',
\ 'ifx_connect(': '[string database [, string userid [, string password]]] | int',
\ 'ifx_copy_blob(': 'int bid | int',
\ 'ifx_create_blob(': 'int type, int mode, string param | int',
\ 'ifx_create_char(': 'string param | int',
\ 'ifx_do(': 'int result_id | int',
\ 'ifx_error(': 'void  | string',
\ 'ifx_errormsg(': '[int errorcode] | string',
\ 'ifx_fetch_row(': 'int result_id [, mixed position] | array',
\ 'ifx_fieldproperties(': 'int result_id | array',
\ 'ifx_fieldtypes(': 'int result_id | array',
\ 'ifx_free_blob(': 'int bid | int',
\ 'ifx_free_char(': 'int bid | int',
\ 'ifx_free_result(': 'int result_id | int',
\ 'ifx_get_blob(': 'int bid | int',
\ 'ifx_get_char(': 'int bid | int',
\ 'ifx_getsqlca(': 'int result_id | array',
\ 'ifx_htmltbl_result(': 'int result_id [, string html_table_options] | int',
\ 'ifx_nullformat(': 'int mode | void',
\ 'ifx_num_fields(': 'int result_id | int',
\ 'ifx_num_rows(': 'int result_id | int',
\ 'ifx_pconnect(': '[string database [, string userid [, string password]]] | int',
\ 'ifx_prepare(': 'string query, int conn_id [, int cursor_def, mixed blobidarray] | int',
\ 'ifx_query(': 'string query, int link_identifier [, int cursor_type [, mixed blobidarray]] | int',
\ 'ifx_textasvarchar(': 'int mode | void',
\ 'ifx_update_blob(': 'int bid, string content | bool',
\ 'ifx_update_char(': 'int bid, string content | int',
\ 'ifxus_close_slob(': 'int bid | int',
\ 'ifxus_create_slob(': 'int mode | int',
\ 'ifxus_free_slob(': 'int bid | int',
\ 'ifxus_open_slob(': 'int bid, int mode | int',
\ 'ifxus_read_slob(': 'int bid, int nbytes | int',
\ 'ifxus_seek_slob(': 'int bid, int mode, int offset | int',
\ 'ifxus_tell_slob(': 'int bid | int',
\ 'ifxus_write_slob(': 'int bid, string content | int',
\ 'ignore_user_abort(': '[bool setting] | int',
\ 'iis_add_server(': 'string path, string comment, string server_ip, int port, string host_name, int rights, int start_server | int',
\ 'iis_get_dir_security(': 'int server_instance, string virtual_path | int',
\ 'iis_get_script_map(': 'int server_instance, string virtual_path, string script_extension | string',
\ 'iis_get_server_by_comment(': 'string comment | int',
\ 'iis_get_server_by_path(': 'string path | int',
\ 'iis_get_server_rights(': 'int server_instance, string virtual_path | int',
\ 'iis_get_service_state(': 'string service_id | int',
\ 'iis_remove_server(': 'int server_instance | int',
\ 'iis_set_app_settings(': 'int server_instance, string virtual_path, string application_scope | int',
\ 'iis_set_dir_security(': 'int server_instance, string virtual_path, int directory_flags | int',
\ 'iis_set_script_map(': 'int server_instance, string virtual_path, string script_extension, string engine_path, int allow_scripting | int',
\ 'iis_set_server_rights(': 'int server_instance, string virtual_path, int directory_flags | int',
\ 'iis_start_server(': 'int server_instance | int',
\ 'iis_start_service(': 'string service_id | int',
\ 'iis_stop_server(': 'int server_instance | int',
\ 'iis_stop_service(': 'string service_id | int',
\ 'image2wbmp(': 'resource image [, string filename [, int threshold]] | int',
\ 'imagealphablending(': 'resource image, bool blendmode | bool',
\ 'imageantialias(': 'resource im, bool on | bool',
\ 'imagearc(': 'resource image, int cx, int cy, int w, int h, int s, int e, int color | bool',
\ 'imagechar(': 'resource image, int font, int x, int y, string c, int color | bool',
\ 'imagecharup(': 'resource image, int font, int x, int y, string c, int color | bool',
\ 'imagecolorallocatealpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorallocate(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorat(': 'resource image, int x, int y | int',
\ 'imagecolorclosestalpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorclosest(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorclosesthwb(': 'resource image, int red, int green, int blue | int',
\ 'imagecolordeallocate(': 'resource image, int color | bool',
\ 'imagecolorexactalpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorexact(': 'resource image, int red, int green, int blue | int',
\ 'imagecolormatch(': 'resource image1, resource image2 | bool',
\ 'imagecolorresolvealpha(': 'resource image, int red, int green, int blue, int alpha | int',
\ 'imagecolorresolve(': 'resource image, int red, int green, int blue | int',
\ 'imagecolorset(': 'resource image, int index, int red, int green, int blue | void',
\ 'imagecolorsforindex(': 'resource image, int index | array',
\ 'imagecolorstotal(': 'resource image | int',
\ 'imagecolortransparent(': 'resource image [, int color] | int',
\ 'imageconvolution(': 'resource image, array matrix3x3, float div, float offset | bool',
\ 'imagecopy(': 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h | bool',
\ 'imagecopymergegray(': 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct | bool',
\ 'imagecopymerge(': 'resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct | bool',
\ 'imagecopyresampled(': 'resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h | bool',
\ 'imagecopyresized(': 'resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h | bool',
\ 'imagecreatefromgd2(': 'string filename | resource',
\ 'imagecreatefromgd2part(': 'string filename, int srcX, int srcY, int width, int height | resource',
\ 'imagecreatefromgd(': 'string filename | resource',
\ 'imagecreatefromgif(': 'string filename | resource',
\ 'imagecreatefromjpeg(': 'string filename | resource',
\ 'imagecreatefrompng(': 'string filename | resource',
\ 'imagecreatefromstring(': 'string image | resource',
\ 'imagecreatefromwbmp(': 'string filename | resource',
\ 'imagecreatefromxbm(': 'string filename | resource',
\ 'imagecreatefromxpm(': 'string filename | resource',
\ 'imagecreate(': 'int x_size, int y_size | resource',
\ 'imagecreatetruecolor(': 'int x_size, int y_size | resource',
\ 'imagedashedline(': 'resource image, int x1, int y1, int x2, int y2, int color | bool',
\ 'imagedestroy(': 'resource image | bool',
\ 'imageellipse(': 'resource image, int cx, int cy, int w, int h, int color | bool',
\ 'imagefilledarc(': 'resource image, int cx, int cy, int w, int h, int s, int e, int color, int style | bool',
\ 'imagefilledellipse(': 'resource image, int cx, int cy, int w, int h, int color | bool',
\ 'imagefilledpolygon(': 'resource image, array points, int num_points, int color | bool',
\ 'imagefilledrectangle(': 'resource image, int x1, int y1, int x2, int y2, int color | bool',
\ 'imagefill(': 'resource image, int x, int y, int color | bool',
\ 'imagefilltoborder(': 'resource image, int x, int y, int border, int color | bool',
\ 'imagefilter(': 'resource src_im, int filtertype [, int arg1 [, int arg2 [, int arg3]]] | bool',
\ 'imagefontheight(': 'int font | int',
\ 'imagefontwidth(': 'int font | int',
\ 'imageftbbox(': 'float size, float angle, string font_file, string text [, array extrainfo] | array',
\ 'imagefttext(': 'resource image, float size, float angle, int x, int y, int col, string font_file, string text [, array extrainfo] | array',
\ 'imagegammacorrect(': 'resource image, float inputgamma, float outputgamma | bool',
\ 'imagegd2(': 'resource image [, string filename [, int chunk_size [, int type]]] | bool',
\ 'imagegd(': 'resource image [, string filename] | bool',
\ 'imagegif(': 'resource image [, string filename] | bool',
\ 'imageinterlace(': 'resource image [, int interlace] | int',
\ 'imageistruecolor(': 'resource image | bool',
\ 'imagejpeg(': 'resource image [, string filename [, int quality]] | bool',
\ 'imagelayereffect(': 'resource image, int effect | bool',
\ 'imageline(': 'resource image, int x1, int y1, int x2, int y2, int color | bool',
\ 'imageloadfont(': 'string file | int',
\ 'imagepalettecopy(': 'resource destination, resource source | void',
\ 'imagepng(': 'resource image [, string filename] | bool',
\ 'imagepolygon(': 'resource image, array points, int num_points, int color | bool',
\ 'imagepsbbox(': 'string text, int font, int size [, int space, int tightness, float angle] | array',
\ 'imagepscopyfont(': 'resource fontindex | int',
\ 'imagepsencodefont(': 'resource font_index, string encodingfile | bool',
\ 'imagepsextendfont(': 'int font_index, float extend | bool',
\ 'imagepsfreefont(': 'resource fontindex | bool',
\ 'imagepsloadfont(': 'string filename | resource',
\ 'imagepsslantfont(': 'resource font_index, float slant | bool',
\ 'imagepstext(': 'resource image, string text, resource font, int size, int foreground, int background, int x, int y [, int space, int tightness, float angle, int antialias_steps] | array',
\ 'imagerectangle(': 'resource image, int x1, int y1, int x2, int y2, int col | bool',
\ 'imagerotate(': 'resource src_im, float angle, int bgd_color [, int ignore_transparent] | resource',
\ 'imagesavealpha(': 'resource image, bool saveflag | bool',
\ 'imagesetbrush(': 'resource image, resource brush | bool',
\ 'imagesetpixel(': 'resource image, int x, int y, int color | bool',
\ 'imagesetstyle(': 'resource image, array style | bool',
\ 'imagesetthickness(': 'resource image, int thickness | bool',
\ 'imagesettile(': 'resource image, resource tile | bool',
\ 'imagestring(': 'resource image, int font, int x, int y, string s, int col | bool',
\ 'imagestringup(': 'resource image, int font, int x, int y, string s, int col | bool',
\ 'imagesx(': 'resource image | int',
\ 'imagesy(': 'resource image | int',
\ 'imagetruecolortopalette(': 'resource image, bool dither, int ncolors | bool',
\ 'imagettfbbox(': 'float size, float angle, string fontfile, string text | array',
\ 'imagettftext(': 'resource image, float size, float angle, int x, int y, int color, string fontfile, string text | array',
\ 'imagetypes(': 'void  | int',
\ 'image_type_to_extension(': 'int imagetype [, bool include_dot] | string',
\ 'image_type_to_mime_type(': 'int imagetype | string',
\ 'imagewbmp(': 'resource image [, string filename [, int foreground]] | bool',
\ 'imagexbm(': 'resource image, string filename [, int foreground] | bool',
\ 'imap_8bit(': 'string string | string',
\ 'imap_alerts(': 'void  | array',
\ 'imap_append(': 'resource imap_stream, string mbox, string message [, string options] | bool',
\ 'imap_base64(': 'string text | string',
\ 'imap_binary(': 'string string | string',
\ 'imap_body(': 'resource imap_stream, int msg_number [, int options] | string',
\ 'imap_bodystruct(': 'resource stream_id, int msg_no, string section | object',
\ 'imap_check(': 'resource imap_stream | object',
\ 'imap_clearflag_full(': 'resource stream, string sequence, string flag [, string options] | bool',
\ 'imap_close(': 'resource imap_stream [, int flag] | bool',
\ 'imap_createmailbox(': 'resource imap_stream, string mbox | bool',
\ 'imap_delete(': 'int imap_stream, int msg_number [, int options] | bool',
\ 'imap_deletemailbox(': 'resource imap_stream, string mbox | bool',
\ 'imap_errors(': 'void  | array',
\ 'imap_expunge(': 'resource imap_stream | bool',
\ 'imap_fetchbody(': 'resource imap_stream, int msg_number, string part_number [, int options] | string',
\ 'imap_fetchheader(': 'resource imap_stream, int msgno [, int options] | string',
\ 'imap_fetch_overview(': 'resource imap_stream, string sequence [, int options] | array',
\ 'imap_fetchstructure(': 'resource imap_stream, int msg_number [, int options] | object',
\ 'imap_getacl(': 'resource stream_id, string mailbox | array',
\ 'imap_getmailboxes(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_get_quota(': 'resource imap_stream, string quota_root | array',
\ 'imap_get_quotaroot(': 'resource imap_stream, string quota_root | array',
\ 'imap_getsubscribed(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_headerinfo(': 'resource imap_stream, int msg_number [, int fromlength [, int subjectlength [, string defaulthost]]] | object',
\ 'imap_headers(': 'resource imap_stream | array',
\ 'imap_last_error(': 'void  | string',
\ 'imap_list(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_listscan(': 'resource imap_stream, string ref, string pattern, string content | array',
\ 'imap_lsub(': 'resource imap_stream, string ref, string pattern | array',
\ 'imap_mailboxmsginfo(': 'resource imap_stream | object',
\ 'imap_mail_compose(': 'array envelope, array body | string',
\ 'imap_mail_copy(': 'resource imap_stream, string msglist, string mbox [, int options] | bool',
\ 'imap_mail(': 'string to, string subject, string message [, string additional_headers [, string cc [, string bcc [, string rpath]]]] | bool',
\ 'imap_mail_move(': 'resource imap_stream, string msglist, string mbox [, int options] | bool',
\ 'imap_mime_header_decode(': 'string text | array',
\ 'imap_msgno(': 'resource imap_stream, int uid | int',
\ 'imap_num_msg(': 'resource imap_stream | int',
\ 'imap_num_recent(': 'resource imap_stream | int',
\ 'imap_open(': 'string mailbox, string username, string password [, int options] | resource',
\ 'imap_ping(': 'resource imap_stream | bool',
\ 'imap_qprint(': 'string string | string',
\ 'imap_renamemailbox(': 'resource imap_stream, string old_mbox, string new_mbox | bool',
\ 'imap_reopen(': 'resource imap_stream, string mailbox [, int options] | bool',
\ 'imap_rfc822_parse_adrlist(': 'string address, string default_host | array',
\ 'imap_rfc822_parse_headers(': 'string headers [, string defaulthost] | object',
\ 'imap_rfc822_write_address(': 'string mailbox, string host, string personal | string',
\ 'imap_search(': 'resource imap_stream, string criteria [, int options [, string charset]] | array',
\ 'imap_setacl(': 'resource stream_id, string mailbox, string id, string rights | bool',
\ 'imap_setflag_full(': 'resource stream, string sequence, string flag [, string options] | bool',
\ 'imap_set_quota(': 'resource imap_stream, string quota_root, int quota_limit | bool',
\ 'imap_sort(': 'resource stream, int criteria, int reverse [, int options [, string search_criteria [, string charset]]] | array',
\ 'imap_status(': 'resource imap_stream, string mailbox, int options | object',
\ 'imap_subscribe(': 'resource imap_stream, string mbox | bool',
\ 'imap_thread(': 'resource stream_id [, int options] | array',
\ 'imap_timeout(': 'int timeout_type [, int timeout] | mixed',
\ 'imap_uid(': 'resource imap_stream, int msgno | int',
\ 'imap_undelete(': 'resource imap_stream, int msg_number [, int flags] | bool',
\ 'imap_unsubscribe(': 'string imap_stream, string mbox | bool',
\ 'imap_utf7_decode(': 'string text | string',
\ 'imap_utf7_encode(': 'string data | string',
\ 'imap_utf8(': 'string mime_encoded_text | string',
\ 'implode(': 'string glue, array pieces | string',
\ 'import_request_variables(': 'string types [, string prefix] | bool',
\ 'in_array(': 'mixed needle, array haystack [, bool strict] | bool',
\ 'inet_ntop(': 'string in_addr | string',
\ 'inet_pton(': 'string address | string',
\ 'ingres_autocommit(': '[resource link] | bool',
\ 'ingres_close(': '[resource link] | bool',
\ 'ingres_commit(': '[resource link] | bool',
\ 'ingres_connect(': '[string database [, string username [, string password]]] | resource',
\ 'ingres_cursor(': '[resource link] | string',
\ 'ingres_errno(': '[resource link] | int',
\ 'ingres_error(': '[resource link] | string',
\ 'ingres_errsqlstate(': '[resource link] | string',
\ 'ingres_fetch_array(': '[int result_type [, resource link]] | array',
\ 'ingres_fetch_object(': '[int result_type [, resource link]] | object',
\ 'ingres_fetch_row(': '[resource link] | array',
\ 'ingres_field_length(': 'int index [, resource link] | int',
\ 'ingres_field_name(': 'int index [, resource link] | string',
\ 'ingres_field_nullable(': 'int index [, resource link] | bool',
\ 'ingres_field_precision(': 'int index [, resource link] | int',
\ 'ingres_field_scale(': 'int index [, resource link] | int',
\ 'ingres_field_type(': 'int index [, resource link] | string',
\ 'ingres_num_fields(': '[resource link] | int',
\ 'ingres_num_rows(': '[resource link] | int',
\ 'ingres_pconnect(': '[string database [, string username [, string password]]] | resource',
\ 'ingres_query(': 'string query [, resource link] | bool',
\ 'ingres_rollback(': '[resource link] | bool',
\ 'ini_get_all(': '[string extension] | array',
\ 'ini_get(': 'string varname | string',
\ 'ini_restore(': 'string varname | void',
\ 'ini_set(': 'string varname, string newvalue | string',
\ 'interface_exists(': 'string interface_name [, bool autoload] | bool',
\ 'intval(': 'mixed var [, int base] | int',
\ 'ip2long(': 'string ip_address | int',
\ 'iptcembed(': 'string iptcdata, string jpeg_file_name [, int spool] | mixed',
\ 'iptcparse(': 'string iptcblock | array',
\ 'ircg_channel_mode(': 'resource connection, string channel, string mode_spec, string nick | bool',
\ 'ircg_disconnect(': 'resource connection, string reason | bool',
\ 'ircg_eval_ecmascript_params(': 'string params | array',
\ 'ircg_fetch_error_msg(': 'resource connection | array',
\ 'ircg_get_username(': 'resource connection | string',
\ 'ircg_html_encode(': 'string html_string [, bool auto_links [, bool conv_br]] | string',
\ 'ircg_ignore_add(': 'resource connection, string nick | void',
\ 'ircg_ignore_del(': 'resource connection, string nick | bool',
\ 'ircg_invite(': 'resource connection, string channel, string nickname | bool',
\ 'ircg_is_conn_alive(': 'resource connection | bool',
\ 'ircg_join(': 'resource connection, string channel [, string key] | bool',
\ 'ircg_kick(': 'resource connection, string channel, string nick, string reason | bool',
\ 'ircg_list(': 'resource connection, string channel | bool',
\ 'ircg_lookup_format_messages(': 'string name | bool',
\ 'ircg_lusers(': 'resource connection | bool',
\ 'ircg_msg(': 'resource connection, string recipient, string message [, bool suppress] | bool',
\ 'ircg_names(': 'int connection, string channel [, string target] | bool',
\ 'ircg_nick(': 'resource connection, string nick | bool',
\ 'ircg_nickname_escape(': 'string nick | string',
\ 'ircg_nickname_unescape(': 'string nick | string',
\ 'ircg_notice(': 'resource connection, string recipient, string message | bool',
\ 'ircg_oper(': 'resource connection, string name, string password | bool',
\ 'ircg_part(': 'resource connection, string channel | bool',
\ 'ircg_pconnect(': 'string username [, string server_ip [, int server_port [, string msg_format [, array ctcp_messages [, array user_settings [, bool bailout_on_trivial]]]]]] | resource',
\ 'ircg_register_format_messages(': 'string name, array messages | bool',
\ 'ircg_set_current(': 'resource connection | bool',
\ 'ircg_set_file(': 'resource connection, string path | bool',
\ 'ircg_set_on_die(': 'resource connection, string host, int port, string data | bool',
\ 'ircg_topic(': 'resource connection, string channel, string new_topic | bool',
\ 'ircg_who(': 'resource connection, string mask [, bool ops_only] | bool',
\ 'ircg_whois(': 'resource connection, string nick | bool',
\ 'is_a(': 'object object, string class_name | bool',
\ 'is_array(': 'mixed var | bool',
\ 'is_bool(': 'mixed var | bool',
\ 'is_callable(': 'mixed var [, bool syntax_only [, string &#38;callable_name]] | bool',
\ 'is_dir(': 'string filename | bool',
\ 'is_executable(': 'string filename | bool',
\ 'is_file(': 'string filename | bool',
\ 'is_finite(': 'float val | bool',
\ 'is_float(': 'mixed var | bool',
\ 'is_infinite(': 'float val | bool',
\ 'is_int(': 'mixed var | bool',
\ 'is_link(': 'string filename | bool',
\ 'is_nan(': 'float val | bool',
\ 'is_null(': 'mixed var | bool',
\ 'is_numeric(': 'mixed var | bool',
\ 'is_object(': 'mixed var | bool',
\ 'is_readable(': 'string filename | bool',
\ 'is_resource(': 'mixed var | bool',
\ 'is_scalar(': 'mixed var | bool',
\ 'isset(': 'mixed var [, mixed var [, ...]] | bool',
\ 'is_soap_fault(': 'mixed obj | bool',
\ 'is_string(': 'mixed var | bool',
\ 'is_subclass_of(': 'mixed object, string class_name | bool',
\ 'is_uploaded_file(': 'string filename | bool',
\ 'is_writable(': 'string filename | bool',
\ 'iterator_count(': 'IteratorAggregate iterator | int',
\ 'iterator_to_array(': 'IteratorAggregate iterator | array',
\ 'java_last_exception_clear(': 'void  | void',
\ 'java_last_exception_get(': 'void  | object',
\ 'jddayofweek(': 'int julianday [, int mode] | mixed',
\ 'jdmonthname(': 'int julianday, int mode | string',
\ 'jdtofrench(': 'int juliandaycount | string',
\ 'jdtogregorian(': 'int julianday | string',
\ 'jdtojewish(': 'int juliandaycount [, bool hebrew [, int fl]] | string',
\ 'jdtojulian(': 'int julianday | string',
\ 'jdtounix(': 'int jday | int',
\ 'jewishtojd(': 'int month, int day, int year | int',
\ 'jpeg2wbmp(': 'string jpegname, string wbmpname, int d_height, int d_width, int threshold | int',
\ 'juliantojd(': 'int month, int day, int year | int',
\ 'kadm5_chpass_principal(': 'resource handle, string principal, string password | bool',
\ 'kadm5_create_principal(': 'resource handle, string principal [, string password [, array options]] | bool',
\ 'kadm5_delete_principal(': 'resource handle, string principal | bool',
\ 'kadm5_destroy(': 'resource handle | bool',
\ 'kadm5_flush(': 'resource handle | bool',
\ 'kadm5_get_policies(': 'resource handle | array',
\ 'kadm5_get_principal(': 'resource handle, string principal | array',
\ 'kadm5_get_principals(': 'resource handle | array',
\ 'kadm5_init_with_password(': 'string admin_server, string realm, string principal, string password | resource',
\ 'kadm5_modify_principal(': 'resource handle, string principal, array options | bool',
\ 'key(': 'array &#38;array | mixed',
\ 'krsort(': 'array &#38;array [, int sort_flags] | bool',
\ 'ksort(': 'array &#38;array [, int sort_flags] | bool',
\ 'lcg_value(': 'void  | float',
\ 'ldap_8859_to_t61(': 'string value | string',
\ 'ldap_add(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_bind(': 'resource link_identifier [, string bind_rdn [, string bind_password]] | bool',
\ 'ldap_compare(': 'resource link_identifier, string dn, string attribute, string value | mixed',
\ 'ldap_connect(': '[string hostname [, int port]] | resource',
\ 'ldap_count_entries(': 'resource link_identifier, resource result_identifier | int',
\ 'ldap_delete(': 'resource link_identifier, string dn | bool',
\ 'ldap_dn2ufn(': 'string dn | string',
\ 'ldap_err2str(': 'int errno | string',
\ 'ldap_errno(': 'resource link_identifier | int',
\ 'ldap_error(': 'resource link_identifier | string',
\ 'ldap_explode_dn(': 'string dn, int with_attrib | array',
\ 'ldap_first_attribute(': 'resource link_identifier, resource result_entry_identifier, int &#38;ber_identifier | string',
\ 'ldap_first_entry(': 'resource link_identifier, resource result_identifier | resource',
\ 'ldap_first_reference(': 'resource link, resource result | resource',
\ 'ldap_free_result(': 'resource result_identifier | bool',
\ 'ldap_get_attributes(': 'resource link_identifier, resource result_entry_identifier | array',
\ 'ldap_get_dn(': 'resource link_identifier, resource result_entry_identifier | string',
\ 'ldap_get_entries(': 'resource link_identifier, resource result_identifier | array',
\ 'ldap_get_option(': 'resource link_identifier, int option, mixed &#38;retval | bool',
\ 'ldap_get_values(': 'resource link_identifier, resource result_entry_identifier, string attribute | array',
\ 'ldap_get_values_len(': 'resource link_identifier, resource result_entry_identifier, string attribute | array',
\ 'ldap_list(': 'resource link_identifier, string base_dn, string filter [, array attributes [, int attrsonly [, int sizelimit [, int timelimit [, int deref]]]]] | resource',
\ 'ldap_mod_add(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_mod_del(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_modify(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_mod_replace(': 'resource link_identifier, string dn, array entry | bool',
\ 'ldap_next_attribute(': 'resource link_identifier, resource result_entry_identifier, resource &#38;ber_identifier | string',
\ 'ldap_next_entry(': 'resource link_identifier, resource result_entry_identifier | resource',
\ 'ldap_next_reference(': 'resource link, resource entry | resource',
\ 'ldap_parse_reference(': 'resource link, resource entry, array &#38;referrals | bool',
\ 'ldap_parse_result(': 'resource link, resource result, int &#38;errcode [, string &#38;matcheddn [, string &#38;errmsg [, array &#38;referrals]]] | bool',
\ 'ldap_read(': 'resource link_identifier, string base_dn, string filter [, array attributes [, int attrsonly [, int sizelimit [, int timelimit [, int deref]]]]] | resource',
\ 'ldap_rename(': 'resource link_identifier, string dn, string newrdn, string newparent, bool deleteoldrdn | bool',
\ 'ldap_sasl_bind(': 'resource link [, string binddn [, string password [, string sasl_mech [, string sasl_realm [, string sasl_authz_id [, string props]]]]]] | bool',
\ 'ldap_search(': 'resource link_identifier, string base_dn, string filter [, array attributes [, int attrsonly [, int sizelimit [, int timelimit [, int deref]]]]] | resource',
\ 'ldap_set_option(': 'resource link_identifier, int option, mixed newval | bool',
\ 'ldap_set_rebind_proc(': 'resource link, callback callback | bool',
\ 'ldap_sort(': 'resource link, resource result, string sortfilter | bool',
\ 'ldap_start_tls(': 'resource link | bool',
\ 'ldap_t61_to_8859(': 'string value | string',
\ 'ldap_unbind(': 'resource link_identifier | bool',
\ 'levenshtein(': 'string str1, string str2 [, int cost_ins [, int cost_rep, int cost_del]] | int',
\ 'libxml_clear_errors(': 'void  | void',
\ 'libxml_get_errors(': 'void  | array',
\ 'libxml_get_last_error(': 'void  | LibXMLError',
\ 'libxml_set_streams_context(': 'resource streams_context | void',
\ 'libxml_use_internal_errors(': '[bool use_errors] | bool',
\ 'LimitIterator::getPosition(': 'void  | int',
\ 'LimitIterator::next(': 'void  | void',
\ 'LimitIterator::rewind(': 'void  | void',
\ 'LimitIterator::seek(': 'int position | void',
\ 'LimitIterator::valid(': 'void  | bool',
\ 'link(': 'string target, string link | bool',
\ 'linkinfo(': 'string path | int',
\ 'list(': 'mixed varname, mixed ... | void',
\ 'localeconv(': 'void  | array',
\ 'localtime(': '[int timestamp [, bool is_associative]] | array',
\ 'log10(': 'float arg | float',
\ 'log1p(': 'float number | float',
\ 'log(': 'float arg [, float base] | float',
\ 'long2ip(': 'int proper_address | string',
\ 'lstat(': 'string filename | array',
\ 'ltrim(': 'string str [, string charlist] | string',
\ 'lzf_compress(': 'string data | string',
\ 'lzf_decompress(': 'string data | string',
\ 'lzf_optimized_for(': 'void  | int',
\ 'mail(': 'string to, string subject, string message [, string additional_headers [, string additional_parameters]] | bool',
\ 'mailparse_determine_best_xfer_encoding(': 'resource fp | string',
\ 'mailparse_msg_create(': 'void  | resource',
\ 'mailparse_msg_extract_part_file(': 'resource rfc2045, string filename [, callback callbackfunc] | string',
\ 'mailparse_msg_extract_part(': 'resource rfc2045, string msgbody [, callback callbackfunc] | void',
\ 'mailparse_msg_free(': 'resource rfc2045buf | bool',
\ 'mailparse_msg_get_part_data(': 'resource rfc2045 | array',
\ 'mailparse_msg_get_part(': 'resource rfc2045, string mimesection | resource',
\ 'mailparse_msg_get_structure(': 'resource rfc2045 | array',
\ 'mailparse_msg_parse_file(': 'string filename | resource',
\ 'mailparse_msg_parse(': 'resource rfc2045buf, string data | bool',
\ 'mailparse_rfc822_parse_addresses(': 'string addresses | array',
\ 'mailparse_stream_encode(': 'resource sourcefp, resource destfp, string encoding | bool',
\ 'mailparse_uudecode_all(': 'resource fp | array',
\ 'maxdb_connect_errno(': 'void  | int',
\ 'maxdb_connect_error(': 'void  | string',
\ 'maxdb_debug(': 'string debug | void',
\ 'maxdb_disable_rpl_parse(': 'resource link | bool',
\ 'maxdb_dump_debug_info(': 'resource link | bool',
\ 'maxdb_embedded_connect(': '[string dbname] | resource',
\ 'maxdb_enable_reads_from_master(': 'resource link | bool',
\ 'maxdb_enable_rpl_parse(': 'resource link | bool',
\ 'maxdb_get_client_info(': 'void  | string',
\ 'maxdb_get_client_version(': 'void  | int',
\ 'maxdb_init(': 'void  | resource',
\ 'maxdb_master_query(': 'resource link, string query | bool',
\ 'maxdb_more_results(': 'resource link | bool',
\ 'maxdb_next_result(': 'resource link | bool',
\ 'maxdb_report(': 'int flags | bool',
\ 'maxdb_rollback(': 'resource link | bool',
\ 'maxdb_rpl_parse_enabled(': 'resource link | int',
\ 'maxdb_rpl_probe(': 'resource link | bool',
\ 'maxdb_rpl_query_type(': 'resource link | int',
\ 'maxdb_select_db(': 'resource link, string dbname | bool',
\ 'maxdb_send_query(': 'resource link, string query | bool',
\ 'maxdb_server_end(': 'void  | void',
\ 'maxdb_server_init(': '[array server [, array groups]] | bool',
\ 'maxdb_stmt_sqlstate(': 'resource stmt | string',
\ 'max(': 'number arg1, number arg2 [, number ...] | mixed',
\ 'mb_convert_case(': 'string str, int mode [, string encoding] | string',
\ 'mb_convert_encoding(': 'string str, string to_encoding [, mixed from_encoding] | string',
\ 'mb_convert_kana(': 'string str [, string option [, string encoding]] | string',
\ 'mb_convert_variables(': 'string to_encoding, mixed from_encoding, mixed &#38;vars [, mixed &#38;...] | string',
\ 'mb_decode_mimeheader(': 'string str | string',
\ 'mb_decode_numericentity(': 'string str, array convmap [, string encoding] | string',
\ 'mb_detect_encoding(': 'string str [, mixed encoding_list [, bool strict]] | string',
\ 'mb_detect_order(': '[mixed encoding_list] | mixed',
\ 'mb_encode_mimeheader(': 'string str [, string charset [, string transfer_encoding [, string linefeed]]] | string',
\ 'mb_encode_numericentity(': 'string str, array convmap [, string encoding] | string',
\ 'mb_ereg(': 'string pattern, string string [, array regs] | int',
\ 'mb_eregi(': 'string pattern, string string [, array regs] | int',
\ 'mb_eregi_replace(': 'string pattern, string replace, string string [, string option] | string',
\ 'mb_ereg_match(': 'string pattern, string string [, string option] | bool',
\ 'mb_ereg_replace(': 'string pattern, string replacement, string string [, string option] | string',
\ 'mb_ereg_search_getpos(': 'void  | int',
\ 'mb_ereg_search_getregs(': 'void  | array',
\ 'mb_ereg_search(': '[string pattern [, string option]] | bool',
\ 'mb_ereg_search_init(': 'string string [, string pattern [, string option]] | bool',
\ 'mb_ereg_search_pos(': '[string pattern [, string option]] | array',
\ 'mb_ereg_search_regs(': '[string pattern [, string option]] | array',
\ 'mb_ereg_search_setpos(': 'int position | bool',
\ 'mb_get_info(': '[string type] | mixed',
\ 'mb_http_input(': '[string type] | mixed',
\ 'mb_http_output(': '[string encoding] | mixed',
\ 'mb_internal_encoding(': '[string encoding] | mixed',
\ 'mb_language(': '[string language] | mixed',
\ 'mb_list_encodings(': 'void  | array',
\ 'mb_output_handler(': 'string contents, int status | string',
\ 'mb_parse_str(': 'string encoded_string [, array &#38;result] | bool',
\ 'mb_preferred_mime_name(': 'string encoding | string',
\ 'mb_regex_encoding(': '[string encoding] | mixed',
\ 'mb_regex_set_options(': '[string options] | string',
\ 'mb_send_mail(': 'string to, string subject, string message [, string additional_headers [, string additional_parameter]] | bool',
\ 'mb_split(': 'string pattern, string string [, int limit] | array',
\ 'mb_strcut(': 'string str, int start [, int length [, string encoding]] | string',
\ 'mb_strimwidth(': 'string str, int start, int width [, string trimmarker [, string encoding]] | string',
\ 'mb_strlen(': 'string str [, string encoding] | int',
\ 'mb_strpos(': 'string haystack, string needle [, int offset [, string encoding]] | int',
\ 'mb_strrpos(': 'string haystack, string needle [, string encoding] | int',
\ 'mb_strtolower(': 'string str [, string encoding] | string',
\ 'mb_strtoupper(': 'string str [, string encoding] | string',
\ 'mb_strwidth(': 'string str [, string encoding] | int',
\ 'mb_substitute_character(': '[mixed substrchar] | mixed',
\ 'mb_substr_count(': 'string haystack, string needle [, string encoding] | int',
\ 'mb_substr(': 'string str, int start [, int length [, string encoding]] | string',
\ 'mcal_append_event(': 'int mcal_stream | int',
\ 'mcal_close(': 'int mcal_stream [, int flags] | bool',
\ 'mcal_create_calendar(': 'int stream, string calendar | bool',
\ 'mcal_date_compare(': 'int a_year, int a_month, int a_day, int b_year, int b_month, int b_day | int',
\ 'mcal_date_valid(': 'int year, int month, int day | bool',
\ 'mcal_day_of_week(': 'int year, int month, int day | int',
\ 'mcal_day_of_year(': 'int year, int month, int day | int',
\ 'mcal_days_in_month(': 'int month, int leap_year | int',
\ 'mcal_delete_calendar(': 'int stream, string calendar | bool',
\ 'mcal_delete_event(': 'int mcal_stream, int event_id | bool',
\ 'mcal_event_add_attribute(': 'int stream, string attribute, string value | bool',
\ 'mcal_event_init(': 'int stream | void',
\ 'mcal_event_set_alarm(': 'int stream, int alarm | void',
\ 'mcal_event_set_category(': 'int stream, string category | void',
\ 'mcal_event_set_class(': 'int stream, int class | void',
\ 'mcal_event_set_description(': 'int stream, string description | void',
\ 'mcal_event_set_end(': 'int stream, int year, int month, int day [, int hour [, int min [, int sec]]] | void',
\ 'mcal_event_set_recur_daily(': 'int stream, int year, int month, int day, int interval | void',
\ 'mcal_event_set_recur_monthly_mday(': 'int stream, int year, int month, int day, int interval | void',
\ 'mcal_event_set_recur_monthly_wday(': 'int stream, int year, int month, int day, int interval | void',
\ 'mcal_event_set_recur_none(': 'int stream | void',
\ 'mcal_event_set_recur_weekly(': 'int stream, int year, int month, int day, int interval, int weekdays | void',
\ 'mcal_event_set_recur_yearly(': 'int stream, int year, int month, int day, int interval | void',
\ 'mcal_event_set_start(': 'int stream, int year, int month, int day [, int hour [, int min [, int sec]]] | void',
\ 'mcal_event_set_title(': 'int stream, string title | void',
\ 'mcal_expunge(': 'int stream | bool',
\ 'mcal_fetch_current_stream_event(': 'int stream | object',
\ 'mcal_fetch_event(': 'int mcal_stream, int event_id [, int options] | object',
\ 'mcal_is_leap_year(': 'int year | bool',
\ 'mcal_list_alarms(': 'int mcal_stream [, int begin_year, int begin_month, int begin_day, int end_year, int end_month, int end_day] | array',
\ 'mcal_list_events(': 'int mcal_stream [, int begin_year, int begin_month, int begin_day, int end_year, int end_month, int end_day] | array',
\ 'mcal_next_recurrence(': 'int stream, int weekstart, array next | object',
\ 'mcal_open(': 'string calendar, string username, string password [, int options] | int',
\ 'mcal_popen(': 'string calendar, string username, string password [, int options] | int',
\ 'mcal_rename_calendar(': 'int stream, string old_name, string new_name | bool',
\ 'mcal_reopen(': 'int mcal_stream, string calendar [, int options] | bool',
\ 'mcal_snooze(': 'int stream_id, int event_id | bool',
\ 'mcal_store_event(': 'int mcal_stream | int',
\ 'mcal_time_valid(': 'int hour, int minutes, int seconds | bool',
\ 'mcal_week_of_year(': 'int day, int month, int year | int',
\ 'm_checkstatus(': 'resource conn, int identifier | int',
\ 'm_completeauthorizations(': 'resource conn, int &#38;array | int',
\ 'm_connect(': 'resource conn | int',
\ 'm_connectionerror(': 'resource conn | string',
\ 'mcrypt_cbc(': 'int cipher, string key, string data, int mode [, string iv] | string',
\ 'mcrypt_cfb(': 'int cipher, string key, string data, int mode, string iv | string',
\ 'mcrypt_create_iv(': 'int size [, int source] | string',
\ 'mcrypt_decrypt(': 'string cipher, string key, string data, string mode [, string iv] | string',
\ 'mcrypt_ecb(': 'int cipher, string key, string data, int mode | string',
\ 'mcrypt_enc_get_algorithms_name(': 'resource td | string',
\ 'mcrypt_enc_get_block_size(': 'resource td | int',
\ 'mcrypt_enc_get_iv_size(': 'resource td | int',
\ 'mcrypt_enc_get_key_size(': 'resource td | int',
\ 'mcrypt_enc_get_modes_name(': 'resource td | string',
\ 'mcrypt_enc_get_supported_key_sizes(': 'resource td | array',
\ 'mcrypt_enc_is_block_algorithm(': 'resource td | bool',
\ 'mcrypt_enc_is_block_algorithm_mode(': 'resource td | bool',
\ 'mcrypt_enc_is_block_mode(': 'resource td | bool',
\ 'mcrypt_encrypt(': 'string cipher, string key, string data, string mode [, string iv] | string',
\ 'mcrypt_enc_self_test(': 'resource td | int',
\ 'mcrypt_generic_deinit(': 'resource td | bool',
\ 'mcrypt_generic_end(': 'resource td | bool',
\ 'mcrypt_generic(': 'resource td, string data | string',
\ 'mcrypt_generic_init(': 'resource td, string key, string iv | int',
\ 'mcrypt_get_block_size(': 'int cipher | int',
\ 'mcrypt_get_cipher_name(': 'int cipher | string',
\ 'mcrypt_get_iv_size(': 'string cipher, string mode | int',
\ 'mcrypt_get_key_size(': 'int cipher | int',
\ 'mcrypt_list_algorithms(': '[string lib_dir] | array',
\ 'mcrypt_list_modes(': '[string lib_dir] | array',
\ 'mcrypt_module_close(': 'resource td | bool',
\ 'mcrypt_module_get_algo_block_size(': 'string algorithm [, string lib_dir] | int',
\ 'mcrypt_module_get_algo_key_size(': 'string algorithm [, string lib_dir] | int',
\ 'mcrypt_module_get_supported_key_sizes(': 'string algorithm [, string lib_dir] | array',
\ 'mcrypt_module_is_block_algorithm(': 'string algorithm [, string lib_dir] | bool',
\ 'mcrypt_module_is_block_algorithm_mode(': 'string mode [, string lib_dir] | bool',
\ 'mcrypt_module_is_block_mode(': 'string mode [, string lib_dir] | bool',
\ 'mcrypt_module_open(': 'string algorithm, string algorithm_directory, string mode, string mode_directory | resource',
\ 'mcrypt_module_self_test(': 'string algorithm [, string lib_dir] | bool',
\ 'mcrypt_ofb(': 'int cipher, string key, string data, int mode, string iv | string',
\ 'md5_file(': 'string filename [, bool raw_output] | string',
\ 'md5(': 'string str [, bool raw_output] | string',
\ 'mdecrypt_generic(': 'resource td, string data | string',
\ 'm_deletetrans(': 'resource conn, int identifier | bool',
\ 'm_destroyconn(': 'resource conn | bool',
\ 'm_destroyengine(': 'void  | void',
\ 'Memcache::add(': 'string key, mixed var [, int flag [, int expire]] | bool',
\ 'Memcache::addServer(': 'string host [, int port [, bool persistent [, int weight [, int timeout [, int retry_interval]]]]] | bool',
\ 'Memcache::close(': 'void  | bool',
\ 'Memcache::connect(': 'string host [, int port [, int timeout]] | bool',
\ 'memcache_debug(': 'bool on_off | bool',
\ 'Memcache::decrement(': 'string key [, int value] | int',
\ 'Memcache::delete(': 'string key [, int timeout] | bool',
\ 'Memcache::flush(': 'void  | bool',
\ 'Memcache::getExtendedStats(': 'void  | array',
\ 'Memcache::get(': 'string key | string',
\ 'Memcache::getStats(': 'void  | array',
\ 'Memcache::getVersion(': 'void  | string',
\ 'Memcache::increment(': 'string key [, int value] | int',
\ 'Memcache::pconnect(': 'string host [, int port [, int timeout]] | bool',
\ 'Memcache::replace(': 'string key, mixed var [, int flag [, int expire]] | bool',
\ 'Memcache::setCompressThreshold(': 'int threshold [, float min_savings] | bool',
\ 'Memcache::set(': 'string key, mixed var [, int flag [, int expire]] | bool',
\ 'memory_get_usage(': 'void  | int',
\ 'metaphone(': 'string str [, int phones] | string',
\ 'method_exists(': 'object object, string method_name | bool',
\ 'm_getcellbynum(': 'resource conn, int identifier, int column, int row | string',
\ 'm_getcell(': 'resource conn, int identifier, string column, int row | string',
\ 'm_getcommadelimited(': 'resource conn, int identifier | string',
\ 'm_getheader(': 'resource conn, int identifier, int column_num | string',
\ 'mhash_count(': 'void  | int',
\ 'mhash_get_block_size(': 'int hash | int',
\ 'mhash_get_hash_name(': 'int hash | string',
\ 'mhash(': 'int hash, string data [, string key] | string',
\ 'mhash_keygen_s2k(': 'int hash, string password, string salt, int bytes | string',
\ 'microtime(': '[bool get_as_float] | mixed',
\ 'mime_content_type(': 'string filename | string',
\ 'ming_keypress(': 'string str | int',
\ 'ming_setcubicthreshold(': 'int threshold | void',
\ 'ming_setscale(': 'int scale | void',
\ 'ming_useConstants(': 'int use | void',
\ 'ming_useswfversion(': 'int version | void',
\ 'min(': 'number arg1, number arg2 [, number ...] | mixed',
\ 'm_initconn(': 'void  | resource',
\ 'm_initengine(': 'string location | int',
\ 'm_iscommadelimited(': 'resource conn, int identifier | int',
\ 'mkdir(': 'string pathname [, int mode [, bool recursive [, resource context]]] | bool',
\ 'mktime(': '[int hour [, int minute [, int second [, int month [, int day [, int year [, int is_dst]]]]]]] | int',
\ 'm_maxconntimeout(': 'resource conn, int secs | bool',
\ 'm_monitor(': 'resource conn | int',
\ 'm_numcolumns(': 'resource conn, int identifier | int',
\ 'm_numrows(': 'resource conn, int identifier | int',
\ 'money_format(': 'string format, float number | string',
\ 'move_uploaded_file(': 'string filename, string destination | bool',
\ 'm_parsecommadelimited(': 'resource conn, int identifier | int',
\ 'm_responsekeys(': 'resource conn, int identifier | array',
\ 'm_responseparam(': 'resource conn, int identifier, string key | string',
\ 'm_returnstatus(': 'resource conn, int identifier | int',
\ 'msession_connect(': 'string host, string port | bool',
\ 'msession_count(': 'void  | int',
\ 'msession_create(': 'string session | bool',
\ 'msession_destroy(': 'string name | bool',
\ 'msession_disconnect(': 'void  | void',
\ 'msession_find(': 'string name, string value | array',
\ 'msession_get_array(': 'string session | array',
\ 'msession_get_data(': 'string session | string',
\ 'msession_get(': 'string session, string name, string value | string',
\ 'msession_inc(': 'string session, string name | string',
\ 'msession_list(': 'void  | array',
\ 'msession_listvar(': 'string name | array',
\ 'msession_lock(': 'string name | int',
\ 'msession_plugin(': 'string session, string val [, string param] | string',
\ 'msession_randstr(': 'int param | string',
\ 'msession_set_array(': 'string session, array tuples | void',
\ 'msession_set_data(': 'string session, string value | bool',
\ 'msession_set(': 'string session, string name, string value | bool',
\ 'msession_timeout(': 'string session [, int param] | int',
\ 'msession_uniq(': 'int param | string',
\ 'msession_unlock(': 'string session, int key | int',
\ 'm_setblocking(': 'resource conn, int tf | int',
\ 'm_setdropfile(': 'resource conn, string directory | int',
\ 'm_setip(': 'resource conn, string host, int port | int',
\ 'm_setssl_cafile(': 'resource conn, string cafile | int',
\ 'm_setssl_files(': 'resource conn, string sslkeyfile, string sslcertfile | int',
\ 'm_setssl(': 'resource conn, string host, int port | int',
\ 'm_settimeout(': 'resource conn, int seconds | int',
\ 'msg_get_queue(': 'int key [, int perms] | resource',
\ 'msg_receive(': 'resource queue, int desiredmsgtype, int &#38;msgtype, int maxsize, mixed &#38;message [, bool unserialize [, int flags [, int &#38;errorcode]]] | bool',
\ 'msg_remove_queue(': 'resource queue | bool',
\ 'msg_send(': 'resource queue, int msgtype, mixed message [, bool serialize [, bool blocking [, int &#38;errorcode]]] | bool',
\ 'msg_set_queue(': 'resource queue, array data | bool',
\ 'msg_stat_queue(': 'resource queue | array',
\ 'msql_affected_rows(': 'resource result | int',
\ 'msql_close(': '[resource link_identifier] | bool',
\ 'msql_connect(': '[string hostname] | resource',
\ 'msql_create_db(': 'string database_name [, resource link_identifier] | bool',
\ 'msql_data_seek(': 'resource result, int row_number | bool',
\ 'msql_db_query(': 'string database, string query [, resource link_identifier] | resource',
\ 'msql_drop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'msql_error(': 'void  | string',
\ 'msql_fetch_array(': 'resource result [, int result_type] | array',
\ 'msql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'msql_fetch_object(': 'resource result | object',
\ 'msql_fetch_row(': 'resource result | array',
\ 'msql_field_flags(': 'resource result, int field_offset | string',
\ 'msql_field_len(': 'resource result, int field_offset | int',
\ 'msql_field_name(': 'resource result, int field_offset | string',
\ 'msql_field_seek(': 'resource result, int field_offset | bool',
\ 'msql_field_table(': 'resource result, int field_offset | int',
\ 'msql_field_type(': 'resource result, int field_offset | string',
\ 'msql_free_result(': 'resource result | bool',
\ 'msql_list_dbs(': '[resource link_identifier] | resource',
\ 'msql_list_fields(': 'string database, string tablename [, resource link_identifier] | resource',
\ 'msql_list_tables(': 'string database [, resource link_identifier] | resource',
\ 'msql_num_fields(': 'resource result | int',
\ 'msql_num_rows(': 'resource query_identifier | int',
\ 'msql_pconnect(': '[string hostname] | resource',
\ 'msql_query(': 'string query [, resource link_identifier] | resource',
\ 'msql_result(': 'resource result, int row [, mixed field] | string',
\ 'msql_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'm_sslcert_gen_hash(': 'string filename | string',
\ 'mssql_bind(': 'resource stmt, string param_name, mixed &#38;var, int type [, int is_output [, int is_null [, int maxlen]]] | bool',
\ 'mssql_close(': '[resource link_identifier] | bool',
\ 'mssql_connect(': '[string servername [, string username [, string password]]] | resource',
\ 'mssql_data_seek(': 'resource result_identifier, int row_number | bool',
\ 'mssql_execute(': 'resource stmt [, bool skip_results] | mixed',
\ 'mssql_fetch_array(': 'resource result [, int result_type] | array',
\ 'mssql_fetch_assoc(': 'resource result_id | array',
\ 'mssql_fetch_batch(': 'resource result_index | int',
\ 'mssql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'mssql_fetch_object(': 'resource result | object',
\ 'mssql_fetch_row(': 'resource result | array',
\ 'mssql_field_length(': 'resource result [, int offset] | int',
\ 'mssql_field_name(': 'resource result [, int offset] | string',
\ 'mssql_field_seek(': 'resource result, int field_offset | bool',
\ 'mssql_field_type(': 'resource result [, int offset] | string',
\ 'mssql_free_result(': 'resource result | bool',
\ 'mssql_free_statement(': 'resource statement | bool',
\ 'mssql_get_last_message(': 'void  | string',
\ 'mssql_guid_string(': 'string binary [, int short_format] | string',
\ 'mssql_init(': 'string sp_name [, resource conn_id] | resource',
\ 'mssql_min_error_severity(': 'int severity | void',
\ 'mssql_min_message_severity(': 'int severity | void',
\ 'mssql_next_result(': 'resource result_id | bool',
\ 'mssql_num_fields(': 'resource result | int',
\ 'mssql_num_rows(': 'resource result | int',
\ 'mssql_pconnect(': '[string servername [, string username [, string password]]] | resource',
\ 'mssql_query(': 'string query [, resource link_identifier [, int batch_size]] | mixed',
\ 'mssql_result(': 'resource result, int row, mixed field | string',
\ 'mssql_rows_affected(': 'resource conn_id | int',
\ 'mssql_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mt_getrandmax(': 'void  | int',
\ 'mt_rand(': '[int min, int max] | int',
\ 'm_transactionssent(': 'resource conn | int',
\ 'm_transinqueue(': 'resource conn | int',
\ 'm_transkeyval(': 'resource conn, int identifier, string key, string value | int',
\ 'm_transnew(': 'resource conn | int',
\ 'm_transsend(': 'resource conn, int identifier | int',
\ 'mt_srand(': '[int seed] | void',
\ 'muscat_close(': 'resource muscat_handle | void',
\ 'muscat_get(': 'resource muscat_handle | string',
\ 'muscat_give(': 'resource muscat_handle, string string | void',
\ 'muscat_setup(': 'int size [, string muscat_dir] | resource',
\ 'muscat_setup_net(': 'string muscat_host | resource',
\ 'm_uwait(': 'int microsecs | int',
\ 'm_validateidentifier(': 'resource conn, int tf | int',
\ 'm_verifyconnection(': 'resource conn, int tf | bool',
\ 'm_verifysslcert(': 'resource conn, int tf | bool',
\ 'mysql_affected_rows(': '[resource link_identifier] | int',
\ 'mysql_change_user(': 'string user, string password [, string database [, resource link_identifier]] | int',
\ 'mysql_client_encoding(': '[resource link_identifier] | string',
\ 'mysql_close(': '[resource link_identifier] | bool',
\ 'mysql_connect(': '[string server [, string username [, string password [, bool new_link [, int client_flags]]]]] | resource',
\ 'mysql_create_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mysql_data_seek(': 'resource result, int row_number | bool',
\ 'mysql_db_name(': 'resource result, int row [, mixed field] | string',
\ 'mysql_db_query(': 'string database, string query [, resource link_identifier] | resource',
\ 'mysql_drop_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mysql_errno(': '[resource link_identifier] | int',
\ 'mysql_error(': '[resource link_identifier] | string',
\ 'mysql_escape_string(': 'string unescaped_string | string',
\ 'mysql_fetch_array(': 'resource result [, int result_type] | array',
\ 'mysql_fetch_assoc(': 'resource result | array',
\ 'mysql_fetch_field(': 'resource result [, int field_offset] | object',
\ 'mysql_fetch_lengths(': 'resource result | array',
\ 'mysql_fetch_object(': 'resource result | object',
\ 'mysql_fetch_row(': 'resource result | array',
\ 'mysql_field_flags(': 'resource result, int field_offset | string',
\ 'mysql_field_len(': 'resource result, int field_offset | int',
\ 'mysql_field_name(': 'resource result, int field_offset | string',
\ 'mysql_field_seek(': 'resource result, int field_offset | bool',
\ 'mysql_field_table(': 'resource result, int field_offset | string',
\ 'mysql_field_type(': 'resource result, int field_offset | string',
\ 'mysql_free_result(': 'resource result | bool',
\ 'mysql_get_client_info(': 'void  | string',
\ 'mysql_get_host_info(': '[resource link_identifier] | string',
\ 'mysql_get_proto_info(': '[resource link_identifier] | int',
\ 'mysql_get_server_info(': '[resource link_identifier] | string',
\ 'mysqli_connect_errno(': 'void  | int',
\ 'mysqli_connect_error(': 'void  | string',
\ 'mysqli_debug(': 'string debug | bool',
\ 'mysqli_disable_rpl_parse(': 'mysqli link | bool',
\ 'mysqli_dump_debug_info(': 'mysqli link | bool',
\ 'mysqli_embedded_connect(': '[string dbname] | mysqli',
\ 'mysqli_enable_reads_from_master(': 'mysqli link | bool',
\ 'mysqli_enable_rpl_parse(': 'mysqli link | bool',
\ 'mysqli_get_client_info(': 'void  | string',
\ 'mysqli_get_client_version(': 'void  | int',
\ 'mysqli_init(': 'void  | mysqli',
\ 'mysqli_master_query(': 'mysqli link, string query | bool',
\ 'mysqli_more_results(': 'mysqli link | bool',
\ 'mysqli_next_result(': 'mysqli link | bool',
\ 'mysql_info(': '[resource link_identifier] | string',
\ 'mysql_insert_id(': '[resource link_identifier] | int',
\ 'mysqli_report(': 'int flags | bool',
\ 'mysqli_rollback(': 'mysqli link | bool',
\ 'mysqli_rpl_parse_enabled(': 'mysqli link | int',
\ 'mysqli_rpl_probe(': 'mysqli link | bool',
\ 'mysqli_select_db(': 'mysqli link, string dbname | bool',
\ 'mysqli_server_end(': 'void  | void',
\ 'mysqli_server_init(': '[array server [, array groups]] | bool',
\ 'mysqli_set_charset(': 'mysqli link, string charset | bool',
\ 'mysqli_stmt_sqlstate(': 'mysqli_stmt stmt | string',
\ 'mysql_list_dbs(': '[resource link_identifier] | resource',
\ 'mysql_list_fields(': 'string database_name, string table_name [, resource link_identifier] | resource',
\ 'mysql_list_processes(': '[resource link_identifier] | resource',
\ 'mysql_list_tables(': 'string database [, resource link_identifier] | resource',
\ 'mysql_num_fields(': 'resource result | int',
\ 'mysql_num_rows(': 'resource result | int',
\ 'mysql_pconnect(': '[string server [, string username [, string password [, int client_flags]]]] | resource',
\ 'mysql_ping(': '[resource link_identifier] | bool',
\ 'mysql_query(': 'string query [, resource link_identifier] | resource',
\ 'mysql_real_escape_string(': 'string unescaped_string [, resource link_identifier] | string',
\ 'mysql_result(': 'resource result, int row [, mixed field] | string',
\ 'mysql_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'mysql_stat(': '[resource link_identifier] | string',
\ 'mysql_tablename(': 'resource result, int i | string',
\ 'mysql_thread_id(': '[resource link_identifier] | int',
\ 'mysql_unbuffered_query(': 'string query [, resource link_identifier] | resource',
\ 'natcasesort(': 'array &#38;array | bool',
\ 'natsort(': 'array &#38;array | bool',
\ 'ncurses_addch(': 'int ch | int',
\ 'ncurses_addchnstr(': 'string s, int n | int',
\ 'ncurses_addchstr(': 'string s | int',
\ 'ncurses_addnstr(': 'string s, int n | int',
\ 'ncurses_addstr(': 'string text | int',
\ 'ncurses_assume_default_colors(': 'int fg, int bg | int',
\ 'ncurses_attroff(': 'int attributes | int',
\ 'ncurses_attron(': 'int attributes | int',
\ 'ncurses_attrset(': 'int attributes | int',
\ 'ncurses_baudrate(': 'void  | int',
\ 'ncurses_beep(': 'void  | int',
\ 'ncurses_bkgd(': 'int attrchar | int',
\ 'ncurses_bkgdset(': 'int attrchar | void',
\ 'ncurses_border(': 'int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner | int',
\ 'ncurses_bottom_panel(': 'resource panel | int',
\ 'ncurses_can_change_color(': 'void  | bool',
\ 'ncurses_cbreak(': 'void  | bool',
\ 'ncurses_clear(': 'void  | bool',
\ 'ncurses_clrtobot(': 'void  | bool',
\ 'ncurses_clrtoeol(': 'void  | bool',
\ 'ncurses_color_content(': 'int color, int &#38;r, int &#38;g, int &#38;b | int',
\ 'ncurses_color_set(': 'int pair | int',
\ 'ncurses_curs_set(': 'int visibility | int',
\ 'ncurses_define_key(': 'string definition, int keycode | int',
\ 'ncurses_def_prog_mode(': 'void  | bool',
\ 'ncurses_def_shell_mode(': 'void  | bool',
\ 'ncurses_delay_output(': 'int milliseconds | int',
\ 'ncurses_delch(': 'void  | bool',
\ 'ncurses_deleteln(': 'void  | bool',
\ 'ncurses_del_panel(': 'resource panel | bool',
\ 'ncurses_delwin(': 'resource window | bool',
\ 'ncurses_doupdate(': 'void  | bool',
\ 'ncurses_echochar(': 'int character | int',
\ 'ncurses_echo(': 'void  | bool',
\ 'ncurses_end(': 'void  | int',
\ 'ncurses_erasechar(': 'void  | string',
\ 'ncurses_erase(': 'void  | bool',
\ 'ncurses_filter(': 'void  | void',
\ 'ncurses_flash(': 'void  | bool',
\ 'ncurses_flushinp(': 'void  | bool',
\ 'ncurses_getch(': 'void  | int',
\ 'ncurses_getmaxyx(': 'resource window, int &#38;y, int &#38;x | void',
\ 'ncurses_getmouse(': 'array &#38;mevent | bool',
\ 'ncurses_getyx(': 'resource window, int &#38;y, int &#38;x | void',
\ 'ncurses_halfdelay(': 'int tenth | int',
\ 'ncurses_has_colors(': 'void  | bool',
\ 'ncurses_has_ic(': 'void  | bool',
\ 'ncurses_has_il(': 'void  | bool',
\ 'ncurses_has_key(': 'int keycode | int',
\ 'ncurses_hide_panel(': 'resource panel | int',
\ 'ncurses_hline(': 'int charattr, int n | int',
\ 'ncurses_inch(': 'void  | string',
\ 'ncurses_init_color(': 'int color, int r, int g, int b | int',
\ 'ncurses_init(': 'void  | void',
\ 'ncurses_init_pair(': 'int pair, int fg, int bg | int',
\ 'ncurses_insch(': 'int character | int',
\ 'ncurses_insdelln(': 'int count | int',
\ 'ncurses_insertln(': 'void  | bool',
\ 'ncurses_insstr(': 'string text | int',
\ 'ncurses_instr(': 'string &#38;buffer | int',
\ 'ncurses_isendwin(': 'void  | bool',
\ 'ncurses_keyok(': 'int keycode, bool enable | int',
\ 'ncurses_keypad(': 'resource window, bool bf | int',
\ 'ncurses_killchar(': 'void  | string',
\ 'ncurses_longname(': 'void  | string',
\ 'ncurses_meta(': 'resource window, bool 8bit | int',
\ 'ncurses_mouseinterval(': 'int milliseconds | int',
\ 'ncurses_mousemask(': 'int newmask, int &#38;oldmask | int',
\ 'ncurses_mouse_trafo(': 'int &#38;y, int &#38;x, bool toscreen | bool',
\ 'ncurses_move(': 'int y, int x | int',
\ 'ncurses_move_panel(': 'resource panel, int startx, int starty | int',
\ 'ncurses_mvaddch(': 'int y, int x, int c | int',
\ 'ncurses_mvaddchnstr(': 'int y, int x, string s, int n | int',
\ 'ncurses_mvaddchstr(': 'int y, int x, string s | int',
\ 'ncurses_mvaddnstr(': 'int y, int x, string s, int n | int',
\ 'ncurses_mvaddstr(': 'int y, int x, string s | int',
\ 'ncurses_mvcur(': 'int old_y, int old_x, int new_y, int new_x | int',
\ 'ncurses_mvdelch(': 'int y, int x | int',
\ 'ncurses_mvgetch(': 'int y, int x | int',
\ 'ncurses_mvhline(': 'int y, int x, int attrchar, int n | int',
\ 'ncurses_mvinch(': 'int y, int x | int',
\ 'ncurses_mvvline(': 'int y, int x, int attrchar, int n | int',
\ 'ncurses_mvwaddstr(': 'resource window, int y, int x, string text | int',
\ 'ncurses_napms(': 'int milliseconds | int',
\ 'ncurses_newpad(': 'int rows, int cols | resource',
\ 'ncurses_new_panel(': 'resource window | resource',
\ 'ncurses_newwin(': 'int rows, int cols, int y, int x | resource',
\ 'ncurses_nl(': 'void  | bool',
\ 'ncurses_nocbreak(': 'void  | bool',
\ 'ncurses_noecho(': 'void  | bool',
\ 'ncurses_nonl(': 'void  | bool',
\ 'ncurses_noqiflush(': 'void  | void',
\ 'ncurses_noraw(': 'void  | bool',
\ 'ncurses_pair_content(': 'int pair, int &#38;f, int &#38;b | int',
\ 'ncurses_panel_above(': 'resource panel | resource',
\ 'ncurses_panel_below(': 'resource panel | resource',
\ 'ncurses_panel_window(': 'resource panel | resource',
\ 'ncurses_pnoutrefresh(': 'resource pad, int pminrow, int pmincol, int sminrow, int smincol, int smaxrow, int smaxcol | int',
\ 'ncurses_prefresh(': 'resource pad, int pminrow, int pmincol, int sminrow, int smincol, int smaxrow, int smaxcol | int',
\ 'ncurses_putp(': 'string text | int',
\ 'ncurses_qiflush(': 'void  | void',
\ 'ncurses_raw(': 'void  | bool',
\ 'ncurses_refresh(': 'int ch | int',
\ 'ncurses_replace_panel(': 'resource panel, resource window | int',
\ 'ncurses_reset_prog_mode(': 'void  | int',
\ 'ncurses_reset_shell_mode(': 'void  | int',
\ 'ncurses_resetty(': 'void  | bool',
\ 'ncurses_savetty(': 'void  | bool',
\ 'ncurses_scr_dump(': 'string filename | int',
\ 'ncurses_scr_init(': 'string filename | int',
\ 'ncurses_scrl(': 'int count | int',
\ 'ncurses_scr_restore(': 'string filename | int',
\ 'ncurses_scr_set(': 'string filename | int',
\ 'ncurses_show_panel(': 'resource panel | int',
\ 'ncurses_slk_attr(': 'void  | bool',
\ 'ncurses_slk_attroff(': 'int intarg | int',
\ 'ncurses_slk_attron(': 'int intarg | int',
\ 'ncurses_slk_attrset(': 'int intarg | int',
\ 'ncurses_slk_clear(': 'void  | bool',
\ 'ncurses_slk_color(': 'int intarg | int',
\ 'ncurses_slk_init(': 'int format | bool',
\ 'ncurses_slk_noutrefresh(': 'void  | bool',
\ 'ncurses_slk_refresh(': 'void  | bool',
\ 'ncurses_slk_restore(': 'void  | bool',
\ 'ncurses_slk_set(': 'int labelnr, string label, int format | bool',
\ 'ncurses_slk_touch(': 'void  | bool',
\ 'ncurses_standend(': 'void  | int',
\ 'ncurses_standout(': 'void  | int',
\ 'ncurses_start_color(': 'void  | int',
\ 'ncurses_termattrs(': 'void  | bool',
\ 'ncurses_termname(': 'void  | string',
\ 'ncurses_timeout(': 'int millisec | void',
\ 'ncurses_top_panel(': 'resource panel | int',
\ 'ncurses_typeahead(': 'int fd | int',
\ 'ncurses_ungetch(': 'int keycode | int',
\ 'ncurses_ungetmouse(': 'array mevent | bool',
\ 'ncurses_update_panels(': 'void  | void',
\ 'ncurses_use_default_colors(': 'void  | bool',
\ 'ncurses_use_env(': 'bool flag | void',
\ 'ncurses_use_extended_names(': 'bool flag | int',
\ 'ncurses_vidattr(': 'int intarg | int',
\ 'ncurses_vline(': 'int charattr, int n | int',
\ 'ncurses_waddch(': 'resource window, int ch | int',
\ 'ncurses_waddstr(': 'resource window, string str [, int n] | int',
\ 'ncurses_wattroff(': 'resource window, int attrs | int',
\ 'ncurses_wattron(': 'resource window, int attrs | int',
\ 'ncurses_wattrset(': 'resource window, int attrs | int',
\ 'ncurses_wborder(': 'resource window, int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner | int',
\ 'ncurses_wclear(': 'resource window | int',
\ 'ncurses_wcolor_set(': 'resource window, int color_pair | int',
\ 'ncurses_werase(': 'resource window | int',
\ 'ncurses_wgetch(': 'resource window | int',
\ 'ncurses_whline(': 'resource window, int charattr, int n | int',
\ 'ncurses_wmouse_trafo(': 'resource window, int &#38;y, int &#38;x, bool toscreen | bool',
\ 'ncurses_wmove(': 'resource window, int y, int x | int',
\ 'ncurses_wnoutrefresh(': 'resource window | int',
\ 'ncurses_wrefresh(': 'resource window | int',
\ 'ncurses_wstandend(': 'resource window | int',
\ 'ncurses_wstandout(': 'resource window | int',
\ 'ncurses_wvline(': 'resource window, int charattr, int n | int',
\ 'newt_bell(': 'void  | void',
\ 'newt_button_bar(': 'array &#38;buttons | resource',
\ 'newt_button(': 'int left, int top, string text | resource',
\ 'newt_centered_window(': 'int width, int height [, string title] | int',
\ 'newt_checkbox_get_value(': 'resource checkbox | string',
\ 'newt_checkbox(': 'int left, int top, string text, string def_value [, string seq] | resource',
\ 'newt_checkbox_set_flags(': 'resource checkbox, int flags, int sense | void',
\ 'newt_checkbox_set_value(': 'resource checkbox, string value | void',
\ 'newt_checkbox_tree_add_item(': 'resource checkboxtree, string text, mixed data, int flags, int index [, int ...] | void',
\ 'newt_checkbox_tree_find_item(': 'resource checkboxtree, mixed data | array',
\ 'newt_checkbox_tree_get_current(': 'resource checkboxtree | mixed',
\ 'newt_checkbox_tree_get_entry_value(': 'resource checkboxtree, mixed data | string',
\ 'newt_checkbox_tree_get_multi_selection(': 'resource checkboxtree, string seqnum | array',
\ 'newt_checkbox_tree_get_selection(': 'resource checkboxtree | array',
\ 'newt_checkbox_tree(': 'int left, int top, int height [, int flags] | resource',
\ 'newt_checkbox_tree_multi(': 'int left, int top, int height, string seq [, int flags] | resource',
\ 'newt_checkbox_tree_set_current(': 'resource checkboxtree, mixed data | void',
\ 'newt_checkbox_tree_set_entry(': 'resource checkboxtree, mixed data, string text | void',
\ 'newt_checkbox_tree_set_entry_value(': 'resource checkboxtree, mixed data, string value | void',
\ 'newt_checkbox_tree_set_width(': 'resource checkbox_tree, int width | void',
\ 'newt_clear_key_buffer(': 'void  | void',
\ 'newt_cls(': 'void  | void',
\ 'newt_compact_button(': 'int left, int top, string text | resource',
\ 'newt_component_add_callback(': 'resource component, mixed func_name, mixed data | void',
\ 'newt_component_takes_focus(': 'resource component, bool takes_focus | void',
\ 'newt_create_grid(': 'int cols, int rows | resource',
\ 'newt_cursor_off(': 'void  | void',
\ 'newt_cursor_on(': 'void  | void',
\ 'newt_delay(': 'int microseconds | void',
\ 'newt_draw_form(': 'resource form | void',
\ 'newt_draw_root_text(': 'int left, int top, string text | void',
\ 'newt_entry_get_value(': 'resource entry | string',
\ 'newt_entry(': 'int left, int top, int width [, string init_value [, int flags]] | resource',
\ 'newt_entry_set_filter(': 'resource entry, callback filter, mixed data | void',
\ 'newt_entry_set_flags(': 'resource entry, int flags, int sense | void',
\ 'newt_entry_set(': 'resource entry, string value [, bool cursor_at_end] | void',
\ 'newt_finished(': 'void  | int',
\ 'newt_form_add_component(': 'resource form, resource component | void',
\ 'newt_form_add_components(': 'resource form, array components | void',
\ 'newt_form_add_host_key(': 'resource form, int key | void',
\ 'newt_form_destroy(': 'resource form | void',
\ 'newt_form_get_current(': 'resource form | resource',
\ 'newt_form(': '[resource vert_bar [, string help [, int flags]]] | resource',
\ 'newt_form_run(': 'resource form, array &#38;exit_struct | void',
\ 'newt_form_set_background(': 'resource from, int background | void',
\ 'newt_form_set_height(': 'resource form, int height | void',
\ 'newt_form_set_size(': 'resource form | void',
\ 'newt_form_set_timer(': 'resource form, int milliseconds | void',
\ 'newt_form_set_width(': 'resource form, int width | void',
\ 'newt_form_watch_fd(': 'resource form, resource stream [, int flags] | void',
\ 'newt_get_screen_size(': 'int &#38;cols, int &#38;rows | void',
\ 'newt_grid_add_components_to_form(': 'resource grid, resource form, bool recurse | void',
\ 'newt_grid_basic_window(': 'resource text, resource middle, resource buttons | resource',
\ 'newt_grid_free(': 'resource grid, bool recurse | void',
\ 'newt_grid_get_size(': 'resouce grid, int &#38;width, int &#38;height | void',
\ 'newt_grid_h_close_stacked(': 'int element1_type, resource element1 [, int ... [, resource ...]] | resource',
\ 'newt_grid_h_stacked(': 'int element1_type, resource element1 [, int ... [, resource ...]] | resource',
\ 'newt_grid_place(': 'resource grid, int left, int top | void',
\ 'newt_grid_set_field(': 'resource grid, int col, int row, int type, resource val, int pad_left, int pad_top, int pad_right, int pad_bottom, int anchor [, int flags] | void',
\ 'newt_grid_simple_window(': 'resource text, resource middle, resource buttons | resource',
\ 'newt_grid_v_close_stacked(': 'int element1_type, resource element1 [, int ... [, resource ...]] | resource',
\ 'newt_grid_v_stacked(': 'int element1_type, resource element1 [, int ... [, resource ...]] | resource',
\ 'newt_grid_wrapped_window_at(': 'resource grid, string title, int left, int top | void',
\ 'newt_grid_wrapped_window(': 'resource grid, string title | void',
\ 'newt_init(': 'void  | int',
\ 'newt_label(': 'int left, int top, string text | resource',
\ 'newt_label_set_text(': 'resource label, string text | void',
\ 'newt_listbox_append_entry(': 'resource listbox, string text, mixed data | void',
\ 'newt_listbox_clear(': 'resource listobx | void',
\ 'newt_listbox_clear_selection(': 'resource listbox | void',
\ 'newt_listbox_delete_entry(': 'resource listbox, mixed key | void',
\ 'newt_listbox_get_current(': 'resource listbox | string',
\ 'newt_listbox_get_selection(': 'resource listbox | array',
\ 'newt_listbox(': 'int left, int top, int height [, int flags] | resource',
\ 'newt_listbox_insert_entry(': 'resource listbox, string text, mixed data, mixed key | void',
\ 'newt_listbox_item_count(': 'resource listbox | int',
\ 'newt_listbox_select_item(': 'resource listbox, mixed key, int sense | void',
\ 'newt_listbox_set_current_by_key(': 'resource listbox, mixed key | void',
\ 'newt_listbox_set_current(': 'resource listbox, int num | void',
\ 'newt_listbox_set_data(': 'resource listbox, int num, mixed data | void',
\ 'newt_listbox_set_entry(': 'resource listbox, int num, string text | void',
\ 'newt_listbox_set_width(': 'resource listbox, int width | void',
\ 'newt_listitem_get_data(': 'resource item | mixed',
\ 'newt_listitem(': 'int left, int top, string text, bool is_default, resouce prev_item, mixed data [, int flags] | resource',
\ 'newt_listitem_set(': 'resource item, string text | void',
\ 'newt_open_window(': 'int left, int top, int width, int height [, string title] | int',
\ 'newt_pop_help_line(': 'void  | void',
\ 'newt_pop_window(': 'void  | void',
\ 'newt_push_help_line(': '[string text] | void',
\ 'newt_radiobutton(': 'int left, int top, string text, bool is_default [, resource prev_button] | resource',
\ 'newt_radio_get_current(': 'resource set_member | resource',
\ 'newt_redraw_help_line(': 'void  | void',
\ 'newt_reflow_text(': 'string text, int width, int flex_down, int flex_up, int &#38;actual_width, int &#38;actual_height | string',
\ 'newt_refresh(': 'void  | void',
\ 'newt_resize_screen(': '[bool redraw] | void',
\ 'newt_resume(': 'void  | void',
\ 'newt_run_form(': 'resource form | resource',
\ 'newt_scale(': 'int left, int top, int width, int full_value | resource',
\ 'newt_scale_set(': 'resource scale, int amount | void',
\ 'newt_scrollbar_set(': 'resource scrollbar, int where, int total | void',
\ 'newt_set_help_callback(': 'mixed function | void',
\ 'newt_set_suspend_callback(': 'callback function, mixed data | void',
\ 'newt_suspend(': 'void  | void',
\ 'newt_texbox_set_text(': 'resource textbox, string text | void',
\ 'newt_textbox_get_num_lines(': 'resource textbox | int',
\ 'newt_textbox(': 'int left, int top, int width, int height [, int flags] | resource',
\ 'newt_textbox_reflowed(': 'int left, int top, char *text, int width, int flex_down, int flex_up [, int flags] | resource',
\ 'newt_textbox_set_height(': 'resource textbox, int height | void',
\ 'newt_vertical_scrollbar(': 'int left, int top, int height [, int normal_colorset [, int thumb_colorset]] | resource',
\ 'newt_wait_for_key(': 'void  | void',
\ 'newt_win_choice(': 'string title, string button1_text, string button2_text, string format [, mixed args [, mixed ...]] | int',
\ 'newt_win_entries(': 'string title, string text, int suggested_width, int flex_down, int flex_up, int data_width, array &#38;items, string button1 [, string ...] | int',
\ 'newt_win_menu(': 'string title, string text, int suggestedWidth, int flexDown, int flexUp, int maxListHeight, array items, int &#38;listItem [, string button1 [, string ...]] | int',
\ 'newt_win_message(': 'string title, string button_text, string format [, mixed args [, mixed ...]] | void',
\ 'newt_win_messagev(': 'string title, string button_text, string format, array args | void',
\ 'newt_win_ternary(': 'string title, string button1_text, string button2_text, string button3_text, string format [, mixed args [, mixed ...]] | int',
\ 'next(': 'array &#38;array | mixed',
\ 'ngettext(': 'string msgid1, string msgid2, int n | string',
\ 'nl2br(': 'string string | string',
\ 'nl_langinfo(': 'int item | string',
\ 'notes_body(': 'string server, string mailbox, int msg_number | array',
\ 'notes_copy_db(': 'string from_database_name, string to_database_name | bool',
\ 'notes_create_db(': 'string database_name | bool',
\ 'notes_create_note(': 'string database_name, string form_name | bool',
\ 'notes_drop_db(': 'string database_name | bool',
\ 'notes_find_note(': 'string database_name, string name [, string type] | int',
\ 'notes_header_info(': 'string server, string mailbox, int msg_number | object',
\ 'notes_list_msgs(': 'string db | bool',
\ 'notes_mark_read(': 'string database_name, string user_name, string note_id | bool',
\ 'notes_mark_unread(': 'string database_name, string user_name, string note_id | bool',
\ 'notes_nav_create(': 'string database_name, string name | bool',
\ 'notes_search(': 'string database_name, string keywords | array',
\ 'notes_unread(': 'string database_name, string user_name | array',
\ 'notes_version(': 'string database_name | float',
\ 'nsapi_request_headers(': 'void  | array',
\ 'nsapi_response_headers(': 'void  | array',
\ 'nsapi_virtual(': 'string uri | bool',
\ 'number_format(': 'float number [, int decimals [, string dec_point, string thousands_sep]] | string',
\ 'ob_clean(': 'void  | void',
\ 'ob_end_clean(': 'void  | bool',
\ 'ob_end_flush(': 'void  | bool',
\ 'ob_flush(': 'void  | void',
\ 'ob_get_clean(': 'void  | string',
\ 'ob_get_contents(': 'void  | string',
\ 'ob_get_flush(': 'void  | string',
\ 'ob_get_length(': 'void  | int',
\ 'ob_get_level(': 'void  | int',
\ 'ob_gzhandler(': 'string buffer, int mode | string',
\ 'ob_iconv_handler(': 'string contents, int status | string',
\ 'ob_implicit_flush(': '[int flag] | void',
\ 'ob_list_handlers(': 'void  | array',
\ 'ob_start(': '[callback output_callback [, int chunk_size [, bool erase]]] | bool',
\ 'ob_tidyhandler(': 'string input [, int mode] | string',
\ 'oci_bind_by_name(': 'resource stmt, string ph_name, mixed &#38;variable [, int maxlength [, int type]] | bool',
\ 'oci_cancel(': 'resource stmt | bool',
\ 'oci_close(': 'resource connection | bool',
\ 'oci_commit(': 'resource connection | bool',
\ 'oci_connect(': 'string username, string password [, string db [, string charset [, int session_mode]]] | resource',
\ 'oci_define_by_name(': 'resource statement, string column_name, mixed &#38;variable [, int type] | bool',
\ 'oci_error(': '[resource source] | array',
\ 'oci_execute(': 'resource stmt [, int mode] | bool',
\ 'oci_fetch_all(': 'resource statement, array &#38;output [, int skip [, int maxrows [, int flags]]] | int',
\ 'oci_fetch_array(': 'resource statement [, int mode] | array',
\ 'oci_fetch_assoc(': 'resource statement | array',
\ 'oci_fetch(': 'resource statement | bool',
\ 'ocifetchinto(': 'resource statement, array &#38;result [, int mode] | int',
\ 'oci_fetch_object(': 'resource statement | object',
\ 'oci_fetch_row(': 'resource statement | array',
\ 'oci_field_is_null(': 'resource stmt, mixed field | bool',
\ 'oci_field_name(': 'resource statement, int field | string',
\ 'oci_field_precision(': 'resource statement, int field | int',
\ 'oci_field_scale(': 'resource statement, int field | int',
\ 'oci_field_size(': 'resource stmt, mixed field | int',
\ 'oci_field_type(': 'resource stmt, int field | mixed',
\ 'oci_field_type_raw(': 'resource statement, int field | int',
\ 'oci_free_statement(': 'resource statement | bool',
\ 'oci_internal_debug(': 'int onoff | void',
\ 'oci_lob_copy(': 'OCI-Lob lob_to, OCI-Lob lob_from [, int length] | bool',
\ 'oci_lob_is_equal(': 'OCI-Lob lob1, OCI-Lob lob2 | bool',
\ 'oci_new_collection(': 'resource connection, string tdo [, string schema] | OCI-Collection',
\ 'oci_new_connect(': 'string username, string password [, string db [, string charset [, int session_mode]]] | resource',
\ 'oci_new_cursor(': 'resource connection | resource',
\ 'oci_new_descriptor(': 'resource connection [, int type] | OCI-Lob',
\ 'oci_num_fields(': 'resource statement | int',
\ 'oci_num_rows(': 'resource stmt | int',
\ 'oci_parse(': 'resource connection, string query | resource',
\ 'oci_password_change(': 'resource connection, string username, string old_password, string new_password | bool',
\ 'oci_pconnect(': 'string username, string password [, string db [, string charset [, int session_mode]]] | resource',
\ 'oci_result(': 'resource statement, mixed field | mixed',
\ 'oci_rollback(': 'resource connection | bool',
\ 'oci_server_version(': 'resource connection | string',
\ 'oci_set_prefetch(': 'resource statement [, int rows] | bool',
\ 'oci_statement_type(': 'resource statement | string',
\ 'octdec(': 'string octal_string | number',
\ 'odbc_autocommit(': 'resource connection_id [, bool OnOff] | mixed',
\ 'odbc_binmode(': 'resource result_id, int mode | bool',
\ 'odbc_close_all(': 'void  | void',
\ 'odbc_close(': 'resource connection_id | void',
\ 'odbc_columnprivileges(': 'resource connection_id, string qualifier, string owner, string table_name, string column_name | resource',
\ 'odbc_columns(': 'resource connection_id [, string qualifier [, string schema [, string table_name [, string column_name]]]] | resource',
\ 'odbc_commit(': 'resource connection_id | bool',
\ 'odbc_connect(': 'string dsn, string user, string password [, int cursor_type] | resource',
\ 'odbc_cursor(': 'resource result_id | string',
\ 'odbc_data_source(': 'resource connection_id, int fetch_type | array',
\ 'odbc_do(': 'resource conn_id, string query | resource',
\ 'odbc_error(': '[resource connection_id] | string',
\ 'odbc_errormsg(': '[resource connection_id] | string',
\ 'odbc_exec(': 'resource connection_id, string query_string [, int flags] | resource',
\ 'odbc_execute(': 'resource result_id [, array parameters_array] | bool',
\ 'odbc_fetch_array(': 'resource result [, int rownumber] | array',
\ 'odbc_fetch_into(': 'resource result_id, array &#38;result_array [, int rownumber] | int',
\ 'odbc_fetch_object(': 'resource result [, int rownumber] | object',
\ 'odbc_fetch_row(': 'resource result_id [, int row_number] | bool',
\ 'odbc_field_len(': 'resource result_id, int field_number | int',
\ 'odbc_field_name(': 'resource result_id, int field_number | string',
\ 'odbc_field_num(': 'resource result_id, string field_name | int',
\ 'odbc_field_precision(': 'resource result_id, int field_number | int',
\ 'odbc_field_scale(': 'resource result_id, int field_number | int',
\ 'odbc_field_type(': 'resource result_id, int field_number | string',
\ 'odbc_foreignkeys(': 'resource connection_id, string pk_qualifier, string pk_owner, string pk_table, string fk_qualifier, string fk_owner, string fk_table | resource',
\ 'odbc_free_result(': 'resource result_id | bool',
\ 'odbc_gettypeinfo(': 'resource connection_id [, int data_type] | resource',
\ 'odbc_longreadlen(': 'resource result_id, int length | bool',
\ 'odbc_next_result(': 'resource result_id | bool',
\ 'odbc_num_fields(': 'resource result_id | int',
\ 'odbc_num_rows(': 'resource result_id | int',
\ 'odbc_pconnect(': 'string dsn, string user, string password [, int cursor_type] | resource',
\ 'odbc_prepare(': 'resource connection_id, string query_string | resource',
\ 'odbc_primarykeys(': 'resource connection_id, string qualifier, string owner, string table | resource',
\ 'odbc_procedurecolumns(': 'resource connection_id [, string qualifier, string owner, string proc, string column] | resource',
\ 'odbc_procedures(': 'resource connection_id [, string qualifier, string owner, string name] | resource',
\ 'odbc_result_all(': 'resource result_id [, string format] | int',
\ 'odbc_result(': 'resource result_id, mixed field | mixed',
\ 'odbc_rollback(': 'resource connection_id | bool',
\ 'odbc_setoption(': 'resource id, int function, int option, int param | bool',
\ 'odbc_specialcolumns(': 'resource connection_id, int type, string qualifier, string owner, string table, int scope, int nullable | resource',
\ 'odbc_statistics(': 'resource connection_id, string qualifier, string owner, string table_name, int unique, int accuracy | resource',
\ 'odbc_tableprivileges(': 'resource connection_id, string qualifier, string owner, string name | resource',
\ 'odbc_tables(': 'resource connection_id [, string qualifier [, string owner [, string name [, string types]]]] | resource',
\ 'openal_buffer_create(': 'void  | resource',
\ 'openal_buffer_data(': 'resource buffer, int format, string data, int freq | bool',
\ 'openal_buffer_destroy(': 'resource buffer | bool',
\ 'openal_buffer_get(': 'resource buffer, int property | int',
\ 'openal_buffer_loadwav(': 'resource buffer, string wavfile | bool',
\ 'openal_context_create(': 'resource device | resource',
\ 'openal_context_current(': 'resource context | bool',
\ 'openal_context_destroy(': 'resource context | bool',
\ 'openal_context_process(': 'resource context | bool',
\ 'openal_context_suspend(': 'resource context | bool',
\ 'openal_device_close(': 'resource device | bool',
\ 'openal_device_open(': '[string device_desc] | resource',
\ 'openal_listener_get(': 'int property | mixed',
\ 'openal_listener_set(': 'int property, mixed setting | bool',
\ 'openal_source_create(': 'void  | resource',
\ 'openal_source_destroy(': 'resource source | bool',
\ 'openal_source_get(': 'resource source, int property | mixed',
\ 'openal_source_pause(': 'resource source | bool',
\ 'openal_source_play(': 'resource source | bool',
\ 'openal_source_rewind(': 'resource source | bool',
\ 'openal_source_set(': 'resource source, int property, mixed setting | bool',
\ 'openal_source_stop(': 'resource source | bool',
\ 'openal_stream(': 'resource source, int format, int rate | resource',
\ 'opendir(': 'string path [, resource context] | resource',
\ 'openlog(': 'string ident, int option, int facility | bool',
\ 'openssl_csr_export(': 'resource csr, string &#38;out [, bool notext] | bool',
\ 'openssl_csr_export_to_file(': 'resource csr, string outfilename [, bool notext] | bool',
\ 'openssl_csr_new(': 'array dn, resource &#38;privkey [, array configargs [, array extraattribs]] | mixed',
\ 'openssl_csr_sign(': 'mixed csr, mixed cacert, mixed priv_key, int days [, array configargs [, int serial]] | resource',
\ 'openssl_error_string(': 'void  | string',
\ 'openssl_free_key(': 'resource key_identifier | void',
\ 'openssl_open(': 'string sealed_data, string &#38;open_data, string env_key, mixed priv_key_id | bool',
\ 'openssl_pkcs7_decrypt(': 'string infilename, string outfilename, mixed recipcert [, mixed recipkey] | bool',
\ 'openssl_pkcs7_encrypt(': 'string infile, string outfile, mixed recipcerts, array headers [, int flags [, int cipherid]] | bool',
\ 'openssl_pkcs7_sign(': 'string infilename, string outfilename, mixed signcert, mixed privkey, array headers [, int flags [, string extracerts]] | bool',
\ 'openssl_pkcs7_verify(': 'string filename, int flags [, string outfilename [, array cainfo [, string extracerts]]] | mixed',
\ 'openssl_pkey_export(': 'mixed key, string &#38;out [, string passphrase [, array configargs]] | bool',
\ 'openssl_pkey_export_to_file(': 'mixed key, string outfilename [, string passphrase [, array configargs]] | bool',
\ 'openssl_pkey_free(': 'resource key | void',
\ 'openssl_pkey_get_private(': 'mixed key [, string passphrase] | resource',
\ 'openssl_pkey_get_public(': 'mixed certificate | resource',
\ 'openssl_pkey_new(': '[array configargs] | resource',
\ 'openssl_private_decrypt(': 'string data, string &#38;decrypted, mixed key [, int padding] | bool',
\ 'openssl_private_encrypt(': 'string data, string &#38;crypted, mixed key [, int padding] | bool',
\ 'openssl_public_decrypt(': 'string data, string &#38;decrypted, mixed key [, int padding] | bool',
\ 'openssl_public_encrypt(': 'string data, string &#38;crypted, mixed key [, int padding] | bool',
\ 'openssl_seal(': 'string data, string &#38;sealed_data, array &#38;env_keys, array pub_key_ids | int',
\ 'openssl_sign(': 'string data, string &#38;signature, mixed priv_key_id [, int signature_alg] | bool',
\ 'openssl_verify(': 'string data, string signature, mixed pub_key_id | int',
\ 'openssl_x509_check_private_key(': 'mixed cert, mixed key | bool',
\ 'openssl_x509_checkpurpose(': 'mixed x509cert, int purpose [, array cainfo [, string untrustedfile]] | int',
\ 'openssl_x509_export(': 'mixed x509, string &#38;output [, bool notext] | bool',
\ 'openssl_x509_export_to_file(': 'mixed x509, string outfilename [, bool notext] | bool',
\ 'openssl_x509_free(': 'resource x509cert | void',
\ 'openssl_x509_parse(': 'mixed x509cert [, bool shortnames] | array',
\ 'openssl_x509_read(': 'mixed x509certdata | resource',
\ 'ora_bind(': 'resource cursor, string PHP_variable_name, string SQL_parameter_name, int length [, int type] | bool',
\ 'ora_close(': 'resource cursor | bool',
\ 'ora_columnname(': 'resource cursor, int column | string',
\ 'ora_columnsize(': 'resource cursor, int column | int',
\ 'ora_columntype(': 'resource cursor, int column | string',
\ 'ora_commit(': 'resource conn | bool',
\ 'ora_commitoff(': 'resource conn | bool',
\ 'ora_commiton(': 'resource conn | bool',
\ 'ora_do(': 'resource conn, string query | resource',
\ 'ora_errorcode(': '[resource cursor_or_connection] | int',
\ 'ora_error(': '[resource cursor_or_connection] | string',
\ 'ora_exec(': 'resource cursor | bool',
\ 'ora_fetch(': 'resource cursor | bool',
\ 'ora_fetch_into(': 'resource cursor, array &#38;result [, int flags] | int',
\ 'ora_getcolumn(': 'resource cursor, int column | string',
\ 'ora_logoff(': 'resource connection | bool',
\ 'ora_logon(': 'string user, string password | resource',
\ 'ora_numcols(': 'resource cursor | int',
\ 'ora_numrows(': 'resource cursor | int',
\ 'ora_open(': 'resource connection | resource',
\ 'ora_parse(': 'resource cursor, string sql_statement [, int defer] | bool',
\ 'ora_plogon(': 'string user, string password | resource',
\ 'ora_rollback(': 'resource connection | bool',
\ 'OrbitEnum(': 'string id | new',
\ 'OrbitObject(': 'string ior | new',
\ 'OrbitStruct(': 'string id | new',
\ 'ord(': 'string string | int',
\ 'output_add_rewrite_var(': 'string name, string value | bool',
\ 'output_reset_rewrite_vars(': 'void  | bool',
\ 'overload(': '[string class_name] | void',
\ 'override_function(': 'string function_name, string function_args, string function_code | bool',
\ 'ovrimos_close(': 'int connection | void',
\ 'ovrimos_commit(': 'int connection_id | bool',
\ 'ovrimos_connect(': 'string host, string db, string user, string password | int',
\ 'ovrimos_cursor(': 'int result_id | string',
\ 'ovrimos_exec(': 'int connection_id, string query | int',
\ 'ovrimos_execute(': 'int result_id [, array parameters_array] | bool',
\ 'ovrimos_fetch_into(': 'int result_id, array &#38;result_array [, string how [, int rownumber]] | bool',
\ 'ovrimos_fetch_row(': 'int result_id [, int how [, int row_number]] | bool',
\ 'ovrimos_field_len(': 'int result_id, int field_number | int',
\ 'ovrimos_field_name(': 'int result_id, int field_number | string',
\ 'ovrimos_field_num(': 'int result_id, string field_name | int',
\ 'ovrimos_field_type(': 'int result_id, int field_number | int',
\ 'ovrimos_free_result(': 'int result_id | bool',
\ 'ovrimos_longreadlen(': 'int result_id, int length | bool',
\ 'ovrimos_num_fields(': 'int result_id | int',
\ 'ovrimos_num_rows(': 'int result_id | int',
\ 'ovrimos_prepare(': 'int connection_id, string query | int',
\ 'ovrimos_result_all(': 'int result_id [, string format] | int',
\ 'ovrimos_result(': 'int result_id, mixed field | string',
\ 'ovrimos_rollback(': 'int connection_id | bool',
\ 'pack(': 'string format [, mixed args [, mixed ...]] | string',
\ 'ParentIterator::getChildren(': 'void  | ParentIterator',
\ 'ParentIterator::hasChildren(': 'void  | bool',
\ 'ParentIterator::next(': 'void  | void',
\ 'ParentIterator::rewind(': 'void  | void',
\ 'parse_ini_file(': 'string filename [, bool process_sections] | array',
\ 'parsekit_compile_file(': 'string filename [, array &#38;errors [, int options]] | array',
\ 'parsekit_compile_string(': 'string phpcode [, array &#38;errors [, int options]] | array',
\ 'parsekit_func_arginfo(': 'mixed function | array',
\ 'parse_str(': 'string str [, array &#38;arr] | void',
\ 'parse_url(': 'string url | array',
\ 'passthru(': 'string command [, int &#38;return_var] | void',
\ 'pathinfo(': 'string path [, int options] | mixed',
\ 'pclose(': 'resource handle | int',
\ 'pcntl_alarm(': 'int seconds | int',
\ 'pcntl_exec(': 'string path [, array args [, array envs]] | void',
\ 'pcntl_fork(': 'void  | int',
\ 'pcntl_getpriority(': '[int pid [, int process_identifier]] | int',
\ 'pcntl_setpriority(': 'int priority [, int pid [, int process_identifier]] | bool',
\ 'pcntl_signal(': 'int signo, callback handle [, bool restart_syscalls] | bool',
\ 'pcntl_wait(': 'int &#38;status [, int options] | int',
\ 'pcntl_waitpid(': 'int pid, int &#38;status [, int options] | int',
\ 'pcntl_wexitstatus(': 'int status | int',
\ 'pcntl_wifexited(': 'int status | bool',
\ 'pcntl_wifsignaled(': 'int status | bool',
\ 'pcntl_wifstopped(': 'int status | bool',
\ 'pcntl_wstopsig(': 'int status | int',
\ 'pcntl_wtermsig(': 'int status | int',
\ 'pdf_activate_item(': 'resource pdfdoc, int id | bool',
\ 'pdf_add_launchlink(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string filename | bool',
\ 'pdf_add_locallink(': 'resource pdfdoc, float lowerleftx, float lowerlefty, float upperrightx, float upperrighty, int page, string dest | bool',
\ 'pdf_add_nameddest(': 'resource pdfdoc, string name, string optlist | bool',
\ 'pdf_add_note(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string contents, string title, string icon, int open | bool',
\ 'pdf_add_pdflink(': 'resource pdfdoc, float bottom_left_x, float bottom_left_y, float up_right_x, float up_right_y, string filename, int page, string dest | bool',
\ 'pdf_add_thumbnail(': 'resource pdfdoc, int image | bool',
\ 'pdf_add_weblink(': 'resource pdfdoc, float lowerleftx, float lowerlefty, float upperrightx, float upperrighty, string url | bool',
\ 'pdf_arc(': 'resource p, float x, float y, float r, float alpha, float beta | bool',
\ 'pdf_arcn(': 'resource p, float x, float y, float r, float alpha, float beta | bool',
\ 'pdf_attach_file(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string filename, string description, string author, string mimetype, string icon | bool',
\ 'pdf_begin_document(': 'resource pdfdoc, string filename, string optlist | int',
\ 'pdf_begin_font(': 'resource pdfdoc, string filename, float a, float b, float c, float d, float e, float f, string optlist | bool',
\ 'pdf_begin_glyph(': 'resource pdfdoc, string glyphname, float wx, float llx, float lly, float urx, float ury | bool',
\ 'pdf_begin_item(': 'resource pdfdoc, string tag, string optlist | int',
\ 'pdf_begin_layer(': 'resource pdfdoc, int layer | bool',
\ 'pdf_begin_page_ext(': 'resource pdfdoc, float width, float height, string optlist | bool',
\ 'pdf_begin_page(': 'resource pdfdoc, float width, float height | bool',
\ 'pdf_begin_pattern(': 'resource pdfdoc, float width, float height, float xstep, float ystep, int painttype | int',
\ 'pdf_begin_template(': 'resource pdfdoc, float width, float height | int',
\ 'pdf_circle(': 'resource pdfdoc, float x, float y, float r | bool',
\ 'pdf_clip(': 'resource p | bool',
\ 'pdf_close(': 'resource p | bool',
\ 'pdf_close_image(': 'resource p, int image | void',
\ 'pdf_closepath_fill_stroke(': 'resource p | bool',
\ 'pdf_closepath(': 'resource p | bool',
\ 'pdf_closepath_stroke(': 'resource p | bool',
\ 'pdf_close_pdi(': 'resource p, int doc | bool',
\ 'pdf_close_pdi_page(': 'resource p, int page | bool',
\ 'pdf_concat(': 'resource p, float a, float b, float c, float d, float e, float f | bool',
\ 'pdf_continue_text(': 'resource p, string text | bool',
\ 'pdf_create_action(': 'resource pdfdoc, string type, string optlist | int',
\ 'pdf_create_annotation(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string type, string optlist | bool',
\ 'pdf_create_bookmark(': 'resource pdfdoc, string text, string optlist | int',
\ 'pdf_create_fieldgroup(': 'resource pdfdoc, string name, string optlist | bool',
\ 'pdf_create_field(': 'resource pdfdoc, float llx, float lly, float urx, float ury, string name, string type, string optlist | bool',
\ 'pdf_create_gstate(': 'resource pdfdoc, string optlist | int',
\ 'pdf_create_pvf(': 'resource pdfdoc, string filename, string data, string optlist | bool',
\ 'pdf_create_textflow(': 'resource pdfdoc, string text, string optlist | int',
\ 'pdf_curveto(': 'resource p, float x1, float y1, float x2, float y2, float x3, float y3 | bool',
\ 'pdf_define_layer(': 'resource pdfdoc, string name, string optlist | int',
\ 'pdf_delete(': 'resource pdfdoc | bool',
\ 'pdf_delete_pvf(': 'resource pdfdoc, string filename | int',
\ 'pdf_delete_textflow(': 'resource pdfdoc, int textflow | bool',
\ 'pdf_encoding_set_char(': 'resource pdfdoc, string encoding, int slot, string glyphname, int uv | bool',
\ 'pdf_end_document(': 'resource pdfdoc, string optlist | bool',
\ 'pdf_end_font(': 'resource pdfdoc | bool',
\ 'pdf_end_glyph(': 'resource pdfdoc | bool',
\ 'pdf_end_item(': 'resource pdfdoc, int id | bool',
\ 'pdf_end_layer(': 'resource pdfdoc | bool',
\ 'pdf_end_page_ext(': 'resource pdfdoc, string optlist | bool',
\ 'pdf_end_page(': 'resource p | bool',
\ 'pdf_end_pattern(': 'resource p | bool',
\ 'pdf_end_template(': 'resource p | bool',
\ 'pdf_fill(': 'resource p | bool',
\ 'pdf_fill_imageblock(': 'resource pdfdoc, int page, string blockname, int image, string optlist | int',
\ 'pdf_fill_pdfblock(': 'resource pdfdoc, int page, string blockname, int contents, string optlist | int',
\ 'pdf_fill_stroke(': 'resource p | bool',
\ 'pdf_fill_textblock(': 'resource pdfdoc, int page, string blockname, string text, string optlist | int',
\ 'pdf_findfont(': 'resource p, string fontname, string encoding, int embed | int',
\ 'pdf_fit_image(': 'resource pdfdoc, int image, float x, float y, string optlist | bool',
\ 'pdf_fit_pdi_page(': 'resource pdfdoc, int page, float x, float y, string optlist | bool',
\ 'pdf_fit_textflow(': 'resource pdfdoc, int textflow, float llx, float lly, float urx, float ury, string optlist | string',
\ 'pdf_fit_textline(': 'resource pdfdoc, string text, float x, float y, string optlist | bool',
\ 'pdf_get_apiname(': 'resource pdfdoc | string',
\ 'pdf_get_buffer(': 'resource p | string',
\ 'pdf_get_errmsg(': 'resource pdfdoc | string',
\ 'pdf_get_errnum(': 'resource pdfdoc | int',
\ 'pdf_get_majorversion(': 'void  | int',
\ 'pdf_get_minorversion(': 'void  | int',
\ 'pdf_get_parameter(': 'resource p, string key, float modifier | string',
\ 'pdf_get_pdi_parameter(': 'resource p, string key, int doc, int page, int reserved | string',
\ 'pdf_get_pdi_value(': 'resource p, string key, int doc, int page, int reserved | float',
\ 'pdf_get_value(': 'resource p, string key, float modifier | float',
\ 'pdf_info_textflow(': 'resource pdfdoc, int textflow, string keyword | float',
\ 'pdf_initgraphics(': 'resource p | bool',
\ 'pdf_lineto(': 'resource p, float x, float y | bool',
\ 'pdf_load_font(': 'resource pdfdoc, string fontname, string encoding, string optlist | int',
\ 'pdf_load_iccprofile(': 'resource pdfdoc, string profilename, string optlist | int',
\ 'pdf_load_image(': 'resource pdfdoc, string imagetype, string filename, string optlist | int',
\ 'pdf_makespotcolor(': 'resource p, string spotname | int',
\ 'pdf_moveto(': 'resource p, float x, float y | bool',
\ 'pdf_new(': ' | resource',
\ 'pdf_open_ccitt(': 'resource pdfdoc, string filename, int width, int height, int BitReverse, int k, int Blackls1 | int',
\ 'pdf_open_file(': 'resource p, string filename | bool',
\ 'pdf_open_image_file(': 'resource p, string imagetype, string filename, string stringparam, int intparam | int',
\ 'pdf_open_image(': 'resource p, string imagetype, string source, string data, int length, int width, int height, int components, int bpc, string params | int',
\ 'pdf_open_memory_image(': 'resource p, resource image | int',
\ 'pdf_open_pdi(': 'resource pdfdoc, string filename, string optlist, int len | int',
\ 'pdf_open_pdi_page(': 'resource p, int doc, int pagenumber, string optlist | int',
\ 'pdf_place_image(': 'resource pdfdoc, int image, float x, float y, float scale | bool',
\ 'pdf_place_pdi_page(': 'resource pdfdoc, int page, float x, float y, float sx, float sy | bool',
\ 'pdf_process_pdi(': 'resource pdfdoc, int doc, int page, string optlist | int',
\ 'pdf_rect(': 'resource p, float x, float y, float width, float height | bool',
\ 'pdf_restore(': 'resource p | bool',
\ 'pdf_resume_page(': 'resource pdfdoc, string optlist | bool',
\ 'pdf_rotate(': 'resource p, float phi | bool',
\ 'pdf_save(': 'resource p | bool',
\ 'pdf_scale(': 'resource p, float sx, float sy | bool',
\ 'pdf_set_border_color(': 'resource p, float red, float green, float blue | bool',
\ 'pdf_set_border_dash(': 'resource pdfdoc, float black, float white | bool',
\ 'pdf_set_border_style(': 'resource pdfdoc, string style, float width | bool',
\ 'pdf_setcolor(': 'resource p, string fstype, string colorspace, float c1, float c2, float c3, float c4 | bool',
\ 'pdf_setdash(': 'resource pdfdoc, float b, float w | bool',
\ 'pdf_setdashpattern(': 'resource pdfdoc, string optlist | bool',
\ 'pdf_setflat(': 'resource pdfdoc, float flatness | bool',
\ 'pdf_setfont(': 'resource pdfdoc, int font, float fontsize | bool',
\ 'pdf_setgray_fill(': 'resource p, float g | bool',
\ 'pdf_setgray(': 'resource p, float g | bool',
\ 'pdf_setgray_stroke(': 'resource p, float g | bool',
\ 'pdf_set_gstate(': 'resource pdfdoc, int gstate | bool',
\ 'pdf_set_info(': 'resource p, string key, string value | bool',
\ 'pdf_set_layer_dependency(': 'resource pdfdoc, string type, string optlist | bool',
\ 'pdf_setlinecap(': 'resource p, int linecap | bool',
\ 'pdf_setlinejoin(': 'resource p, int value | bool',
\ 'pdf_setlinewidth(': 'resource p, float width | bool',
\ 'pdf_setmatrix(': 'resource p, float a, float b, float c, float d, float e, float f | bool',
\ 'pdf_setmiterlimit(': 'resource pdfdoc, float miter | bool',
\ 'pdf_set_parameter(': 'resource p, string key, string value | bool',
\ 'pdf_setrgbcolor_fill(': 'resource p, float red, float green, float blue | bool',
\ 'pdf_setrgbcolor(': 'resource p, float red, float green, float blue | bool',
\ 'pdf_setrgbcolor_stroke(': 'resource p, float red, float green, float blue | bool',
\ 'pdf_set_text_pos(': 'resource p, float x, float y | bool',
\ 'pdf_set_value(': 'resource p, string key, float value | bool',
\ 'pdf_shading(': 'resource pdfdoc, string shtype, float x0, float y0, float x1, float y1, float c1, float c2, float c3, float c4, string optlist | int',
\ 'pdf_shading_pattern(': 'resource pdfdoc, int shading, string optlist | int',
\ 'pdf_shfill(': 'resource pdfdoc, int shading | bool',
\ 'pdf_show_boxed(': 'resource p, string text, float left, float top, float width, float height, string mode, string feature | int',
\ 'pdf_show(': 'resource pdfdoc, string text | bool',
\ 'pdf_show_xy(': 'resource p, string text, float x, float y | bool',
\ 'pdf_skew(': 'resource p, float alpha, float beta | bool',
\ 'pdf_stringwidth(': 'resource p, string text, int font, float fontsize | float',
\ 'pdf_stroke(': 'resource p | bool',
\ 'pdf_suspend_page(': 'resource pdfdoc, string optlist | bool',
\ 'pdf_translate(': 'resource p, float tx, float ty | bool',
\ 'pdf_utf16_to_utf8(': 'resource pdfdoc, string utf16string | string',
\ 'pdf_utf8_to_utf16(': 'resource pdfdoc, string utf8string, string ordering | string',
\ 'pdf_xshow(': 'resource pdfdoc, string text | bool',
\ 'PDO::beginTransaction(': 'void  | bool',
\ 'PDO::commit(': 'void  | bool',
\ 'PDO::__construct(': 'string dsn [, string username [, string password [, array driver_options]]] | PDO',
\ 'PDO::errorCode(': 'void  | string',
\ 'PDO::errorInfo(': 'void  | array',
\ 'PDO::exec(': 'string statement | int',
\ 'PDO::getAttribute(': 'int attribute | mixed',
\ 'PDO::getAvailableDrivers(': 'void  | array',
\ 'PDO::lastInsertId(': '[string name] | string',
\ 'PDO::prepare(': 'string statement [, array driver_options] | PDOStatement',
\ 'PDO::query(': 'string statement | PDOStatement',
\ 'PDO::quote(': 'string string [, int parameter_type] | string',
\ 'PDO::rollBack(': 'void  | bool',
\ 'PDO::setAttribute(': 'int attribute, mixed value | bool',
\ 'PDO::sqliteCreateAggregate(': 'string function_name, callback step_func, callback finalize_func [, int num_args] | bool',
\ 'PDO::sqliteCreateFunction(': 'string function_name, callback callback [, int num_args] | bool',
\ 'PDOStatement::bindColumn(': 'mixed column, mixed &#38;param [, int type] | bool',
\ 'PDOStatement::bindParam(': 'mixed parameter, mixed &#38;variable [, int data_type [, int length [, mixed driver_options]]] | bool',
\ 'PDOStatement::bindValue(': 'mixed parameter, mixed value [, int data_type] | bool',
\ 'PDOStatement::closeCursor(': 'void  | bool',
\ 'PDOStatement::columnCount(': 'void  | int',
\ 'PDOStatement::errorCode(': 'void  | string',
\ 'PDOStatement::errorInfo(': 'void  | array',
\ 'PDOStatement::execute(': '[array input_parameters] | bool',
\ 'PDOStatement::fetchAll(': '[int fetch_style [, int column_index]] | array',
\ 'PDOStatement::fetchColumn(': '[int column_number] | string',
\ 'PDOStatement::fetch(': '[int fetch_style [, int cursor_orientation [, int cursor_offset]]] | mixed',
\ 'PDOStatement::fetchObject(': '[string class_name [, array ctor_args]] | mixed',
\ 'PDOStatement::getAttribute(': 'int attribute | mixed',
\ 'PDOStatement::getColumnMeta(': 'int column | mixed',
\ 'PDOStatement::nextRowset(': 'void  | bool',
\ 'PDOStatement::rowCount(': 'void  | int',
\ 'PDOStatement::setAttribute(': 'int attribute, mixed value | bool',
\ 'PDOStatement::setFetchMode(': 'int mode | bool',
\ 'pfpro_cleanup(': 'void  | bool',
\ 'pfpro_init(': 'void  | bool',
\ 'pfpro_process(': 'array parameters [, string address [, int port [, int timeout [, string proxy_address [, int proxy_port [, string proxy_logon [, string proxy_password]]]]]]] | array',
\ 'pfpro_process_raw(': 'string parameters [, string address [, int port [, int timeout [, string proxy_address [, int proxy_port [, string proxy_logon [, string proxy_password]]]]]]] | string',
\ 'pfpro_version(': 'void  | string',
\ 'pfsockopen(': 'string hostname [, int port [, int &#38;errno [, string &#38;errstr [, float timeout]]]] | resource',
\ 'pg_affected_rows(': 'resource result | int',
\ 'pg_cancel_query(': 'resource connection | bool',
\ 'pg_client_encoding(': '[resource connection] | string',
\ 'pg_close(': '[resource connection] | bool',
\ 'pg_connect(': 'string connection_string [, int connect_type] | resource',
\ 'pg_connection_busy(': 'resource connection | bool',
\ 'pg_connection_reset(': 'resource connection | bool',
\ 'pg_connection_status(': 'resource connection | int',
\ 'pg_convert(': 'resource connection, string table_name, array assoc_array [, int options] | array',
\ 'pg_copy_from(': 'resource connection, string table_name, array rows [, string delimiter [, string null_as]] | bool',
\ 'pg_copy_to(': 'resource connection, string table_name [, string delimiter [, string null_as]] | array',
\ 'pg_dbname(': '[resource connection] | string',
\ 'pg_delete(': 'resource connection, string table_name, array assoc_array [, int options] | mixed',
\ 'pg_end_copy(': '[resource connection] | bool',
\ 'pg_escape_bytea(': 'string data | string',
\ 'pg_escape_string(': 'string data | string',
\ 'pg_execute(': 'resource connection, string stmtname, array params | resource',
\ 'pg_fetch_all_columns(': 'resource result [, int column] | array',
\ 'pg_fetch_all(': 'resource result | array',
\ 'pg_fetch_array(': 'resource result [, int row [, int result_type]] | array',
\ 'pg_fetch_assoc(': 'resource result [, int row] | array',
\ 'pg_fetch_object(': 'resource result [, int row [, int result_type]] | object',
\ 'pg_fetch_result(': 'resource result, int row, mixed field | string',
\ 'pg_fetch_row(': 'resource result [, int row] | array',
\ 'pg_field_is_null(': 'resource result, int row, mixed field | int',
\ 'pg_field_name(': 'resource result, int field_number | string',
\ 'pg_field_num(': 'resource result, string field_name | int',
\ 'pg_field_prtlen(': 'resource result, int row_number, mixed field_name_or_number | int',
\ 'pg_field_size(': 'resource result, int field_number | int',
\ 'pg_field_type(': 'resource result, int field_number | string',
\ 'pg_field_type_oid(': 'resource result, int field_number | int',
\ 'pg_free_result(': 'resource result | bool',
\ 'pg_get_notify(': 'resource connection [, int result_type] | array',
\ 'pg_get_pid(': 'resource connection | int',
\ 'pg_get_result(': '[resource connection] | resource',
\ 'pg_host(': '[resource connection] | string',
\ 'pg_insert(': 'resource connection, string table_name, array assoc_array [, int options] | mixed',
\ 'pg_last_error(': '[resource connection] | string',
\ 'pg_last_notice(': 'resource connection | string',
\ 'pg_last_oid(': 'resource result | string',
\ 'pg_lo_close(': 'resource large_object | bool',
\ 'pg_lo_create(': '[resource connection] | int',
\ 'pg_lo_export(': 'resource connection, int oid, string pathname | bool',
\ 'pg_lo_import(': 'resource connection, string pathname | int',
\ 'pg_lo_open(': 'resource connection, int oid, string mode | resource',
\ 'pg_lo_read_all(': 'resource large_object | int',
\ 'pg_lo_read(': 'resource large_object [, int len] | string',
\ 'pg_lo_seek(': 'resource large_object, int offset [, int whence] | bool',
\ 'pg_lo_tell(': 'resource large_object | int',
\ 'pg_lo_unlink(': 'resource connection, int oid | bool',
\ 'pg_lo_write(': 'resource large_object, string data [, int len] | int',
\ 'pg_meta_data(': 'resource connection, string table_name | array',
\ 'pg_num_fields(': 'resource result | int',
\ 'pg_num_rows(': 'resource result | int',
\ 'pg_options(': '[resource connection] | string',
\ 'pg_parameter_status(': 'resource connection, string param_name | string',
\ 'pg_pconnect(': 'string connection_string [, int connect_type] | resource',
\ 'pg_ping(': '[resource connection] | bool',
\ 'pg_port(': '[resource connection] | int',
\ 'pg_prepare(': 'resource connection, string stmtname, string query | resource',
\ 'pg_put_line(': 'string data | bool',
\ 'pg_query(': 'string query | resource',
\ 'pg_query_params(': 'resource connection, string query, array params | resource',
\ 'pg_result_error_field(': 'resource result, int fieldcode | string',
\ 'pg_result_error(': 'resource result | string',
\ 'pg_result_seek(': 'resource result, int offset | bool',
\ 'pg_result_status(': 'resource result [, int type] | mixed',
\ 'pg_select(': 'resource connection, string table_name, array assoc_array [, int options] | mixed',
\ 'pg_send_execute(': 'resource connection, string stmtname, array params | bool',
\ 'pg_send_prepare(': 'resource connection, string stmtname, string query | bool',
\ 'pg_send_query(': 'resource connection, string query | bool',
\ 'pg_send_query_params(': 'resource connection, string query, array params | bool',
\ 'pg_set_client_encoding(': 'string encoding | int',
\ 'pg_set_error_verbosity(': 'resource connection, int verbosity | int',
\ 'pg_trace(': 'string pathname [, string mode [, resource connection]] | bool',
\ 'pg_transaction_status(': 'resource connection | int',
\ 'pg_tty(': '[resource connection] | string',
\ 'pg_unescape_bytea(': 'string data | string',
\ 'pg_untrace(': '[resource connection] | bool',
\ 'pg_update(': 'resource connection, string table_name, array data, array condition [, int options] | mixed',
\ 'pg_version(': '[resource connection] | array',
\ 'php_check_syntax(': 'string file_name [, string &#38;error_message] | bool',
\ 'phpcredits(': '[int flag] | bool',
\ 'phpinfo(': '[int what] | bool',
\ 'php_ini_scanned_files(': 'void  | string',
\ 'php_logo_guid(': 'void  | string',
\ 'php_sapi_name(': 'void  | string',
\ 'php_strip_whitespace(': 'string filename | string',
\ 'php_uname(': '[string mode] | string',
\ 'phpversion(': '[string extension] | string',
\ 'pi(': 'void  | float',
\ 'png2wbmp(': 'string pngname, string wbmpname, int d_height, int d_width, int threshold | int',
\ 'popen(': 'string command, string mode | resource',
\ 'posix_access(': 'string file [, int mode] | bool',
\ 'posix_ctermid(': 'void  | string',
\ 'posix_getcwd(': 'void  | string',
\ 'posix_getegid(': 'void  | int',
\ 'posix_geteuid(': 'void  | int',
\ 'posix_getgid(': 'void  | int',
\ 'posix_getgrgid(': 'int gid | array',
\ 'posix_getgrnam(': 'string name | array',
\ 'posix_getgroups(': 'void  | array',
\ 'posix_get_last_error(': 'void  | int',
\ 'posix_getlogin(': 'void  | string',
\ 'posix_getpgid(': 'int pid | int',
\ 'posix_getpgrp(': 'void  | int',
\ 'posix_getpid(': 'void  | int',
\ 'posix_getppid(': 'void  | int',
\ 'posix_getpwnam(': 'string username | array',
\ 'posix_getpwuid(': 'int uid | array',
\ 'posix_getrlimit(': 'void  | array',
\ 'posix_getsid(': 'int pid | int',
\ 'posix_getuid(': 'void  | int',
\ 'posix_isatty(': 'int fd | bool',
\ 'posix_kill(': 'int pid, int sig | bool',
\ 'posix_mkfifo(': 'string pathname, int mode | bool',
\ 'posix_mknod(': 'string pathname, int mode [, int major [, int minor]] | bool',
\ 'posix_setegid(': 'int gid | bool',
\ 'posix_seteuid(': 'int uid | bool',
\ 'posix_setgid(': 'int gid | bool',
\ 'posix_setpgid(': 'int pid, int pgid | bool',
\ 'posix_setsid(': 'void  | int',
\ 'posix_setuid(': 'int uid | bool',
\ 'posix_strerror(': 'int errno | string',
\ 'posix_times(': 'void  | array',
\ 'posix_ttyname(': 'int fd | string',
\ 'posix_uname(': 'void  | array',
\ 'pow(': 'number base, number exp | number',
\ 'preg_grep(': 'string pattern, array input [, int flags] | array',
\ 'preg_match_all(': 'string pattern, string subject, array &#38;matches [, int flags [, int offset]] | int',
\ 'preg_match(': 'string pattern, string subject [, array &#38;matches [, int flags [, int offset]]] | int',
\ 'preg_quote(': 'string str [, string delimiter] | string',
\ 'preg_replace_callback(': 'mixed pattern, callback callback, mixed subject [, int limit [, int &#38;count]] | mixed',
\ 'preg_replace(': 'mixed pattern, mixed replacement, mixed subject [, int limit [, int &#38;count]] | mixed',
\ 'preg_split(': 'string pattern, string subject [, int limit [, int flags]] | array',
\ 'prev(': 'array &#38;array | mixed',
\ 'printer_abort(': 'resource handle | void',
\ 'printer_close(': 'resource handle | void',
\ 'printer_create_brush(': 'int style, string color | resource',
\ 'printer_create_dc(': 'resource handle | void',
\ 'printer_create_font(': 'string face, int height, int width, int font_weight, bool italic, bool underline, bool strikeout, int orientation | resource',
\ 'printer_create_pen(': 'int style, int width, string color | resource',
\ 'printer_delete_brush(': 'resource handle | void',
\ 'printer_delete_dc(': 'resource handle | bool',
\ 'printer_delete_font(': 'resource handle | void',
\ 'printer_delete_pen(': 'resource handle | void',
\ 'printer_draw_bmp(': 'resource handle, string filename, int x, int y [, int width, int height] | bool',
\ 'printer_draw_chord(': 'resource handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad_x, int rad_y, int rad_x1, int rad_y1 | void',
\ 'printer_draw_elipse(': 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y | void',
\ 'printer_draw_line(': 'resource printer_handle, int from_x, int from_y, int to_x, int to_y | void',
\ 'printer_draw_pie(': 'resource handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad1_x, int rad1_y, int rad2_x, int rad2_y | void',
\ 'printer_draw_rectangle(': 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y | void',
\ 'printer_draw_roundrect(': 'resource handle, int ul_x, int ul_y, int lr_x, int lr_y, int width, int height | void',
\ 'printer_draw_text(': 'resource printer_handle, string text, int x, int y | void',
\ 'printer_end_doc(': 'resource handle | bool',
\ 'printer_end_page(': 'resource handle | bool',
\ 'printer_get_option(': 'resource handle, string option | mixed',
\ 'printer_list(': 'int enumtype [, string name [, int level]] | array',
\ 'printer_logical_fontheight(': 'resource handle, int height | int',
\ 'printer_open(': '[string devicename] | resource',
\ 'printer_select_brush(': 'resource printer_handle, resource brush_handle | void',
\ 'printer_select_font(': 'resource printer_handle, resource font_handle | void',
\ 'printer_select_pen(': 'resource printer_handle, resource pen_handle | void',
\ 'printer_set_option(': 'resource handle, int option, mixed value | bool',
\ 'printer_start_doc(': 'resource handle [, string document] | bool',
\ 'printer_start_page(': 'resource handle | bool',
\ 'printer_write(': 'resource handle, string content | bool',
\ 'printf(': 'string format [, mixed args [, mixed ...]] | int',
\ 'print(': 'string arg | int',
\ 'print_r(': 'mixed expression [, bool return] | bool',
\ 'proc_close(': 'resource process | int',
\ 'proc_get_status(': 'resource process | array',
\ 'proc_nice(': 'int increment | bool',
\ 'proc_open(': 'string cmd, array descriptorspec, array &#38;pipes [, string cwd [, array env [, array other_options]]] | resource',
\ 'proc_terminate(': 'resource process [, int signal] | int',
\ 'property_exists(': 'mixed class, string property | bool',
\ 'ps_add_bookmark(': 'resource psdoc, string text [, int parent [, int open]] | int',
\ 'ps_add_launchlink(': 'resource psdoc, float llx, float lly, float urx, float ury, string filename | bool',
\ 'ps_add_locallink(': 'resource psdoc, float llx, float lly, float urx, float ury, int page, string dest | bool',
\ 'ps_add_note(': 'resource psdoc, float llx, float lly, float urx, float ury, string contents, string title, string icon, int open | bool',
\ 'ps_add_pdflink(': 'resource psdoc, float llx, float lly, float urx, float ury, string filename, int page, string dest | bool',
\ 'ps_add_weblink(': 'resource psdoc, float llx, float lly, float urx, float ury, string url | bool',
\ 'ps_arc(': 'resource psdoc, float x, float y, float radius, float alpha, float beta | bool',
\ 'ps_arcn(': 'resource psdoc, float x, float y, float radius, float alpha, float beta | bool',
\ 'ps_begin_page(': 'resource psdoc, float width, float height | bool',
\ 'ps_begin_pattern(': 'resource psdoc, float width, float height, float xstep, float ystep, int painttype | bool',
\ 'ps_begin_template(': 'resource psdoc, float width, float height | bool',
\ 'ps_circle(': 'resource psdoc, float x, float y, float radius | bool',
\ 'ps_clip(': 'resource psdoc | bool',
\ 'ps_close(': 'resource psdoc | bool',
\ 'ps_close_image(': 'resource psdoc, int imageid | void',
\ 'ps_closepath(': 'resource psdoc | bool',
\ 'ps_closepath_stroke(': 'resource psdoc | bool',
\ 'ps_continue_text(': 'resource psdoc, string text | bool',
\ 'ps_curveto(': 'resource psdoc, float x1, float y1, float x2, float y2, float x3, float y3 | bool',
\ 'ps_delete(': 'resource psdoc | bool',
\ 'ps_end_page(': 'resource psdoc | bool',
\ 'ps_end_pattern(': 'resource psdoc | bool',
\ 'ps_end_template(': 'resource psdoc | bool',
\ 'ps_fill(': 'resource psdoc | bool',
\ 'ps_fill_stroke(': 'resource psdoc | bool',
\ 'ps_findfont(': 'resource psdoc, string fontname, string encoding [, bool embed] | int',
\ 'ps_get_buffer(': 'resource psdoc | string',
\ 'ps_get_parameter(': 'resource psdoc, string name [, float modifier] | string',
\ 'ps_get_value(': 'resource psdoc, string name [, float modifier] | float',
\ 'ps_hyphenate(': 'resource psdoc, string text | array',
\ 'ps_lineto(': 'resource psdoc, float x, float y | bool',
\ 'ps_makespotcolor(': 'resource psdoc, string name [, float reserved] | int',
\ 'ps_moveto(': 'resource psdoc, float x, float y | bool',
\ 'ps_new(': 'void  | resource',
\ 'ps_open_file(': 'resource psdoc [, string filename] | bool',
\ 'ps_open_image_file(': 'resource psdoc, string type, string filename [, string stringparam [, int intparam]] | int',
\ 'ps_open_image(': 'resource psdoc, string type, string source, string data, int lenght, int width, int height, int components, int bpc, string params | int',
\ 'pspell_add_to_personal(': 'int dictionary_link, string word | bool',
\ 'pspell_add_to_session(': 'int dictionary_link, string word | bool',
\ 'pspell_check(': 'int dictionary_link, string word | bool',
\ 'pspell_clear_session(': 'int dictionary_link | bool',
\ 'pspell_config_create(': 'string language [, string spelling [, string jargon [, string encoding]]] | int',
\ 'pspell_config_data_dir(': 'int conf, string directory | bool',
\ 'pspell_config_dict_dir(': 'int conf, string directory | bool',
\ 'pspell_config_ignore(': 'int dictionary_link, int n | bool',
\ 'pspell_config_mode(': 'int dictionary_link, int mode | bool',
\ 'pspell_config_personal(': 'int dictionary_link, string file | bool',
\ 'pspell_config_repl(': 'int dictionary_link, string file | bool',
\ 'pspell_config_runtogether(': 'int dictionary_link, bool flag | bool',
\ 'pspell_config_save_repl(': 'int dictionary_link, bool flag | bool',
\ 'pspell_new_config(': 'int config | int',
\ 'pspell_new(': 'string language [, string spelling [, string jargon [, string encoding [, int mode]]]] | int',
\ 'pspell_new_personal(': 'string personal, string language [, string spelling [, string jargon [, string encoding [, int mode]]]] | int',
\ 'pspell_save_wordlist(': 'int dictionary_link | bool',
\ 'pspell_store_replacement(': 'int dictionary_link, string misspelled, string correct | bool',
\ 'pspell_suggest(': 'int dictionary_link, string word | array',
\ 'ps_place_image(': 'resource psdoc, int imageid, float x, float y, float scale | bool',
\ 'ps_rect(': 'resource psdoc, float x, float y, float width, float height | bool',
\ 'ps_restore(': 'resource psdoc | bool',
\ 'ps_rotate(': 'resource psdoc, float rot | bool',
\ 'ps_save(': 'resource psdoc | bool',
\ 'ps_scale(': 'resource psdoc, float x, float y | bool',
\ 'ps_set_border_color(': 'resource psdoc, float red, float green, float blue | bool',
\ 'ps_set_border_dash(': 'resource psdoc, float black, float white | bool',
\ 'ps_set_border_style(': 'resource psdoc, string style, float width | bool',
\ 'ps_setcolor(': 'resource psdoc, string type, string colorspace, float c1, float c2, float c3, float c4 | bool',
\ 'ps_setdash(': 'resource psdoc, float on, float off | bool',
\ 'ps_setflat(': 'resource psdoc, float value | bool',
\ 'ps_setfont(': 'resource psdoc, int fontid, float size | bool',
\ 'ps_setgray(': 'resource psdoc, float gray | bool',
\ 'ps_set_info(': 'resource p, string key, string val | bool',
\ 'ps_setlinecap(': 'resource psdoc, int type | bool',
\ 'ps_setlinejoin(': 'resource psdoc, int type | bool',
\ 'ps_setlinewidth(': 'resource psdoc, float width | bool',
\ 'ps_setmiterlimit(': 'resource psdoc, float value | bool',
\ 'ps_set_parameter(': 'resource psdoc, string name, string value | bool',
\ 'ps_setpolydash(': 'resource psdoc, float arr | bool',
\ 'ps_set_text_pos(': 'resource psdoc, float x, float y | bool',
\ 'ps_set_value(': 'resource psdoc, string name, float value | bool',
\ 'ps_shading(': 'resource psdoc, string type, float x0, float y0, float x1, float y1, float c1, float c2, float c3, float c4, string optlist | int',
\ 'ps_shading_pattern(': 'resource psdoc, int shadingid, string optlist | int',
\ 'ps_shfill(': 'resource psdoc, int shadingid | bool',
\ 'ps_show_boxed(': 'resource psdoc, string text, float left, float bottom, float width, float height, string hmode [, string feature] | int',
\ 'ps_show(': 'resource psdoc, string text | bool',
\ 'ps_show_xy(': 'resource psdoc, string text, float x, float y | bool',
\ 'ps_string_geometry(': 'resource psdoc, string text [, int fontid [, float size]] | array',
\ 'ps_stringwidth(': 'resource psdoc, string text [, int fontid [, float size]] | float',
\ 'ps_stroke(': 'resource psdoc | bool',
\ 'ps_symbol(': 'resource psdoc, int ord | bool',
\ 'ps_symbol_name(': 'resource psdoc, int ord [, int fontid] | string',
\ 'ps_symbol_width(': 'resource psdoc, int ord [, int fontid [, float size]] | float',
\ 'ps_translate(': 'resource psdoc, float x, float y | bool',
\ 'putenv(': 'string setting | bool',
\ 'px_close(': 'resource pxdoc | bool',
\ 'px_create_fp(': 'resource pxdoc, resource file, array fielddesc | bool',
\ 'px_date2string(': 'resource pxdoc, int value, string format | string',
\ 'px_delete(': 'resource pxdoc | bool',
\ 'px_delete_record(': 'resource pxdoc, int num | bool',
\ 'px_get_field(': 'resource pxdoc, int fieldno | array',
\ 'px_get_info(': 'resource pxdoc | array',
\ 'px_get_parameter(': 'resource pxdoc, string name | string',
\ 'px_get_record(': 'resource pxdoc, int num [, int mode] | array',
\ 'px_get_schema(': 'resource pxdoc [, int mode] | array',
\ 'px_get_value(': 'resource pxdoc, string name | float',
\ 'px_insert_record(': 'resource pxdoc, array data | int',
\ 'px_new(': 'void  | resource',
\ 'px_numfields(': 'resource pxdoc | int',
\ 'px_numrecords(': 'resource pxdoc | int',
\ 'px_open_fp(': 'resource pxdoc, resource file | bool',
\ 'px_put_record(': 'resource pxdoc, array record [, int recpos] | bool',
\ 'px_retrieve_record(': 'resource pxdoc, int num [, int mode] | array',
\ 'px_set_blob_file(': 'resource pxdoc, string filename | bool',
\ 'px_set_parameter(': 'resource pxdoc, string name, string value | bool',
\ 'px_set_tablename(': 'resource pxdoc, string name | void',
\ 'px_set_targetencoding(': 'resource pxdoc, string encoding | bool',
\ 'px_set_value(': 'resource pxdoc, string name, float value | bool',
\ 'px_timestamp2string(': 'resource pxdoc, float value, string format | string',
\ 'px_update_record(': 'resource pxdoc, array data, int num | bool',
\ 'qdom_error(': 'void  | string',
\ 'qdom_tree(': 'string doc | QDomDocument',
\ 'quoted_printable_decode(': 'string str | string',
\ 'quotemeta(': 'string str | string',
\ 'rad2deg(': 'float number | float',
\ 'radius_acct_open(': 'void  | resource',
\ 'radius_add_server(': 'resource radius_handle, string hostname, int port, string secret, int timeout, int max_tries | bool',
\ 'radius_auth_open(': 'void  | resource',
\ 'radius_close(': 'resource radius_handle | bool',
\ 'radius_config(': 'resource radius_handle, string file | bool',
\ 'radius_create_request(': 'resource radius_handle, int type | bool',
\ 'radius_cvt_addr(': 'string data | string',
\ 'radius_cvt_int(': 'string data | int',
\ 'radius_cvt_string(': 'string data | string',
\ 'radius_demangle(': 'resource radius_handle, string mangled | string',
\ 'radius_demangle_mppe_key(': 'resource radius_handle, string mangled | string',
\ 'radius_get_attr(': 'resource radius_handle | mixed',
\ 'radius_get_vendor_attr(': 'string data | array',
\ 'radius_put_addr(': 'resource radius_handle, int type, string addr | bool',
\ 'radius_put_attr(': 'resource radius_handle, int type, string value | bool',
\ 'radius_put_int(': 'resource radius_handle, int type, int value | bool',
\ 'radius_put_string(': 'resource radius_handle, int type, string value | bool',
\ 'radius_put_vendor_addr(': 'resource radius_handle, int vendor, int type, string addr | bool',
\ 'radius_put_vendor_attr(': 'resource radius_handle, int vendor, int type, string value | bool',
\ 'radius_put_vendor_int(': 'resource radius_handle, int vendor, int type, int value | bool',
\ 'radius_put_vendor_string(': 'resource radius_handle, int vendor, int type, string value | bool',
\ 'radius_request_authenticator(': 'resource radius_handle | string',
\ 'radius_send_request(': 'resource radius_handle | int',
\ 'radius_server_secret(': 'resource radius_handle | string',
\ 'radius_strerror(': 'resource radius_handle | string',
\ 'rand(': '[int min, int max] | int',
\ 'range(': 'mixed low, mixed high [, number step] | array',
\ 'rar_close(': 'resource rar_file | bool',
\ 'rar_entry_get(': 'resource rar_file, string entry_name | RarEntry',
\ 'Rar::extract(': 'string dir [, string filepath] | bool',
\ 'Rar::getAttr(': 'void  | int',
\ 'Rar::getCrc(': 'void  | int',
\ 'Rar::getFileTime(': 'void  | string',
\ 'Rar::getHostOs(': 'void  | int',
\ 'Rar::getMethod(': 'void  | int',
\ 'Rar::getName(': 'void  | string',
\ 'Rar::getPackedSize(': 'void  | int',
\ 'Rar::getUnpackedSize(': 'void  | int',
\ 'Rar::getVersion(': 'void  | int',
\ 'rar_list(': 'resource rar_file | array',
\ 'rar_open(': 'string filename [, string password] | resource',
\ 'rawurldecode(': 'string str | string',
\ 'rawurlencode(': 'string str | string',
\ 'readdir(': 'resource dir_handle | string',
\ 'readfile(': 'string filename [, bool use_include_path [, resource context]] | int',
\ 'readgzfile(': 'string filename [, int use_include_path] | int',
\ 'readline_add_history(': 'string line | bool',
\ 'readline_callback_handler_install(': 'string prompt, callback callback | bool',
\ 'readline_callback_handler_remove(': 'void  | bool',
\ 'readline_callback_read_char(': 'void  | void',
\ 'readline_clear_history(': 'void  | bool',
\ 'readline_completion_function(': 'callback function | bool',
\ 'readline(': 'string prompt | string',
\ 'readline_info(': '[string varname [, string newvalue]] | mixed',
\ 'readline_list_history(': 'void  | array',
\ 'readline_on_new_line(': 'void  | void',
\ 'readline_read_history(': '[string filename] | bool',
\ 'readline_redisplay(': 'void  | void',
\ 'readline_write_history(': '[string filename] | bool',
\ 'readlink(': 'string path | string',
\ 'realpath(': 'string path | string',
\ 'recode_file(': 'string request, resource input, resource output | bool',
\ 'recode_string(': 'string request, string string | string',
\ 'RecursiveDirectoryIterator::getChildren(': 'void  | object',
\ 'RecursiveDirectoryIterator::hasChildren(': '[bool allow_links] | bool',
\ 'RecursiveDirectoryIterator::key(': 'void  | string',
\ 'RecursiveDirectoryIterator::next(': 'void  | void',
\ 'RecursiveDirectoryIterator::rewind(': 'void  | void',
\ 'RecursiveIteratorIterator::current(': 'void  | mixed',
\ 'RecursiveIteratorIterator::getDepth(': 'void  | int',
\ 'RecursiveIteratorIterator::getSubIterator(': 'void  | RecursiveIterator',
\ 'RecursiveIteratorIterator::key(': 'void  | mixed',
\ 'RecursiveIteratorIterator::next(': 'void  | void',
\ 'RecursiveIteratorIterator::rewind(': 'void  | void',
\ 'RecursiveIteratorIterator::valid(': 'void  | bolean',
\ 'register_shutdown_function(': 'callback function [, mixed parameter [, mixed ...]] | void',
\ 'register_tick_function(': 'callback function [, mixed arg [, mixed ...]] | bool',
\ 'rename_function(': 'string original_name, string new_name | bool',
\ 'rename(': 'string oldname, string newname [, resource context] | bool',
\ 'reset(': 'array &#38;array | mixed',
\ 'restore_error_handler(': 'void  | bool',
\ 'restore_exception_handler(': 'void  | bool',
\ 'restore_include_path(': 'void  | void',
\ 'rewinddir(': 'resource dir_handle | void',
\ 'rewind(': 'resource handle | bool',
\ 'rmdir(': 'string dirname [, resource context] | bool',
\ 'round(': 'float val [, int precision] | float',
\ 'rpm_close(': 'resource rpmr | boolean',
\ 'rpm_get_tag(': 'resource rpmr, int tagnum | mixed',
\ 'rpm_is_valid(': 'string filename | boolean',
\ 'rpm_open(': 'string filename | resource',
\ 'rpm_version(': 'void  | string',
\ 'rsort(': 'array &#38;array [, int sort_flags] | bool',
\ 'rtrim(': 'string str [, string charlist] | string',
\ 'runkit_class_adopt(': 'string classname, string parentname | bool',
\ 'runkit_class_emancipate(': 'string classname | bool',
\ 'runkit_constant_add(': 'string constname, mixed value | bool',
\ 'runkit_constant_redefine(': 'string constname, mixed newvalue | bool',
\ 'runkit_constant_remove(': 'string constname | bool',
\ 'runkit_function_add(': 'string funcname, string arglist, string code | bool',
\ 'runkit_function_copy(': 'string funcname, string targetname | bool',
\ 'runkit_function_redefine(': 'string funcname, string arglist, string code | bool',
\ 'runkit_function_remove(': 'string funcname | bool',
\ 'runkit_function_rename(': 'string funcname, string newname | bool',
\ 'runkit_import(': 'string filename [, int flags] | bool',
\ 'runkit_lint_file(': 'string filename | bool',
\ 'runkit_lint(': 'string code | bool',
\ 'runkit_method_add(': 'string classname, string methodname, string args, string code [, int flags] | bool',
\ 'runkit_method_copy(': 'string dClass, string dMethod, string sClass [, string sMethod] | bool',
\ 'runkit_method_redefine(': 'string classname, string methodname, string args, string code [, int flags] | bool',
\ 'runkit_method_remove(': 'string classname, string methodname | bool',
\ 'runkit_method_rename(': 'string classname, string methodname, string newname | bool',
\ 'runkit_return_value_used(': 'void  | bool',
\ 'runkit_sandbox_output_handler(': 'object sandbox [, mixed callback] | mixed',
\ 'runkit_superglobals(': 'void  | array',
\ 'satellite_caught_exception(': 'void  | bool',
\ 'satellite_exception_id(': 'void  | string',
\ 'satellite_exception_value(': 'void  | OrbitStruct',
\ 'satellite_get_repository_id(': 'object obj | int',
\ 'satellite_load_idl(': 'string file | bool',
\ 'satellite_object_to_string(': 'object obj | string',
\ 'scandir(': 'string directory [, int sorting_order [, resource context]] | array',
\ 'SDO_DAS_ChangeSummary::beginLogging(': 'void  | void',
\ 'SDO_DAS_ChangeSummary::endLogging(': 'void  | void',
\ 'SDO_DAS_ChangeSummary::getChangedDataObjects(': 'void  | SDO_List',
\ 'SDO_DAS_ChangeSummary::getChangeType(': 'SDO_DataObject dataObject | int',
\ 'SDO_DAS_ChangeSummary::getOldContainer(': 'SDO_DataObject data_object | SDO_DataObject',
\ 'SDO_DAS_ChangeSummary::getOldValues(': 'SDO_DataObject data_object | SDO_List',
\ 'SDO_DAS_ChangeSummary::isLogging(': 'void  | bool',
\ 'SDO_DAS_DataFactory::addPropertyToType(': 'string parent_type_namespace_uri, string parent_type_name, string property_name, string type_namespace_uri, string type_name [, array options] | void',
\ 'SDO_DAS_DataFactory::addType(': 'string type_namespace_uri, string type_name [, array options] | void',
\ 'SDO_DAS_DataFactory::getDataFactory(': 'void  | SDO_DAS_DataFactory',
\ 'SDO_DAS_DataObject::getChangeSummary(': 'void  | SDO_DAS_ChangeSummary',
\ 'SDO_DAS_Relational::applyChanges(': 'PDO database_handle, SDODataObject root_data_object | void',
\ 'SDO_DAS_Relational::__construct(': 'array database_metadata [, string application_root_type [, array SDO_containment_references_metadata]] | SDO_DAS_Relational',
\ 'SDO_DAS_Relational::createRootDataObject(': 'void  | SDODataObject',
\ 'SDO_DAS_Relational::executePreparedQuery(': 'PDO database_handle, PDOStatement prepared_statement, array value_list [, array column_specifier] | SDODataObject',
\ 'SDO_DAS_Relational::executeQuery(': 'PDO database_handle, string SQL_statement [, array column_specifier] | SDODataObject',
\ 'SDO_DAS_Setting::getListIndex(': 'void  | int',
\ 'SDO_DAS_Setting::getPropertyIndex(': 'void  | int',
\ 'SDO_DAS_Setting::getPropertyName(': 'void  | string',
\ 'SDO_DAS_Setting::getValue(': 'void  | mixed',
\ 'SDO_DAS_Setting::isSet(': 'void  | bool',
\ 'SDO_DAS_XML::addTypes(': 'string xsd_file | void',
\ 'SDO_DAS_XML::createDataObject(': 'string namespace_uri, string type_name | SDO_DataObject',
\ 'SDO_DAS_XML::createDocument(': '[string document_element_name] | SDO_DAS_XML_Document',
\ 'SDO_DAS_XML::create(': '[string xsd_file] | SDO_DAS_XML',
\ 'SDO_DAS_XML_Document::getRootDataObject(': 'void  | SDO_DataObject',
\ 'SDO_DAS_XML_Document::getRootElementName(': 'void  | string',
\ 'SDO_DAS_XML_Document::getRootElementURI(': 'void  | string',
\ 'SDO_DAS_XML_Document::setEncoding(': 'string encoding | void',
\ 'SDO_DAS_XML_Document::setXMLDeclaration(': 'bool xmlDeclatation | void',
\ 'SDO_DAS_XML_Document::setXMLVersion(': 'string xmlVersion | void',
\ 'SDO_DAS_XML::loadFile(': 'string xml_file | SDO_XMLDocument',
\ 'SDO_DAS_XML::loadString(': 'string xml_string | SDO_DAS_XML_Document',
\ 'SDO_DAS_XML::saveFile(': 'SDO_XMLDocument xdoc, string xml_file [, int indent] | void',
\ 'SDO_DAS_XML::saveString(': 'SDO_XMLDocument xdoc [, int indent] | string',
\ 'SDO_DataFactory::create(': 'string type_namespace_uri, string type_name | void',
\ 'SDO_DataObject::clear(': 'void  | void',
\ 'SDO_DataObject::createDataObject(': 'mixed identifier | SDO_DataObject',
\ 'SDO_DataObject::getContainer(': 'void  | SDO_DataObject',
\ 'SDO_DataObject::getSequence(': 'void  | SDO_Sequence',
\ 'SDO_DataObject::getTypeName(': 'void  | string',
\ 'SDO_DataObject::getTypeNamespaceURI(': 'void  | string',
\ 'SDO_Exception::getCause(': 'void  | mixed',
\ 'SDO_List::insert(': 'mixed value [, int index] | void',
\ 'SDO_Model_Property::getContainingType(': 'void  | SDO_Model_Type',
\ 'SDO_Model_Property::getDefault(': 'void  | mixed',
\ 'SDO_Model_Property::getName(': 'void  | string',
\ 'SDO_Model_Property::getType(': 'void  | SDO_Model_Type',
\ 'SDO_Model_Property::isContainment(': 'void  | bool',
\ 'SDO_Model_Property::isMany(': 'void  | bool',
\ 'SDO_Model_ReflectionDataObject::__construct(': 'SDO_DataObject data_object | SDO_Model_ReflectionDataObject',
\ 'SDO_Model_ReflectionDataObject::export(': 'SDO_Model_ReflectionDataObject rdo [, bool return] | mixed',
\ 'SDO_Model_ReflectionDataObject::getContainmentProperty(': 'void  | SDO_Model_Property',
\ 'SDO_Model_ReflectionDataObject::getInstanceProperties(': 'void  | array',
\ 'SDO_Model_ReflectionDataObject::getType(': 'void  | SDO_Model_Type',
\ 'SDO_Model_Type::getBaseType(': 'void  | SDO_Model_Type',
\ 'SDO_Model_Type::getName(': 'void  | string',
\ 'SDO_Model_Type::getNamespaceURI(': 'void  | string',
\ 'SDO_Model_Type::getProperties(': 'void  | array',
\ 'SDO_Model_Type::getProperty(': 'mixed identifier | SDO_Model_Property',
\ 'SDO_Model_Type::isAbstractType(': 'void  | bool',
\ 'SDO_Model_Type::isDataType(': 'void  | bool',
\ 'SDO_Model_Type::isInstance(': 'SDO_DataObject data_object | bool',
\ 'SDO_Model_Type::isOpenType(': 'void  | bool',
\ 'SDO_Model_Type::isSequencedType(': 'void  | bool',
\ 'SDO_Sequence::getProperty(': 'int sequence_index | SDO_Model_Property',
\ 'SDO_Sequence::insert(': 'mixed value [, int sequenceIndex [, mixed propertyIdentifier]] | void',
\ 'SDO_Sequence::move(': 'int toIndex, int fromIndex | void',
\ 'sem_acquire(': 'resource sem_identifier | bool',
\ 'sem_get(': 'int key [, int max_acquire [, int perm [, int auto_release]]] | resource',
\ 'sem_release(': 'resource sem_identifier | bool',
\ 'sem_remove(': 'resource sem_identifier | bool',
\ 'serialize(': 'mixed value | string',
\ 'sesam_affected_rows(': 'string result_id | int',
\ 'sesam_commit(': 'void  | bool',
\ 'sesam_connect(': 'string catalog, string schema, string user | bool',
\ 'sesam_diagnostic(': 'void  | array',
\ 'sesam_disconnect(': 'void  | bool',
\ 'sesam_errormsg(': 'void  | string',
\ 'sesam_execimm(': 'string query | string',
\ 'sesam_fetch_array(': 'string result_id [, int whence [, int offset]] | array',
\ 'sesam_fetch_result(': 'string result_id [, int max_rows] | mixed',
\ 'sesam_fetch_row(': 'string result_id [, int whence [, int offset]] | array',
\ 'sesam_field_array(': 'string result_id | array',
\ 'sesam_field_name(': 'string result_id, int index | int',
\ 'sesam_free_result(': 'string result_id | int',
\ 'sesam_num_fields(': 'string result_id | int',
\ 'sesam_query(': 'string query [, bool scrollable] | string',
\ 'sesam_rollback(': 'void  | bool',
\ 'sesam_seek_row(': 'string result_id, int whence [, int offset] | bool',
\ 'sesam_settransaction(': 'int isolation_level, int read_only | bool',
\ 'session_cache_expire(': '[int new_cache_expire] | int',
\ 'session_cache_limiter(': '[string cache_limiter] | string',
\ 'session_decode(': 'string data | bool',
\ 'session_destroy(': 'void  | bool',
\ 'session_encode(': 'void  | string',
\ 'session_get_cookie_params(': 'void  | array',
\ 'session_id(': '[string id] | string',
\ 'session_is_registered(': 'string name | bool',
\ 'session_module_name(': '[string module] | string',
\ 'session_name(': '[string name] | string',
\ 'session_pgsql_add_error(': 'int error_level [, string error_message] | bool',
\ 'session_pgsql_get_error(': '[bool with_error_message] | array',
\ 'session_pgsql_get_field(': 'void  | string',
\ 'session_pgsql_reset(': 'void  | bool',
\ 'session_pgsql_set_field(': 'string value | bool',
\ 'session_pgsql_status(': 'void  | array',
\ 'session_regenerate_id(': '[bool delete_old_session] | bool',
\ 'session_register(': 'mixed name [, mixed ...] | bool',
\ 'session_save_path(': '[string path] | string',
\ 'session_set_cookie_params(': 'int lifetime [, string path [, string domain [, bool secure]]] | void',
\ 'session_set_save_handler(': 'callback open, callback close, callback read, callback write, callback destroy, callback gc | bool',
\ 'session_start(': 'void  | bool',
\ 'session_unregister(': 'string name | bool',
\ 'session_unset(': 'void  | void',
\ 'session_write_close(': 'void  | void',
\ 'setcookie(': 'string name [, string value [, int expire [, string path [, string domain [, bool secure]]]]] | bool',
\ 'set_error_handler(': 'callback error_handler [, int error_types] | mixed',
\ 'set_exception_handler(': 'callback exception_handler | string',
\ 'set_include_path(': 'string new_include_path | string',
\ 'setlocale(': 'int category, string locale [, string ...] | string',
\ 'set_magic_quotes_runtime(': 'int new_setting | bool',
\ 'setrawcookie(': 'string name [, string value [, int expire [, string path [, string domain [, bool secure]]]]] | bool',
\ 'set_time_limit(': 'int seconds | void',
\ 'settype(': 'mixed &#38;var, string type | bool',
\ 'sha1_file(': 'string filename [, bool raw_output] | string',
\ 'sha1(': 'string str [, bool raw_output] | string',
\ 'shell_exec(': 'string cmd | string',
\ 'shm_attach(': 'int key [, int memsize [, int perm]] | int',
\ 'shm_detach(': 'int shm_identifier | bool',
\ 'shm_get_var(': 'int shm_identifier, int variable_key | mixed',
\ 'shmop_close(': 'int shmid | void',
\ 'shmop_delete(': 'int shmid | bool',
\ 'shmop_open(': 'int key, string flags, int mode, int size | int',
\ 'shmop_read(': 'int shmid, int start, int count | string',
\ 'shmop_size(': 'int shmid | int',
\ 'shmop_write(': 'int shmid, string data, int offset | int',
\ 'shm_put_var(': 'int shm_identifier, int variable_key, mixed variable | bool',
\ 'shm_remove(': 'int shm_identifier | bool',
\ 'shm_remove_var(': 'int shm_identifier, int variable_key | bool',
\ 'shuffle(': 'array &#38;array | bool',
\ 'similar_text(': 'string first, string second [, float &#38;percent] | int',
\ 'SimpleXMLElement-&#62;asXML(': '[string filename] | mixed',
\ 'simplexml_element-&#62;attributes(': '[string data] | SimpleXMLElement',
\ 'simplexml_element-&#62;children(': '[string nsprefix] | SimpleXMLElement',
\ 'SimpleXMLElement-&#62;xpath(': 'string path | array',
\ 'simplexml_import_dom(': 'DOMNode node [, string class_name] | SimpleXMLElement',
\ 'SimpleXMLIterator::current(': 'void  | mixed',
\ 'SimpleXMLIterator::getChildren(': 'void  | object',
\ 'SimpleXMLIterator::hasChildren(': 'void  | bool',
\ 'SimpleXMLIterator::key(': 'void  | mixed',
\ 'SimpleXMLIterator::next(': 'void  | void',
\ 'SimpleXMLIterator::rewind(': 'void  | void',
\ 'SimpleXMLIterator::valid(': 'void  | bool',
\ 'simplexml_load_file(': 'string filename [, string class_name [, int options]] | object',
\ 'simplexml_load_string(': 'string data [, string class_name [, int options]] | object',
\ 'sinh(': 'float arg | float',
\ 'sin(': 'float arg | float',
\ 'sleep(': 'int seconds | int',
\ 'snmpget(': 'string hostname, string community, string object_id [, int timeout [, int retries]] | string',
\ 'snmpgetnext(': 'string host, string community, string object_id [, int timeout [, int retries]] | string',
\ 'snmp_get_quick_print(': 'void  | bool',
\ 'snmp_get_valueretrieval(': 'void  | int',
\ 'snmp_read_mib(': 'string filename | bool',
\ 'snmprealwalk(': 'string host, string community, string object_id [, int timeout [, int retries]] | array',
\ 'snmp_set_enum_print(': 'int enum_print | void',
\ 'snmpset(': 'string hostname, string community, string object_id, string type, mixed value [, int timeout [, int retries]] | bool',
\ 'snmp_set_oid_numeric_print(': 'int oid_numeric_print | void',
\ 'snmp_set_quick_print(': 'bool quick_print | void',
\ 'snmp_set_valueretrieval(': 'int method | void',
\ 'snmpwalk(': 'string hostname, string community, string object_id [, int timeout [, int retries]] | array',
\ 'snmpwalkoid(': 'string hostname, string community, string object_id [, int timeout [, int retries]] | array',
\ 'socket_accept(': 'resource socket | resource',
\ 'socket_bind(': 'resource socket, string address [, int port] | bool',
\ 'socket_clear_error(': '[resource socket] | void',
\ 'socket_close(': 'resource socket | void',
\ 'socket_connect(': 'resource socket, string address [, int port] | bool',
\ 'socket_create(': 'int domain, int type, int protocol | resource',
\ 'socket_create_listen(': 'int port [, int backlog] | resource',
\ 'socket_create_pair(': 'int domain, int type, int protocol, array &#38;fd | bool',
\ 'socket_get_option(': 'resource socket, int level, int optname | mixed',
\ 'socket_getpeername(': 'resource socket, string &#38;addr [, int &#38;port] | bool',
\ 'socket_getsockname(': 'resource socket, string &#38;addr [, int &#38;port] | bool',
\ 'socket_last_error(': '[resource socket] | int',
\ 'socket_listen(': 'resource socket [, int backlog] | bool',
\ 'socket_read(': 'resource socket, int length [, int type] | string',
\ 'socket_recvfrom(': 'resource socket, string &#38;buf, int len, int flags, string &#38;name [, int &#38;port] | int',
\ 'socket_recv(': 'resource socket, string &#38;buf, int len, int flags | int',
\ 'socket_select(': 'array &#38;read, array &#38;write, array &#38;except, int tv_sec [, int tv_usec] | int',
\ 'socket_send(': 'resource socket, string buf, int len, int flags | int',
\ 'socket_sendto(': 'resource socket, string buf, int len, int flags, string addr [, int port] | int',
\ 'socket_set_block(': 'resource socket | bool',
\ 'socket_set_nonblock(': 'resource socket | bool',
\ 'socket_set_option(': 'resource socket, int level, int optname, mixed optval | bool',
\ 'socket_shutdown(': 'resource socket [, int how] | bool',
\ 'socket_strerror(': 'int errno | string',
\ 'socket_write(': 'resource socket, string buffer [, int length] | int',
\ 'sort(': 'array &#38;array [, int sort_flags] | bool',
\ 'soundex(': 'string str | string',
\ 'spl_classes(': 'void  | array',
\ 'split(': 'string pattern, string string [, int limit] | array',
\ 'spliti(': 'string pattern, string string [, int limit] | array',
\ 'sprintf(': 'string format [, mixed args [, mixed ...]] | string',
\ 'sqlite_array_query(': 'resource dbhandle, string query [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_busy_timeout(': 'resource dbhandle, int milliseconds | void',
\ 'sqlite_changes(': 'resource dbhandle | int',
\ 'sqlite_close(': 'resource dbhandle | void',
\ 'sqlite_column(': 'resource result, mixed index_or_name [, bool decode_binary] | mixed',
\ 'sqlite_create_aggregate(': 'resource dbhandle, string function_name, callback step_func, callback finalize_func [, int num_args] | void',
\ 'sqlite_create_function(': 'resource dbhandle, string function_name, callback callback [, int num_args] | void',
\ 'sqlite_current(': 'resource result [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_error_string(': 'int error_code | string',
\ 'sqlite_escape_string(': 'string item | string',
\ 'sqlite_exec(': 'resource dbhandle, string query [, string &#38;error_msg] | bool',
\ 'sqlite_factory(': 'string filename [, int mode [, string &#38;error_message]] | SQLiteDatabase',
\ 'sqlite_fetch_all(': 'resource result [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_fetch_array(': 'resource result [, int result_type [, bool decode_binary]] | array',
\ 'sqlite_fetch_column_types(': 'string table_name, resource dbhandle [, int result_type] | array',
\ 'sqlite_fetch_object(': 'resource result [, string class_name [, array ctor_params [, bool decode_binary]]] | object',
\ 'sqlite_fetch_single(': 'resource result [, bool decode_binary] | string',
\ 'sqlite_field_name(': 'resource result, int field_index | string',
\ 'sqlite_has_more(': 'resource result | bool',
\ 'sqlite_has_prev(': 'resource result | bool',
\ 'sqlite_key(': 'resource result | int',
\ 'sqlite_last_error(': 'resource dbhandle | int',
\ 'sqlite_last_insert_rowid(': 'resource dbhandle | int',
\ 'sqlite_libencoding(': 'void  | string',
\ 'sqlite_libversion(': 'void  | string',
\ 'sqlite_next(': 'resource result | bool',
\ 'sqlite_num_fields(': 'resource result | int',
\ 'sqlite_num_rows(': 'resource result | int',
\ 'sqlite_open(': 'string filename [, int mode [, string &#38;error_message]] | resource',
\ 'sqlite_popen(': 'string filename [, int mode [, string &#38;error_message]] | resource',
\ 'sqlite_prev(': 'resource result | bool',
\ 'sqlite_query(': 'resource dbhandle, string query [, int result_type [, string &#38;error_msg]] | resource',
\ 'sqlite_rewind(': 'resource result | bool',
\ 'sqlite_seek(': 'resource result, int rownum | bool',
\ 'sqlite_single_query(': 'resource db, string query [, bool first_row_only [, bool decode_binary]] | array',
\ 'sqlite_udf_decode_binary(': 'string data | string',
\ 'sqlite_udf_encode_binary(': 'string data | string',
\ 'sqlite_unbuffered_query(': 'resource dbhandle, string query [, int result_type [, string &#38;error_msg]] | resource',
\ 'sqlite_valid(': 'resource result | bool',
\ 'sql_regcase(': 'string string | string',
\ 'sqrt(': 'float arg | float',
\ 'srand(': '[int seed] | void',
\ 'sscanf(': 'string str, string format [, mixed &#38;...] | mixed',
\ 'ssh2_auth_hostbased_file(': 'resource session, string username, string hostname, string pubkeyfile, string privkeyfile [, string passphrase [, string local_username]] | bool',
\ 'ssh2_auth_none(': 'resource session, string username | mixed',
\ 'ssh2_auth_password(': 'resource session, string username, string password | bool',
\ 'ssh2_auth_pubkey_file(': 'resource session, string username, string pubkeyfile, string privkeyfile [, string passphrase] | bool',
\ 'ssh2_connect(': 'string host [, int port [, array methods [, array callbacks]]] | resource',
\ 'ssh2_exec(': 'resource session, string command [, string pty [, array env [, int width [, int height [, int width_height_type]]]]] | resource',
\ 'ssh2_fetch_stream(': 'resource channel, int streamid | resource',
\ 'ssh2_fingerprint(': 'resource session [, int flags] | string',
\ 'ssh2_methods_negotiated(': 'resource session | array',
\ 'ssh2_publickey_add(': 'resource pkey, string algoname, string blob [, bool overwrite [, array attributes]] | bool',
\ 'ssh2_publickey_init(': 'resource session | resource',
\ 'ssh2_publickey_list(': 'resource pkey | array',
\ 'ssh2_publickey_remove(': 'resource pkey, string algoname, string blob | bool',
\ 'ssh2_scp_recv(': 'resource session, string remote_file, string local_file | bool',
\ 'ssh2_scp_send(': 'resource session, string local_file, string remote_file [, int create_mode] | bool',
\ 'ssh2_sftp(': 'resource session | resource',
\ 'ssh2_sftp_lstat(': 'resource sftp, string path | array',
\ 'ssh2_sftp_mkdir(': 'resource sftp, string dirname [, int mode [, bool recursive]] | bool',
\ 'ssh2_sftp_readlink(': 'resource sftp, string link | string',
\ 'ssh2_sftp_realpath(': 'resource sftp, string filename | string',
\ 'ssh2_sftp_rename(': 'resource sftp, string from, string to | bool',
\ 'ssh2_sftp_rmdir(': 'resource sftp, string dirname | bool',
\ 'ssh2_sftp_stat(': 'resource sftp, string path | array',
\ 'ssh2_sftp_symlink(': 'resource sftp, string target, string link | bool',
\ 'ssh2_sftp_unlink(': 'resource sftp, string filename | bool',
\ 'ssh2_shell(': 'resource session [, string term_type [, array env [, int width [, int height [, int width_height_type]]]]] | resource',
\ 'ssh2_tunnel(': 'resource session, string host, int port | resource',
\ 'stat(': 'string filename | array',
\ 'stats_absolute_deviation(': 'array a | float',
\ 'stats_cdf_beta(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_binomial(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_cauchy(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_chisquare(': 'float par1, float par2, int which | float',
\ 'stats_cdf_exponential(': 'float par1, float par2, int which | float',
\ 'stats_cdf_f(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_gamma(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_laplace(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_logistic(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_negative_binomial(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_noncentral_chisquare(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_noncentral_f(': 'float par1, float par2, float par3, float par4, int which | float',
\ 'stats_cdf_poisson(': 'float par1, float par2, int which | float',
\ 'stats_cdf_t(': 'float par1, float par2, int which | float',
\ 'stats_cdf_uniform(': 'float par1, float par2, float par3, int which | float',
\ 'stats_cdf_weibull(': 'float par1, float par2, float par3, int which | float',
\ 'stats_covariance(': 'array a, array b | float',
\ 'stats_dens_beta(': 'float x, float a, float b | float',
\ 'stats_dens_cauchy(': 'float x, float ave, float stdev | float',
\ 'stats_dens_chisquare(': 'float x, float dfr | float',
\ 'stats_dens_exponential(': 'float x, float scale | float',
\ 'stats_dens_f(': 'float x, float dfr1, float dfr2 | float',
\ 'stats_dens_gamma(': 'float x, float shape, float scale | float',
\ 'stats_dens_laplace(': 'float x, float ave, float stdev | float',
\ 'stats_dens_logistic(': 'float x, float ave, float stdev | float',
\ 'stats_dens_negative_binomial(': 'float x, float n, float pi | float',
\ 'stats_dens_normal(': 'float x, float ave, float stdev | float',
\ 'stats_dens_pmf_binomial(': 'float x, float n, float pi | float',
\ 'stats_dens_pmf_hypergeometric(': 'float n1, float n2, float N1, float N2 | float',
\ 'stats_dens_pmf_poisson(': 'float x, float lb | float',
\ 'stats_dens_t(': 'float x, float dfr | float',
\ 'stats_dens_weibull(': 'float x, float a, float b | float',
\ 'stats_den_uniform(': 'float x, float a, float b | float',
\ 'stats_harmonic_mean(': 'array a | number',
\ 'stats_kurtosis(': 'array a | float',
\ 'stats_rand_gen_beta(': 'float a, float b | float',
\ 'stats_rand_gen_chisquare(': 'float df | float',
\ 'stats_rand_gen_exponential(': 'float av | float',
\ 'stats_rand_gen_f(': 'float dfn, float dfd | float',
\ 'stats_rand_gen_funiform(': 'float low, float high | float',
\ 'stats_rand_gen_gamma(': 'float a, float r | float',
\ 'stats_rand_gen_ibinomial(': 'int n, float pp | int',
\ 'stats_rand_gen_ibinomial_negative(': 'int n, float p | int',
\ 'stats_rand_gen_int(': 'void  | int',
\ 'stats_rand_gen_ipoisson(': 'float mu | int',
\ 'stats_rand_gen_iuniform(': 'int low, int high | int',
\ 'stats_rand_gen_noncenral_chisquare(': 'float df, float xnonc | float',
\ 'stats_rand_gen_noncentral_f(': 'float dfn, float dfd, float xnonc | float',
\ 'stats_rand_gen_noncentral_t(': 'float df, float xnonc | float',
\ 'stats_rand_gen_normal(': 'float av, float sd | float',
\ 'stats_rand_gen_t(': 'float df | float',
\ 'stats_rand_get_seeds(': 'void  | array',
\ 'stats_rand_phrase_to_seeds(': 'string phrase | array',
\ 'stats_rand_ranf(': 'void  | float',
\ 'stats_rand_setall(': 'int iseed1, int iseed2 | void',
\ 'stats_skew(': 'array a | float',
\ 'stats_standard_deviation(': 'array a [, bool sample] | float',
\ 'stats_stat_binomial_coef(': 'int x, int n | float',
\ 'stats_stat_correlation(': 'array arr1, array arr2 | float',
\ 'stats_stat_gennch(': 'int n | float',
\ 'stats_stat_independent_t(': 'array arr1, array arr2 | float',
\ 'stats_stat_innerproduct(': 'array arr1, array arr2 | float',
\ 'stats_stat_noncentral_t(': 'float par1, float par2, float par3, int which | float',
\ 'stats_stat_paired_t(': 'array arr1, array arr2 | float',
\ 'stats_stat_percentile(': 'float df, float xnonc | float',
\ 'stats_stat_powersum(': 'array arr, float power | float',
\ 'stats_variance(': 'array a [, bool sample] | float',
\ 'strcasecmp(': 'string str1, string str2 | int',
\ 'strcmp(': 'string str1, string str2 | int',
\ 'strcoll(': 'string str1, string str2 | int',
\ 'strcspn(': 'string str1, string str2 [, int start [, int length]] | int',
\ 'stream_bucket_append(': 'resource brigade, resource bucket | void',
\ 'stream_bucket_make_writeable(': 'resource brigade | object',
\ 'stream_bucket_new(': 'resource stream, string buffer | object',
\ 'stream_bucket_prepend(': 'resource brigade, resource bucket | void',
\ 'stream_context_create(': '[array options] | resource',
\ 'stream_context_get_default(': '[array options] | resource',
\ 'stream_context_get_options(': 'resource stream_or_context | array',
\ 'stream_context_set_option(': 'resource stream_or_context, string wrapper, string option, mixed value | bool',
\ 'stream_context_set_params(': 'resource stream_or_context, array params | bool',
\ 'stream_copy_to_stream(': 'resource source, resource dest [, int maxlength [, int offset]] | int',
\ 'stream_filter_append(': 'resource stream, string filtername [, int read_write [, mixed params]] | resource',
\ 'stream_filter_prepend(': 'resource stream, string filtername [, int read_write [, mixed params]] | resource',
\ 'stream_filter_register(': 'string filtername, string classname | bool',
\ 'stream_filter_remove(': 'resource stream_filter | bool',
\ 'stream_get_contents(': 'resource handle [, int maxlength [, int offset]] | string',
\ 'stream_get_filters(': 'void  | array',
\ 'stream_get_line(': 'resource handle, int length [, string ending] | string',
\ 'stream_get_meta_data(': 'resource stream | array',
\ 'stream_get_transports(': 'void  | array',
\ 'stream_get_wrappers(': 'void  | array',
\ 'stream_select(': 'array &#38;read, array &#38;write, array &#38;except, int tv_sec [, int tv_usec] | int',
\ 'stream_set_blocking(': 'resource stream, int mode | bool',
\ 'stream_set_timeout(': 'resource stream, int seconds [, int microseconds] | bool',
\ 'stream_set_write_buffer(': 'resource stream, int buffer | int',
\ 'stream_socket_accept(': 'resource server_socket [, float timeout [, string &#38;peername]] | resource',
\ 'stream_socket_client(': 'string remote_socket [, int &#38;errno [, string &#38;errstr [, float timeout [, int flags [, resource context]]]]] | resource',
\ 'stream_socket_enable_crypto(': 'resource stream, bool enable [, int crypto_type [, resource session_stream]] | mixed',
\ 'stream_socket_get_name(': 'resource handle, bool want_peer | string',
\ 'stream_socket_pair(': 'int domain, int type, int protocol | array',
\ 'stream_socket_recvfrom(': 'resource socket, int length [, int flags [, string &#38;address]] | string',
\ 'stream_socket_sendto(': 'resource socket, string data [, int flags [, string address]] | int',
\ 'stream_socket_server(': 'string local_socket [, int &#38;errno [, string &#38;errstr [, int flags [, resource context]]]] | resource',
\ 'stream_wrapper_register(': 'string protocol, string classname | bool',
\ 'stream_wrapper_restore(': 'string protocol | bool',
\ 'stream_wrapper_unregister(': 'string protocol | bool',
\ 'strftime(': 'string format [, int timestamp] | string',
\ 'stripcslashes(': 'string str | string',
\ 'stripos(': 'string haystack, string needle [, int offset] | int',
\ 'stripslashes(': 'string str | string',
\ 'strip_tags(': 'string str [, string allowable_tags] | string',
\ 'str_ireplace(': 'mixed search, mixed replace, mixed subject [, int &#38;count] | mixed',
\ 'stristr(': 'string haystack, string needle | string',
\ 'strlen(': 'string string | int',
\ 'strnatcasecmp(': 'string str1, string str2 | int',
\ 'strnatcmp(': 'string str1, string str2 | int',
\ 'strncasecmp(': 'string str1, string str2, int len | int',
\ 'strncmp(': 'string str1, string str2, int len | int',
\ 'str_pad(': 'string input, int pad_length [, string pad_string [, int pad_type]] | string',
\ 'strpbrk(': 'string haystack, string char_list | string',
\ 'strpos(': 'string haystack, mixed needle [, int offset] | int',
\ 'strptime(': 'string date, string format | array',
\ 'strrchr(': 'string haystack, string needle | string',
\ 'str_repeat(': 'string input, int multiplier | string',
\ 'str_replace(': 'mixed search, mixed replace, mixed subject [, int &#38;count] | mixed',
\ 'strrev(': 'string string | string',
\ 'strripos(': 'string haystack, string needle [, int offset] | int',
\ 'str_rot13(': 'string str | string',
\ 'strrpos(': 'string haystack, string needle [, int offset] | int',
\ 'str_shuffle(': 'string str | string',
\ 'str_split(': 'string string [, int split_length] | array',
\ 'strspn(': 'string str1, string str2 [, int start [, int length]] | int',
\ 'strstr(': 'string haystack, string needle | string',
\ 'strtok(': 'string str, string token | string',
\ 'strtolower(': 'string str | string',
\ 'strtotime(': 'string time [, int now] | int',
\ 'strtoupper(': 'string string | string',
\ 'strtr(': 'string str, string from, string to | string',
\ 'strval(': 'mixed var | string',
\ 'str_word_count(': 'string string [, int format [, string charlist]] | mixed',
\ 'substr_compare(': 'string main_str, string str, int offset [, int length [, bool case_insensitivity]] | int',
\ 'substr_count(': 'string haystack, string needle [, int offset [, int length]] | int',
\ 'substr(': 'string string, int start [, int length] | string',
\ 'substr_replace(': 'mixed string, string replacement, int start [, int length] | mixed',
\ 'swf_actiongeturl(': 'string url, string target | void',
\ 'swf_actiongotoframe(': 'int framenumber | void',
\ 'swf_actiongotolabel(': 'string label | void',
\ 'swfaction(': 'string script | SWFAction',
\ 'swf_actionnextframe(': 'void  | void',
\ 'swf_actionplay(': 'void  | void',
\ 'swf_actionprevframe(': 'void  | void',
\ 'swf_actionsettarget(': 'string target | void',
\ 'swf_actionstop(': 'void  | void',
\ 'swf_actiontogglequality(': 'void  | void',
\ 'swf_actionwaitforframe(': 'int framenumber, int skipcount | void',
\ 'swf_addbuttonrecord(': 'int states, int shapeid, int depth | void',
\ 'swf_addcolor(': 'float r, float g, float b, float a | void',
\ 'swfbitmap-&#62;getheight(': 'void  | float',
\ 'swfbitmap-&#62;getwidth(': 'void  | float',
\ 'swfbitmap(': 'mixed file [, mixed alphafile] | SWFBitmap',
\ 'swfbutton-&#62;addaction(': 'resource action, int flags | void',
\ 'SWFButton::addASound(': 'SWFSound sound, int flags | SWFSoundInstance',
\ 'swfbutton-&#62;addshape(': 'resource shape, int flags | void',
\ 'swfbutton(': 'void  | SWFButton',
\ 'swfbutton-&#62;setaction(': 'resource action | void',
\ 'swfbutton-&#62;setdown(': 'resource shape | void',
\ 'swfbutton-&#62;sethit(': 'resource shape | void',
\ 'SWFButton::setMenu(': 'int flag | void',
\ 'swfbutton-&#62;setover(': 'resource shape | void',
\ 'swfbutton-&#62;setup(': 'resource shape | void',
\ 'swf_closefile(': '[int return_file] | void',
\ 'swf_definebitmap(': 'int objid, string image_name | void',
\ 'swf_definefont(': 'int fontid, string fontname | void',
\ 'swf_defineline(': 'int objid, float x1, float y1, float x2, float y2, float width | void',
\ 'swf_definepoly(': 'int objid, array coords, int npoints, float width | void',
\ 'swf_definerect(': 'int objid, float x1, float y1, float x2, float y2, float width | void',
\ 'swf_definetext(': 'int objid, string str, int docenter | void',
\ 'SWFDisplayItem::addAction(': 'SWFAction action, int flags | void',
\ 'swfdisplayitem-&#62;addcolor(': 'int red, int green, int blue [, int a] | void',
\ 'SWFDisplayItem::endMask(': 'void  | void',
\ 'SWFDisplayItem::getRot(': 'void  | float',
\ 'SWFDisplayItem::getX(': 'void  | float',
\ 'SWFDisplayItem::getXScale(': 'void  | float',
\ 'SWFDisplayItem::getXSkew(': 'void  | float',
\ 'SWFDisplayItem::getY(': 'void  | float',
\ 'SWFDisplayItem::getYScale(': 'void  | float',
\ 'SWFDisplayItem::getYSkew(': 'void  | float',
\ 'swfdisplayitem-&#62;move(': 'int dx, int dy | void',
\ 'swfdisplayitem-&#62;moveto(': 'int x, int y | void',
\ 'swfdisplayitem-&#62;multcolor(': 'int red, int green, int blue [, int a] | void',
\ 'swfdisplayitem-&#62;remove(': 'void  | void',
\ 'swfdisplayitem-&#62;rotate(': 'float ddegrees | void',
\ 'swfdisplayitem-&#62;rotateto(': 'float degrees | void',
\ 'swfdisplayitem-&#62;scale(': 'int dx, int dy | void',
\ 'swfdisplayitem-&#62;scaleto(': 'int x [, int y] | void',
\ 'swfdisplayitem-&#62;setdepth(': 'float depth | void',
\ 'SWFDisplayItem::setMaskLevel(': 'int level | void',
\ 'SWFDisplayItem::setMatrix(': 'float a, float b, float c, float d, float x, float y | void',
\ 'swfdisplayitem-&#62;setname(': 'string name | void',
\ 'swfdisplayitem-&#62;setratio(': 'float ratio | void',
\ 'swfdisplayitem-&#62;skewx(': 'float ddegrees | void',
\ 'swfdisplayitem-&#62;skewxto(': 'float degrees | void',
\ 'swfdisplayitem-&#62;skewy(': 'float ddegrees | void',
\ 'swfdisplayitem-&#62;skewyto(': 'float degrees | void',
\ 'swf_endbutton(': 'void  | void',
\ 'swf_enddoaction(': 'void  | void',
\ 'swf_endshape(': 'void  | void',
\ 'swf_endsymbol(': 'void  | void',
\ 'swffill(': 'void  | SWFFill',
\ 'swffill-&#62;moveto(': 'int x, int y | void',
\ 'swffill-&#62;rotateto(': 'float degrees | void',
\ 'swffill-&#62;scaleto(': 'int x [, int y] | void',
\ 'swffill-&#62;skewxto(': 'float x | void',
\ 'swffill-&#62;skewyto(': 'float y | void',
\ 'SWFFontChar::addChars(': 'string char | void',
\ 'SWFFontChar::addUTF8Chars(': 'string char | void',
\ 'SWFFont::getAscent(': 'void  | float',
\ 'SWFFont::getDescent(': 'void  | float',
\ 'SWFFont::getLeading(': 'void  | float',
\ 'SWFFont::getShape(': 'int code | string',
\ 'SWFFont::getUTF8Width(': 'string string | float',
\ 'swffont-&#62;getwidth(': 'string string | float',
\ 'swffont(': 'string filename | SWFFont',
\ 'swf_fontsize(': 'float size | void',
\ 'swf_fontslant(': 'float slant | void',
\ 'swf_fonttracking(': 'float tracking | void',
\ 'swf_getbitmapinfo(': 'int bitmapid | array',
\ 'swf_getfontinfo(': 'void  | array',
\ 'swf_getframe(': 'void  | int',
\ 'swfgradient-&#62;addentry(': 'float ratio, int red, int green, int blue [, int a] | void',
\ 'swfgradient(': 'void  | SWFGradient',
\ 'swf_labelframe(': 'string name | void',
\ 'swf_lookat(': 'float view_x, float view_y, float view_z, float reference_x, float reference_y, float reference_z, float twist | void',
\ 'swf_modifyobject(': 'int depth, int how | void',
\ 'swfmorph-&#62;getshape1(': 'void  | mixed',
\ 'swfmorph-&#62;getshape2(': 'void  | mixed',
\ 'swfmorph(': 'void  | SWFMorph',
\ 'SWFMovie::addExport(': 'SWFCharacter char, string name | void',
\ 'SWFMovie::addFont(': 'SWFFont font | SWFFontChar',
\ 'swfmovie-&#62;add(': 'resource instance | void',
\ 'swfmovie(': 'void  | SWFMovie',
\ 'SWFMovie::importChar(': 'string libswf, string name | SWFSprite',
\ 'SWFMovie::importFont(': 'string libswf, string name | SWFFontChar',
\ 'SWFMovie::labelFrame(': 'string label | void',
\ 'swfmovie-&#62;nextframe(': 'void  | void',
\ 'swfmovie-&#62;output(': '[int compression] | int',
\ 'swfmovie-&#62;remove(': 'resource instance | void',
\ 'swfmovie-&#62;save(': 'string filename [, int compression] | int',
\ 'SWFMovie::saveToFile(': 'stream x [, int compression] | int',
\ 'swfmovie-&#62;setbackground(': 'int red, int green, int blue | void',
\ 'swfmovie-&#62;setdimension(': 'int width, int height | void',
\ 'swfmovie-&#62;setframes(': 'string numberofframes | void',
\ 'swfmovie-&#62;setrate(': 'int rate | void',
\ 'SWFMovie::startSound(': 'SWFSound sound | SWFSoundInstance',
\ 'SWFMovie::stopSound(': 'SWFSound sound | void',
\ 'swfmovie-&#62;streammp3(': 'mixed mp3File | void',
\ 'SWFMovie::writeExports(': 'void  | void',
\ 'swf_mulcolor(': 'float r, float g, float b, float a | void',
\ 'swf_nextid(': 'void  | int',
\ 'swf_oncondition(': 'int transition | void',
\ 'swf_openfile(': 'string filename, float width, float height, float framerate, float r, float g, float b | void',
\ 'swf_ortho2(': 'float xmin, float xmax, float ymin, float ymax | void',
\ 'swf_ortho(': 'float xmin, float xmax, float ymin, float ymax, float zmin, float zmax | void',
\ 'swf_perspective(': 'float fovy, float aspect, float near, float far | void',
\ 'swf_placeobject(': 'int objid, int depth | void',
\ 'swf_polarview(': 'float dist, float azimuth, float incidence, float twist | void',
\ 'swf_popmatrix(': 'void  | void',
\ 'swf_posround(': 'int round | void',
\ 'SWFPrebuiltClip(': '[string file] | SWFPrebuiltClip',
\ 'swf_pushmatrix(': 'void  | void',
\ 'swf_removeobject(': 'int depth | void',
\ 'swf_rotate(': 'float angle, string axis | void',
\ 'swf_scale(': 'float x, float y, float z | void',
\ 'swf_setfont(': 'int fontid | void',
\ 'swf_setframe(': 'int framenumber | void',
\ 'SWFShape-&#62;addFill(': 'int red, int green, int blue [, int a] | SWFFill',
\ 'swf_shapearc(': 'float x, float y, float r, float ang1, float ang2 | void',
\ 'swf_shapecurveto3(': 'float x1, float y1, float x2, float y2, float x3, float y3 | void',
\ 'swf_shapecurveto(': 'float x1, float y1, float x2, float y2 | void',
\ 'SWFShape::drawArc(': 'float r, float startAngle, float endAngle | void',
\ 'SWFShape::drawCircle(': 'float r | void',
\ 'SWFShape::drawCubic(': 'float bx, float by, float cx, float cy, float dx, float dy | int',
\ 'SWFShape::drawCubicTo(': 'float bx, float by, float cx, float cy, float dx, float dy | int',
\ 'swfshape-&#62;drawcurve(': 'int controldx, int controldy, int anchordx, int anchordy [, int targetdx, int targetdy] | int',
\ 'swfshape-&#62;drawcurveto(': 'int controlx, int controly, int anchorx, int anchory [, int targetx, int targety] | int',
\ 'SWFShape::drawGlyph(': 'SWFFont font, string character [, int size] | void',
\ 'swfshape-&#62;drawline(': 'int dx, int dy | void',
\ 'swfshape-&#62;drawlineto(': 'int x, int y | void',
\ 'swf_shapefillbitmapclip(': 'int bitmapid | void',
\ 'swf_shapefillbitmaptile(': 'int bitmapid | void',
\ 'swf_shapefilloff(': 'void  | void',
\ 'swf_shapefillsolid(': 'float r, float g, float b, float a | void',
\ 'swfshape(': 'void  | SWFShape',
\ 'swf_shapelinesolid(': 'float r, float g, float b, float a, float width | void',
\ 'swf_shapelineto(': 'float x, float y | void',
\ 'swfshape-&#62;movepen(': 'int dx, int dy | void',
\ 'swfshape-&#62;movepento(': 'int x, int y | void',
\ 'swf_shapemoveto(': 'float x, float y | void',
\ 'swfshape-&#62;setleftfill(': 'swfgradient fill | void',
\ 'swfshape-&#62;setline(': 'swfshape shape | void',
\ 'swfshape-&#62;setrightfill(': 'swfgradient fill | void',
\ 'swf_showframe(': 'void  | void',
\ 'SWFSound(': 'string filename, int flags | SWFSound',
\ 'SWFSoundInstance::loopCount(': 'int point | void',
\ 'SWFSoundInstance::loopInPoint(': 'int point | void',
\ 'SWFSoundInstance::loopOutPoint(': 'int point | void',
\ 'SWFSoundInstance::noMultiple(': 'void  | void',
\ 'swfsprite-&#62;add(': 'resource object | void',
\ 'swfsprite(': 'void  | SWFSprite',
\ 'SWFSprite::labelFrame(': 'string label | void',
\ 'swfsprite-&#62;nextframe(': 'void  | void',
\ 'swfsprite-&#62;remove(': 'resource object | void',
\ 'swfsprite-&#62;setframes(': 'int numberofframes | void',
\ 'SWFSprite::startSound(': 'SWFSound sound | SWFSoundInstance',
\ 'SWFSprite::stopSound(': 'SWFSound sound | void',
\ 'swf_startbutton(': 'int objid, int type | void',
\ 'swf_startdoaction(': 'void  | void',
\ 'swf_startshape(': 'int objid | void',
\ 'swf_startsymbol(': 'int objid | void',
\ 'swftext-&#62;addstring(': 'string string | void',
\ 'SWFText::addUTF8String(': 'string text | void',
\ 'SWFTextField::addChars(': 'string chars | void',
\ 'swftextfield-&#62;addstring(': 'string string | void',
\ 'swftextfield-&#62;align(': 'int alignement | void',
\ 'swftextfield(': '[int flags] | SWFTextField',
\ 'swftextfield-&#62;setbounds(': 'int width, int height | void',
\ 'swftextfield-&#62;setcolor(': 'int red, int green, int blue [, int a] | void',
\ 'swftextfield-&#62;setfont(': 'string font | void',
\ 'swftextfield-&#62;setheight(': 'int height | void',
\ 'swftextfield-&#62;setindentation(': 'int width | void',
\ 'swftextfield-&#62;setleftmargin(': 'int width | void',
\ 'swftextfield-&#62;setlinespacing(': 'int height | void',
\ 'swftextfield-&#62;setmargins(': 'int left, int right | void',
\ 'swftextfield-&#62;setname(': 'string name | void',
\ 'SWFTextField::setPadding(': 'float padding | void',
\ 'swftextfield-&#62;setrightmargin(': 'int width | void',
\ 'SWFText::getAscent(': 'void  | float',
\ 'SWFText::getDescent(': 'void  | float',
\ 'SWFText::getLeading(': 'void  | float',
\ 'SWFText::getUTF8Width(': 'string string | float',
\ 'swftext-&#62;getwidth(': 'string string | float',
\ 'swftext(': 'void  | SWFText',
\ 'swftext-&#62;moveto(': 'int x, int y | void',
\ 'swftext-&#62;setcolor(': 'int red, int green, int blue [, int a] | void',
\ 'swftext-&#62;setfont(': 'string font | void',
\ 'swftext-&#62;setheight(': 'int height | void',
\ 'swftext-&#62;setspacing(': 'float spacing | void',
\ 'swf_textwidth(': 'string str | float',
\ 'swf_translate(': 'float x, float y, float z | void',
\ 'SWFVideoStream::getNumFrames(': 'void  | int',
\ 'SWFVideoStream(': '[string file] | SWFVideoStream',
\ 'SWFVideoStream::setDimension(': 'int x, int y | void',
\ 'swf_viewport(': 'float xmin, float xmax, float ymin, float ymax | void',
\ 'sybase_affected_rows(': '[resource link_identifier] | int',
\ 'sybase_close(': '[resource link_identifier] | bool',
\ 'sybase_connect(': '[string servername [, string username [, string password [, string charset [, string appname]]]]] | resource',
\ 'sybase_data_seek(': 'resource result_identifier, int row_number | bool',
\ 'sybase_deadlock_retry_count(': 'int retry_count | void',
\ 'sybase_fetch_array(': 'resource result | array',
\ 'sybase_fetch_assoc(': 'resource result | array',
\ 'sybase_fetch_field(': 'resource result [, int field_offset] | object',
\ 'sybase_fetch_object(': 'resource result [, mixed object] | object',
\ 'sybase_fetch_row(': 'resource result | array',
\ 'sybase_field_seek(': 'resource result, int field_offset | bool',
\ 'sybase_free_result(': 'resource result | bool',
\ 'sybase_get_last_message(': 'void  | string',
\ 'sybase_min_client_severity(': 'int severity | void',
\ 'sybase_min_error_severity(': 'int severity | void',
\ 'sybase_min_message_severity(': 'int severity | void',
\ 'sybase_min_server_severity(': 'int severity | void',
\ 'sybase_num_fields(': 'resource result | int',
\ 'sybase_num_rows(': 'resource result | int',
\ 'sybase_pconnect(': '[string servername [, string username [, string password [, string charset [, string appname]]]]] | resource',
\ 'sybase_query(': 'string query [, resource link_identifier] | mixed',
\ 'sybase_result(': 'resource result, int row, mixed field | string',
\ 'sybase_select_db(': 'string database_name [, resource link_identifier] | bool',
\ 'sybase_set_message_handler(': 'callback handler [, resource connection] | bool',
\ 'sybase_unbuffered_query(': 'string query, resource link_identifier [, bool store_result] | resource',
\ 'symlink(': 'string target, string link | bool',
\ 'sys_getloadavg(': 'void  | array',
\ 'syslog(': 'int priority, string message | bool',
\ 'system(': 'string command [, int &#38;return_var] | string',
\ 'tanh(': 'float arg | float',
\ 'tan(': 'float arg | float',
\ 'tcpwrap_check(': 'string daemon, string address [, string user [, bool nodns]] | bool',
\ 'tempnam(': 'string dir, string prefix | string',
\ 'textdomain(': 'string text_domain | string',
\ 'tidy_access_count(': 'tidy object | int',
\ 'tidy_config_count(': 'tidy object | int',
\ 'tidy::__construct(': '[string filename [, mixed config [, string encoding [, bool use_include_path]]]] | tidy',
\ 'tidy_error_count(': 'tidy object | int',
\ 'tidy_get_output(': 'tidy object | string',
\ 'tidy_load_config(': 'string filename, string encoding | void',
\ 'tidy_node-&#62;get_attr(': 'int attrib_id | tidy_attr',
\ 'tidy_node-&#62;get_nodes(': 'int node_id | array',
\ 'tidyNode-&#62;hasChildren(': 'void  | bool',
\ 'tidyNode-&#62;hasSiblings(': 'void  | bool',
\ 'tidyNode-&#62;isAsp(': 'void  | bool',
\ 'tidyNode-&#62;isComment(': 'void  | bool',
\ 'tidyNode-&#62;isHtml(': 'void  | bool',
\ 'tidyNode-&#62;isJste(': 'void  | bool',
\ 'tidyNode-&#62;isPhp(': 'void  | bool',
\ 'tidyNode-&#62;isText(': 'void  | bool',
\ 'tidy_node-&#62;next(': 'void  | tidy_node',
\ 'tidy_node-&#62;prev(': 'void  | tidy_node',
\ 'tidy_repair_file(': 'string filename [, mixed config [, string encoding [, bool use_include_path]]] | string',
\ 'tidy_repair_string(': 'string data [, mixed config [, string encoding]] | string',
\ 'tidy_reset_config(': 'void  | bool',
\ 'tidy_save_config(': 'string filename | bool',
\ 'tidy_set_encoding(': 'string encoding | bool',
\ 'tidy_setopt(': 'string option, mixed value | bool',
\ 'tidy_warning_count(': 'tidy object | int',
\ 'time(': 'void  | int',
\ 'time_nanosleep(': 'int seconds, int nanoseconds | mixed',
\ 'time_sleep_until(': 'float timestamp | bool',
\ 'tmpfile(': 'void  | resource',
\ 'token_get_all(': 'string source | array',
\ 'token_name(': 'int token | string',
\ 'touch(': 'string filename [, int time [, int atime]] | bool',
\ 'trigger_error(': 'string error_msg [, int error_type] | bool',
\ 'trim(': 'string str [, string charlist] | string',
\ 'uasort(': 'array &#38;array, callback cmp_function | bool',
\ 'ucfirst(': 'string str | string',
\ 'ucwords(': 'string str | string',
\ 'udm_add_search_limit(': 'resource agent, int var, string val | bool',
\ 'udm_alloc_agent_array(': 'array databases | resource',
\ 'udm_alloc_agent(': 'string dbaddr [, string dbmode] | resource',
\ 'udm_api_version(': 'void  | int',
\ 'udm_cat_list(': 'resource agent, string category | array',
\ 'udm_cat_path(': 'resource agent, string category | array',
\ 'udm_check_charset(': 'resource agent, string charset | bool',
\ 'udm_check_stored(': 'resource agent, int link, string doc_id | int',
\ 'udm_clear_search_limits(': 'resource agent | bool',
\ 'udm_close_stored(': 'resource agent, int link | int',
\ 'udm_crc32(': 'resource agent, string str | int',
\ 'udm_errno(': 'resource agent | int',
\ 'udm_error(': 'resource agent | string',
\ 'udm_find(': 'resource agent, string query | resource',
\ 'udm_free_agent(': 'resource agent | int',
\ 'udm_free_ispell_data(': 'int agent | bool',
\ 'udm_free_res(': 'resource res | bool',
\ 'udm_get_doc_count(': 'resource agent | int',
\ 'udm_get_res_field(': 'resource res, int row, int field | string',
\ 'udm_get_res_param(': 'resource res, int param | string',
\ 'udm_hash32(': 'resource agent, string str | int',
\ 'udm_load_ispell_data(': 'resource agent, int var, string val1, string val2, int flag | bool',
\ 'udm_open_stored(': 'resource agent, string storedaddr | int',
\ 'udm_set_agent_param(': 'resource agent, int var, string val | bool',
\ 'uksort(': 'array &#38;array, callback cmp_function | bool',
\ 'umask(': '[int mask] | int',
\ 'unicode_encode(': 'unicode input, string encoding | string',
\ 'unicode_semantics(': 'void  | bool',
\ 'uniqid(': '[string prefix [, bool more_entropy]] | string',
\ 'unixtojd(': '[int timestamp] | int',
\ 'unlink(': 'string filename [, resource context] | bool',
\ 'unpack(': 'string format, string data | array',
\ 'unregister_tick_function(': 'string function_name | void',
\ 'unserialize(': 'string str | mixed',
\ 'unset(': 'mixed var [, mixed var [, mixed ...]] | void',
\ 'urldecode(': 'string str | string',
\ 'urlencode(': 'string str | string',
\ 'use_soap_error_handler(': '[bool handler] | bool',
\ 'usleep(': 'int micro_seconds | void',
\ 'usort(': 'array &#38;array, callback cmp_function | bool',
\ 'utf8_decode(': 'string data | string',
\ 'utf8_encode(': 'string data | string',
\ 'var_dump(': 'mixed expression [, mixed expression [, ...]] | void',
\ 'var_export(': 'mixed expression [, bool return] | mixed',
\ 'variant_abs(': 'mixed val | mixed',
\ 'variant_add(': 'mixed left, mixed right | mixed',
\ 'variant_and(': 'mixed left, mixed right | mixed',
\ 'variant_cast(': 'variant variant, int type | variant',
\ 'variant_cat(': 'mixed left, mixed right | mixed',
\ 'variant_cmp(': 'mixed left, mixed right [, int lcid [, int flags]] | int',
\ 'variant_date_from_timestamp(': 'int timestamp | variant',
\ 'variant_date_to_timestamp(': 'variant variant | int',
\ 'variant_div(': 'mixed left, mixed right | mixed',
\ 'variant_eqv(': 'mixed left, mixed right | mixed',
\ 'variant_fix(': 'mixed variant | mixed',
\ 'variant_get_type(': 'variant variant | int',
\ 'variant_idiv(': 'mixed left, mixed right | mixed',
\ 'variant_imp(': 'mixed left, mixed right | mixed',
\ 'variant_int(': 'mixed variant | mixed',
\ 'variant_mod(': 'mixed left, mixed right | mixed',
\ 'variant_mul(': 'mixed left, mixed right | mixed',
\ 'variant_neg(': 'mixed variant | mixed',
\ 'variant_not(': 'mixed variant | mixed',
\ 'variant_or(': 'mixed left, mixed right | mixed',
\ 'variant_pow(': 'mixed left, mixed right | mixed',
\ 'variant_round(': 'mixed variant, int decimals | mixed',
\ 'variant_set(': 'variant variant, mixed value | void',
\ 'variant_set_type(': 'variant variant, int type | void',
\ 'variant_sub(': 'mixed left, mixed right | mixed',
\ 'variant_xor(': 'mixed left, mixed right | mixed',
\ 'version_compare(': 'string version1, string version2 [, string operator] | mixed',
\ 'vfprintf(': 'resource handle, string format, array args | int',
\ 'virtual(': 'string filename | bool',
\ 'vpopmail_add_alias_domain_ex(': 'string olddomain, string newdomain | bool',
\ 'vpopmail_add_alias_domain(': 'string domain, string aliasdomain | bool',
\ 'vpopmail_add_domain_ex(': 'string domain, string passwd [, string quota [, string bounce [, bool apop]]] | bool',
\ 'vpopmail_add_domain(': 'string domain, string dir, int uid, int gid | bool',
\ 'vpopmail_add_user(': 'string user, string domain, string password [, string gecos [, bool apop]] | bool',
\ 'vpopmail_alias_add(': 'string user, string domain, string alias | bool',
\ 'vpopmail_alias_del_domain(': 'string domain | bool',
\ 'vpopmail_alias_del(': 'string user, string domain | bool',
\ 'vpopmail_alias_get_all(': 'string domain | array',
\ 'vpopmail_alias_get(': 'string alias, string domain | array',
\ 'vpopmail_auth_user(': 'string user, string domain, string password [, string apop] | bool',
\ 'vpopmail_del_domain_ex(': 'string domain | bool',
\ 'vpopmail_del_domain(': 'string domain | bool',
\ 'vpopmail_del_user(': 'string user, string domain | bool',
\ 'vpopmail_error(': 'void  | string',
\ 'vpopmail_passwd(': 'string user, string domain, string password [, bool apop] | bool',
\ 'vpopmail_set_user_quota(': 'string user, string domain, string quota | bool',
\ 'vprintf(': 'string format, array args | int',
\ 'vsprintf(': 'string format, array args | string',
\ 'w32api_deftype(': 'string typename, string member1_type, string member1_name [, string ... [, string ...]] | bool',
\ 'w32api_init_dtype(': 'string typename, mixed value [, mixed ...] | resource',
\ 'w32api_invoke_function(': 'string funcname, mixed argument [, mixed ...] | mixed',
\ 'w32api_register_function(': 'string library, string function_name, string return_type | bool',
\ 'w32api_set_call_method(': 'int method | void',
\ 'wddx_add_vars(': 'int packet_id, mixed name_var [, mixed ...] | bool',
\ 'wddx_packet_end(': 'resource packet_id | string',
\ 'wddx_packet_start(': '[string comment] | resource',
\ 'wddx_serialize_value(': 'mixed var [, string comment] | string',
\ 'wddx_serialize_vars(': 'mixed var_name [, mixed ...] | string',
\ 'wddx_unserialize(': 'string packet | mixed',
\ 'win32_create_service(': 'array details [, string machine] | int',
\ 'win32_delete_service(': 'string servicename [, string machine] | int',
\ 'win32_get_last_control_message(': 'void  | int',
\ 'win32_ps_list_procs(': 'void  | array',
\ 'win32_ps_stat_mem(': 'void  | array',
\ 'win32_ps_stat_proc(': '[int pid] | array',
\ 'win32_query_service_status(': 'string servicename [, string machine] | mixed',
\ 'win32_set_service_status(': 'int status | bool',
\ 'win32_start_service_ctrl_dispatcher(': 'string name | bool',
\ 'win32_start_service(': 'string servicename [, string machine] | int',
\ 'win32_stop_service(': 'string servicename [, string machine] | int',
\ 'wordwrap(': 'string str [, int width [, string break [, bool cut]]] | string',
\ 'xattr_get(': 'string filename, string name [, int flags] | string',
\ 'xattr_list(': 'string filename [, int flags] | array',
\ 'xattr_remove(': 'string filename, string name [, int flags] | bool',
\ 'xattr_set(': 'string filename, string name, string value [, int flags] | bool',
\ 'xattr_supported(': 'string filename [, int flags] | bool',
\ 'xdiff_file_diff_binary(': 'string file1, string file2, string dest | bool',
\ 'xdiff_file_diff(': 'string file1, string file2, string dest [, int context [, bool minimal]] | bool',
\ 'xdiff_file_merge3(': 'string file1, string file2, string file3, string dest | mixed',
\ 'xdiff_file_patch_binary(': 'string file, string patch, string dest | bool',
\ 'xdiff_file_patch(': 'string file, string patch, string dest [, int flags] | mixed',
\ 'xdiff_string_diff_binary(': 'string str1, string str2 | string',
\ 'xdiff_string_diff(': 'string str1, string str2 [, int context [, bool minimal]] | string',
\ 'xdiff_string_merge3(': 'string str1, string str2, string str3 [, string &#38;error] | mixed',
\ 'xdiff_string_patch_binary(': 'string str, string patch | string',
\ 'xdiff_string_patch(': 'string str, string patch [, int flags [, string &#38;error]] | string',
\ 'xml_error_string(': 'int code | string',
\ 'xml_get_current_byte_index(': 'resource parser | int',
\ 'xml_get_current_column_number(': 'resource parser | int',
\ 'xml_get_current_line_number(': 'resource parser | int',
\ 'xml_get_error_code(': 'resource parser | int',
\ 'xml_parse(': 'resource parser, string data [, bool is_final] | int',
\ 'xml_parse_into_struct(': 'resource parser, string data, array &#38;values [, array &#38;index] | int',
\ 'xml_parser_create(': '[string encoding] | resource',
\ 'xml_parser_create_ns(': '[string encoding [, string separator]] | resource',
\ 'xml_parser_free(': 'resource parser | bool',
\ 'xml_parser_get_option(': 'resource parser, int option | mixed',
\ 'xml_parser_set_option(': 'resource parser, int option, mixed value | bool',
\ 'xmlrpc_decode(': 'string xml [, string encoding] | array',
\ 'xmlrpc_decode_request(': 'string xml, string &#38;method [, string encoding] | array',
\ 'xmlrpc_encode(': 'mixed value | string',
\ 'xmlrpc_encode_request(': 'string method, mixed params [, array output_options] | string',
\ 'xmlrpc_get_type(': 'mixed value | string',
\ 'xmlrpc_is_fault(': 'array arg | bool',
\ 'xmlrpc_parse_method_descriptions(': 'string xml | array',
\ 'xmlrpc_server_add_introspection_data(': 'resource server, array desc | int',
\ 'xmlrpc_server_call_method(': 'resource server, string xml, mixed user_data [, array output_options] | string',
\ 'xmlrpc_server_create(': 'void  | resource',
\ 'xmlrpc_server_destroy(': 'resource server | int',
\ 'xmlrpc_server_register_introspection_callback(': 'resource server, string function | bool',
\ 'xmlrpc_server_register_method(': 'resource server, string method_name, string function | bool',
\ 'xmlrpc_set_type(': 'string &#38;value, string type | bool',
\ 'xml_set_character_data_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_default_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_element_handler(': 'resource parser, callback start_element_handler, callback end_element_handler | bool',
\ 'xml_set_end_namespace_decl_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_external_entity_ref_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_notation_decl_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_object(': 'resource parser, object &#38;object | bool',
\ 'xml_set_processing_instruction_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_start_namespace_decl_handler(': 'resource parser, callback handler | bool',
\ 'xml_set_unparsed_entity_decl_handler(': 'resource parser, callback handler | bool',
\ 'xmlwriter_end_attribute(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_cdata(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_comment(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_document(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_dtd_attlist(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_dtd_element(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_dtd_entity(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_dtd(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_element(': 'resource xmlwriter | bool',
\ 'xmlwriter_end_pi(': 'resource xmlwriter | bool',
\ 'xmlwriter_flush(': 'resource xmlwriter [, bool empty] | mixed',
\ 'xmlwriter_full_end_element(': 'resource xmlwriter | bool',
\ 'xmlwriter_open_memory(': 'void  | resource',
\ 'xmlwriter_open_uri(': 'string source | resource',
\ 'xmlwriter_output_memory(': 'resource xmlwriter [, bool flush] | string',
\ 'xmlwriter_set_indent(': 'resource xmlwriter, bool indent | bool',
\ 'xmlwriter_set_indent_string(': 'resource xmlwriter, string indentString | bool',
\ 'xmlwriter_start_attribute(': 'resource xmlwriter, string name | bool',
\ 'xmlwriter_start_attribute_ns(': 'resource xmlwriter, string prefix, string name, string uri | bool',
\ 'xmlwriter_start_cdata(': 'resource xmlwriter | bool',
\ 'xmlwriter_start_comment(': 'resource xmlwriter | bool',
\ 'xmlwriter_start_document(': 'resource xmlwriter [, string version [, string encoding [, string standalone]]] | bool',
\ 'xmlwriter_start_dtd_attlist(': 'resource xmlwriter, string name | bool',
\ 'xmlwriter_start_dtd_element(': 'resource xmlwriter, string name | bool',
\ 'xmlwriter_start_dtd_entity(': 'resource xmlwriter, string name, bool isparam | bool',
\ 'xmlwriter_start_dtd(': 'resource xmlwriter, string name [, string pubid [, string sysid]] | bool',
\ 'xmlwriter_start_element(': 'resource xmlwriter, string name | bool',
\ 'xmlwriter_start_element_ns(': 'resource xmlwriter, string prefix, string name, string uri | bool',
\ 'xmlwriter_start_pi(': 'resource xmlwriter, string target | bool',
\ 'xmlwriter_text(': 'resource xmlwriter, string content | bool',
\ 'xmlwriter_write_attribute(': 'resource xmlwriter, string name, string content | bool',
\ 'xmlwriter_write_attribute_ns(': 'resource xmlwriter, string prefix, string name, string uri, string content | bool',
\ 'xmlwriter_write_cdata(': 'resource xmlwriter, string content | bool',
\ 'xmlwriter_write_comment(': 'resource xmlwriter, string content | bool',
\ 'xmlwriter_write_dtd_attlist(': 'resource xmlwriter, string name, string content | bool',
\ 'xmlwriter_write_dtd_element(': 'resource xmlwriter, string name, string content | bool',
\ 'xmlwriter_write_dtd_entity(': 'resource xmlwriter, string name, string content | bool',
\ 'xmlwriter_write_dtd(': 'resource xmlwriter, string name [, string pubid [, string sysid [, string subset]]] | bool',
\ 'xmlwriter_write_element(': 'resource xmlwriter, string name, string content | bool',
\ 'xmlwriter_write_element_ns(': 'resource xmlwriter, string prefix, string name, string uri, string content | bool',
\ 'xmlwriter_write_pi(': 'resource xmlwriter, string target, string content | bool',
\ 'xmlwriter_write_raw(': 'resource xmlwriter, string content | bool',
\ 'xpath_new_context(': 'domdocument dom_document | XPathContext',
\ 'xpath_register_ns_auto(': 'XPathContext xpath_context [, object context_node] | bool',
\ 'xpath_register_ns(': 'XPathContext xpath_context, string prefix, string uri | bool',
\ 'xptr_new_context(': 'void  | XPathContext',
\ 'xslt_backend_info(': 'void  | string',
\ 'xslt_backend_name(': 'void  | string',
\ 'xslt_backend_version(': 'void  | string',
\ 'xslt_create(': 'void  | resource',
\ 'xslt_errno(': 'resource xh | int',
\ 'xslt_error(': 'resource xh | string',
\ 'xslt_free(': 'resource xh | void',
\ 'xslt_getopt(': 'resource processor | int',
\ 'xslt_process(': 'resource xh, string xmlcontainer, string xslcontainer [, string resultcontainer [, array arguments [, array parameters]]] | mixed',
\ 'xslt_set_base(': 'resource xh, string uri | void',
\ 'xslt_set_encoding(': 'resource xh, string encoding | void',
\ 'xslt_set_error_handler(': 'resource xh, mixed handler | void',
\ 'xslt_set_log(': 'resource xh [, mixed log] | void',
\ 'xslt_set_object(': 'resource processor, object &#38;obj | bool',
\ 'xslt_setopt(': 'resource processor, int newmask | mixed',
\ 'xslt_set_sax_handler(': 'resource xh, array handlers | void',
\ 'xslt_set_sax_handlers(': 'resource processor, array handlers | void',
\ 'xslt_set_scheme_handler(': 'resource xh, array handlers | void',
\ 'xslt_set_scheme_handlers(': 'resource processor, array handlers | void',
\ 'yaz_addinfo(': 'resource id | string',
\ 'yaz_ccl_conf(': 'resource id, array config | void',
\ 'yaz_ccl_parse(': 'resource id, string query, array &#38;result | bool',
\ 'yaz_close(': 'resource id | bool',
\ 'yaz_connect(': 'string zurl [, mixed options] | mixed',
\ 'yaz_database(': 'resource id, string databases | bool',
\ 'yaz_element(': 'resource id, string elementset | bool',
\ 'yaz_errno(': 'resource id | int',
\ 'yaz_error(': 'resource id | string',
\ 'yaz_es_result(': 'resource id | array',
\ 'yaz_get_option(': 'resource id, string name | string',
\ 'yaz_hits(': 'resource id [, array searchresult] | int',
\ 'yaz_itemorder(': 'resource id, array args | void',
\ 'yaz_present(': 'resource id | bool',
\ 'yaz_range(': 'resource id, int start, int number | void',
\ 'yaz_record(': 'resource id, int pos, string type | string',
\ 'yaz_scan(': 'resource id, string type, string startterm [, array flags] | void',
\ 'yaz_scan_result(': 'resource id [, array &#38;result] | array',
\ 'yaz_schema(': 'resource id, string schema | void',
\ 'yaz_search(': 'resource id, string type, string query | bool',
\ 'yaz_set_option(': 'resource id, string name, string value | void',
\ 'yaz_sort(': 'resource id, string criteria | void',
\ 'yaz_syntax(': 'resource id, string syntax | void',
\ 'yaz_wait(': '[array &#38;options] | mixed',
\ 'yp_all(': 'string domain, string map, string callback | void',
\ 'yp_cat(': 'string domain, string map | array',
\ 'yp_errno(': 'void  | int',
\ 'yp_err_string(': 'int errorcode | string',
\ 'yp_first(': 'string domain, string map | array',
\ 'yp_get_default_domain(': 'void  | string',
\ 'yp_master(': 'string domain, string map | string',
\ 'yp_match(': 'string domain, string map, string key | string',
\ 'yp_next(': 'string domain, string map, string key | array',
\ 'yp_order(': 'string domain, string map | int',
\ 'zend_logo_guid(': 'void  | string',
\ 'zend_version(': 'void  | string',
\ 'zip_close(': 'resource zip | void',
\ 'zip_entry_close(': 'resource zip_entry | void',
\ 'zip_entry_compressedsize(': 'resource zip_entry | int',
\ 'zip_entry_compressionmethod(': 'resource zip_entry | string',
\ 'zip_entry_filesize(': 'resource zip_entry | int',
\ 'zip_entry_name(': 'resource zip_entry | string',
\ 'zip_entry_open(': 'resource zip, resource zip_entry [, string mode] | bool',
\ 'zip_entry_read(': 'resource zip_entry [, int length] | string',
\ 'zip_open(': 'string filename | resource',
\ 'zip_read(': 'resource zip | resource',
\ 'zlib_get_coding_type(': 'void  | string'
\ }
" }}}
" Add control structures (they are outside regular pattern of PHP functions)
let php_control = {
			\ 'include(': 'string filename | resource',
			\ 'include_once(': 'string filename | resource',
			\ 'require(': 'string filename | resource',
			\ 'require_once(': 'string filename | resource',
			\ }
call extend(b:php_builtin_functions, php_control)
endfunction
" }}}
" vim:set foldmethod=marker:
