/*
 * Copyright (C) 2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.watcher;

import static org.junit.Assert.assertFalse;

import java.net.InetAddress;
import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.videolan.vlma.model.Program;

public class DirectMulticastStreamWatcherTest {

    private StreamWatcher watcher;

    @Before
    public void setup() {
        watcher = new DirectMulticastStreamWatcher();
    }

    @Test
    public void testIsPlayed() throws Exception {
        Random random = new Random();
        Program program = new Program();
        assertFalse(watcher.isPlayed(program));
        // Pick a random address
        program.setIp(InetAddress.getByName("239.142." + random.nextInt(256) + "." + random.nextInt(256)));
        assertFalse(watcher.isPlayed(program));
    }

}
