/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdException;

public class RrdOpener {
    protected RrdDbPool pool;
    protected boolean readOnly = false;
    protected boolean usePool = false;

    public RrdOpener(boolean bl) {
        this.usePool = bl;
        if (bl) {
            this.pool = RrdDbPool.getInstance();
        }
    }

    public RrdOpener(boolean bl, boolean bl2) {
        this(bl);
        this.readOnly = bl2;
    }

    public RrdDb getRrd(String string, RrdBackendFactory rrdBackendFactory) throws IOException, RrdException {
        if (this.pool != null) {
            return this.pool.requestRrdDb(string);
        }
        return new RrdDb(string, this.readOnly, rrdBackendFactory);
    }

    public void releaseRrd(RrdDb rrdDb) throws IOException, RrdException {
        if (this.pool != null) {
            this.pool.release(rrdDb);
        } else {
            rrdDb.close();
        }
    }
}

