/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.jrobin.core.Archive;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RpnCalculator;
import org.jrobin.core.RrdDataSet;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class FetchData
implements RrdDataSet {
    private FetchRequest request;
    private Archive matchingArchive;
    private String[] dsNames;
    private long[] timestamps;
    private double[][] values;

    FetchData(Archive archive, FetchRequest fetchRequest) throws IOException {
        this.matchingArchive = archive;
        this.dsNames = fetchRequest.getFilter();
        if (this.dsNames == null) {
            this.dsNames = archive.getParentDb().getDsNames();
        }
        this.request = fetchRequest;
    }

    void setTimestamps(long[] lArray) {
        this.timestamps = lArray;
    }

    void setValues(double[][] dArray) {
        this.values = dArray;
    }

    public int getRowCount() {
        return this.timestamps.length;
    }

    public int getColumnCount() {
        return this.dsNames.length;
    }

    public FetchPoint getRow(int n) {
        int n2 = this.getColumnCount();
        FetchPoint fetchPoint = new FetchPoint(this.timestamps[n], this.getColumnCount());
        for (int i = 0; i < n2; ++i) {
            fetchPoint.setValue(i, this.values[i][n]);
        }
        return fetchPoint;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long getStep() {
        return this.timestamps[1] - this.timestamps[0];
    }

    public double[] getValues(int n) {
        return this.values[n];
    }

    public double[][] getValues() {
        return this.values;
    }

    public double[] getValues(String string) throws RrdException {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!string.equals(this.dsNames[i])) continue;
            return this.getValues(i);
        }
        throw new RrdException("Datasource [" + string + "] not found");
    }

    public FetchRequest getRequest() {
        return this.request;
    }

    public long getFirstTimestamp() {
        return this.timestamps[0];
    }

    public long getLastTimestamp() {
        return this.timestamps[this.timestamps.length - 1];
    }

    public Archive getMatchingArchive() {
        return this.matchingArchive;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public int getDsIndex(String string) {
        for (int i = 0; i < this.dsNames.length; ++i) {
            if (!this.dsNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void dump() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            System.out.println(this.getRow(i).dump());
        }
    }

    public String toString() {
        int n;
        DecimalFormat decimalFormat = new DecimalFormat("+0.0000000000E00");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FetchData.padWithBlanks("", 10));
        stringBuffer.append(" ");
        for (n = 0; n < this.dsNames.length; ++n) {
            stringBuffer.append(FetchData.padWithBlanks(this.dsNames[n], 18));
        }
        stringBuffer.append("\n \n");
        for (n = 0; n < this.timestamps.length; ++n) {
            stringBuffer.append(FetchData.padWithBlanks("" + this.timestamps[n], 10));
            stringBuffer.append(":");
            for (int i = 0; i < this.dsNames.length; ++i) {
                double d = this.values[i][n];
                String string = Double.isNaN(d) ? "nan" : decimalFormat.format(d);
                stringBuffer.append(FetchData.padWithBlanks(string, 18));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static String padWithBlanks(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = n - string.length();
        while (n2-- > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public double getAggregate(String string, String string2) throws RrdException {
        return this.getAggregate(string, string2, null);
    }

    public double getAggregate(String string, String string2, String string3) throws RrdException {
        if (string2.equals("MAX")) {
            return this.getMax(string, string3);
        }
        if (string2.equals("MIN")) {
            return this.getMin(string, string3);
        }
        if (string2.equals("LAST")) {
            return this.getLast(string, string3);
        }
        if (string2.equals("AVERAGE")) {
            return this.getAverage(string, string3);
        }
        throw new RrdException("Unsupported consolidation function [" + string2 + "]");
    }

    private double getMax(String string, String string2) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (string2 != null) {
            rpnCalculator = new RpnCalculator(string2);
        }
        double[] dArray = this.getValues(string);
        double d = Double.NaN;
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d2 = dArray[i + 1];
            if (rpnCalculator != null) {
                rpnCalculator.setValue(d2);
                d2 = rpnCalculator.calculate();
            }
            d = Util.max(d, d2);
        }
        return d;
    }

    private double getMin(String string, String string2) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (string2 != null) {
            rpnCalculator = new RpnCalculator(string2);
        }
        double[] dArray = this.getValues(string);
        double d = Double.NaN;
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d2 = dArray[i + 1];
            if (rpnCalculator != null) {
                rpnCalculator.setValue(d2);
                d2 = rpnCalculator.calculate();
            }
            d = Util.min(d, d2);
        }
        return d;
    }

    private double getLast(String string, String string2) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (string2 != null) {
            rpnCalculator = new RpnCalculator(string2);
        }
        double[] dArray = this.getValues(string);
        double d = dArray[dArray.length - 1];
        if (rpnCalculator != null) {
            rpnCalculator.setValue(d);
            d = rpnCalculator.calculate();
        }
        return d;
    }

    private double getAverage(String string, String string2) throws RrdException {
        RpnCalculator rpnCalculator = null;
        if (string2 != null) {
            rpnCalculator = new RpnCalculator(string2);
        }
        double[] dArray = this.getValues(string);
        double d = 0.0;
        long l = 0L;
        for (int i = 0; i < dArray.length - 1; ++i) {
            long l2 = Math.max(this.request.getFetchStart(), this.timestamps[i]);
            long l3 = Math.min(this.request.getFetchEnd(), this.timestamps[i + 1]);
            double d2 = dArray[i + 1];
            if (rpnCalculator != null) {
                rpnCalculator.setValue(d2);
                d2 = rpnCalculator.calculate();
            }
            if (Double.isNaN(d2)) continue;
            l += l3 - l2;
            d += (double)(l3 - l2) * d2;
        }
        return l > 0L ? d / (double)l : Double.NaN;
    }

    public void exportXml(OutputStream outputStream) throws IOException {
        int n;
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("fetch_data");
        xmlWriter.startTag("request");
        xmlWriter.writeTag("file", this.request.getParentDb().getPath());
        xmlWriter.writeComment(Util.getDate(this.request.getFetchStart()));
        xmlWriter.writeTag("start", this.request.getFetchStart());
        xmlWriter.writeComment(Util.getDate(this.request.getFetchEnd()));
        xmlWriter.writeTag("end", this.request.getFetchEnd());
        xmlWriter.writeTag("resolution", this.request.getResolution());
        xmlWriter.writeTag("cf", this.request.getConsolFun());
        xmlWriter.closeTag();
        xmlWriter.startTag("datasources");
        for (n = 0; n < this.dsNames.length; ++n) {
            xmlWriter.writeTag("name", this.dsNames[n]);
        }
        xmlWriter.closeTag();
        xmlWriter.startTag("data");
        for (n = 0; n < this.timestamps.length; ++n) {
            xmlWriter.startTag("row");
            xmlWriter.writeComment(Util.getDate(this.timestamps[n]));
            xmlWriter.writeTag("timestamp", this.timestamps[n]);
            xmlWriter.startTag("values");
            for (int i = 0; i < this.dsNames.length; ++i) {
                xmlWriter.writeTag("v", this.values[i][n]);
            }
            xmlWriter.closeTag();
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
        xmlWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXml(String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.exportXml(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public String exportXml() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportXml(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }
}

