/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.order;

import java.io.IOException;
import org.videolan.vlma.model.DTTChannel;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.StreamingStrategy;
import org.videolan.vlma.order.OrderSender;

public class DTTOrderSender
extends OrderSender {
    public void start(Order o) throws IOException {
        this.telnetConnect(o.getAdapter().getServer());
        this.init(this.getVLMCommandName(o), o.getAdapter());
        if (!o.getMedias().isEmpty()) {
            DTTChannel ch = (DTTChannel)o.getMedias().get(0);
            this.telnetCommand("setup " + this.getVLMCommandName(o) + " input dvb://", o.getAdapter());
            this.telnetCommand("setup " + this.getVLMCommandName(o) + " option dvb-frequency=" + Integer.toString(ch.getFrequency()), o.getAdapter());
            this.telnetCommand("setup " + this.getVLMCommandName(o) + " option dvb-adapter=" + o.getAdapter().getName(), o.getAdapter());
            this.telnetCommand("setup " + this.getVLMCommandName(o) + " option dvb-bandwidth=" + Integer.toString(this.configuration.getInt("vlc.stream.dvb-bandwidth")), o.getAdapter());
            StringBuilder ids = new StringBuilder();
            StringBuilder command = new StringBuilder();
            command.append("setup ").append(this.getVLMCommandName(o)).append(" output #duplicate{");
            boolean firstLoop = true;
            for (Media m : o.getMedias()) {
                ch = (DTTChannel)m;
                if (!firstLoop) {
                    ids.append(",");
                }
                ids.append(ch.getSid());
                if (!firstLoop) {
                    command.append(",");
                }
                command.append(String.format("dst=standard{mux=%s,access=%s,dst=%s", this.getMux(ch.getProgram()), this.getAccess(ch.getProgram()), this.getDst(ch.getProgram())));
                if (ch.getProgram().getStreamingStrategy().isEnabled(StreamingStrategy.Announcement.SAP)) {
                    command.append(String.format(",sap,name=\"%s\",group=\"%s\"", ch.getProgram().getSapName(), ch.getProgram().getSapGroup()));
                }
                command.append(String.format("},select=\"program=%d\"", ch.getSid()));
                firstLoop = false;
            }
            this.telnetCommand("setup " + this.getVLMCommandName(o) + " option programs=" + ids, o.getAdapter());
            command.append("}");
            this.telnetCommand(command.toString(), o.getAdapter());
            this.telnetCommand("setup " + this.getVLMCommandName(o) + " enabled", o.getAdapter());
            this.telnetCommand("control " + this.getVLMCommandName(o) + " play", o.getAdapter());
        }
        this.telnetClose();
    }
}

