/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ti;

import javax.tv.locator.Locator;
import javax.tv.service.SIException;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.ServiceType;
import org.bluray.net.BDLocator;
import org.bluray.ti.PlayList;
import org.bluray.ti.PlayListImpl;
import org.bluray.ti.Title;
import org.bluray.ti.TitleType;
import org.davic.net.InvalidLocatorException;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.TitleInfo;
import org.videolan.bdjo.Bdjo;

public class TitleImpl
implements Title {
    private int titleNum;
    private TitleInfo ti;
    private Bdjo bdjo = null;

    public TitleImpl(int titleNum) throws SIException {
        this.titleNum = titleNum;
        this.ti = Libbluray.getTitleInfo(titleNum);
        if (this.ti == null) {
            throw new SIException("Title " + titleNum + " does not exist in disc index");
        }
        if (this.ti.isBdj()) {
            this.bdjo = Libbluray.getBdjo(this.ti.getBdjoName());
            if (this.bdjo == null) {
                throw new SIException("title " + titleNum + ": Failed loading " + this.ti.getBdjoName() + ".bdjo");
            }
        }
    }

    public PlayList[] getPlayLists() {
        if (this.bdjo == null) {
            return new PlayList[0];
        }
        String[] playlistNames = this.bdjo.getAccessiblePlaylists().getPlayLists();
        PlayList[] playlists = new PlayList[playlistNames.length];
        for (int i = 0; i < playlistNames.length; ++i) {
            playlists[i] = new PlayListImpl(playlistNames[i], this);
        }
        return playlists;
    }

    public boolean hasAutoPlayList() {
        if (this.bdjo == null) {
            return false;
        }
        return this.bdjo.getAccessiblePlaylists().isAutostartFirst();
    }

    public Locator getLocator() {
        String url = "bd://" + Integer.toString(this.titleNum, 16);
        try {
            return new BDLocator(url);
        }
        catch (InvalidLocatorException ex) {
            return null;
        }
    }

    public String getName() {
        if (this.titleNum == 0) {
            return "Top Menu";
        }
        if (this.titleNum == 65535) {
            return "First Playback";
        }
        if (this.titleNum == 65534) {
            return "Suspended Title";
        }
        return "Title " + this.titleNum;
    }

    public ServiceType getServiceType() {
        switch (this.ti.getPlaybackType()) {
            case 0: {
                return TitleType.HDMV_MOVIE;
            }
            case 1: {
                return TitleType.HDMV_INTERACTIVE;
            }
            case 2: {
                return TitleType.BDJ_MOVIE;
            }
            case 3: {
                return TitleType.BDJ_INTERACTIVE;
            }
        }
        return TitleType.UNKNOWN;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TitleImpl)) {
            return false;
        }
        TitleImpl other = (TitleImpl)obj;
        int otherNum = other.getTitleNum();
        return otherNum == this.titleNum;
    }

    public boolean hasMultipleInstances() {
        return false;
    }

    public SIRequest retrieveDetails(SIRequestor requestor) {
        Logger.unimplemented(TitleImpl.class.getName(), "retrieveDetails");
        return null;
    }

    public int getTitleNum() {
        return this.titleNum;
    }

    public TitleInfo getTitleInfo() {
        return this.ti;
    }
}

