/////////////////////////////////////////////////////////////////////////////
// Name:        _accel.i
// Purpose:     SWIG interface for wxAcceleratorTable
//
// Author:      Robin Dunn
//
// Created:     03-July-1997
// RCS-ID:      $Id: _accel.i,v 1.3 2003/11/26 06:09:55 RD Exp $
// Copyright:   (c) 2003 by Total Control Software
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// Not a %module


//---------------------------------------------------------------------------

%typemap(in) (int n, const wxAcceleratorEntry* entries) {
    $2 = wxAcceleratorEntry_LIST_helper($input);
    if ($2) $1 = PyList_Size($input);
    else    $1 = 0;
}

%typemap(freearg) wxAcceleratorEntry* entries {
     delete [] $1;
}



//---------------------------------------------------------------------------
%newgroup;


class wxAcceleratorEntry {
public:
    wxAcceleratorEntry(int flags = 0, int keyCode = 0, int cmd = 0, wxMenuItem *item = NULL);
    ~wxAcceleratorEntry();

    void Set(int flags, int keyCode, int cmd, wxMenuItem *item = NULL);

    void SetMenuItem(wxMenuItem *item);
    wxMenuItem *GetMenuItem() const;

    int GetFlags();
    int GetKeyCode();
    int GetCommand();
};


class wxAcceleratorTable : public wxObject {
public:
    DocAStr(wxAcceleratorTable,
            "__init__(entries) -> AcceleratorTable",
            "Construct an AcceleratorTable from a list of AcceleratorEntry items or\n"
            "3-tuples (flags, keyCode, cmdID)");
    wxAcceleratorTable(int n, const wxAcceleratorEntry* entries);
    ~wxAcceleratorTable();

    bool Ok() const;
};

 
%immutable;
// See also wxPy_ReinitStockObjects in helpers.cpp
const wxAcceleratorTable wxNullAcceleratorTable;
%mutable;


wxAcceleratorEntry *wxGetAccelFromString(const wxString& label);

//---------------------------------------------------------------------------
