/******************************************************************************/
/* vlsat.cpp (c)1999 Bozo                                                     */
/******************************************************************************/

#define DEBUG

#include "../core/core.h"

#include "../server/ts.h"

#include "seconst.h"
#include "seprot.h"
#include "seerror.h"

#include "cmdlink.h"
#include "datalink.h"
#include "blboard.h"
#include "vlsat.h"



//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
C_VlSat::C_VlSat() : C_Application("VlSat")
{
	m_pBlBoard = NULL;
}


//------------------------------------------------------------------------------
// Construction
//------------------------------------------------------------------------------
C_VlSat* C_VlSat::Create()
{
	return new C_VlSat();
}


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------
int C_VlSat::OnAppInit()
{
	m_pBlBoard = C_BlBoard::Create(m_hLog);
	int iRc = m_pBlBoard->Init();

	return iRc;
}

//------------------------------------------------------------------------------
// Execution
//------------------------------------------------------------------------------
int C_VlSat::OnAppRun()
{
	int iRc = m_pBlBoard->Run();

	return iRc;
}


//------------------------------------------------------------------------------
// Stop
//------------------------------------------------------------------------------
int C_VlSat::OnAppExit()
{
//	m_bContinue = false;
	int iRc = m_pBlBoard->Destroy();

	return iRc;
}


//------------------------------------------------------------------------------
// Destruction
//------------------------------------------------------------------------------
int C_VlSat::OnAppDestroy()
{
	int iRc = NO_ERR;

	if (m_pBlBoard)
	{
		iRc = m_pBlBoard->Destroy();
		delete m_pBlBoard;
	}

	return iRc;
}









int main(int argc, char* argv[])
{
	int iRc = 0;

	WORD wVersionRequested;
	WSADATA wsaData;
	int err;

	wVersionRequested = MAKEWORD( 2, 2 );

	err = WSAStartup( wVersionRequested, &wsaData );

	C_VlSat* pApp = C_VlSat::Create();
	ASSERT(pApp);

	iRc = pApp->Init(argc, argv);

	if (!iRc)
		iRc = pApp->Run ();

	iRc |= pApp->Destroy ();

	WSACleanup();

	return iRc;
}
