/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BDImage;
import java.awt.BDToolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class BDImageConsumer
extends BDImage
implements ImageConsumer {
    private Hashtable properties;
    private ImageProducer producer;
    private int status;
    private boolean started;

    public BDImageConsumer(ImageProducer producer) {
        super(null, -1, -1, null);
        this.producer = producer;
    }

    public int getWidth(ImageObserver observer) {
        if (this.width < 0) {
            this.addObserver(observer);
            this.startProduction();
        }
        return this.width;
    }

    public int getHeight(ImageObserver observer) {
        if (this.height < 0) {
            this.addObserver(observer);
            this.startProduction();
        }
        return this.height;
    }

    public boolean isComplete(ImageObserver observer) {
        if ((this.status & 0x20) != 0) {
            return true;
        }
        if (observer != null && observer.imageUpdate(this, this.status, 0, 0, this.width, this.height)) {
            this.addObserver(observer);
        }
        return false;
    }

    public int checkImage(ImageObserver observer) {
        if (observer != null && observer.imageUpdate(this, this.status, 0, 0, this.width, this.height)) {
            this.addObserver(observer);
        }
        return this.status;
    }

    public boolean prepareImage(ImageObserver observer) {
        if (this.started) {
            if (observer != null && observer.imageUpdate(this, this.status, 0, 0, this.width, this.height)) {
                this.addObserver(observer);
            }
        } else {
            this.addObserver(observer);
            this.startProduction();
        }
        return (this.status & 0x20) != 0;
    }

    public ImageProducer getSource() {
        return this.producer;
    }

    public void flush() {
        this.width = -1;
        this.height = -1;
        this.backBuffer = null;
        this.status = 0;
        this.started = false;
        this.producer.removeConsumer(this);
        BDToolkit.clearCache(this);
    }

    public void imageComplete(int stat) {
        switch (stat) {
            case 1: {
                this.status |= 0x40;
                this.notifyObservers(this, 64, 0, 0, this.width, this.height);
                break;
            }
            case 2: {
                this.status |= 0x10;
                this.notifyObservers(this, 16, 0, 0, this.width, this.height);
                break;
            }
            case 3: {
                this.status |= 0x20;
                this.notifyObservers(this, 32, 0, 0, this.width, this.height);
                break;
            }
            case 4: {
                this.status |= 0x80;
                this.notifyObservers(this, 128, 0, 0, this.width, this.height);
            }
        }
    }

    public void setColorModel(ColorModel cm) {
    }

    public void setDimensions(int width, int height) {
        if (width >= 0 && height >= 0) {
            this.width = width;
            this.height = height;
            this.backBuffer = new int[width * height];
            this.status |= 3;
            this.notifyObservers(this, 3, 0, 0, width, height);
        }
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Object getProperty(String name, ImageObserver observer) {
        if (this.properties == null) {
            this.addObserver(observer);
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperties(Hashtable props) {
        this.properties = props;
        this.status |= 4;
        this.notifyObservers(this, 4, 0, 0, this.width, this.height);
    }

    public void setHints(int hints) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel cm, byte[] pixels, int offset, int scansize) {
        for (int Y = y; Y < y + h; ++Y) {
            for (int X = x; X < x + w; ++X) {
                this.backBuffer[Y * this.width + X] = cm.getRGB(pixels[offset + (Y - y) * scansize + (X - x)] & 0xFF);
            }
        }
        this.status |= 8;
        this.notifyObservers(this, 8, x, y, w, h);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel cm, int[] pixels, int offset, int scansize) {
        for (int Y = y; Y < y + h; ++Y) {
            for (int X = x; X < x + w; ++X) {
                this.backBuffer[Y * this.width + X] = cm.getRGB(pixels[offset + (Y - y) * scansize + (X - x)]);
            }
        }
        this.status |= 8;
        this.notifyObservers(this, 8, x, y, w, h);
    }

    protected synchronized void startProduction() {
        if (this.producer != null && !this.started) {
            if (!this.producer.isConsumer(this)) {
                this.producer.addConsumer(this);
            }
            this.started = true;
            this.producer.startProduction(this);
        }
    }
}

