/*
 * Copyright (C) 2000-2007 the xine project
 *
 * This file is part of xine, a free video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * 
 * Xine plugin for Mozilla/Firefox 
 *      written by Claudio Ciccani <klan@users.sf.net>
 *      
 */
 
#ifndef __XINE_METHODS_H__
#define __XINE_METHODS_H__


enum {
  METHOD_ID_None = -1,

  METHOD_ID_play = 0, // WMP
  METHOD_ID_Play, // Quicktime
  METHOD_ID_DoPlay, // Real Player
  METHOD_ID_pause, // WMP
  METHOD_ID_Pause, // Xine
  METHOD_ID_DoPause, // Real Player
  METHOD_ID_stop, // WMP
  METHOD_ID_Stop, // Quicktime
  METHOD_ID_DoStop, // Real Player
  METHOD_ID_CanPlay, // Real Player
  METHOD_ID_CanPause, // Real Player
  METHOD_ID_CanStop, // Real Player
  METHOD_ID_GetLength, // Real Player
  METHOD_ID_GetDuration, // Quicktime
  METHOD_ID_GetPosition, // Real Player
  METHOD_ID_GetCurrentPosition, // WMP
  METHOD_ID_GetTime, // Quicktime
  METHOD_ID_SetPosition, // Real Player
  METHOD_ID_SetCurrentPosition, // WMP
  METHOD_ID_SetTime, // Quicktime
  METHOD_ID_Rewind, // Quicktime
  METHOD_ID_GetStartTime, // Quicktime
  METHOD_ID_SetStartTime, // Quicktime
  METHOD_ID_GetTimeScale, // Quicktime
  METHOD_ID_GetPlayState, // Real Player
  METHOD_ID_GetSource, // Real Player
  METHOD_ID_GetURL, // Quicktime
  METHOD_ID_GetFileName, // WMP
  METHOD_ID_SetSource, // Real Player
  METHOD_ID_SetURL, // Quicktime
  METHOD_ID_SetFileName, // WMP
  METHOD_ID_GetAutoStart, // Real Player
  METHOD_ID_GetAutoPlay, // Quicktime
  METHOD_ID_SetAutoStart, // Real Player
  METHOD_ID_SetAutoPlay, // Quicktime
  METHOD_ID_GetLoop, // Real Player
  METHOD_ID_GetIsLooping, // Quicktime
  METHOD_ID_SetLoop, // Real Player
  METHOD_ID_SetIsLooping,// Quicktime
  METHOD_ID_GetNumLoop, // Real Player
  METHOD_ID_GetPlayCount, // WMP
  METHOD_ID_SetNumLoop, // Real Player
  METHOD_ID_SetPlayCount, // WMP
  METHOD_ID_GetClipWidth, // Real Player
  METHOD_ID_GetClipHeight, // Real Player
  METHOD_ID_HasNextEntry, // Real Player
  METHOD_ID_HasPrevEntry, // Real Player
  METHOD_ID_DoNextEntry, // Real Player
  METHOD_ID_DoPrevEntry, // Real Player
  METHOD_ID_GetNumEntries, // Real Player
  METHOD_ID_GetCurrentEntry, // Real Player
  METHOD_ID_SetCurrentEntry, // Xine
  
  NUM_METHODS
};


static const char *const methodName[NUM_METHODS] = {
  [METHOD_ID_play] = "play",
  [METHOD_ID_Play] = "Play",
  [METHOD_ID_DoPlay] = "DoPlay",
  [METHOD_ID_pause] = "pause",
  [METHOD_ID_Pause] = "Pause",
  [METHOD_ID_DoPause] = "DoPause",
  [METHOD_ID_stop] = "stop",
  [METHOD_ID_Stop] = "Stop",
  [METHOD_ID_DoStop] = "DoStop",
  [METHOD_ID_CanPlay] = "CanPlay",
  [METHOD_ID_CanPause] = "CanPause",
  [METHOD_ID_CanStop] = "CanStop",
  [METHOD_ID_GetLength] = "GetLength",
  [METHOD_ID_GetDuration] = "GetDuration",
  [METHOD_ID_GetPosition] = "GetPosition",
  [METHOD_ID_GetCurrentPosition] = "GetCurrentPosition",
  [METHOD_ID_GetTime] = "GetTime",
  [METHOD_ID_SetPosition] = "SetPosition",
  [METHOD_ID_SetCurrentPosition] = "SetCurrentPosition",
  [METHOD_ID_SetTime] = "SetTime",
  [METHOD_ID_Rewind] = "Rewind",
  [METHOD_ID_GetStartTime] = "GetStartTime",
  [METHOD_ID_SetStartTime] = "SetStartTime",
  [METHOD_ID_GetTimeScale] = "GetTimeScale",
  [METHOD_ID_GetPlayState] = "GetPlayState",
  [METHOD_ID_GetSource] = "GetSource",
  [METHOD_ID_GetURL] = "GetURL",
  [METHOD_ID_GetFileName] = "GetFileName",
  [METHOD_ID_SetSource] = "SetSource",
  [METHOD_ID_SetURL] = "SetURL",
  [METHOD_ID_SetFileName] = "SetFileName",
  [METHOD_ID_GetAutoStart] = "GetAutoStart",
  [METHOD_ID_GetAutoPlay] = "GetAutoPlay",
  [METHOD_ID_SetAutoStart] = "SetAutoStart",
  [METHOD_ID_SetAutoPlay] = "SetAutoPlay",
  [METHOD_ID_GetLoop] = "GetLoop",
  [METHOD_ID_GetIsLooping] = "GetIsLooping",
  [METHOD_ID_SetLoop] = "SetLoop",
  [METHOD_ID_SetIsLooping] = "SetIsLooping",
  [METHOD_ID_GetNumLoop] = "GetNumLoop",
  [METHOD_ID_GetPlayCount] = "GetPlayCount",
  [METHOD_ID_SetNumLoop] = "SetNumLoop",
  [METHOD_ID_SetPlayCount] = "SetPlayCount",
  [METHOD_ID_GetClipWidth] = "GetClipWidth",
  [METHOD_ID_GetClipHeight] = "GetClipHeight",
  [METHOD_ID_HasNextEntry] = "HasNextEntry",
  [METHOD_ID_HasPrevEntry] = "HasPrevEntry",
  [METHOD_ID_DoNextEntry] = "DoNextEntry",
  [METHOD_ID_DoPrevEntry] = "DoPrevEntry",
  [METHOD_ID_GetNumEntries] = "GetNumEntries",
  [METHOD_ID_GetCurrentEntry] = "GetCurrentEntry",
  [METHOD_ID_SetCurrentEntry] = "SetCurrentEntry",
};


#endif /* __XINE_METHODS_H__ */
  
