target=trilineaire trilineaire_c
#if #TARGET(trilineaire)
\title{Coordonnes trilinaires}
#endif
#if #TARGET(trilineaire_c)
\title{Coordonnes trilinaires et droites}
#endif
\author{Bernadette PERRIN-RIOU}
\email{bpr@math.u-psud.fr}
\text{B = -1,-sqrt(3)/3}
\text{C = 1,-sqrt(3)/3}
\text{A = 0, 2*sqrt(3)/3}
\text{h = randint(5..12)}
\text{rotation=0}
\text{xrange=-1.2,1.2}
\text{yrange= -1,1.4}
\text{SIZE=300,300}
\text{A1=pari(1.1*[\A])}
\text{B1=pari(1.1*[\B])}
\text{C1=pari(1.1*[\C])}
\text{dessin=xrange \xrange
yrange \yrange
rotate \rotation
triangle \A,\B,\C,black
text black,\A1, large, A
text black,\B1, large, B
text black,\C1, large, C
}

#if #TARGET(trilineaire)
\text{point_coord=slib(stat/multinomial 1,\h,[1/3,1/3])}
\text{point = pari(point_coord=[\point_coord] ; 
(point_coord[1]*[\A] + point_coord[2]*[\B] + point_coord[3]*[\C])/\h)}
\text{point_pixel=slib(draw/convpixel \point, \SIZE,\xrange,\yrange,0,pixels)}
#endif

#if #TARGET(trilineaire_c)

\text{u = randint( 1..\h-1)}
\text{v = randint(1..3)}
\text{liste=a,b,c}
\text{var=\liste[\v]}

\integer{ b = \h - \u}
\text{Point1 = \v = 1 ? \u,\b,0}
\text{Point2 = \v = 1 ? \u,0,\b}

\text{Point1 = \v = 2 ? \b,\u,0}
\text{Point2 = \v = 2 ? 0,\u,\b}

\text{Point1 = \v = 3 ? \b,0,\u}
\text{Point2 = \v = 3 ? 0,\b,\u}


\text{point1 = pari(point_coord=[\Point1] ; 
(point_coord[1]*[\A] + point_coord[2]*[\B] + point_coord[3]*[\C])/\h)}
\text{point_p1=slib(draw/convpixel \point1, \SIZE,\xrange,\yrange,0,pixels)}
\text{point2 = pari(point_coord=[\Point2] ; 
(point_coord[1]*[\A] + point_coord[2]*[\B] + point_coord[3]*[\C])/\h)}
\text{point_p2=slib(draw/convpixel \point2, \SIZE,\xrange,\yrange,0,pixels)}

#endif


\text{couleur=red,blue,green}
\text{couleur=green,green,green}
\for{i = 0 to \h}{
 \text{P = pari((\i*[\A] + (\h-\i)*[\B])/\h)}
 \text{Q = pari((\i*[\A] + (\h-\i)*[\C])/\h)}
 \text{R = pari((\i*[\B] + (\h-\i)*[\C])/\h)}
 \text{S = pari((\i*[\C] + (\h-\i)*[\B])/\h)}
   \text{dessin = \dessin
   line \P,\Q, \couleur[1]
   line \Q,\R, \couleur[2]
   line \P,\S, \couleur[3]
  }  
}
\text{DESSIN=draw(\SIZE
\dessin)}
\text{DESSIN1=draw(\SIZE
\dessin
disk \point,9,green)}


#if #TARGET(trilineaire)

\statement{Le triangle \((ABC)) est un triangle quilatral 
de hauteur \h. 
Cliquer sur le point de coordonnes \special{help tri,trilinaires}
(\point_coord) :
<p align="center">
\embed{reply1}
</p>
}
\answer{}{\DESSIN;point,\point_pixel}{type=coord}
\feedback{1=1}{<img src="\DESSIN1">}
#endif

#if #TARGET(trilineaire_c)

\statement{Le triangle \((ABC)) est un triangle quilatral 
de hauteur \h. Un point intrieur au triangle est repr par ses coordonnes \special{help tri,trilinaires}
\((a, b, c)).
Dessiner le segment correspondant  \(\var = \u) :
<p align="center">
\embed{reply1}
</p>
}
\answer{}{\DESSIN;segment,\point_p1,\point_p2}{type=javacurve}

#endif


\help{\if{\help_subject issametext or \help_subject issametext tri}
{
La somme des distances d'un point 
\(M) aux cts du triangle quilatral 
est gale  la hauteur \(h) du triangle. 

<p>
Les <i>coordonnes trilinaires</i>  d'un point \(M) de l'intrieur du triangle
sont \((a, b, c)) avec  \(a) la distance de \(M) au ct \(BC), 
\(b) la distance de \(M) au ct \(CA), 
et
\(c) la distance de \(M) au ct \(AB). 
<p>
Le point \(M) est  le barycentre de \((A, a)), \((B, b)) et \((C, c))
avec \(a + b + c = h). 

}
}
