
#ifndef __MESSAGES_PC_DSP_H__
#define __MESSAGES_PC_DSP_H__

#define	PC_PING			1	/* see if VPB DSP is alive		*/
#define PC_TONED_ST		2	/* call progress state table		*/
#define	PC_TONEG		3	/* generate tone			*/
#define	PC_CONFIG_OBJ		4	/* create object in config manager	*/
#define	PC_CONFIG_WIRE		5	/* connect two objs using software wire	*/
#define	PC_CONFIG_CLR		6	/* connect two objs using software wire	*/
#define	PC_CONFIG_RUN		7	/* enable config signal processing	*/
#define	PC_CONFIG_STOP		8	/* disable config signal processing	*/
#define	PC_CODEC_OFFHK		9	/* take channel off hook		*/
#define	PC_CODEC_ONHK		10	/* place channel on hook		*/
#define	PC_CONFIG_EN		11	/* enable an object			*/
#define	PC_CONFIG_DIS		12	/* disable an object			*/
#define	PC_SPI_LOAD 		13	/* tell DSP to send comp. load report	*/
#define	PC_SPI_RESLOAD 		14	/* tell DSP to reset comp load stats	*/
#define	PC_CONFIG_NWIRE		15	/* remove software wire			*/
#define	PC_CODEC_BREAK		16	/* loop break				*/
#define	PC_CODEC_RECGAIN	17	/* change UP direction gain		*/
#define	PC_CODEC_PLAYGAIN	18	/* change DOWN direction gain		*/
#define	PC_TONED_DEBUG		19	/* places toned in debug mode		*/
#define	PC_VOX_UPDATE		20	/* change VOX levels			*/
#define PC_AGC_UPDATE  		21	/* chage AGC parameters			*/
#define	PC_CONFIG_8K		22	/* configure an object for 8k operation */
#define	PC_CONFIG_6K		23	/* configure an object for 6k operation */
#define PC_CONFIG_PACK		24	/* configure packing ratio 		*/
#define PC_ECHO_FORCEON		25	/* start force echo canc to adapt	*/
#define PC_ECHO_FORCEOFF	26	/* stop force echo canc to adapt	*/
#define	PC_COMP_ADPCMRES	27	/* reset ADPCM state variables		*/
#define PC_ECHO_INIT		28	/* set adaptive coefficients to zero	*/
#define PC_CONFIG_ZEROBUF	29	/* connect an object to the zero buffer	*/
#define PC_CONFIG_FLUSHFIFO	30	/* flush a DSP fifo	 		*/
#define PC_ECHO_ENABLE		31	/* start echo cancellation		*/
#define PC_ECHO_DISABLE		32	/* stop echo canc (continue adaption)	*/
#define PC_TONEG_RESET		33	/* reset tone generator			*/
#define	PC_CONFIG_EN2		34	/* enable an two objects		*/
//#define PC_CONFIG_RESFA	35	/* reset FIFO alarm			*/
#define	PC_CONFIG_ENLIST	36	/* enable a list of objects		*/
#define PC_FIXGAIN_UPDATE	37	/* change the fixed gain		*/
#define	PC_CODEC_OFFHKSCP	38	/* off hook, audio from SCP             */
#define	PC_CODEC_GEN		39	/* general codec config message         */
#define	PC_SPI_BRIDGE		40	/* firmware level bridging              */
#define	PC_SPI_BRIDGE_OFF	41	/* turn off firmware level bridging     */
//#define PC_STATION_OFF	42	/* turn station port off                */
//#define PC_STATION_ON		43	/* turn station port on                 */
#define	PC_RING_OFF		44	/* start ringing a station port         */
#define	PC_RING_ON		45 	/* stop ringing a station port          */
//#define PC_WD_ENABLE		46	/* enable/disable V12PCI watchdog timer */
//#define PC_WD_RESET		47  	/* reset V12PCI watchdog timer          */
//#define PC_URING_OFF		48  	/* start ringing a station port         */
//#define PC_URING_ON		49  	/* stop ringing a station port          */
#define	PC_CONF_JOIN   		50  	/* Join a conference			*/
#define	PC_CONF_LEAVE  		51  	/* Leave a conference			*/
#define	PC_SPI_SBRIDGE		52	/* Soft firmware level bridging		*/
#define	PC_SPI_SBRIDGE_OFF	53	/* turn off Soft firmware level bridging*/
#define	PC_LOOPBACK_ON		54	/* turn on tx-rx soft loop back         */
#define	PC_LOOPBACK_OFF		55	/* turn off tx-rx soft loop back        */
#define	PC_HOSTECHO_ON		56	/* turn on host echo cancelation 	*/
#define	PC_HOSTECHO_OFF		57	/* turn off host echo cancelation 	*/
//#define PC_HOSTECHO_OPT	58	/* Set host echo optimization		*/
#define PC_TONED_ST_DEL		59	/* call progress state table delete	*/
#define PC_ISDN_CALL		60	/* make an ISDN call			*/
#define PC_ISDN_GET_CINFO	61	/* Get the calling number		*/
#define PC_ISDN_GET_CNAM	62	/* Get the calling name			*/
#define PC_ISDN_GET_CDNUM	63	/* Get the called  number		*/
//#define PC_CODEC_FXSOFFHK	64	/* Take a FXS port off hook, to remove line voltage */
//#define PC_CODEC_FXSONHK	65	/* Take a FXS port off hook, to apply line voltage */

/* length of PC -> DSP messages (if fixed) */

#define PC_LPING		2
#define	PC_LTONEG		13
#define	PC_LCONFIG_OBJ		6
#define	PC_LCONFIG_WIRE		4
#define	PC_LCONFIG_CLR		2
#define	PC_LCONFIG_RUN		2
#define	PC_LCONFIG_STOP		2
#define	PC_LCODEC_OFFHK		3
#define	PC_LCODEC_ONHK		3
#define	PC_LCONFIG_EN		3
#define	PC_LCONFIG_DIS		3
#define	PC_LSPI_LOAD		2
#define	PC_LSPI_RESLOAD		2
#define	PC_LCONFIG_NWIRE	3
#define	PC_LCODEC_BREAK		4
#define	PC_LCODEC_RECGAIN	4
#define	PC_LCODEC_PLAYGAIN	4
#define	PC_LTONED_DEBUG		5
#define	PC_LVOX_UPDATE		10
#define	PC_LAGC_UPDATE		9
#define	PC_LCONFIG_8K		3
#define	PC_LCONFIG_6K		3
#define PC_LCONFIG_PACK		4
#define PC_LECHO_FORCEON	3
#define PC_LECHO_FORCEOFF	3
#define	PC_LCOMP_ADPCMRES	3
#define	PC_LECHO_INIT		3
#define PC_LCONFIG_ZEROBUF 	3
#define PC_LCONFIG_FLUSHFIFO 	3
#define PC_LECHO_ENABLE		3
#define PC_LECHO_DISABLE 	3
#define PC_LTONEG_RESET  	3
#define	PC_LCONFIG_EN2		4
//#define PC_LCONFIG_RESFA	3
#define PC_LFIXGAIN_UPDATE 	4
#define	PC_LCODEC_OFFHKSCP	3
#define	PC_LCODEC_GEN           5
#define PC_LSPI_SBRIDGE         5
#define PC_LSPI_SBRIDGE_OFF     5
#define PC_LSPI_BRIDGE          5
#define PC_LSPI_BRIDGE_OFF      5
//#define PC_LSTATION_OFF	3
//#define PC_LSTATION_ON	3
#define	PC_LRING_OFF	        4
#define	PC_LRING_ON	        4
//#define PC_LWD_ENABLE         3
//#define PC_LWD_RESET	        2
//#define PC_LURING_OFF	        3
//#define PC_LURING_ON	        3
#define	PC_LCONF_JOIN	        4 // msg,bd,p,r
#define	PC_LCONF_LEAVE	        3 // msg,bd,p
#define	PC_LLOOPBACK_ON		3
#define	PC_LLOOPBACK_OFF	3
#define	PC_LHOSTECHO_ON		3
#define	PC_LHOSTECHO_OFF	3
//#define PC_LHOSTECHO_OPT	3
#define	PC_LISDN_CALL		26
#define PC_LISDN_GET_CINFO	6
#define PC_LISDN_GET_CNAM	6
#define PC_LISDN_GET_CDNUM	6
//#define PC_LCODEC_FXSOFFHK	3
//#define PC_LCODEC_FXSONHK	3

#endif
