/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
*/

#ifndef SMARTSCOPESCLIENT_H
#define SMARTSCOPESCLIENT_H

#include <QObject>
#include <QUrl>
#include <unity.h>
#include "SmartScopesParser.h"
#include "SmartScopesPreviewParser.h"

class StringList;

class SmartScopesClient
{
public:
    SmartScopesClient(const QString &locale);
    ~SmartScopesClient();

    void search(const QString& query, const QString& sessionId, const QStringList& scopes,
                const QStringList& removedScopes,
                const QString &origin,
                const ResultHandler& resultHandler,
                const RecommendationsHandler& recommendHandler,
                UnityCancellable *cancellable);
    UnityAbstractPreview* preview(const QString& serverSid, const QString& sessionId, const QString &resultId, const UnityScopeResult& result);

    QUrl buildSearchUrl(const QString& searchString, const QStringList& scopes,
                        const QStringList& removedScopes, const QString& sessionId, const QString &origin);
    QUrl buildPreviewUrl(const QString& sessionId, const QString& resultId);

private:
    static QByteArray resultToJson(const UnityScopeResult& result);

    static const QString SERVER;
    static const QString SEARCH_URI;
    static const QString PREVIEW_URI;

    SmartScopesParser m_parser;
    SmartScopesPreviewParser m_previewParser;
    QString m_locale;
    QString m_server;
};

#endif
