/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef NOTIFICATIONDIALOG_H
#define NOTIFICATIONDIALOG_H

#include <QDialog>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QTimer>
#include <QStyleOption>
#include <QPainter>
#include <QPainterPath>

class NotificationDialog : public QDialog
{
    Q_OBJECT
private:
    QVBoxLayout *m_layout = nullptr;
    QHBoxLayout *m_topLayout = nullptr;
    QVBoxLayout *m_verLayout = nullptr;
    QPushButton *m_confirmBtn = nullptr;
    QPushButton *m_closeButton = nullptr;
    QLabel *m_tipsLabel = nullptr;
    QLabel *m_icon = nullptr;
    QLabel *m_title = nullptr;
    QTimer *m_showTimer = nullptr;
    QTimer *m_clockTimer = nullptr;

    QString m_showText;
    QString m_warningText;
    void uiInit();
    void timerInit();

protected Q_SLOTS:
    void confirmBtnClicked();
    void showTime();
    void stopTimer();

protected:
    void paintEvent(QPaintEvent *);
    bool eventFilter(QObject *watched, QEvent *event);

public:
    void start();
    void setShowMsg(QString str);
    NotificationDialog(QWidget *parent = nullptr);
    ~NotificationDialog();

Q_SIGNALS:
    void dialogClosed();
};

#endif // NOTIFICATIONDIALOG_H
