from _typeshed import SupportsRead
from collections.abc import Callable
from email.feedparser import BytesFeedParser as BytesFeedParser, FeedParser as FeedParser
from email.message import Message
from email.policy import Policy
from io import _WrappedBuffer
from typing import Generic, TypeVar, overload

__all__ = ["Parser", "HeaderParser", "BytesParser", "BytesHeaderParser", "FeedParser", "BytesFeedParser"]

_MessageT = TypeVar("_MessageT", bound=Message, default=Message)

class Parser(Generic[_MessageT]):
    @overload
    def __init__(self: Parser[Message[str, str]], _class: None = None, *, policy: Policy[Message[str, str]] = ...) -> None: ...
    @overload
    def __init__(self, _class: Callable[[], _MessageT], *, policy: Policy[_MessageT] = ...) -> None: ...
    def parse(self, fp: SupportsRead[str], headersonly: bool = False) -> _MessageT: ...
    def parsestr(self, text: str, headersonly: bool = False) -> _MessageT: ...

class HeaderParser(Parser[_MessageT]):
    def parse(self, fp: SupportsRead[str], headersonly: bool = True) -> _MessageT: ...
    def parsestr(self, text: str, headersonly: bool = True) -> _MessageT: ...

class BytesParser(Generic[_MessageT]):
    parser: Parser[_MessageT]
    @overload
    def __init__(
        self: BytesParser[Message[str, str]], _class: None = None, *, policy: Policy[Message[str, str]] = ...
    ) -> None: ...
    @overload
    def __init__(self, _class: Callable[[], _MessageT], *, policy: Policy[_MessageT] = ...) -> None: ...
    def parse(self, fp: _WrappedBuffer, headersonly: bool = False) -> _MessageT: ...
    def parsebytes(self, text: bytes | bytearray, headersonly: bool = False) -> _MessageT: ...

class BytesHeaderParser(BytesParser[_MessageT]):
    def parse(self, fp: _WrappedBuffer, headersonly: bool = True) -> _MessageT: ...
    def parsebytes(self, text: bytes | bytearray, headersonly: bool = True) -> _MessageT: ...
