## TFSA-2021-105: Crash in `tf.transpose` with complex inputs

### CVE Number
CVE-2021-29618

### Impact
Passing a complex argument to `tf.transpose` at the same time as passing
`conjugate=True` argument results in a crash:

```python
import tensorflow as tf
tf.transpose(conjugate=True, a=complex(1))
```

### Patches
We have received a patch for the issue in GitHub commit
[1dc6a7ce6e0b3e27a7ae650bfc05b195ca793f88](https://github.com/tensorflow/tensorflow/commit/1dc6a7ce6e0b3e27a7ae650bfc05b195ca793f88).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported in
[#42105](https://github.com/tensorflow/issues/42105) and fixed in
[#46973](https://github.com/tensorflow/issues/46973).
