[comment {-*- tcl -*- doctools manpage}]
[manpage_begin oometa n 0.7.2]
[keywords TOOL]
[copyright {2015 Sean Woods <yoda@etoyoc.com>}]
[moddesc   {Data registry for TclOO frameworks}]
[titledesc {oo::meta A data registry for classess}]
[category TclOO]
[keywords TclOO]
[description]

The [cmd oo::meta] package provides a data registry service for TclOO classes.

[section Usage]

[example {
oo::class create animal {
  meta set biodata animal: 1
}
oo::class create mammal {
  superclass animal
  meta set biodata mammal: 1
}
oo::class create cat {
  superclass mammal
  meta set biodata diet: carnivore
}

cat create felix
puts [felix meta dump biodata]
> animal: 1 mammal: 1 diet: carnivore

felix meta set biodata likes: {birds mice}
puts [felix meta get biodata]
> animal: 1 mammal: 1 diet: carnivore likes: {bird mice}

# Modify a class
mammal meta set biodata metabolism: warm-blooded
puts [felix meta get biodata]
> animal: 1 mammal: 1 metabolism: warm-blooded diet: carnivore likes: {birds mice}

# Overwrite class info
felix meta set biodata mammal: yes
puts [felix meta get biodata]
> animal: 1 mammal: yes metabolism: warm-blooded diet: carnivore likes: {birds mice}
}]
[section Concept]
The concept behind [cmd oo::meta] is that each class contributes a snippet of [emph local] data.
When [cmd oo::meta::metadata] is called, the system walks through the linear ancestry produced by
[cmd oo::meta::ancestors], and recursively combines all of that local data for all of a class'
ancestors into a single dict.

Instances of oo::object can also combine class data with a local dict stored in the [emph meta] variable.

[section COMMANDS]

[list_begin definitions]

[call [cmd oo::meta::info]]

[cmd oo::meta::info] is intended to work on the metadata of a class in a manner similar to if the aggregate
pieces where assembled into a single dict. The system mimics all of the standard dict commands, and addes
the following:

[call [cmd {oo::meta::info branchget}] [opt [arg key]] [opt ...]]

Returns a dict representation of the element at [emph args], but with any trailing : removed from field names.

[example {
::oo::meta::info $myclass set option color {default: green widget: colorselect}
puts [::oo::meta::info $myclass get option color]
> {default: green widget: color}
puts [::oo::meta::info $myclass branchget option color]
> {default green widget color}
}]

[call [cmd {oo::meta::info branchset}] [opt [arg key...]] [arg key] [arg value]]

Merges [emph dict] with any other information contaned at node [opt [arg key...]], and adding a trailing :
to all field names.

[example {
::oo::meta::info $myclass branchset option color {default green widget colorselect}
puts [::oo::meta::info $myclass get option color]
> {default: green widget: color}
}]

[call [cmd {oo::meta::info dump}] [arg class]]

Returns the complete snapshot of a class metadata, as producted by [cmd oo::meta::metadata]

[call [cmd oo::meta::info] [arg class] [cmd is] [arg type] [opt [arg args]]]

Returns a boolean true or false if the element [opt [arg args]] would match [cmd {string is}] [arg type] [arg value]

[example {
::oo::meta::info $myclass set constant mammal 1
puts [::oo::meta::info $myclass is true constant mammal]
> 1
}]

[call [cmd oo::meta::info] [arg class] [cmd merge] [opt [arg dict]] [opt [arg dict]] [opt [arg ...]]]

Combines all of the arguments into a single dict, which is then stored as the new
local representation for this class.

[call [cmd oo::meta::info] [arg class] [cmd rebuild]]

Forces the meta system to destroy any cached representation of a class' metadata before
the next access to [cmd oo::meta::metadata]

[call [cmd oo::meta::metadata] [arg class]]

Returns an aggregate picture of the metadata for [arg class], combining its [emph local] data
with the [emph local] data from its ancestors.

[call [cmd {oo::define meta}]]

The package injects a command [cmd oo::define::meta] which works to provide a class in the
process of definition access to [cmd oo::meta::info], but without having to look the name up.

[example {
oo::define myclass {
  meta set foo bar: baz
}
}]

[call [cmd {oo::class method meta}]]

The package injects a new method [cmd meta] into [cmd oo::class] which works to provide a class
instance access to [cmd oo::meta::info].

[call [cmd {oo::object method meta}]]

The package injects a new method [cmd meta] into [cmd oo::object]. [cmd oo::object] combines the data
for its class (as provided by [cmd oo::meta::metadata]), with a local variable [emph meta] to
produce a local picture of metadata.

This method provides the following additional commands:

[call [cmd {oo::object method meta cget}] [opt [arg field]] [opt [arg ...]] [arg field]]

Attempts to locate a singlar leaf, and return its value. For single option lookups, this
is faster than [cmd {my meta getnull}] [opt [arg field]] [opt [arg ...]] [arg field]], because
it performs a search instead directly instead of producing the recursive merge product
between the class metadata, the local [emph meta] variable, and THEN performing the search.

[list_end]

[vset CATEGORY tcloo]
[include ../common-text/feedback.inc]
[manpage_end]

