from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


STYLE = _Mock()

create_window = _Mock()

customize_shape = _Mock()

make = _Mock()

osp = _Mock()

style_generator = _Mock()

test = _Mock()

update_style_attr = _Mock()

SHOW = _Mock()

class EllipseTool(_Mock):
  pass
  AVOID_NULL_SHAPE = False
  CURSOR = 2
  ICON = u'ellipse_shape.png'
  SHAPE_STYLE_KEY = u'shape/drag'
  SHAPE_STYLE_SECT = u'plot'
  SWITCH_TO_DEFAULT_TOOL = False
  TITLE = u'Ellipse'

class FreeFormTool(_Mock):
  pass
  CURSOR = 0
  ICON = u'freeform.png'
  SWITCH_TO_DEFAULT_TOOL = False
  TITLE = u'Free form'

class ImageDialog(_Mock):
  pass
  Accepted = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rejected = 0

class MultiLineTool(_Mock):
  pass
  CURSOR = 0
  ICON = u'polyline.png'
  SWITCH_TO_DEFAULT_TOOL = False
  TITLE = u'Polyline'

class RectangleTool(_Mock):
  pass
  AVOID_NULL_SHAPE = False
  CURSOR = 2
  ICON = u'rectangle.png'
  SHAPE_STYLE_KEY = u'shape/drag'
  SHAPE_STYLE_SECT = u'plot'
  SWITCH_TO_DEFAULT_TOOL = False
  TITLE = u'Rectangle'

class SegmentTool(_Mock):
  pass
  AVOID_NULL_SHAPE = False
  CURSOR = 2
  ICON = u'segment.png'
  SHAPE_STYLE_KEY = u'shape/segment'
  SHAPE_STYLE_SECT = u'plot'
  SWITCH_TO_DEFAULT_TOOL = False
  TITLE = u'Segment'

