/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  5.5.7.cpp -- Test code snipped from IEEE Std 1666-2023 LRM 

  Original Author: Andy Goodrich, Accellera Systems Initiative

 *****************************************************************************/

#include <systemc>

int f1() { std::cout << "f1()" << std::endl; return 0; }
int f2() { std::cout << "f2()" << std::endl; return 0; }
int f3() { std::cout << "f3()" << std::endl; return 0; }

SC_MODULE(M)
{
    SC_CTOR(M)
    {
        SC_THREAD(spawner);
    }
    void spawner()
    {
	using namespace sc_core;
	sc_process_handle h1, h2, h3;

	std::cout << "spawner() entry" << std::endl;
	SC_FORK
	    h1 = sc_spawn(&f1),
	    h2 = sc_spawn(&f2),
	    h3 = sc_spawn(&f3)
	SC_JOIN
	std::cout << "spawner() exit" << std::endl;
    }
};

int sc_main( int argc, char* argv[] ) { 

    M m("m");

    sc_start(20, sc_core::SC_NS);
    std::cout << "program completed" << std::endl;
    return 0;
}
