"""
The contents of this file are the return value of
``sympy.assumptions.ask.compute_known_facts``.  Do NOT manually
edit this file.  Instead, run ./bin/ask_update.py.
"""

from sympy.logic.boolalg import And, Not, Or
from sympy.assumptions.ask import Q

# -{ Known facts in CNF }-
known_facts_cnf = And(
    Or(Q.invertible, Q.singular),
    Or(Not(Q.rational), Q.algebraic),
    Or(Not(Q.imaginary), Q.antihermitian),
    Or(Not(Q.algebraic), Q.complex),
    Or(Not(Q.imaginary), Q.complex),
    Or(Not(Q.real), Q.complex),
    Or(Not(Q.real_elements), Q.complex_elements),
    Or(Not(Q.zero), Q.even),
    Or(Not(Q.infinity), Q.extended_real),
    Or(Not(Q.real), Q.extended_real),
    Or(Not(Q.invertible), Q.fullrank),
    Or(Not(Q.real), Q.hermitian),
    Or(Not(Q.even), Q.integer),
    Or(Not(Q.odd), Q.integer),
    Or(Not(Q.prime), Q.integer),
    Or(Not(Q.positive_definite), Q.invertible),
    Or(Not(Q.unitary), Q.invertible),
    Or(Not(Q.diagonal), Q.lower_triangular),
    Or(Not(Q.negative), Q.nonzero),
    Or(Not(Q.positive), Q.nonzero),
    Or(Not(Q.diagonal), Q.normal),
    Or(Not(Q.unitary), Q.normal),
    Or(Not(Q.prime), Q.positive),
    Or(Not(Q.orthogonal), Q.positive_definite),
    Or(Not(Q.integer), Q.rational),
    Or(Not(Q.irrational), Q.real),
    Or(Not(Q.nonnegative), Q.real),
    Or(Not(Q.nonpositive), Q.real),
    Or(Not(Q.nonzero), Q.real),
    Or(Not(Q.rational), Q.real),
    Or(Not(Q.zero), Q.real),
    Or(Not(Q.integer_elements), Q.real_elements),
    Or(Not(Q.invertible), Q.square),
    Or(Not(Q.normal), Q.square),
    Or(Not(Q.symmetric), Q.square),
    Or(Not(Q.diagonal), Q.symmetric),
    Or(Not(Q.lower_triangular), Q.triangular),
    Or(Not(Q.unit_triangular), Q.triangular),
    Or(Not(Q.upper_triangular), Q.triangular),
    Or(Not(Q.orthogonal), Q.unitary),
    Or(Not(Q.diagonal), Q.upper_triangular),
    Or(Not(Q.antihermitian), Not(Q.hermitian)),
    Or(Not(Q.composite), Not(Q.prime)),
    Or(Not(Q.even), Not(Q.odd)),
    Or(Not(Q.imaginary), Not(Q.real)),
    Or(Not(Q.invertible), Not(Q.singular)),
    Or(Not(Q.irrational), Not(Q.rational)),
    Or(Not(Q.negative), Not(Q.nonnegative)),
    Or(Not(Q.negative), Not(Q.positive)),
    Or(Not(Q.nonpositive), Not(Q.positive)),
    Or(Not(Q.nonzero), Not(Q.zero)),
    Or(Not(Q.integer), Q.even, Q.odd),
    Or(Not(Q.extended_real), Q.infinity, Q.real),
    Or(Not(Q.real), Q.irrational, Q.rational),
    Or(Not(Q.triangular), Q.lower_triangular, Q.upper_triangular),
    Or(Not(Q.real), Q.negative, Q.nonnegative),
    Or(Not(Q.nonzero), Q.negative, Q.positive),
    Or(Not(Q.real), Q.nonpositive, Q.positive),
    Or(Not(Q.real), Q.nonzero, Q.zero),
    Or(Not(Q.lower_triangular), Not(Q.upper_triangular), Q.diagonal),
    Or(Not(Q.fullrank), Not(Q.square), Q.invertible),
    Or(Not(Q.real), Not(Q.unitary), Q.orthogonal),
    Or(Not(Q.integer), Not(Q.positive), Q.composite, Q.prime)
)

# -{ Known facts in compressed sets }-
known_facts_dict = {
    Q.algebraic: set([Q.algebraic, Q.complex]),
    Q.antihermitian: set([Q.antihermitian]),
    Q.bounded: set([Q.bounded]),
    Q.commutative: set([Q.commutative]),
    Q.complex: set([Q.complex]),
    Q.complex_elements: set([Q.complex_elements]),
    Q.composite: set([Q.composite]),
    Q.diagonal: set([Q.diagonal, Q.lower_triangular, Q.normal, Q.square,
        Q.symmetric, Q.triangular, Q.upper_triangular]),
    Q.even: set([Q.algebraic, Q.complex, Q.even, Q.extended_real,
        Q.hermitian, Q.integer, Q.rational, Q.real]),
    Q.extended_real: set([Q.extended_real]),
    Q.fullrank: set([Q.fullrank]),
    Q.hermitian: set([Q.hermitian]),
    Q.imaginary: set([Q.antihermitian, Q.complex, Q.imaginary]),
    Q.infinitesimal: set([Q.infinitesimal]),
    Q.infinity: set([Q.extended_real, Q.infinity]),
    Q.integer: set([Q.algebraic, Q.complex, Q.extended_real, Q.hermitian,
        Q.integer, Q.rational, Q.real]),
    Q.integer_elements: set([Q.complex_elements, Q.integer_elements,
        Q.real_elements]),
    Q.invertible: set([Q.fullrank, Q.invertible, Q.square]),
    Q.irrational: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.irrational, Q.nonzero, Q.real]),
    Q.is_true: set([Q.is_true]),
    Q.lower_triangular: set([Q.lower_triangular, Q.triangular]),
    Q.negative: set([Q.complex, Q.extended_real, Q.hermitian, Q.negative,
        Q.nonpositive, Q.nonzero, Q.real]),
    Q.nonnegative: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonnegative, Q.real]),
    Q.nonpositive: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonpositive, Q.real]),
    Q.nonzero: set([Q.complex, Q.extended_real, Q.hermitian, Q.nonzero,
        Q.real]),
    Q.normal: set([Q.normal, Q.square]),
    Q.odd: set([Q.algebraic, Q.complex, Q.extended_real, Q.hermitian,
        Q.integer, Q.nonzero, Q.odd, Q.rational, Q.real]),
    Q.orthogonal: set([Q.fullrank, Q.invertible, Q.normal, Q.orthogonal,
        Q.positive_definite, Q.square, Q.unitary]),
    Q.positive: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonnegative, Q.nonzero, Q.positive, Q.real]),
    Q.positive_definite: set([Q.fullrank, Q.invertible,
        Q.positive_definite, Q.square]),
    Q.prime: set([Q.algebraic, Q.complex, Q.extended_real, Q.hermitian,
        Q.integer, Q.nonnegative, Q.nonzero, Q.positive, Q.prime,
        Q.rational, Q.real]),
    Q.rational: set([Q.algebraic, Q.complex, Q.extended_real, Q.hermitian,
        Q.rational, Q.real]),
    Q.real: set([Q.complex, Q.extended_real, Q.hermitian, Q.real]),
    Q.real_elements: set([Q.complex_elements, Q.real_elements]),
    Q.singular: set([Q.singular]),
    Q.square: set([Q.square]),
    Q.symmetric: set([Q.square, Q.symmetric]),
    Q.triangular: set([Q.triangular]),
    Q.unit_triangular: set([Q.triangular, Q.unit_triangular]),
    Q.unitary: set([Q.fullrank, Q.invertible, Q.normal, Q.square,
        Q.unitary]),
    Q.upper_triangular: set([Q.triangular, Q.upper_triangular]),
    Q.zero: set([Q.algebraic, Q.complex, Q.even, Q.extended_real,
        Q.hermitian, Q.integer, Q.nonnegative, Q.nonpositive,
        Q.rational, Q.real, Q.zero]),
}
