// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef PTV_TOOLS_IS_INCLUDED
#define PTV_TOOLS_IS_INCLUDED

#include "Ptv.h"
#include <vector>

using namespace std;

namespace SyFi
{

	void sort_vector(vector<Ptv>& a);

	void set_tolerance(double tolerance);

	double mul(const Ptv&a, const Ptv& b);

	double norm(const Ptv& a);

	void normalize(Ptv& a);

	void add(const Ptv&a, const Ptv& b, Ptv& c);

	void sub(const Ptv&a, const Ptv& b, Ptv& c);

	void cross(const Ptv& a, const Ptv& b, Ptv& c);

	bool is_equal(Ptv& a, Ptv& b);

	bool line_contains(Ptv& e0, Ptv& e1, Ptv& p);

	bool is_inside_triangle(Ptv& e0, Ptv& e1, Ptv& e2, Ptv& p);

	bool contains2D(Ptv& e0, Ptv& e1, Ptv& p);

	bool contains3D(Ptv& e0, Ptv& e1, Ptv& e2, Ptv& p);

}								 // namespace SyFi
#endif
