//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2022-2025 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// This was auto-generated by utils/gen-unicode-data/GenScripts,
// please do not edit this file yourself!

#ifndef SCRIPT_DATA_H
#define SCRIPT_DATA_H

#include "stdint.h"

#define SCRIPTS_COUNT 1709

static const uint32_t _swift_stdlib_scripts[1709] = {
  0x3000000, 0x9200041, 0x300005B, 0x9200061, 0x300007B, 0x92000AA, 0x30000AB, 0x92000BA, 0x30000BB,
  0x92000C0, 0x30000D7, 0x92000D8, 0x30000F7, 0x92000F8, 0x30002B9, 0x92002E0, 0x30002E5, 0x18002EA,
  0x30002EC, 0x7200300, 0x5800370, 0x3000374, 0x5800375, 0x14800378, 0x580037A, 0x300037E,
  0x580037F, 0x14800380, 0x5800384, 0x3000385, 0x5800386, 0x3000387, 0x5800388, 0x1480038B,
  0x580038C, 0x1480038D, 0x580038E, 0x148003A2, 0x58003A3, 0x32003E2, 0x58003F0, 0x3800400,
  0x7200485, 0x3800487, 0x14800530, 0x800531, 0x14800557, 0x800559, 0x1480058B, 0x80058D,
  0x14800590, 0x6C00591, 0x148005C8, 0x6C005D0, 0x148005EB, 0x6C005EF, 0x148005F5, 0x600600,
  0x3000605, 0x600606, 0x300060C, 0x60060D, 0x300061B, 0x60061C, 0x300061F, 0x600620, 0x3000640,
  0x600641, 0x720064B, 0x600656, 0x7200670, 0x600671, 0x30006DD, 0x6006DE, 0x12000700, 0x1480070E,
  0x1200070F, 0x1480074B, 0x1200074D, 0x600750, 0x13600780, 0x148007B2, 0xD2007C0, 0x148007FB,
  0xD2007FD, 0x10600800, 0x1480082E, 0x10600830, 0x1480083F, 0xAA00840, 0x1480085C, 0xAA0085E,
  0x1480085F, 0x12000860, 0x1480086B, 0x600870, 0x1480088F, 0x600890, 0x14800892, 0x600897,
  0x30008E2, 0x6008E3, 0x3E00900, 0x7200951, 0x3E00955, 0x3000964, 0x3E00966, 0x1400980, 0x14800984,
  0x1400985, 0x1480098D, 0x140098F, 0x14800991, 0x1400993, 0x148009A9, 0x14009AA, 0x148009B1,
  0x14009B2, 0x148009B3, 0x14009B6, 0x148009BA, 0x14009BC, 0x148009C5, 0x14009C7, 0x148009C9,
  0x14009CB, 0x148009CF, 0x14009D7, 0x148009D8, 0x14009DC, 0x148009DE, 0x14009DF, 0x148009E4,
  0x14009E6, 0x148009FF, 0x5E00A01, 0x14800A04, 0x5E00A05, 0x14800A0B, 0x5E00A0F, 0x14800A11,
  0x5E00A13, 0x14800A29, 0x5E00A2A, 0x14800A31, 0x5E00A32, 0x14800A34, 0x5E00A35, 0x14800A37,
  0x5E00A38, 0x14800A3A, 0x5E00A3C, 0x14800A3D, 0x5E00A3E, 0x14800A43, 0x5E00A47, 0x14800A49,
  0x5E00A4B, 0x14800A4E, 0x5E00A51, 0x14800A52, 0x5E00A59, 0x14800A5D, 0x5E00A5E, 0x14800A5F,
  0x5E00A66, 0x14800A77, 0x5A00A81, 0x14800A84, 0x5A00A85, 0x14800A8E, 0x5A00A8F, 0x14800A92,
  0x5A00A93, 0x14800AA9, 0x5A00AAA, 0x14800AB1, 0x5A00AB2, 0x14800AB4, 0x5A00AB5, 0x14800ABA,
  0x5A00ABC, 0x14800AC6, 0x5A00AC7, 0x14800ACA, 0x5A00ACB, 0x14800ACE, 0x5A00AD0, 0x14800AD1,
  0x5A00AE0, 0x14800AE4, 0x5A00AE6, 0x14800AF2, 0x5A00AF9, 0x14800B00, 0xF000B01, 0x14800B04,
  0xF000B05, 0x14800B0D, 0xF000B0F, 0x14800B11, 0xF000B13, 0x14800B29, 0xF000B2A, 0x14800B31,
  0xF000B32, 0x14800B34, 0xF000B35, 0x14800B3A, 0xF000B3C, 0x14800B45, 0xF000B47, 0x14800B49,
  0xF000B4B, 0x14800B4E, 0xF000B55, 0x14800B58, 0xF000B5C, 0x14800B5E, 0xF000B5F, 0x14800B64,
  0xF000B66, 0x14800B78, 0x12E00B82, 0x14800B84, 0x12E00B85, 0x14800B8B, 0x12E00B8E, 0x14800B91,
  0x12E00B92, 0x14800B96, 0x12E00B99, 0x14800B9B, 0x12E00B9C, 0x14800B9D, 0x12E00B9E, 0x14800BA0,
  0x12E00BA3, 0x14800BA5, 0x12E00BA8, 0x14800BAB, 0x12E00BAE, 0x14800BBA, 0x12E00BBE, 0x14800BC3,
  0x12E00BC6, 0x14800BC9, 0x12E00BCA, 0x14800BCE, 0x12E00BD0, 0x14800BD1, 0x12E00BD7, 0x14800BD8,
  0x12E00BE6, 0x14800BFB, 0x13400C00, 0x14800C0D, 0x13400C0E, 0x14800C11, 0x13400C12, 0x14800C29,
  0x13400C2A, 0x14800C3A, 0x13400C3C, 0x14800C45, 0x13400C46, 0x14800C49, 0x13400C4A, 0x14800C4E,
  0x13400C55, 0x14800C57, 0x13400C58, 0x14800C5B, 0x13400C5D, 0x14800C5E, 0x13400C60, 0x14800C64,
  0x13400C66, 0x14800C70, 0x13400C77, 0x7C00C80, 0x14800C8D, 0x7C00C8E, 0x14800C91, 0x7C00C92,
  0x14800CA9, 0x7C00CAA, 0x14800CB4, 0x7C00CB5, 0x14800CBA, 0x7C00CBC, 0x14800CC5, 0x7C00CC6,
  0x14800CC9, 0x7C00CCA, 0x14800CCE, 0x7C00CD5, 0x14800CD7, 0x7C00CDD, 0x14800CDF, 0x7C00CE0,
  0x14800CE4, 0x7C00CE6, 0x14800CF0, 0x7C00CF1, 0x14800CF4, 0xA800D00, 0x14800D0D, 0xA800D0E,
  0x14800D11, 0xA800D12, 0x14800D45, 0xA800D46, 0x14800D49, 0xA800D4A, 0x14800D50, 0xA800D54,
  0x14800D64, 0xA800D66, 0x14800D80, 0x11200D81, 0x14800D84, 0x11200D85, 0x14800D97, 0x11200D9A,
  0x14800DB2, 0x11200DB3, 0x14800DBC, 0x11200DBD, 0x14800DBE, 0x11200DC0, 0x14800DC7, 0x11200DCA,
  0x14800DCB, 0x11200DCF, 0x14800DD5, 0x11200DD6, 0x14800DD7, 0x11200DD8, 0x14800DE0, 0x11200DE6,
  0x14800DF0, 0x11200DF2, 0x14800DF5, 0x13800E01, 0x14800E3B, 0x3000E3F, 0x13800E40, 0x14800E5C,
  0x9000E81, 0x14800E83, 0x9000E84, 0x14800E85, 0x9000E86, 0x14800E8B, 0x9000E8C, 0x14800EA4,
  0x9000EA5, 0x14800EA6, 0x9000EA7, 0x14800EBE, 0x9000EC0, 0x14800EC5, 0x9000EC6, 0x14800EC7,
  0x9000EC8, 0x14800ECF, 0x9000ED0, 0x14800EDA, 0x9000EDC, 0x14800EE0, 0x13A00F00, 0x14800F48,
  0x13A00F49, 0x14800F6D, 0x13A00F71, 0x14800F98, 0x13A00F99, 0x14800FBD, 0x13A00FBE, 0x14800FCD,
  0x13A00FCE, 0x3000FD5, 0x13A00FD9, 0x14800FDB, 0xC601000, 0x50010A0, 0x148010C6, 0x50010C7,
  0x148010C8, 0x50010CD, 0x148010CE, 0x50010D0, 0x30010FB, 0x50010FC, 0x6401100, 0x4C01200,
  0x14801249, 0x4C0124A, 0x1480124E, 0x4C01250, 0x14801257, 0x4C01258, 0x14801259, 0x4C0125A,
  0x1480125E, 0x4C01260, 0x14801289, 0x4C0128A, 0x1480128E, 0x4C01290, 0x148012B1, 0x4C012B2,
  0x148012B6, 0x4C012B8, 0x148012BF, 0x4C012C0, 0x148012C1, 0x4C012C2, 0x148012C6, 0x4C012C8,
  0x148012D7, 0x4C012D8, 0x14801311, 0x4C01312, 0x14801316, 0x4C01318, 0x1480135B, 0x4C0135D,
  0x1480137D, 0x4C01380, 0x1480139A, 0x2C013A0, 0x148013F6, 0x2C013F8, 0x148013FE, 0x2201400,
  0xD801680, 0x1480169D, 0x104016A0, 0x30016EB, 0x104016EE, 0x148016F9, 0x12201700, 0x14801716,
  0x1220171F, 0x6801720, 0x3001735, 0x14801737, 0x2001740, 0x14801754, 0x12401760, 0x1480176D,
  0x1240176E, 0x14801771, 0x12401772, 0x14801774, 0x8A01780, 0x148017DE, 0x8A017E0, 0x148017EA,
  0x8A017F0, 0x148017FA, 0xC001800, 0x3001802, 0xC001804, 0x3001805, 0xC001806, 0x1480181A,
  0xC001820, 0x14801879, 0xC001880, 0x148018AB, 0x22018B0, 0x148018F6, 0x9601900, 0x1480191F,
  0x9601920, 0x1480192C, 0x9601930, 0x1480193C, 0x9601940, 0x14801941, 0x9601944, 0x12601950,
  0x1480196E, 0x12601970, 0x14801975, 0xD001980, 0x148019AC, 0xD0019B0, 0x148019CA, 0xD0019D0,
  0x148019DB, 0xD0019DE, 0x8A019E0, 0x1E01A00, 0x14801A1C, 0x1E01A1E, 0x12801A20, 0x14801A5F,
  0x12801A60, 0x14801A7D, 0x12801A7F, 0x14801A8A, 0x12801A90, 0x14801A9A, 0x12801AA0, 0x14801AAE,
  0x7201AB0, 0x14801ACF, 0xC01B00, 0x14801B4D, 0xC01B4E, 0x11A01B80, 0x1201BC0, 0x14801BF4,
  0x1201BFC, 0x9401C00, 0x14801C38, 0x9401C3B, 0x14801C4A, 0x9401C4D, 0xDA01C50, 0x3801C80,
  0x14801C8B, 0x5001C90, 0x14801CBB, 0x5001CBD, 0x11A01CC0, 0x14801CC8, 0x7201CD0, 0x3001CD3,
  0x7201CD4, 0x3001CE1, 0x7201CE2, 0x3001CE9, 0x7201CED, 0x3001CEE, 0x7201CF4, 0x3001CF5, 0x7201CF8,
  0x3001CFA, 0x14801CFB, 0x9201D00, 0x5801D26, 0x3801D2B, 0x9201D2C, 0x5801D5D, 0x9201D62,
  0x5801D66, 0x9201D6B, 0x3801D78, 0x9201D79, 0x5801DBF, 0x7201DC0, 0x9201E00, 0x5801F00,
  0x14801F16, 0x5801F18, 0x14801F1E, 0x5801F20, 0x14801F46, 0x5801F48, 0x14801F4E, 0x5801F50,
  0x14801F58, 0x5801F59, 0x14801F5A, 0x5801F5B, 0x14801F5C, 0x5801F5D, 0x14801F5E, 0x5801F5F,
  0x14801F7E, 0x5801F80, 0x14801FB5, 0x5801FB6, 0x14801FC5, 0x5801FC6, 0x14801FD4, 0x5801FD6,
  0x14801FDC, 0x5801FDD, 0x14801FF0, 0x5801FF2, 0x14801FF5, 0x5801FF6, 0x14801FFF, 0x3002000,
  0x720200C, 0x300200E, 0x14802065, 0x3002066, 0x9202071, 0x14802072, 0x3002074, 0x920207F,
  0x3002080, 0x1480208F, 0x9202090, 0x1480209D, 0x30020A0, 0x148020C1, 0x72020D0, 0x148020F1,
  0x3002100, 0x5802126, 0x3002127, 0x920212A, 0x300212C, 0x9202132, 0x3002133, 0x920214E, 0x300214F,
  0x9202160, 0x3002189, 0x1480218C, 0x3002190, 0x1480242A, 0x3002440, 0x1480244B, 0x3002460,
  0x1C02800, 0x3002900, 0x14802B74, 0x3002B76, 0x14802B96, 0x3002B97, 0x5202C00, 0x9202C60,
  0x3202C80, 0x14802CF4, 0x3202CF9, 0x5002D00, 0x14802D26, 0x5002D27, 0x14802D28, 0x5002D2D,
  0x14802D2E, 0x13C02D30, 0x14802D68, 0x13C02D6F, 0x14802D71, 0x13C02D7F, 0x4C02D80, 0x14802D97,
  0x4C02DA0, 0x14802DA7, 0x4C02DA8, 0x14802DAF, 0x4C02DB0, 0x14802DB7, 0x4C02DB8, 0x14802DBF,
  0x4C02DC0, 0x14802DC7, 0x4C02DC8, 0x14802DCF, 0x4C02DD0, 0x14802DD7, 0x4C02DD8, 0x14802DDF,
  0x3802DE0, 0x3002E00, 0x14802E5E, 0x6202E80, 0x14802E9A, 0x6202E9B, 0x14802EF4, 0x6202F00,
  0x14802FD6, 0x3002FF0, 0x6203005, 0x3003006, 0x6203007, 0x3003008, 0x6203021, 0x720302A,
  0x640302E, 0x3003030, 0x6203038, 0x300303C, 0x14803040, 0x6E03041, 0x14803097, 0x7203099,
  0x300309B, 0x6E0309D, 0x30030A0, 0x7E030A1, 0x30030FB, 0x7E030FD, 0x14803100, 0x1803105,
  0x14803130, 0x6403131, 0x1480318F, 0x3003190, 0x18031A0, 0x30031C0, 0x148031E6, 0x30031EF,
  0x7E031F0, 0x6403200, 0x1480321F, 0x3003220, 0x6403260, 0x300327F, 0x7E032D0, 0x30032FF,
  0x7E03300, 0x3003358, 0x6203400, 0x3004DC0, 0x6204E00, 0x1540A000, 0x1480A48D, 0x1540A490,
  0x1480A4C7, 0x9C0A4D0, 0x14A0A500, 0x1480A62C, 0x380A640, 0xE0A6A0, 0x1480A6F8, 0x300A700,
  0x920A722, 0x300A788, 0x920A78B, 0x1480A7CE, 0x920A7D0, 0x1480A7D2, 0x920A7D3, 0x1480A7D4,
  0x920A7D5, 0x1480A7DD, 0x920A7F2, 0x11E0A800, 0x1480A82D, 0x300A830, 0x1480A83A, 0xFC0A840,
  0x1480A878, 0x1080A880, 0x1480A8C6, 0x1080A8CE, 0x1480A8DA, 0x3E0A8E0, 0x840A900, 0x300A92E,
  0x840A92F, 0x1020A930, 0x1480A954, 0x1020A95F, 0x640A960, 0x1480A97D, 0x780A980, 0x1480A9CE,
  0x300A9CF, 0x780A9D0, 0x1480A9DA, 0x780A9DE, 0xC60A9E0, 0x1480A9FF, 0x2A0AA00, 0x1480AA37,
  0x2A0AA40, 0x1480AA4E, 0x2A0AA50, 0x1480AA5A, 0x2A0AA5C, 0xC60AA60, 0x12A0AA80, 0x1480AAC3,
  0x12A0AADB, 0xB40AAE0, 0x1480AAF7, 0x4C0AB01, 0x1480AB07, 0x4C0AB09, 0x1480AB0F, 0x4C0AB11,
  0x1480AB17, 0x4C0AB20, 0x1480AB27, 0x4C0AB28, 0x1480AB2F, 0x920AB30, 0x300AB5B, 0x920AB5C,
  0x580AB65, 0x920AB66, 0x300AB6A, 0x1480AB6C, 0x2C0AB70, 0xB40ABC0, 0x1480ABEE, 0xB40ABF0,
  0x1480ABFA, 0x640AC00, 0x1480D7A4, 0x640D7B0, 0x1480D7C7, 0x640D7CB, 0x1480D7FC, 0x1480E000,
  0x620F900, 0x1480FA6E, 0x620FA70, 0x1480FADA, 0x920FB00, 0x1480FB07, 0x80FB13, 0x1480FB18,
  0x6C0FB1D, 0x1480FB37, 0x6C0FB38, 0x1480FB3D, 0x6C0FB3E, 0x1480FB3F, 0x6C0FB40, 0x1480FB42,
  0x6C0FB43, 0x1480FB45, 0x6C0FB46, 0x60FB50, 0x1480FBC3, 0x60FBD3, 0x300FD3E, 0x60FD40, 0x1480FD90,
  0x60FD92, 0x1480FDC8, 0x60FDCF, 0x1480FDD0, 0x60FDF0, 0x720FE00, 0x300FE10, 0x1480FE1A, 0x720FE20,
  0x380FE2E, 0x300FE30, 0x1480FE53, 0x300FE54, 0x1480FE67, 0x300FE68, 0x1480FE6C, 0x60FE70,
  0x1480FE75, 0x60FE76, 0x1480FEFD, 0x300FEFF, 0x1480FF00, 0x300FF01, 0x920FF21, 0x300FF3B,
  0x920FF41, 0x300FF5B, 0x7E0FF66, 0x300FF70, 0x7E0FF71, 0x300FF9E, 0x640FFA0, 0x1480FFBF,
  0x640FFC2, 0x1480FFC8, 0x640FFCA, 0x1480FFD0, 0x640FFD2, 0x1480FFD8, 0x640FFDA, 0x1480FFDD,
  0x300FFE0, 0x1480FFE7, 0x300FFE8, 0x1480FFEF, 0x300FFF9, 0x1480FFFE, 0x9A10000, 0x1481000C,
  0x9A1000D, 0x14810027, 0x9A10028, 0x1481003B, 0x9A1003C, 0x1481003E, 0x9A1003F, 0x1481004E,
  0x9A10050, 0x1481005E, 0x9A10080, 0x148100FB, 0x3010100, 0x14810103, 0x3010107, 0x14810134,
  0x3010137, 0x5810140, 0x1481018F, 0x3010190, 0x1481019D, 0x58101A0, 0x148101A1, 0x30101D0,
  0x72101FD, 0x148101FE, 0x9E10280, 0x1481029D, 0x24102A0, 0x148102D1, 0x72102E0, 0x30102E1,
  0x148102FC, 0xDE10300, 0x14810324, 0xDE1032D, 0x5410330, 0x1481034B, 0xE210350, 0x1481037B,
  0x14610380, 0x1481039E, 0x1461039F, 0xE4103A0, 0x148103C4, 0xE4103C8, 0x148103D6, 0x3C10400,
  0x10C10450, 0xF410480, 0x1481049E, 0xF4104A0, 0x148104AA, 0xF2104B0, 0x148104D4, 0xF2104D8,
  0x148104FC, 0x4810500, 0x14810528, 0x2610530, 0x14810564, 0x261056F, 0x14C10570, 0x1481057B,
  0x14C1057C, 0x1481058B, 0x14C1058C, 0x14810593, 0x14C10594, 0x14810596, 0x14C10597, 0x148105A2,
  0x14C105A3, 0x148105B2, 0x14C105B3, 0x148105BA, 0x14C105BB, 0x148105BD, 0x140105C0, 0x148105F4,
  0x9810600, 0x14810737, 0x9810740, 0x14810756, 0x9810760, 0x14810768, 0x9210780, 0x14810786,
  0x9210787, 0x148107B1, 0x92107B2, 0x148107BB, 0x3610800, 0x14810806, 0x3610808, 0x14810809,
  0x361080A, 0x14810836, 0x3610837, 0x14810839, 0x361083C, 0x1481083D, 0x361083F, 0x7010840,
  0x14810856, 0x7010857, 0xF810860, 0xC810880, 0x1481089F, 0xC8108A7, 0x148108B0, 0x6A108E0,
  0x148108F3, 0x6A108F4, 0x148108F6, 0x6A108FB, 0xFE10900, 0x1481091C, 0xFE1091F, 0xA010920,
  0x1481093A, 0xA01093F, 0x14810940, 0xBA10980, 0xB8109A0, 0x148109B8, 0xB8109BC, 0x148109D0,
  0xB8109D2, 0x8610A00, 0x14810A04, 0x8610A05, 0x14810A07, 0x8610A0C, 0x14810A14, 0x8610A15,
  0x14810A18, 0x8610A19, 0x14810A36, 0x8610A38, 0x14810A3B, 0x8610A3F, 0x14810A49, 0x8610A50,
  0x14810A59, 0xE810A60, 0xE010A80, 0x14810AA0, 0xAC10AC0, 0x14810AE7, 0xAC10AEB, 0x14810AF7,
  0xA10B00, 0x14810B36, 0xA10B39, 0x7610B40, 0x14810B56, 0x7610B58, 0x7410B60, 0x14810B73,
  0x7410B78, 0x10010B80, 0x14810B92, 0x10010B99, 0x14810B9D, 0x10010BA9, 0x14810BB0, 0xEA10C00,
  0x14810C49, 0xDC10C80, 0x14810CB3, 0xDC10CC0, 0x14810CF3, 0xDC10CFA, 0x6610D00, 0x14810D28,
  0x6610D30, 0x14810D3A, 0x4E10D40, 0x14810D66, 0x4E10D69, 0x14810D86, 0x4E10D8E, 0x14810D90,
  0x610E60, 0x14810E7F, 0x15210E80, 0x14810EAA, 0x15210EAB, 0x14810EAE, 0x15210EB0, 0x14810EB2,
  0x610EC2, 0x14810EC5, 0x610EFC, 0xE610F00, 0x14810F28, 0x11410F30, 0x14810F5A, 0xEC10F70,
  0x14810F8A, 0x2E10FB0, 0x14810FCC, 0x4A10FE0, 0x14810FF7, 0x1A11000, 0x1481104E, 0x1A11052,
  0x14811076, 0x1A1107F, 0x7A11080, 0x148110C3, 0x7A110CD, 0x148110CE, 0x116110D0, 0x148110E9,
  0x116110F0, 0x148110FA, 0x2811100, 0x14811135, 0x2811136, 0x14811148, 0xA411150, 0x14811177,
  0x10A11180, 0x148111E0, 0x112111E1, 0x148111F5, 0x8C11200, 0x14811212, 0x8C11213, 0x14811242,
  0xC411280, 0x14811287, 0xC411288, 0x14811289, 0xC41128A, 0x1481128E, 0xC41128F, 0x1481129E,
  0xC41129F, 0x148112AA, 0x8E112B0, 0x148112EB, 0x8E112F0, 0x148112FA, 0x5611300, 0x14811304,
  0x5611305, 0x1481130D, 0x561130F, 0x14811311, 0x5611313, 0x14811329, 0x561132A, 0x14811331,
  0x5611332, 0x14811334, 0x5611335, 0x1481133A, 0x721133B, 0x561133C, 0x14811345, 0x5611347,
  0x14811349, 0x561134B, 0x1481134E, 0x5611350, 0x14811351, 0x5611357, 0x14811358, 0x561135D,
  0x14811364, 0x5611366, 0x1481136D, 0x5611370, 0x14811375, 0x14411380, 0x1481138A, 0x1441138B,
  0x1481138C, 0x1441138E, 0x1481138F, 0x14411390, 0x148113B6, 0x144113B7, 0x148113C1, 0x144113C2,
  0x148113C3, 0x144113C5, 0x148113C6, 0x144113C7, 0x148113CB, 0x144113CC, 0x148113D6, 0x144113D7,
  0x148113D9, 0x144113E1, 0x148113E3, 0xCE11400, 0x1481145C, 0xCE1145D, 0x14811462, 0x13E11480,
  0x148114C8, 0x13E114D0, 0x148114DA, 0x10E11580, 0x148115B6, 0x10E115B8, 0x148115DE, 0xBE11600,
  0x14811645, 0xBE11650, 0x1481165A, 0xC011660, 0x1481166D, 0x12C11680, 0x148116BA, 0x12C116C0,
  0x148116CA, 0xC6116D0, 0x148116E4, 0x211700, 0x1481171B, 0x21171D, 0x1481172C, 0x211730,
  0x14811747, 0x4211800, 0x1481183C, 0x150118A0, 0x148118F3, 0x150118FF, 0x4011900, 0x14811907,
  0x4011909, 0x1481190A, 0x401190C, 0x14811914, 0x4011915, 0x14811917, 0x4011918, 0x14811936,
  0x4011937, 0x14811939, 0x401193B, 0x14811947, 0x4011950, 0x1481195A, 0xCC119A0, 0x148119A8,
  0xCC119AA, 0x148119D8, 0xCC119DA, 0x148119E5, 0x15611A00, 0x14811A48, 0x11811A50, 0x14811AA3,
  0x2211AB0, 0xFA11AC0, 0x14811AF9, 0x3E11B00, 0x14811B0A, 0x11C11BC0, 0x14811BE2, 0x11C11BF0,
  0x14811BFA, 0x1611C00, 0x14811C09, 0x1611C0A, 0x14811C37, 0x1611C38, 0x14811C46, 0x1611C50,
  0x14811C6D, 0xAE11C70, 0x14811C90, 0xAE11C92, 0x14811CA8, 0xAE11CA9, 0x14811CB7, 0xB011D00,
  0x14811D07, 0xB011D08, 0x14811D0A, 0xB011D0B, 0x14811D37, 0xB011D3A, 0x14811D3B, 0xB011D3C,
  0x14811D3E, 0xB011D3F, 0x14811D48, 0xB011D50, 0x14811D5A, 0x5C11D60, 0x14811D66, 0x5C11D67,
  0x14811D69, 0x5C11D6A, 0x14811D8F, 0x5C11D90, 0x14811D92, 0x5C11D93, 0x14811D99, 0x5C11DA0,
  0x14811DAA, 0xA611EE0, 0x14811EF9, 0x8211F00, 0x14811F11, 0x8211F12, 0x14811F3B, 0x8211F3E,
  0x14811F5B, 0x9C11FB0, 0x14811FB1, 0x12E11FC0, 0x14811FF2, 0x12E11FFF, 0x3412000, 0x1481239A,
  0x3412400, 0x1481246F, 0x3412470, 0x14812475, 0x3412480, 0x14812544, 0x3A12F90, 0x14812FF3,
  0x4613000, 0x14813456, 0x4613460, 0x148143FB, 0x414400, 0x14814647, 0x6016100, 0x1481613A,
  0xE16800, 0x14816A39, 0xC216A40, 0x14816A5F, 0xC216A60, 0x14816A6A, 0xC216A6E, 0x13016A70,
  0x14816ABF, 0x13016AC0, 0x14816ACA, 0x1016AD0, 0x14816AEE, 0x1016AF0, 0x14816AF6, 0xF616B00,
  0x14816B46, 0xF616B50, 0x14816B5A, 0xF616B5B, 0x14816B62, 0xF616B63, 0x14816B78, 0xF616B7D,
  0x14816B90, 0xA216D40, 0x14816D7A, 0xB216E40, 0x14816E9B, 0xBC16F00, 0x14816F4B, 0xBC16F4F,
  0x14816F88, 0xBC16F8F, 0x14816FA0, 0x13216FE0, 0xD416FE1, 0x6216FE2, 0x8816FE4, 0x14816FE5,
  0x6216FF0, 0x14816FF2, 0x13217000, 0x148187F8, 0x13218800, 0x8818B00, 0x14818CD6, 0x8818CFF,
  0x13218D00, 0x14818D09, 0x7E1AFF0, 0x1481AFF4, 0x7E1AFF5, 0x1481AFFC, 0x7E1AFFD, 0x1481AFFF,
  0x7E1B000, 0x6E1B001, 0x7E1B120, 0x1481B123, 0x6E1B132, 0x1481B133, 0x6E1B150, 0x1481B153,
  0x7E1B155, 0x1481B156, 0x7E1B164, 0x1481B168, 0xD41B170, 0x1481B2FC, 0x441BC00, 0x1481BC6B,
  0x441BC70, 0x1481BC7D, 0x441BC80, 0x1481BC89, 0x441BC90, 0x1481BC9A, 0x441BC9C, 0x301BCA0,
  0x1481BCA4, 0x301CC00, 0x1481CCFA, 0x301CD00, 0x1481CEB4, 0x721CF00, 0x1481CF2E, 0x721CF30,
  0x1481CF47, 0x301CF50, 0x1481CFC4, 0x301D000, 0x1481D0F6, 0x301D100, 0x1481D127, 0x301D129,
  0x721D167, 0x301D16A, 0x721D17B, 0x301D183, 0x721D185, 0x301D18C, 0x721D1AA, 0x301D1AE,
  0x1481D1EB, 0x581D200, 0x1481D246, 0x301D2C0, 0x1481D2D4, 0x301D2E0, 0x1481D2F4, 0x301D300,
  0x1481D357, 0x301D360, 0x1481D379, 0x301D400, 0x1481D455, 0x301D456, 0x1481D49D, 0x301D49E,
  0x1481D4A0, 0x301D4A2, 0x1481D4A3, 0x301D4A5, 0x1481D4A7, 0x301D4A9, 0x1481D4AD, 0x301D4AE,
  0x1481D4BA, 0x301D4BB, 0x1481D4BC, 0x301D4BD, 0x1481D4C4, 0x301D4C5, 0x1481D506, 0x301D507,
  0x1481D50B, 0x301D50D, 0x1481D515, 0x301D516, 0x1481D51D, 0x301D51E, 0x1481D53A, 0x301D53B,
  0x1481D53F, 0x301D540, 0x1481D545, 0x301D546, 0x1481D547, 0x301D54A, 0x1481D551, 0x301D552,
  0x1481D6A6, 0x301D6A8, 0x1481D7CC, 0x301D7CE, 0x1101D800, 0x1481DA8C, 0x1101DA9B, 0x1481DAA0,
  0x1101DAA1, 0x1481DAB0, 0x921DF00, 0x1481DF1F, 0x921DF25, 0x1481DF2B, 0x521E000, 0x1481E007,
  0x521E008, 0x1481E019, 0x521E01B, 0x1481E022, 0x521E023, 0x1481E025, 0x521E026, 0x1481E02B,
  0x381E030, 0x1481E06E, 0x381E08F, 0x1481E090, 0xD61E100, 0x1481E12D, 0xD61E130, 0x1481E13E,
  0xD61E140, 0x1481E14A, 0xD61E14E, 0x1481E150, 0x1421E290, 0x1481E2AF, 0x14E1E2C0, 0x1481E2FA,
  0x14E1E2FF, 0x1481E300, 0xCA1E4D0, 0x1481E4FA, 0xEE1E5D0, 0x1481E5FB, 0xEE1E5FF, 0x1481E600,
  0x4C1E7E0, 0x1481E7E7, 0x4C1E7E8, 0x1481E7EC, 0x4C1E7ED, 0x1481E7EF, 0x4C1E7F0, 0x1481E7FF,
  0xB61E800, 0x1481E8C5, 0xB61E8C7, 0x1481E8D7, 0x1E900, 0x1481E94C, 0x1E950, 0x1481E95A, 0x1E95E,
  0x1481E960, 0x301EC71, 0x1481ECB5, 0x301ED01, 0x1481ED3E, 0x61EE00, 0x1481EE04, 0x61EE05,
  0x1481EE20, 0x61EE21, 0x1481EE23, 0x61EE24, 0x1481EE25, 0x61EE27, 0x1481EE28, 0x61EE29,
  0x1481EE33, 0x61EE34, 0x1481EE38, 0x61EE39, 0x1481EE3A, 0x61EE3B, 0x1481EE3C, 0x61EE42,
  0x1481EE43, 0x61EE47, 0x1481EE48, 0x61EE49, 0x1481EE4A, 0x61EE4B, 0x1481EE4C, 0x61EE4D,
  0x1481EE50, 0x61EE51, 0x1481EE53, 0x61EE54, 0x1481EE55, 0x61EE57, 0x1481EE58, 0x61EE59,
  0x1481EE5A, 0x61EE5B, 0x1481EE5C, 0x61EE5D, 0x1481EE5E, 0x61EE5F, 0x1481EE60, 0x61EE61,
  0x1481EE63, 0x61EE64, 0x1481EE65, 0x61EE67, 0x1481EE6B, 0x61EE6C, 0x1481EE73, 0x61EE74,
  0x1481EE78, 0x61EE79, 0x1481EE7D, 0x61EE7E, 0x1481EE7F, 0x61EE80, 0x1481EE8A, 0x61EE8B,
  0x1481EE9C, 0x61EEA1, 0x1481EEA4, 0x61EEA5, 0x1481EEAA, 0x61EEAB, 0x1481EEBC, 0x61EEF0,
  0x1481EEF2, 0x301F000, 0x1481F02C, 0x301F030, 0x1481F094, 0x301F0A0, 0x1481F0AF, 0x301F0B1,
  0x1481F0C0, 0x301F0C1, 0x1481F0D0, 0x301F0D1, 0x1481F0F6, 0x301F100, 0x1481F1AE, 0x301F1E6,
  0x6E1F200, 0x301F201, 0x1481F203, 0x301F210, 0x1481F23C, 0x301F240, 0x1481F249, 0x301F250,
  0x1481F252, 0x301F260, 0x1481F266, 0x301F300, 0x1481F6D8, 0x301F6DC, 0x1481F6ED, 0x301F6F0,
  0x1481F6FD, 0x301F700, 0x1481F777, 0x301F77B, 0x1481F7DA, 0x301F7E0, 0x1481F7EC, 0x301F7F0,
  0x1481F7F1, 0x301F800, 0x1481F80C, 0x301F810, 0x1481F848, 0x301F850, 0x1481F85A, 0x301F860,
  0x1481F888, 0x301F890, 0x1481F8AE, 0x301F8B0, 0x1481F8BC, 0x301F8C0, 0x1481F8C2, 0x301F900,
  0x1481FA54, 0x301FA60, 0x1481FA6E, 0x301FA70, 0x1481FA7D, 0x301FA80, 0x1481FA8A, 0x301FA8F,
  0x1481FAC7, 0x301FACE, 0x1481FADD, 0x301FADF, 0x1481FAEA, 0x301FAF0, 0x1481FAF9, 0x301FB00,
  0x1481FB93, 0x301FB94, 0x1481FBFA, 0x6220000, 0x1482A6E0, 0x622A700, 0x1482B73A, 0x622B740,
  0x1482B81E, 0x622B820, 0x1482CEA2, 0x622CEB0, 0x1482EBE1, 0x622EBF0, 0x1482EE5E, 0x622F800,
  0x1482FA1E, 0x6230000, 0x1483134B, 0x6231350, 0x148323B0, 0x30E0001, 0x148E0002, 0x30E0020,
  0x148E0080, 0x72E0100, 0x148E01F0,
};

static const uint8_t _swift_stdlib_script_extensions_data[501] = {
  0x5, 0x12, 0x19, 0x22, 0x24, 0x28, 0x29, 0x2E, 0x2A, 0x2C, 0x31, 0x49, 0x50, 0x52, 0x71, 0x86,
  0xA, 0x1C, 0x1F, 0x49, 0x4E, 0x9C, 0xA1, 0xC, 0x49, 0x49, 0x4E, 0x49, 0x9C, 0x16, 0x19, 0x1C,
  0x2C, 0x49, 0x71, 0x8E, 0x93, 0x16, 0x1C, 0x2C, 0x49, 0x79, 0x8E, 0x93, 0xA0, 0x16, 0x1C, 0x49,
  0x9E, 0x29, 0x49, 0x8E, 0x90, 0x9C, 0x13, 0x16, 0x19, 0x1C, 0x2A, 0x2C, 0x49, 0x79, 0x90, 0x9E,
  0xA0, 0x19, 0x24, 0x29, 0x2A, 0x3F, 0x49, 0x1C, 0x2C, 0x49, 0x71, 0x19, 0x22, 0x36, 0x49, 0x71,
  0x90, 0x93, 0x9E, 0xA0, 0x4, 0x1C, 0x22, 0x2A, 0x2C, 0x36, 0x49, 0x71, 0x90, 0x93, 0x49, 0x9E,
  0x22, 0x49, 0x90, 0x16, 0x1C, 0x49, 0x79, 0x16, 0x49, 0x93, 0x49, 0x8E, 0x26, 0x49, 0x1C, 0x49,
  0xA0, 0x2C, 0x49, 0x71, 0xA0, 0x49, 0x90, 0x16, 0x22, 0x3F, 0x49, 0x90, 0x16, 0x22, 0x49, 0x90,
  0x49, 0x8E, 0x90, 0x16, 0x49, 0x90, 0x13, 0x16, 0x2A, 0x49, 0x8E, 0x9C, 0x2C, 0x49, 0x79, 0x13,
  0x49, 0xA0, 0x49, 0x19, 0x2C, 0x1C, 0x71, 0x1C, 0x29, 0x1C, 0x49, 0x4, 0x28, 0x29, 0x3, 0x27,
  0x69, 0x33, 0x90, 0x9B, 0xA9, 0x3, 0x90, 0x9B, 0x0, 0x3, 0x27, 0x69, 0x33, 0x90, 0x9B, 0xA9, 0x0,
  0x3, 0x55, 0x56, 0x76, 0x80, 0x33, 0x8A, 0x90, 0x3, 0x90, 0x3, 0x9B, 0xA9, 0x3, 0x33, 0xA, 0x1F,
  0x2B, 0x2D, 0x2F, 0x3E, 0x49, 0x54, 0x78, 0x85, 0x97, 0x9A, 0x9F, 0xA, 0x1F, 0x2B, 0x2D, 0x2F,
  0x3E, 0x49, 0x54, 0x78, 0x97, 0x9A, 0x9F, 0xA, 0x1F, 0x21, 0x2E, 0x58, 0x2B, 0x2D, 0x2F, 0x3E,
  0x52, 0x54, 0x66, 0x77, 0x78, 0x47, 0x89, 0x8F, 0x96, 0x97, 0x9A, 0x9F, 0xA, 0x1F, 0x21, 0x2E,
  0x58, 0x2B, 0x2D, 0x30, 0x2F, 0x3E, 0x4B, 0x52, 0x54, 0x66, 0x77, 0x78, 0x47, 0x89, 0x8F, 0x96,
  0x97, 0x9A, 0x9F, 0x1F, 0x21, 0x3D, 0x52, 0xA, 0x14, 0x8F, 0x2F, 0x62, 0x2D, 0x46, 0x2B, 0x97,
  0x3E, 0x66, 0xA2, 0x14, 0x63, 0x93, 0x28, 0x29, 0x49, 0x82, 0x10, 0x34, 0x92, 0x91, 0x60, 0x7E,
  0xA, 0x1F, 0x2B, 0x3E, 0x1F, 0x1F, 0x2B, 0x3E, 0xA, 0x1F, 0x1F, 0x85, 0x1F, 0x3E, 0x54, 0x78,
  0x97, 0x9A, 0x1F, 0x66, 0xA, 0x1F, 0x2B, 0x3E, 0x54, 0x66, 0x78, 0x89, 0x9A, 0x9F, 0xA2, 0x1F,
  0x2B, 0x1F, 0x2B, 0x3E, 0xA2, 0xA, 0x66, 0x1C, 0x49, 0x90, 0x90, 0x49, 0x60, 0x7E, 0x0, 0x3, 0x12,
  0x28, 0x29, 0x6E, 0x4F, 0x75, 0x12, 0x2C, 0x6E, 0x5D, 0x1F, 0x2B, 0x49, 0x19, 0x49, 0x5, 0x75,
  0x5, 0x12, 0x28, 0x6E, 0x3D, 0x50, 0x83, 0x22, 0x0, 0x3, 0x6E, 0x31, 0x99, 0xC, 0x32, 0x31, 0x37,
  0x3F, 0x60, 0xAA, 0xC, 0x32, 0x31, 0x37, 0x3F, 0x60, 0x7E, 0xAA, 0xC, 0x32, 0x31, 0x37, 0x3F,
  0x31, 0xC, 0x32, 0x31, 0x37, 0x3F, 0x60, 0x9D, 0xAA, 0xC, 0x32, 0x31, 0x37, 0x3F, 0x4E, 0x60,
  0x9D, 0xAA, 0xC, 0x32, 0x31, 0x37, 0x3F, 0xAA, 0xC, 0x31, 0x37, 0x3F, 0x31, 0x37, 0x3F, 0x31,
  0x49, 0x1F, 0x21, 0x2D, 0x2F, 0x46, 0x3E, 0x3D, 0x52, 0x54, 0x5F, 0x66, 0x85, 0x47, 0x96, 0x9F,
  0xA2, 0x1F, 0x21, 0x2D, 0x2F, 0x46, 0x3E, 0x3D, 0x52, 0x5F, 0x66, 0x85, 0x47, 0x96, 0x9F, 0xA2,
  0x1F, 0x21, 0x2D, 0x2F, 0x46, 0x3D, 0x52, 0x5F, 0x47, 0x96, 0x9F, 0x1F, 0x21, 0x2D, 0x2F, 0x46,
  0x3D, 0x52, 0x5F, 0x85, 0x47, 0x96, 0x9F, 0xA, 0x1F, 0xA2, 0x1F, 0x97, 0x42, 0x49, 0x63, 0xF,
  0x3C, 0x3, 0x69, 0x3, 0x9B, 0x1D, 0x1B, 0x4D, 0x1B, 0x4D, 0x1B, 0x4C, 0x4D, 0x3, 0x19, 0x56, 0x76,
};

static const uint16_t _swift_stdlib_script_extensions_data_indices[670] = {
  0x8000, 0x3810, 0x1017, 0x1017, 0x1017, 0x1017, 0x1019, 0x101B, 0x1017, 0x401D, 0x4025, 0x202D,
  0x2831, 0x5836, 0x3041, 0x2047, 0x484B, 0x5054, 0x105E, 0x1860, 0x2063, 0x1867, 0x106A, 0x106C,
  0x106A, 0x186E, 0x2071, 0x1075, 0x2877, 0x207C, 0x1075, 0x1880, 0x1075, 0x1883, 0x3086, 0x88C,
  0x88C, 0x108D, 0x188F, 0x892, 0x892, 0x892, 0x892, 0x892, 0x892, 0x892, 0x892, 0x892, 0x892,
  0x892, 0x892, 0x892, 0x1093, 0x1093, 0x1095, 0x1097, 0x1099, 0x1099, 0x1097, 0x189B, 0x389E,
  0x389E, 0x18A5, 0x40A8, 0x48B0, 0x10B9, 0x10B9, 0x10B9, 0x10B9, 0x10B9, 0x10B9, 0x10B9, 0x10B9,
  0x10B9, 0x10B9, 0x10B9, 0x18BB, 0x18BB, 0x18BB, 0x18BB, 0x18BB, 0x18BB, 0x18BB, 0x18BB, 0x18BB,
  0x18BB, 0x10B9, 0x10BE, 0x68C0, 0x60CD, 0xA8D9, 0xB8EE, 0x2105, 0x2105, 0x2105, 0x2105, 0x2105,
  0x2105, 0x2105, 0x2105, 0x2105, 0x2105, 0x1909, 0x1909, 0x1909, 0x1909, 0x1909, 0x1909, 0x1909,
  0x1909, 0x1909, 0x1909, 0x110C, 0x110C, 0x110C, 0x110C, 0x110C, 0x110C, 0x110C, 0x110C, 0x110C,
  0x110C, 0x110E, 0x110E, 0x110E, 0x110E, 0x110E, 0x110E, 0x110E, 0x110E, 0x110E, 0x110E, 0x1110,
  0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110,
  0x1110, 0x1912, 0x1912, 0x1912, 0x1912, 0x1912, 0x1912, 0x1912, 0x1912, 0x1912, 0x1912, 0x1915,
  0x1915, 0x1915, 0x1915, 0x1915, 0x1915, 0x1915, 0x1915, 0x1915, 0x1915, 0x1918, 0x91B, 0x91B,
  0x91B, 0x211C, 0x211C, 0x1120, 0x1120, 0x1120, 0x2122, 0x926, 0x2122, 0x1927, 0x926, 0x112A,
  0x112A, 0x112C, 0x112A, 0x112C, 0x312E, 0x926, 0x112C, 0x112C, 0x926, 0x926, 0x112C, 0x112A,
  0x926, 0x926, 0x926, 0x926, 0x926, 0x926, 0x926, 0x1134, 0x112A, 0x926, 0x926, 0x112A, 0x926,
  0x926, 0x926, 0x926, 0x5936, 0x1141, 0x2143, 0x112A, 0x112A, 0x947, 0x1141, 0x1141, 0x948, 0x88C,
  0x88C, 0x1949, 0x94C, 0x194D, 0x1150, 0x3152, 0x2158, 0x195C, 0x115F, 0x1161, 0x3963, 0x96A,
  0x196B, 0x1097, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E,
  0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x116E, 0x3970, 0x4177, 0x297F, 0x984, 0x4185, 0x4185,
  0x498D, 0x498D, 0x3196, 0x3196, 0x3196, 0x3196, 0x3196, 0x3196, 0x297F, 0x3196, 0x3196, 0x3196,
  0x3196, 0x3196, 0x3196, 0x3196, 0x3196, 0x297F, 0x297F, 0x297F, 0x297F, 0x119C, 0x119C, 0x119C,
  0x119C, 0x297F, 0x119E, 0x119E, 0x119E, 0x119E, 0x119E, 0x297F, 0x19A0, 0x19A0, 0x984, 0x984,
  0x119E, 0x119E, 0x119E, 0x119E, 0x119E, 0x3196, 0x119E, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x116E, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x1097, 0x11A3, 0x11A3, 0x11A3, 0x11A3, 0x11A3, 0x11A3, 0x11A3, 0x11A3, 0x81A5,
  0x81A5, 0x81A5, 0x79B5, 0x79B5, 0x79B5, 0x59C4, 0x59C4, 0x61CF, 0x59C4, 0x19DB, 0x11DE, 0x19E0,
  0x11E3, 0x11E5, 0x11E5, 0x11E7, 0x11E7, 0x297F, 0x297F, 0x3196, 0x3196, 0x3196, 0x3196, 0x3196,
  0x119E, 0x119E, 0x119E, 0x19E9, 0x19E9, 0x11EC, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE,
  0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE,
  0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE,
  0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE, 0x19EE,
  0x19EE, 0x19EE, 0x19EE, 0x11EC, 0x11EC, 0x11EC, 0x11EC, 0x11EC, 0x11EC, 0x11EC, 0x11EC, 0x11EC,
  0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1,
  0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F1,
  0x11F1, 0x11F1, 0x11F1, 0x11F1, 0x11F3, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110, 0x1110,
  0x96A, 0x96A, 0x96A, 0x96A, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
  0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984, 0x984,
};

static const uint16_t _swift_stdlib_script_extensions_ranks[208] = {
  0x0, 0x17, 0x17, 0x1B, 0x22, 0x25, 0x25, 0x27, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x8, 0x1A,
  0x0, 0x13, 0x15, 0x15, 0x15, 0x0, 0x0, 0x5, 0x5, 0x5, 0x0, 0x1, 0x1, 0x2, 0xB, 0x0, 0xB, 0xC, 0xC,
  0xC, 0x0, 0x0, 0x0, 0x0, 0xE, 0x0, 0x0, 0xA, 0xA, 0x14, 0x0, 0x0, 0xA, 0xA, 0xA, 0x0, 0xA, 0xE,
  0xE, 0xE, 0x0, 0xA, 0xA, 0xA, 0xA, 0x0, 0x0, 0xA, 0xA, 0xA, 0x0, 0x0, 0x0, 0x3, 0x5, 0x0, 0x0,
  0x0, 0x3, 0x3, 0x0, 0x20, 0x2B, 0x2B, 0x2B, 0x0, 0x4, 0x4, 0x4, 0x4, 0x0, 0x0, 0x4, 0x4, 0x4, 0x0,
  0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x6, 0x6, 0x0, 0x1C, 0x3A, 0x3A, 0x3F, 0x0, 0x2, 0x2, 0x12,
  0x32, 0x0, 0x10, 0x28, 0x58, 0x65, 0x0, 0x0, 0x1E, 0x1E, 0x3D, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x8,
  0x8, 0x8, 0x8, 0x0, 0x0, 0xA, 0xA, 0xA, 0x0, 0x3, 0x3, 0x3, 0x4, 0x0, 0x0, 0x2, 0x2, 0x2, 0x0,
  0x2, 0x4, 0x4, 0x4, 0x0, 0x0, 0x6, 0x8, 0x8, 0x0, 0x0, 0x0, 0x0, 0xC, 0x0, 0x1D, 0x1D, 0x1D, 0x1D,
  0x0, 0x0, 0x0, 0x10, 0x1C, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2,
  0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x4, 0x4, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x2, 0x2,
  0x2, 0x2,
};

static const uint64_t _swift_stdlib_script_extensions[209] = {
  0x8, 0x1E800D8609F7D, 0x0, 0xF0000000, 0x80FC00000000000, 0x400C, 0x0, 0x80000400000000, 0x200000,
  0x0, 0x0, 0x80000000000000, 0x0, 0x0, 0x0, 0x0, 0x2802E8010000000, 0xB7FFF00000000, 0x16039,
  0xFFF8410000240003, 0x30, 0x0, 0x0, 0x210000, 0x0, 0xF8, 0x0, 0x0, 0x360000, 0x200000000000000,
  0x0, 0x1000000000000000, 0xF801000000009800, 0x3B003F, 0x103FF, 0x10000000000000, 0x0, 0x0,
  0x4C0000, 0x0, 0x0, 0x0, 0xFFF000060000, 0x580000, 0x0, 0xFFC00000, 0x0, 0xFFC00000, 0x660000,
  0x0, 0xFFC0, 0x0, 0x0, 0x7A0000, 0xFFC0000000000000, 0xF, 0x0, 0x0, 0x840000, 0xFFC000000000, 0x0,
  0x0, 0x0, 0x920000, 0x0, 0x3FF0000, 0x0, 0x0, 0x9C0800, 0x0, 0x0, 0x38000000, 0x6000000000,
  0xA70000, 0x0, 0x0, 0x2C00000000, 0x0, 0xAC0000, 0xFFFFFFFF00000000, 0x7FF, 0x0, 0x0, 0xAF0000,
  0x500000000000003, 0x0, 0x0, 0x0, 0xDA0000, 0x0, 0x2400800000008000, 0x0, 0x0, 0xDE0000, 0x1, 0x0,
  0x0, 0x0, 0xE20000, 0x0, 0x8000000000, 0xA1003, 0x0, 0xE30000, 0xFF4EFFFF00000000, 0xF0BF3C00FFFB,
  0x0, 0x11E00, 0xE90000, 0x18000000, 0x0, 0xFFFF000000000000, 0xFFFFFFFF00000000, 0x128803F,
  0xFFFF000000000000, 0xFFFFFF, 0xFFFFFFFFFFFF0000, 0xFFF0001, 0x1618000, 0x0, 0xF801FFFFFF000000,
  0x0, 0x7FFFFFFF00000000, 0x1C70000, 0x0, 0x0, 0x800000000000, 0x0, 0x2040000, 0xFF000000000000,
  0x0, 0x0, 0x0, 0x2050000, 0x0, 0x3FF0000, 0x0, 0x0, 0x20D0000, 0x400000000000000A, 0x0, 0x0,
  0x80000000, 0x2170000, 0x0, 0xC0000000, 0x0, 0x0, 0x21B0000, 0x2004, 0x600000, 0x0, 0x0,
  0x21D0000, 0x0, 0x1003E00000000, 0xC0000000, 0x0, 0x2210000, 0x0, 0x0, 0x0, 0xFF87000000000000,
  0x229FFFF, 0xFF8FFFFF, 0x0, 0x0, 0x0, 0x2450000, 0x0, 0x0, 0xFFFF000000000000, 0xFFF, 0x2620000,
  0x0, 0x4, 0x0, 0x0, 0x27E0000, 0x0, 0x0, 0x0, 0xA00000000, 0x27F0000, 0x1800, 0x0, 0x0, 0x0,
  0x2810000, 0x0, 0x0, 0x0, 0xB000000000000, 0x2830000, 0x0, 0x0, 0xF, 0x0, 0x2860000, 0x0, 0x0,
  0x0, 0xFFFF000000000000, 0x28A0003, 0x3, 0x0, 0x0, 0x0, 0x29C0000,
};

#endif // #ifndef SCRIPT_DATA_H
