use lang:bs:macro;
use sql;
use test;
use io;

void run() {
    print("Running SQL tests!");
    run(named{sql:tests});
}

DATABASE Dummy {
    TABLE MY_TABLE (
        A INTEGER PRIMARY KEY,
        B TEXT NOT NULL UNIQUE
        );
}

suite seltest // TESTING SELECT WITH/WITHOUT WHERE
{
    print("");
    Str testString = "Movies";
    Int testId = 2; // This shouldn't work with the string "2". It do.
    // We cannot specify if storm variable or table attribute in db

    SQLite db(cwdUrl/"chinook.db");
    Dummy connection;
    connection.connect(db);
    var result = SELECT Playlistid, Name FROM playlists WHERE Playlistid = testId OR Name = testString DB connection;
    print(result.errMsg);

    for(row in result)
    {
        print("id: " + row.getInt(0).toS + ", Name: " + row.getStr(1) );
    }

    print("");
}

suite newTable // TESTING CREATING TABLE (IF NOT EXISTS)
{
    print("");

    SQLite db(cwdUrl/"chinook.db");
    Dummy connection;
    connection.connect(db);
    var res = CREATE TABLE IF NOT EXISTS gebaIsIllegal( Geba INTEGER, bacon REAL, Illegal TEXT) DB connection ;
    for(table in db.tables)
        print("Table name: " + table );

    print("");
}


suite newTableWithModifiers {
    SQLite db(cwdUrl/"chinook.db");
    Dummy connection;
    connection.connect(db);
    var res = CREATE TABLE IF NOT EXISTS thisTableHasModifiers( A INTEGER PRIMARY KEY, B TEXT NOT NULL UNIQUE) DB connection;
    for(table in db.tables)
        print("Table name: " + table );
}

suite droptest // TESTING DROP TABLE (IF EXISTS)
{
    print("");

    SQLite db;
    Dummy connection;
    connection.connect(db);
    var res = CREATE TABLE IF NOT EXISTS gebaIsIllegal( Geba INTEGER, bacon REAL, Illegal TEXT) DB connection;

    var res2 = CREATE TABLE IF NOT EXISTS gebaIsNotIllegal( Geba INTEGER, bacon REAL, Illegal TEXT) DB connection;

    print("Printing all tables in db before dropping");
    for(table in db.tables)
        print("Table name: " + table );

    var res3 = DROP TABLE IF EXISTS gebaIsIllegal DB connection;

    print("Removing gebaIsIllegal from db");
    for(table in db.tables)
        print("Table name: " + table );

    print("");
}

suite deltest
{
    print("");
    SQLite db();
    Dummy connection;
    connection.connect(db);
    CREATE TABLE IF NOT EXISTS gebaIsIllegal( Geba INTEGER, bacon REAL, Illegal TEXT) DB connection;


    print("Inserting geba 1 and 2 into table gebaIsIllegal");

    INSERT INTO gebaIsIllegal(geba, bacon, Illegal) VALUES (1, 13.37, "no") DB connection;
    INSERT INTO gebaIsIllegal(geba, bacon, Illegal) VALUES (2, 4.20, "yes") DB connection;

    var res = SELECT geba, bacon, Illegal FROM gebaIsIllegal DB connection;
    print(res.errMsg);
    for (row in res)
        print("geba: " + row.getInt(0).toS + " bacon: " + row.getDouble(1).toS + " Illegal: " + row.getStr(2));

    Str yes = "yes";

    print("removing the geba which is illegal");
    DELETE FROM gebaIsIllegal WHERE Illegal = yes DB connection;

    var res2 = SELECT geba, bacon, Illegal FROM gebaIsIllegal DB connection;
    for (row in res2)
        print("geba: " + row.getInt(0).toS + " bacon: " + row.getDouble(1).toS + " Illegal: " + row.getStr(2));

    print("");

}


suite instest
{
    SQLite db();
    Dummy connection;
    connection.connect(db);
    CREATE TABLE IF NOT EXISTS generic( id INTEGER, name TEXT) DB connection;

    INSERT INTO generic(id, name) VALUES (1, "Lorem asd") DB connection;
    var res = SELECT id, name FROM generic DB connection;

    print(res.errMsg);

    for (row in res)
        print("id: " + row.getInt(0).toS + ", name: " + row.getStr(1));

    Str ipsum = "ipsum";

    INSERT INTO generic VALUES (2,ipsum) DB connection;
    print("inserting the string variable ipsum containing ipsum and printing");

    var res2 = SELECT id, name FROM generic DB connection;
    for (row in res2)
        print("id: " + row.getInt(0).toS + ", name: " + row.getStr(1));
}


suite updtTest {
    print("");
    SQLite db;
    Dummy connection;
    connection.connect(db);

    var res = CREATE TABLE IF NOT EXISTS generic( id INTEGER, name TEXT) DB connection;

    INSERT INTO generic VALUES(1, "lorem") DB connection;
    INSERT INTO generic VALUES(2, "ipsum") DB connection;

    var res2 = SELECT id, name FROM generic DB connection;

    for (row in res2)
        print("id: " + row.getInt(0).toS + ", name: " + row.getStr(1));

    print("Updating table without using variables...");
    UPDATE generic SET name="dolor", id=3 WHERE id=1 DB connection;
    for (row in res2)
        print("id: " + row.getInt(0).toS + ", name: " + row.getStr(1));

    print("Updating table with variables...");
    Str s = "sit amet";
    Int i = 4;

    UPDATE generic SET name=s, id=i WHERE id=2 DB connection;
    var res3 = SELECT id, name FROM generic DB connection;
    Int id = 0;
    for (row in res3) {
        print("id: " + row.getInt(0).toS + ", name: " + row.getStr(1));
    }
    print("");
}
