/************************************************************************
 *
 * Copyright (C) 2009-2015 IRCAD France
 * Copyright (C) 2012-2015 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#ifndef __FWDATA_NAMESPACE_HPP__
#define __FWDATA_NAMESPACE_HPP__

/**
 * @brief Contains the representation of the data objects used in the framework.
 * @namespace fwData
 */
namespace fwData
{

/**
 * @brief Contains the representation of the data objects oriented to fileSystem locations (folder, file, etc).
 * @namespace fwData::location
 */
namespace location
{
} // namespace location

/**
 * @brief Contains helper to lock object for multi-threading.
 * @namespace fwData::mt
 */
namespace mt
{
} // namespace mt

/**
 * @brief Contains fwData::registry details.
 * @namespace fwData::registry
 */
namespace registry
{
} // namespace registry


/**
 * @brief Contains fwData::factory utilities.
 * @namespace fwData::factory
 */
namespace factory
{
} // namespace factory



} // namespace fwData

#endif /* __FWDATA_NAMESPACE_HPP__ */

