// SPDX-FileCopyrightText: 2006-2024 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2024 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \brief Meta-header for the \link utility_tuple Utility / Tuple submodule \endlink.
 * \author Hannes Hauswedell <hannes.hauswedell AT fu-berlin.de>
 */

/*!\defgroup utility_tuple Tuple
 * \brief Additional helper utilities for "tuple" types like std::tuple, std::pair, seqan3::pod_tuple that are not
 *        specific to a SeqAn module.
 * \ingroup utility
 * \see utility
 */

#pragma once

#include <seqan3/utility/tuple/common_tuple.hpp>
#include <seqan3/utility/tuple/concept.hpp>
#include <seqan3/utility/tuple/pod_tuple.hpp>
#include <seqan3/utility/tuple/pop_front.hpp>
#include <seqan3/utility/tuple/split.hpp>
