/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JStackMapTableAttribute
extends JAttribute {
    private JConstantPool pool;
    protected final List entries = new ArrayList();
    protected int entriesSize = 0;
    protected boolean usesU2;

    public JStackMapTableAttribute(FJBGContext context, JClass clazz, JCode code) {
        super(context, clazz);
        this.pool = clazz.pool;
        assert (code.getOwner().getOwner() == clazz);
    }

    public JStackMapTableAttribute(FJBGContext context, JClass clazz, Object owner, String name, int size, DataInputStream stream) throws IOException {
        super(context, clazz, name);
        this.pool = clazz.pool;
        int count = stream.readShort();
        this.usesU2 = count < 65536;
        for (int i = 0; i < count; ++i) {
            this.entries.add(new Frame(stream));
        }
        this.entriesSize = this.computeSize();
        assert (name.equals(this.getName()));
    }

    public String getName() {
        return "StackMapTable";
    }

    public String toString() {
        Frame frame2 = null;
        StringBuffer buf = new StringBuffer("  StackMapTable: number_of_entries = ");
        buf.append(this.entries.size());
        for (Frame frame2 : this.entries) {
            buf.append("\n   frame_type = ");
            buf.append(frame2.tag);
            buf.append(" /* ");
            buf.append(JStackMapTableAttribute.getFrameType(frame2.tag));
            buf.append(" */");
            if (frame2.offsetDelta != -1) {
                buf.append("\n     offset_delta = " + frame2.offsetDelta);
            }
            if (frame2.locals != null) {
                JStackMapTableAttribute.appendTypeInfoArray(buf, "locals", frame2.locals);
            }
            if (frame2.stackItems == null) continue;
            JStackMapTableAttribute.appendTypeInfoArray(buf, "stack", frame2.stackItems);
        }
        buf.append("\n");
        return buf.toString();
    }

    protected int getSize() {
        return this.entriesSize;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.entriesSize);
        for (Frame frame : this.entries) {
            frame.writeContentsTo(stream);
        }
    }

    private int computeSize() {
        int size = this.usesU2 ? 2 : 4;
        for (Frame frame : this.entries) {
            size += frame.getSize();
        }
        return size;
    }

    private static final String getFrameType(int tag) {
        if (tag < 64) {
            return "same";
        }
        if (tag < 128) {
            return "same locals 1 stack item";
        }
        if (tag < 248) {
            return "<reserved>";
        }
        if (tag < 251) {
            return "chop";
        }
        if (tag == 251) {
            return "same frame extended";
        }
        if (tag < 255) {
            return "append";
        }
        return "full frame";
    }

    private static StringBuffer appendTypeInfoArray(StringBuffer buf, String s, TypeInfo[] a) {
        buf.append("\n     ");
        buf.append(s);
        buf.append(" = ");
        if (a.length > 0) {
            buf.append("[ ");
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(a[i]);
            }
            buf.append(" ]");
        } else {
            buf.append("[]");
        }
        return buf;
    }

    private class Frame {
        final int tag;
        int offsetDelta = -1;
        TypeInfo[] stackItems = null;
        TypeInfo[] locals = null;
        private int bytes;

        Frame(DataInputStream stream) throws IOException {
            this.tag = stream.readUnsignedByte();
            if (this.tag >= 64) {
                if (this.tag < 128) {
                    this.offsetDelta = this.tag - 64;
                    this.readStackItems(stream, 1);
                } else if (this.tag < 248) {
                    assert (false) : "Tags in the range [128-247] are reserved for future use.";
                } else if (this.tag < 251) {
                    int k = 251 - this.tag;
                    this.readOffsetDelta(stream);
                } else if (this.tag == 251) {
                    this.readOffsetDelta(stream);
                } else if (this.tag < 255) {
                    this.readOffsetDelta(stream);
                    this.readLocals(stream, this.tag - 251);
                } else {
                    this.readOffsetDelta(stream);
                    this.readLocals(stream);
                    this.readStackItems(stream);
                }
            }
        }

        int getSize() {
            return this.bytes;
        }

        void readOffsetDelta(DataInputStream stream) throws IOException {
            this.offsetDelta = JStackMapTableAttribute.this.usesU2 ? stream.readShort() : stream.readInt();
            this.bytes += JStackMapTableAttribute.this.usesU2 ? 2 : 4;
        }

        int getOffsetDelta() {
            return this.offsetDelta;
        }

        void readStackItems(DataInputStream stream, int k) throws IOException {
            this.stackItems = new TypeInfo[k];
            for (int i = 0; i < k; ++i) {
                this.stackItems[i] = new TypeInfo(stream);
                this.bytes += this.stackItems[i].getSize();
            }
        }

        void readStackItems(DataInputStream stream) throws IOException {
            int k = JStackMapTableAttribute.this.usesU2 ? stream.readShort() : stream.readInt();
            this.bytes += JStackMapTableAttribute.this.usesU2 ? 2 : 4;
            this.readStackItems(stream, k);
        }

        void readLocals(DataInputStream stream, int k) throws IOException {
            this.locals = new TypeInfo[k];
            for (int i = 0; i < k; ++i) {
                this.locals[i] = new TypeInfo(stream);
                this.bytes += this.locals[i].getSize();
            }
        }

        void readLocals(DataInputStream stream) throws IOException {
            int k = JStackMapTableAttribute.this.usesU2 ? stream.readShort() : stream.readInt();
            this.bytes += JStackMapTableAttribute.this.usesU2 ? 2 : 4;
            this.readLocals(stream, k);
        }

        void writeContentsTo(DataOutputStream stream) throws IOException {
            block23: {
                stream.writeByte(this.tag);
                if (this.tag < 64) break block23;
                if (this.tag < 128) {
                    assert (this.stackItems.length == 1);
                    this.stackItems[0].writeContentsTo(stream);
                } else if (this.tag < 248) {
                    assert (false) : "Tags in the range [128-247] are reserved for future use.";
                } else if (this.tag < 251) {
                    if (JStackMapTableAttribute.this.usesU2) {
                        stream.writeShort(this.offsetDelta);
                    } else {
                        stream.writeInt(this.offsetDelta);
                    }
                } else if (this.tag == 251) {
                    if (JStackMapTableAttribute.this.usesU2) {
                        stream.writeShort(this.offsetDelta);
                    } else {
                        stream.writeInt(this.offsetDelta);
                    }
                } else if (this.tag < 255) {
                    if (JStackMapTableAttribute.this.usesU2) {
                        stream.writeShort(this.offsetDelta);
                    } else {
                        stream.writeInt(this.offsetDelta);
                    }
                    for (int i = 0; i < this.locals.length; ++i) {
                        this.locals[i].writeContentsTo(stream);
                    }
                } else {
                    int i;
                    if (JStackMapTableAttribute.this.usesU2) {
                        stream.writeShort(this.offsetDelta);
                    } else {
                        stream.writeInt(this.offsetDelta);
                    }
                    for (i = 0; i < this.locals.length; ++i) {
                        this.locals[i].writeContentsTo(stream);
                    }
                    for (i = 0; i < this.stackItems.length; ++i) {
                        this.stackItems[i].writeContentsTo(stream);
                    }
                }
            }
        }
    }

    private class TypeInfo {
        final int tag;
        final int poolIndexOrOffset;
        private int bytes;

        TypeInfo(DataInputStream stream) throws IOException {
            int size = 1;
            this.tag = stream.readByte();
            if (this.tag == 7) {
                this.poolIndexOrOffset = stream.readShort();
                size += 2;
            } else if (this.tag == 8) {
                this.poolIndexOrOffset = JStackMapTableAttribute.this.usesU2 ? stream.readShort() : stream.readInt();
                size += JStackMapTableAttribute.this.usesU2 ? 2 : 4;
            } else {
                this.poolIndexOrOffset = -1;
            }
            this.bytes += size;
        }

        int getSize() {
            return this.bytes;
        }

        void writeContentsTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.tag);
            if (this.tag == 7) {
                stream.writeShort(this.poolIndexOrOffset);
            } else if (this.tag == 8) {
                if (JStackMapTableAttribute.this.usesU2) {
                    stream.writeShort(this.poolIndexOrOffset);
                } else {
                    stream.writeInt(this.poolIndexOrOffset);
                }
            }
        }

        public String toString() {
            switch (this.tag) {
                case 0: {
                    return "<top>";
                }
                case 1: {
                    return "int";
                }
                case 2: {
                    return "float";
                }
                case 3: {
                    return "double";
                }
                case 4: {
                    return "long";
                }
                case 5: {
                    return "null";
                }
                case 6: {
                    return "this";
                }
                case 7: {
                    String name = JStackMapTableAttribute.this.pool.lookupClass(this.poolIndexOrOffset);
                    if (name.startsWith("[")) {
                        name = "\"" + name + "\"";
                    }
                    return "class " + name;
                }
                case 8: {
                    return "<uninitialized>";
                }
            }
            return "" + this.tag;
        }
    }
}

