/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file PrefsPage.cxx
    \author Romain BONDUE
    \date 19/07/2006 */
#include <sstream>
#include <cstring> // strcmp()

#include "PrefsPage.h"
#include "StaticSettings.h"



namespace
{
    std::string ToMbpsStr (int Value) throw()
    {
        std::ostringstream Os;
        Os << Value / 1000.0 << " Mbps";
        return Os.str();

    } // ToMbpsStr()


    const unsigned NbDelay (7);
    unsigned TabDelay [NbDelay] = {1, 3, 5, 10, 15, 30, 60};


    void DeleteCallback (::GtkWidget* pWidget, ::gint, void*) throw()
    {
        ::gtk_widget_destroy (pWidget);

    } // DeleteCallback()

} // anonymous namespace



nsGUI::CPrefsPage::CPrefsPage (bool IsRoot) throw()
    : m_pTable (GTK_TABLE (::gtk_table_new (6, 2, true))),
      m_pStartMinimizedButton (GTK_CHECK_BUTTON
              (::gtk_check_button_new_with_label ("Start hidden in tray"))),
      m_pAboutButton (GTK_BUTTON (::gtk_button_new_from_stock
                                                        (GTK_STOCK_ABOUT))),
      m_pChangeInterface (GTK_BUTTON (::gtk_button_new_with_label
                                                      ("Change interface"))),
      m_pRootModeButton (GTK_TOGGLE_BUTTON (::gtk_toggle_button_new_with_label
                                                      ("Priviliged mode"))),
      m_pLeaveRootModeBox (GTK_COMBO_BOX (::gtk_combo_box_new_text())),
      m_pRatesLabel (::gtk_label_new ("Maximum Tx rate")),
      m_NbRate (0), m_pRatesBox (GTK_COMBO_BOX (::gtk_combo_box_new_text())),
      m_pTrayIconButton (GTK_CHECK_BUTTON
              (::gtk_check_button_new_with_label ("Display tray icon"))),
      m_pIfaceStatusButton (GTK_TOGGLE_BUTTON (::gtk_toggle_button_new())),
      m_pIfaceLabel (GTK_LABEL (::gtk_label_new (0)))
{
    BuildUI (IsRoot);

} // CPrefsPage()


void nsGUI::CPrefsPage::BuildUI (bool IsRoot) throw()
{
    ::gtk_container_set_border_width (GTK_CONTAINER (m_pTable), 6);
    ::gtk_table_set_col_spacings (m_pTable, 12);
    ::gtk_table_set_row_spacings (m_pTable, 8);

    ::gtk_container_add (GTK_CONTAINER (m_pIfaceStatusButton),
                         GTK_WIDGET (m_pIfaceLabel));
    ::gtk_table_attach_defaults (m_pTable, ::gtk_label_new ("The interface is"
                                                " currently : "), 0, 1, 0, 1);
    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pIfaceStatusButton), 1, 2, 0, 1,
                        GTK_EXPAND, GTK_EXPAND, 0, 0);

    ::gtk_table_attach_defaults (m_pTable, m_pRatesLabel, 0, 1, 1, 2);
    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pRatesBox), 1, 2, 1, 2,
                        GTK_FILL, GTK_SHRINK, 0, 0);

    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pTrayIconButton), 0, 1,
                        2, 3, GTK_EXPAND, GTK_EXPAND, 0, 0);
    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pStartMinimizedButton),
                        1, 2, 2, 3, GTK_EXPAND, GTK_EXPAND, 0, 0);

    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pChangeInterface), 0, 1, 3, 4,
                        GTK_EXPAND, GTK_EXPAND, 0, 0);
    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pRootModeButton), 1, 2, 3, 4,
                        GTK_EXPAND, GTK_EXPAND, 0, 0);

    ::GtkWidget* const pLabel (::gtk_label_new
                                            ("Leave priviliged mode after"));
    ::gtk_table_attach_defaults (m_pTable, pLabel, 0, 1, 4, 5);
    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pLeaveRootModeBox),
                        1, 2, 4, 5, GTK_FILL, GTK_SHRINK, 0, 0);
    
    ::gtk_combo_box_append_text (m_pLeaveRootModeBox, "Disabled");
    for (unsigned i (0) ; i < NbDelay ; ++i)
    {
        std::ostringstream Os;
        Os << TabDelay [i] << " minute" << (TabDelay [i] > 1 ? 's' : '\0');
        ::gtk_combo_box_append_text (m_pLeaveRootModeBox, Os.str().c_str());
    }

    ::gtk_table_attach (m_pTable, GTK_WIDGET (m_pAboutButton), 0, 2, 5, 6,
                        GTK_EXPAND, GTK_EXPAND, 0, 0);

    ::g_signal_connect (G_OBJECT (m_pAboutButton), "clicked",
                        G_CALLBACK (AboutButtonClicked), this);
    ::g_signal_connect (G_OBJECT (m_pTrayIconButton), "clicked",
                        G_CALLBACK (TrayIconButtonClicked), this);

    if (IsRoot)
    {
        ::gtk_widget_set_sensitive (GTK_WIDGET (m_pRootModeButton), false);
        ::gtk_widget_set_sensitive (pLabel, false);
        ::gtk_widget_set_sensitive (GTK_WIDGET (m_pLeaveRootModeBox), false);
    }
    ::gtk_widget_set_sensitive (GTK_WIDGET (m_pStartMinimizedButton), false);

} // BuildUI()


void nsGUI::CPrefsPage::AboutButtonClicked (::GtkButton*, CPrefsPage* This)
                                                                        throw()
{
    ::GtkAboutDialog* const m_pAboutDialog (GTK_ABOUT_DIALOG
                                                (::gtk_about_dialog_new()));
    ::gtk_window_set_transient_for (GTK_WINDOW (m_pAboutDialog),
         GTK_WINDOW (::gtk_widget_get_toplevel (GTK_WIDGET (This->m_pTable))));
    ::gtk_about_dialog_set_name (m_pAboutDialog, "RutilT");
    ::gtk_about_dialog_set_version (m_pAboutDialog,
                                                nsCore::VersionLabel.c_str());
    ::gtk_about_dialog_set_copyright (m_pAboutDialog,
                                      "Copyright © 2005-2008 Romain BONDUE");
    ::gtk_about_dialog_set_comments (m_pAboutDialog, "Wireless devices"
            " configuration tool\n with extra support for Ralink devices.");
    ::gtk_about_dialog_set_license (m_pAboutDialog,
"This program is free software; you can redistribute it and/or modify\n"
"it under the terms of the GNU General Public License as published by\n"
"the Free Software Foundation; either version 2 of the License, or\n"
"(at your option) any later version.\n"
"\n"
"This program is distributed in the hope that it will be useful,\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"GNU General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU General Public License\n"
"along with this program; if not, write to the Free Software\n"
"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA");

    ::gtk_about_dialog_set_website (m_pAboutDialog,
                                    "http://cbbk.free.fr/bonrom/");
    const char* Authors [] = {"Romain BONDUE <spy84464@hotmail.com>", "",
                              "Contributors :", "Neil Armstrong",
                              "Nicolas Favre-Félix", "Szymon Dziok",
                              "Vincent Stehlé", "Kirk Williams",
                              "Alessandro Grechi - AleXit", "Cesare Tirabassi",
                              "Misha Aizatulin", "Ben Hutchings", "",
                              "And thanks to the people who sent feedbacks,",
                              "bug reports and/or helped testing.", 0};
    ::gtk_about_dialog_set_authors (m_pAboutDialog, Authors);
    const char* Artists [] = {"Cyril BONDUE", 0};
    ::gtk_about_dialog_set_artists (m_pAboutDialog, Artists);
    ::gtk_about_dialog_set_documenters (m_pAboutDialog, 0);
    ::gtk_about_dialog_set_translator_credits (m_pAboutDialog, 0);

    ::g_signal_connect (G_OBJECT (m_pAboutDialog), "response",
                        G_CALLBACK (DeleteCallback), 0);

    ::gtk_widget_show_all (GTK_WIDGET (m_pAboutDialog));

} // AboutButtonClicked()


void nsGUI::CPrefsPage::SetRates (const std::vector<int>& RatesVec) throw()
{
    for ( ; m_NbRate ; --m_NbRate)
        ::gtk_combo_box_remove_text (m_pRatesBox, 0);
    if (RatesVec.empty())
    {
        ::gtk_widget_set_sensitive (GTK_WIDGET (m_pRatesLabel), false);
        ::gtk_widget_set_sensitive (GTK_WIDGET (m_pRatesBox), false);
    }
    else
    {
        ::gtk_widget_set_sensitive (GTK_WIDGET (m_pRatesLabel), true);
        ::gtk_widget_set_sensitive (GTK_WIDGET (m_pRatesBox), true);
        for (std::vector<int>::size_type i (0) ; i < RatesVec.size() ; ++i)
            ::gtk_combo_box_append_text (m_pRatesBox,
                                         ToMbpsStr (RatesVec [i]).c_str());
        m_NbRate = RatesVec.size();
    }

} // SetRates()


void nsGUI::CPrefsPage::TrayIconButtonClicked (::GtkToggleButton* pButton,
                                               CPrefsPage* This) throw()
{
    if (::gtk_toggle_button_get_active (pButton))
        ::gtk_widget_set_sensitive (GTK_WIDGET (This->m_pStartMinimizedButton),
                                    true);
    else
    {
        ::gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
                                            (This->m_pStartMinimizedButton),
                                        false);
        ::gtk_widget_set_sensitive (GTK_WIDGET (This->m_pStartMinimizedButton),
                                    false);
    }

} // TrayIconButtonClicked()


unsigned nsGUI::CPrefsPage::GetAutoLeaveRootDelay () const throw()
{
    const char* const DelayStr (::gtk_combo_box_get_active_text
                                                        (m_pLeaveRootModeBox));

    unsigned Delay (0);
    if (DelayStr)
    {
        std::istringstream Is (DelayStr);
        Is >> Delay;
    }
    return Delay * 60;

} // GetAutoLeaveRootDelay()


void nsGUI::CPrefsPage::SetAutoLeaveRootDelay (unsigned Delay) throw()
{
    Delay /= 60;
    for (unsigned i (0) ; i < NbDelay ; ++i)
        if (Delay == TabDelay [i])
        {
            ::gtk_combo_box_set_active (m_pLeaveRootModeBox, i + 1);
            return;
        }
    ::gtk_combo_box_set_active (m_pLeaveRootModeBox, 0);

} // SetAutoLeaveRootDelay()


int nsGUI::CPrefsPage::GetSelectedRate () const throw()
{
    float Rate (0.F);
    const char* const Text (::gtk_combo_box_get_active_text (m_pRatesBox));
    if (Text)
    {
        std::istringstream Is (Text);
        Is >> Rate;
    }
    return int (Rate * 1000);

} // GetSelectedRate()
