/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file SuWProtocol.h
    \author Romain BONDUE
    \date 07/01/2006 */
#ifndef __SUWPROTOCOL_H__
#define __SUWPROTOCOL_H__

#include <string>

#include "Exceptions.h"
#include "Su.h"
#include "Parameters.h"
#include "Msg.h"



namespace nsWireless
{
    class CSuWProtocol
    {
      public :
        CSuWProtocol (const std::string&, const std::string&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        void SetSSID (const std::string&) throw (nsErrors::CSystemExc);
        void SetFrequency (double) throw (nsErrors::CSystemExc);
        void SetChannel (unsigned) throw (nsErrors::CSystemExc);
        CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                             std::bad_alloc);
        void SetEncryption (const CEncryptionD&) throw (nsErrors::CSystemExc,
                                                        std::bad_alloc);
        void SetMode (Mode_e) throw (nsErrors::CSystemExc);
        void SetTxRate (int) throw (nsErrors::CSystemExc);
        void SetAPMacAddr (const CMacAddress&) throw (std::bad_alloc,
                                                      nsErrors::CSystemExc);
        void Scan () throw (nsErrors::CSystemExc);
        void Commit () throw (nsErrors::CSystemExc);


      protected :
        nsRoot::CMsg SuDo (const nsRoot::CMsg&) throw (nsErrors::CSystemExc);
        template<typename T>
        void SuDo (T, int) throw (nsErrors::CSystemExc);


      private :
        nsRoot::CSu m_Su;

    }; // CSuWProtocol

} // namespace nsWireless

#include "private/SuWProtocol.hxx"

#endif // __SUWPROTOCOL_H__
