//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline 25519_scalar 32 '2^252 + 27742317777372353535851937790883648493' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: 25519_scalar
//! machine_wordsize = 32 (from "32")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0x1000000000000000000000000000000014def9dea2f79cd65812631a5cf5d3ed (from "2^252 + 27742317777372353535851937790883648493")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) in
//!                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

pub type fiat_25519_scalar_u1 = u8;
pub type fiat_25519_scalar_i1 = i8;
pub type fiat_25519_scalar_u2 = u8;
pub type fiat_25519_scalar_i2 = i8;

/* The type fiat_25519_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
pub type fiat_25519_scalar_montgomery_domain_field_element = [u32; 8];

/* The type fiat_25519_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
pub type fiat_25519_scalar_non_montgomery_domain_field_element = [u32; 8];


/// The function fiat_25519_scalar_addcarryx_u32 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^32
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_scalar_addcarryx_u32(out1: &mut u32, out2: &mut fiat_25519_scalar_u1, arg1: fiat_25519_scalar_u1, arg2: u32, arg3: u32) -> () {
  let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: fiat_25519_scalar_u1 = ((x1 >> 32) as fiat_25519_scalar_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_scalar_subborrowx_u32 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^32
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_scalar_subborrowx_u32(out1: &mut u32, out2: &mut fiat_25519_scalar_u1, arg1: fiat_25519_scalar_u1, arg2: u32, arg3: u32) -> () {
  let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
  let x2: fiat_25519_scalar_i1 = ((x1 >> 32) as fiat_25519_scalar_i1);
  let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_25519_scalar_i2) - (x2 as fiat_25519_scalar_i2)) as fiat_25519_scalar_u1);
}

/// The function fiat_25519_scalar_mulx_u32 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^32
///   out2 = ⌊arg1 * arg2 / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_25519_scalar_mulx_u32(out1: &mut u32, out2: &mut u32, arg1: u32, arg2: u32) -> () {
  let x1: u64 = ((arg1 as u64) * (arg2 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: u32 = ((x1 >> 32) as u32);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_scalar_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_25519_scalar_cmovznz_u32(out1: &mut u32, arg1: fiat_25519_scalar_u1, arg2: u32, arg3: u32) -> () {
  let x1: fiat_25519_scalar_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_25519_scalar_i2) - (x1 as fiat_25519_scalar_i2)) as fiat_25519_scalar_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_25519_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_mul(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) -> () {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x9, &mut x10, x8, (arg2[7]));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x11, &mut x12, x8, (arg2[6]));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x13, &mut x14, x8, (arg2[5]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x15, &mut x16, x8, (arg2[4]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x17, &mut x18, x8, (arg2[3]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x19, &mut x20, x8, (arg2[2]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x21, &mut x22, x8, (arg2[1]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x23, &mut x24, x8, (arg2[0]));
  let mut x25: u32 = 0;
  let mut x26: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x40, &mut x41, x23, 0x12547e1b);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x42, &mut x43, x40, 0x10000000);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x44, &mut x45, x40, 0x14def9de);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x46, &mut x47, x40, 0xa2f79cd6);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x48, &mut x49, x40, 0x5812631a);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x50, &mut x51, x40, 0x5cf5d3ed);
  let mut x52: u32 = 0;
  let mut x53: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x52, &mut x53, 0x0, x51, x48);
  let mut x54: u32 = 0;
  let mut x55: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x54, &mut x55, x53, x49, x46);
  let mut x56: u32 = 0;
  let mut x57: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x56, &mut x57, x55, x47, x44);
  let x58: u32 = ((x57 as u32) + x45);
  let mut x59: u32 = 0;
  let mut x60: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x59, &mut x60, 0x0, x23, x50);
  let mut x61: u32 = 0;
  let mut x62: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x61, &mut x62, x60, x25, x52);
  let mut x63: u32 = 0;
  let mut x64: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x63, &mut x64, x62, x27, x54);
  let mut x65: u32 = 0;
  let mut x66: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x65, &mut x66, x64, x29, x56);
  let mut x67: u32 = 0;
  let mut x68: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x67, &mut x68, x66, x31, x58);
  let mut x69: u32 = 0;
  let mut x70: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x69, &mut x70, x68, x33, (0x0 as u32));
  let mut x71: u32 = 0;
  let mut x72: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x71, &mut x72, x70, x35, (0x0 as u32));
  let mut x73: u32 = 0;
  let mut x74: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x73, &mut x74, x72, x37, x42);
  let mut x75: u32 = 0;
  let mut x76: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x75, &mut x76, x74, x39, x43);
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x77, &mut x78, x1, (arg2[7]));
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x79, &mut x80, x1, (arg2[6]));
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x81, &mut x82, x1, (arg2[5]));
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x83, &mut x84, x1, (arg2[4]));
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x85, &mut x86, x1, (arg2[3]));
  let mut x87: u32 = 0;
  let mut x88: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x87, &mut x88, x1, (arg2[2]));
  let mut x89: u32 = 0;
  let mut x90: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x89, &mut x90, x1, (arg2[1]));
  let mut x91: u32 = 0;
  let mut x92: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x91, &mut x92, x1, (arg2[0]));
  let mut x93: u32 = 0;
  let mut x94: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x93, &mut x94, 0x0, x92, x89);
  let mut x95: u32 = 0;
  let mut x96: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x95, &mut x96, x94, x90, x87);
  let mut x97: u32 = 0;
  let mut x98: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x97, &mut x98, x96, x88, x85);
  let mut x99: u32 = 0;
  let mut x100: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x99, &mut x100, x98, x86, x83);
  let mut x101: u32 = 0;
  let mut x102: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x101, &mut x102, x100, x84, x81);
  let mut x103: u32 = 0;
  let mut x104: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x103, &mut x104, x102, x82, x79);
  let mut x105: u32 = 0;
  let mut x106: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x105, &mut x106, x104, x80, x77);
  let x107: u32 = ((x106 as u32) + x78);
  let mut x108: u32 = 0;
  let mut x109: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x108, &mut x109, 0x0, x61, x91);
  let mut x110: u32 = 0;
  let mut x111: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x110, &mut x111, x109, x63, x93);
  let mut x112: u32 = 0;
  let mut x113: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x112, &mut x113, x111, x65, x95);
  let mut x114: u32 = 0;
  let mut x115: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x114, &mut x115, x113, x67, x97);
  let mut x116: u32 = 0;
  let mut x117: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x116, &mut x117, x115, x69, x99);
  let mut x118: u32 = 0;
  let mut x119: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x118, &mut x119, x117, x71, x101);
  let mut x120: u32 = 0;
  let mut x121: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x120, &mut x121, x119, x73, x103);
  let mut x122: u32 = 0;
  let mut x123: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x122, &mut x123, x121, x75, x105);
  let mut x124: u32 = 0;
  let mut x125: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x124, &mut x125, x123, (x76 as u32), x107);
  let mut x126: u32 = 0;
  let mut x127: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x126, &mut x127, x108, 0x12547e1b);
  let mut x128: u32 = 0;
  let mut x129: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x128, &mut x129, x126, 0x10000000);
  let mut x130: u32 = 0;
  let mut x131: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x130, &mut x131, x126, 0x14def9de);
  let mut x132: u32 = 0;
  let mut x133: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x132, &mut x133, x126, 0xa2f79cd6);
  let mut x134: u32 = 0;
  let mut x135: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x134, &mut x135, x126, 0x5812631a);
  let mut x136: u32 = 0;
  let mut x137: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x136, &mut x137, x126, 0x5cf5d3ed);
  let mut x138: u32 = 0;
  let mut x139: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x138, &mut x139, 0x0, x137, x134);
  let mut x140: u32 = 0;
  let mut x141: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x140, &mut x141, x139, x135, x132);
  let mut x142: u32 = 0;
  let mut x143: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x142, &mut x143, x141, x133, x130);
  let x144: u32 = ((x143 as u32) + x131);
  let mut x145: u32 = 0;
  let mut x146: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x145, &mut x146, 0x0, x108, x136);
  let mut x147: u32 = 0;
  let mut x148: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x147, &mut x148, x146, x110, x138);
  let mut x149: u32 = 0;
  let mut x150: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x149, &mut x150, x148, x112, x140);
  let mut x151: u32 = 0;
  let mut x152: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x151, &mut x152, x150, x114, x142);
  let mut x153: u32 = 0;
  let mut x154: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x153, &mut x154, x152, x116, x144);
  let mut x155: u32 = 0;
  let mut x156: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x155, &mut x156, x154, x118, (0x0 as u32));
  let mut x157: u32 = 0;
  let mut x158: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x157, &mut x158, x156, x120, (0x0 as u32));
  let mut x159: u32 = 0;
  let mut x160: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x159, &mut x160, x158, x122, x128);
  let mut x161: u32 = 0;
  let mut x162: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x161, &mut x162, x160, x124, x129);
  let x163: u32 = ((x162 as u32) + (x125 as u32));
  let mut x164: u32 = 0;
  let mut x165: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x164, &mut x165, x2, (arg2[7]));
  let mut x166: u32 = 0;
  let mut x167: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x166, &mut x167, x2, (arg2[6]));
  let mut x168: u32 = 0;
  let mut x169: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x168, &mut x169, x2, (arg2[5]));
  let mut x170: u32 = 0;
  let mut x171: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x170, &mut x171, x2, (arg2[4]));
  let mut x172: u32 = 0;
  let mut x173: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x172, &mut x173, x2, (arg2[3]));
  let mut x174: u32 = 0;
  let mut x175: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x174, &mut x175, x2, (arg2[2]));
  let mut x176: u32 = 0;
  let mut x177: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x176, &mut x177, x2, (arg2[1]));
  let mut x178: u32 = 0;
  let mut x179: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x178, &mut x179, x2, (arg2[0]));
  let mut x180: u32 = 0;
  let mut x181: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x180, &mut x181, 0x0, x179, x176);
  let mut x182: u32 = 0;
  let mut x183: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x182, &mut x183, x181, x177, x174);
  let mut x184: u32 = 0;
  let mut x185: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x175, x172);
  let mut x186: u32 = 0;
  let mut x187: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x173, x170);
  let mut x188: u32 = 0;
  let mut x189: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x171, x168);
  let mut x190: u32 = 0;
  let mut x191: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x169, x166);
  let mut x192: u32 = 0;
  let mut x193: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x167, x164);
  let x194: u32 = ((x193 as u32) + x165);
  let mut x195: u32 = 0;
  let mut x196: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x195, &mut x196, 0x0, x147, x178);
  let mut x197: u32 = 0;
  let mut x198: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x197, &mut x198, x196, x149, x180);
  let mut x199: u32 = 0;
  let mut x200: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x199, &mut x200, x198, x151, x182);
  let mut x201: u32 = 0;
  let mut x202: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x201, &mut x202, x200, x153, x184);
  let mut x203: u32 = 0;
  let mut x204: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x203, &mut x204, x202, x155, x186);
  let mut x205: u32 = 0;
  let mut x206: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x205, &mut x206, x204, x157, x188);
  let mut x207: u32 = 0;
  let mut x208: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x207, &mut x208, x206, x159, x190);
  let mut x209: u32 = 0;
  let mut x210: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x209, &mut x210, x208, x161, x192);
  let mut x211: u32 = 0;
  let mut x212: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x211, &mut x212, x210, x163, x194);
  let mut x213: u32 = 0;
  let mut x214: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x213, &mut x214, x195, 0x12547e1b);
  let mut x215: u32 = 0;
  let mut x216: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x215, &mut x216, x213, 0x10000000);
  let mut x217: u32 = 0;
  let mut x218: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x217, &mut x218, x213, 0x14def9de);
  let mut x219: u32 = 0;
  let mut x220: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x219, &mut x220, x213, 0xa2f79cd6);
  let mut x221: u32 = 0;
  let mut x222: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x221, &mut x222, x213, 0x5812631a);
  let mut x223: u32 = 0;
  let mut x224: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x223, &mut x224, x213, 0x5cf5d3ed);
  let mut x225: u32 = 0;
  let mut x226: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x225, &mut x226, 0x0, x224, x221);
  let mut x227: u32 = 0;
  let mut x228: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x227, &mut x228, x226, x222, x219);
  let mut x229: u32 = 0;
  let mut x230: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x229, &mut x230, x228, x220, x217);
  let x231: u32 = ((x230 as u32) + x218);
  let mut x232: u32 = 0;
  let mut x233: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x232, &mut x233, 0x0, x195, x223);
  let mut x234: u32 = 0;
  let mut x235: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x234, &mut x235, x233, x197, x225);
  let mut x236: u32 = 0;
  let mut x237: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x199, x227);
  let mut x238: u32 = 0;
  let mut x239: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x201, x229);
  let mut x240: u32 = 0;
  let mut x241: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x203, x231);
  let mut x242: u32 = 0;
  let mut x243: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x205, (0x0 as u32));
  let mut x244: u32 = 0;
  let mut x245: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x207, (0x0 as u32));
  let mut x246: u32 = 0;
  let mut x247: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x246, &mut x247, x245, x209, x215);
  let mut x248: u32 = 0;
  let mut x249: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x248, &mut x249, x247, x211, x216);
  let x250: u32 = ((x249 as u32) + (x212 as u32));
  let mut x251: u32 = 0;
  let mut x252: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x251, &mut x252, x3, (arg2[7]));
  let mut x253: u32 = 0;
  let mut x254: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x253, &mut x254, x3, (arg2[6]));
  let mut x255: u32 = 0;
  let mut x256: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x255, &mut x256, x3, (arg2[5]));
  let mut x257: u32 = 0;
  let mut x258: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x257, &mut x258, x3, (arg2[4]));
  let mut x259: u32 = 0;
  let mut x260: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x259, &mut x260, x3, (arg2[3]));
  let mut x261: u32 = 0;
  let mut x262: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x261, &mut x262, x3, (arg2[2]));
  let mut x263: u32 = 0;
  let mut x264: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x263, &mut x264, x3, (arg2[1]));
  let mut x265: u32 = 0;
  let mut x266: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x265, &mut x266, x3, (arg2[0]));
  let mut x267: u32 = 0;
  let mut x268: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x267, &mut x268, 0x0, x266, x263);
  let mut x269: u32 = 0;
  let mut x270: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x264, x261);
  let mut x271: u32 = 0;
  let mut x272: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x262, x259);
  let mut x273: u32 = 0;
  let mut x274: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x260, x257);
  let mut x275: u32 = 0;
  let mut x276: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x275, &mut x276, x274, x258, x255);
  let mut x277: u32 = 0;
  let mut x278: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x277, &mut x278, x276, x256, x253);
  let mut x279: u32 = 0;
  let mut x280: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x279, &mut x280, x278, x254, x251);
  let x281: u32 = ((x280 as u32) + x252);
  let mut x282: u32 = 0;
  let mut x283: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x282, &mut x283, 0x0, x234, x265);
  let mut x284: u32 = 0;
  let mut x285: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x284, &mut x285, x283, x236, x267);
  let mut x286: u32 = 0;
  let mut x287: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x238, x269);
  let mut x288: u32 = 0;
  let mut x289: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x240, x271);
  let mut x290: u32 = 0;
  let mut x291: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x242, x273);
  let mut x292: u32 = 0;
  let mut x293: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x292, &mut x293, x291, x244, x275);
  let mut x294: u32 = 0;
  let mut x295: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x294, &mut x295, x293, x246, x277);
  let mut x296: u32 = 0;
  let mut x297: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x296, &mut x297, x295, x248, x279);
  let mut x298: u32 = 0;
  let mut x299: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x298, &mut x299, x297, x250, x281);
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x300, &mut x301, x282, 0x12547e1b);
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x302, &mut x303, x300, 0x10000000);
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x304, &mut x305, x300, 0x14def9de);
  let mut x306: u32 = 0;
  let mut x307: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x306, &mut x307, x300, 0xa2f79cd6);
  let mut x308: u32 = 0;
  let mut x309: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x308, &mut x309, x300, 0x5812631a);
  let mut x310: u32 = 0;
  let mut x311: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x310, &mut x311, x300, 0x5cf5d3ed);
  let mut x312: u32 = 0;
  let mut x313: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x312, &mut x313, 0x0, x311, x308);
  let mut x314: u32 = 0;
  let mut x315: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x314, &mut x315, x313, x309, x306);
  let mut x316: u32 = 0;
  let mut x317: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x316, &mut x317, x315, x307, x304);
  let x318: u32 = ((x317 as u32) + x305);
  let mut x319: u32 = 0;
  let mut x320: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x319, &mut x320, 0x0, x282, x310);
  let mut x321: u32 = 0;
  let mut x322: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x321, &mut x322, x320, x284, x312);
  let mut x323: u32 = 0;
  let mut x324: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x323, &mut x324, x322, x286, x314);
  let mut x325: u32 = 0;
  let mut x326: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x325, &mut x326, x324, x288, x316);
  let mut x327: u32 = 0;
  let mut x328: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x327, &mut x328, x326, x290, x318);
  let mut x329: u32 = 0;
  let mut x330: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x329, &mut x330, x328, x292, (0x0 as u32));
  let mut x331: u32 = 0;
  let mut x332: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x331, &mut x332, x330, x294, (0x0 as u32));
  let mut x333: u32 = 0;
  let mut x334: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x333, &mut x334, x332, x296, x302);
  let mut x335: u32 = 0;
  let mut x336: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x335, &mut x336, x334, x298, x303);
  let x337: u32 = ((x336 as u32) + (x299 as u32));
  let mut x338: u32 = 0;
  let mut x339: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x338, &mut x339, x4, (arg2[7]));
  let mut x340: u32 = 0;
  let mut x341: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x340, &mut x341, x4, (arg2[6]));
  let mut x342: u32 = 0;
  let mut x343: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x342, &mut x343, x4, (arg2[5]));
  let mut x344: u32 = 0;
  let mut x345: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x344, &mut x345, x4, (arg2[4]));
  let mut x346: u32 = 0;
  let mut x347: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x346, &mut x347, x4, (arg2[3]));
  let mut x348: u32 = 0;
  let mut x349: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x348, &mut x349, x4, (arg2[2]));
  let mut x350: u32 = 0;
  let mut x351: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x350, &mut x351, x4, (arg2[1]));
  let mut x352: u32 = 0;
  let mut x353: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x352, &mut x353, x4, (arg2[0]));
  let mut x354: u32 = 0;
  let mut x355: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x354, &mut x355, 0x0, x353, x350);
  let mut x356: u32 = 0;
  let mut x357: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x356, &mut x357, x355, x351, x348);
  let mut x358: u32 = 0;
  let mut x359: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x358, &mut x359, x357, x349, x346);
  let mut x360: u32 = 0;
  let mut x361: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x360, &mut x361, x359, x347, x344);
  let mut x362: u32 = 0;
  let mut x363: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x362, &mut x363, x361, x345, x342);
  let mut x364: u32 = 0;
  let mut x365: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x364, &mut x365, x363, x343, x340);
  let mut x366: u32 = 0;
  let mut x367: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x366, &mut x367, x365, x341, x338);
  let x368: u32 = ((x367 as u32) + x339);
  let mut x369: u32 = 0;
  let mut x370: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x369, &mut x370, 0x0, x321, x352);
  let mut x371: u32 = 0;
  let mut x372: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x371, &mut x372, x370, x323, x354);
  let mut x373: u32 = 0;
  let mut x374: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x373, &mut x374, x372, x325, x356);
  let mut x375: u32 = 0;
  let mut x376: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x375, &mut x376, x374, x327, x358);
  let mut x377: u32 = 0;
  let mut x378: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x377, &mut x378, x376, x329, x360);
  let mut x379: u32 = 0;
  let mut x380: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x379, &mut x380, x378, x331, x362);
  let mut x381: u32 = 0;
  let mut x382: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x381, &mut x382, x380, x333, x364);
  let mut x383: u32 = 0;
  let mut x384: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x383, &mut x384, x382, x335, x366);
  let mut x385: u32 = 0;
  let mut x386: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x337, x368);
  let mut x387: u32 = 0;
  let mut x388: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x387, &mut x388, x369, 0x12547e1b);
  let mut x389: u32 = 0;
  let mut x390: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x389, &mut x390, x387, 0x10000000);
  let mut x391: u32 = 0;
  let mut x392: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x391, &mut x392, x387, 0x14def9de);
  let mut x393: u32 = 0;
  let mut x394: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x393, &mut x394, x387, 0xa2f79cd6);
  let mut x395: u32 = 0;
  let mut x396: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x395, &mut x396, x387, 0x5812631a);
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x397, &mut x398, x387, 0x5cf5d3ed);
  let mut x399: u32 = 0;
  let mut x400: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x399, &mut x400, 0x0, x398, x395);
  let mut x401: u32 = 0;
  let mut x402: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x401, &mut x402, x400, x396, x393);
  let mut x403: u32 = 0;
  let mut x404: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x403, &mut x404, x402, x394, x391);
  let x405: u32 = ((x404 as u32) + x392);
  let mut x406: u32 = 0;
  let mut x407: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x406, &mut x407, 0x0, x369, x397);
  let mut x408: u32 = 0;
  let mut x409: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x408, &mut x409, x407, x371, x399);
  let mut x410: u32 = 0;
  let mut x411: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x410, &mut x411, x409, x373, x401);
  let mut x412: u32 = 0;
  let mut x413: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x412, &mut x413, x411, x375, x403);
  let mut x414: u32 = 0;
  let mut x415: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x414, &mut x415, x413, x377, x405);
  let mut x416: u32 = 0;
  let mut x417: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x416, &mut x417, x415, x379, (0x0 as u32));
  let mut x418: u32 = 0;
  let mut x419: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x381, (0x0 as u32));
  let mut x420: u32 = 0;
  let mut x421: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x383, x389);
  let mut x422: u32 = 0;
  let mut x423: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x385, x390);
  let x424: u32 = ((x423 as u32) + (x386 as u32));
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x425, &mut x426, x5, (arg2[7]));
  let mut x427: u32 = 0;
  let mut x428: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x427, &mut x428, x5, (arg2[6]));
  let mut x429: u32 = 0;
  let mut x430: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x429, &mut x430, x5, (arg2[5]));
  let mut x431: u32 = 0;
  let mut x432: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x431, &mut x432, x5, (arg2[4]));
  let mut x433: u32 = 0;
  let mut x434: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x433, &mut x434, x5, (arg2[3]));
  let mut x435: u32 = 0;
  let mut x436: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x435, &mut x436, x5, (arg2[2]));
  let mut x437: u32 = 0;
  let mut x438: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x437, &mut x438, x5, (arg2[1]));
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x439, &mut x440, x5, (arg2[0]));
  let mut x441: u32 = 0;
  let mut x442: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x441, &mut x442, 0x0, x440, x437);
  let mut x443: u32 = 0;
  let mut x444: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x443, &mut x444, x442, x438, x435);
  let mut x445: u32 = 0;
  let mut x446: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x445, &mut x446, x444, x436, x433);
  let mut x447: u32 = 0;
  let mut x448: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x447, &mut x448, x446, x434, x431);
  let mut x449: u32 = 0;
  let mut x450: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x449, &mut x450, x448, x432, x429);
  let mut x451: u32 = 0;
  let mut x452: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x451, &mut x452, x450, x430, x427);
  let mut x453: u32 = 0;
  let mut x454: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x453, &mut x454, x452, x428, x425);
  let x455: u32 = ((x454 as u32) + x426);
  let mut x456: u32 = 0;
  let mut x457: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x456, &mut x457, 0x0, x408, x439);
  let mut x458: u32 = 0;
  let mut x459: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x458, &mut x459, x457, x410, x441);
  let mut x460: u32 = 0;
  let mut x461: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x460, &mut x461, x459, x412, x443);
  let mut x462: u32 = 0;
  let mut x463: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x462, &mut x463, x461, x414, x445);
  let mut x464: u32 = 0;
  let mut x465: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x464, &mut x465, x463, x416, x447);
  let mut x466: u32 = 0;
  let mut x467: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x466, &mut x467, x465, x418, x449);
  let mut x468: u32 = 0;
  let mut x469: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x468, &mut x469, x467, x420, x451);
  let mut x470: u32 = 0;
  let mut x471: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x470, &mut x471, x469, x422, x453);
  let mut x472: u32 = 0;
  let mut x473: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x472, &mut x473, x471, x424, x455);
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x474, &mut x475, x456, 0x12547e1b);
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x476, &mut x477, x474, 0x10000000);
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x478, &mut x479, x474, 0x14def9de);
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x480, &mut x481, x474, 0xa2f79cd6);
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x482, &mut x483, x474, 0x5812631a);
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x484, &mut x485, x474, 0x5cf5d3ed);
  let mut x486: u32 = 0;
  let mut x487: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x486, &mut x487, 0x0, x485, x482);
  let mut x488: u32 = 0;
  let mut x489: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x483, x480);
  let mut x490: u32 = 0;
  let mut x491: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x481, x478);
  let x492: u32 = ((x491 as u32) + x479);
  let mut x493: u32 = 0;
  let mut x494: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x493, &mut x494, 0x0, x456, x484);
  let mut x495: u32 = 0;
  let mut x496: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x495, &mut x496, x494, x458, x486);
  let mut x497: u32 = 0;
  let mut x498: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x497, &mut x498, x496, x460, x488);
  let mut x499: u32 = 0;
  let mut x500: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x499, &mut x500, x498, x462, x490);
  let mut x501: u32 = 0;
  let mut x502: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x501, &mut x502, x500, x464, x492);
  let mut x503: u32 = 0;
  let mut x504: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x503, &mut x504, x502, x466, (0x0 as u32));
  let mut x505: u32 = 0;
  let mut x506: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x505, &mut x506, x504, x468, (0x0 as u32));
  let mut x507: u32 = 0;
  let mut x508: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x507, &mut x508, x506, x470, x476);
  let mut x509: u32 = 0;
  let mut x510: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x509, &mut x510, x508, x472, x477);
  let x511: u32 = ((x510 as u32) + (x473 as u32));
  let mut x512: u32 = 0;
  let mut x513: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x512, &mut x513, x6, (arg2[7]));
  let mut x514: u32 = 0;
  let mut x515: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x514, &mut x515, x6, (arg2[6]));
  let mut x516: u32 = 0;
  let mut x517: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x516, &mut x517, x6, (arg2[5]));
  let mut x518: u32 = 0;
  let mut x519: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x518, &mut x519, x6, (arg2[4]));
  let mut x520: u32 = 0;
  let mut x521: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x520, &mut x521, x6, (arg2[3]));
  let mut x522: u32 = 0;
  let mut x523: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x522, &mut x523, x6, (arg2[2]));
  let mut x524: u32 = 0;
  let mut x525: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x524, &mut x525, x6, (arg2[1]));
  let mut x526: u32 = 0;
  let mut x527: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x526, &mut x527, x6, (arg2[0]));
  let mut x528: u32 = 0;
  let mut x529: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x528, &mut x529, 0x0, x527, x524);
  let mut x530: u32 = 0;
  let mut x531: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x530, &mut x531, x529, x525, x522);
  let mut x532: u32 = 0;
  let mut x533: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x532, &mut x533, x531, x523, x520);
  let mut x534: u32 = 0;
  let mut x535: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x521, x518);
  let mut x536: u32 = 0;
  let mut x537: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x519, x516);
  let mut x538: u32 = 0;
  let mut x539: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x517, x514);
  let mut x540: u32 = 0;
  let mut x541: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x540, &mut x541, x539, x515, x512);
  let x542: u32 = ((x541 as u32) + x513);
  let mut x543: u32 = 0;
  let mut x544: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x543, &mut x544, 0x0, x495, x526);
  let mut x545: u32 = 0;
  let mut x546: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x545, &mut x546, x544, x497, x528);
  let mut x547: u32 = 0;
  let mut x548: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x547, &mut x548, x546, x499, x530);
  let mut x549: u32 = 0;
  let mut x550: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x549, &mut x550, x548, x501, x532);
  let mut x551: u32 = 0;
  let mut x552: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x551, &mut x552, x550, x503, x534);
  let mut x553: u32 = 0;
  let mut x554: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x553, &mut x554, x552, x505, x536);
  let mut x555: u32 = 0;
  let mut x556: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x555, &mut x556, x554, x507, x538);
  let mut x557: u32 = 0;
  let mut x558: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x557, &mut x558, x556, x509, x540);
  let mut x559: u32 = 0;
  let mut x560: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x559, &mut x560, x558, x511, x542);
  let mut x561: u32 = 0;
  let mut x562: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x561, &mut x562, x543, 0x12547e1b);
  let mut x563: u32 = 0;
  let mut x564: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x563, &mut x564, x561, 0x10000000);
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x565, &mut x566, x561, 0x14def9de);
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x567, &mut x568, x561, 0xa2f79cd6);
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x569, &mut x570, x561, 0x5812631a);
  let mut x571: u32 = 0;
  let mut x572: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x571, &mut x572, x561, 0x5cf5d3ed);
  let mut x573: u32 = 0;
  let mut x574: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x573, &mut x574, 0x0, x572, x569);
  let mut x575: u32 = 0;
  let mut x576: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x575, &mut x576, x574, x570, x567);
  let mut x577: u32 = 0;
  let mut x578: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x577, &mut x578, x576, x568, x565);
  let x579: u32 = ((x578 as u32) + x566);
  let mut x580: u32 = 0;
  let mut x581: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x580, &mut x581, 0x0, x543, x571);
  let mut x582: u32 = 0;
  let mut x583: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x582, &mut x583, x581, x545, x573);
  let mut x584: u32 = 0;
  let mut x585: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x584, &mut x585, x583, x547, x575);
  let mut x586: u32 = 0;
  let mut x587: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x586, &mut x587, x585, x549, x577);
  let mut x588: u32 = 0;
  let mut x589: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x588, &mut x589, x587, x551, x579);
  let mut x590: u32 = 0;
  let mut x591: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x590, &mut x591, x589, x553, (0x0 as u32));
  let mut x592: u32 = 0;
  let mut x593: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x592, &mut x593, x591, x555, (0x0 as u32));
  let mut x594: u32 = 0;
  let mut x595: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x594, &mut x595, x593, x557, x563);
  let mut x596: u32 = 0;
  let mut x597: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x596, &mut x597, x595, x559, x564);
  let x598: u32 = ((x597 as u32) + (x560 as u32));
  let mut x599: u32 = 0;
  let mut x600: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x599, &mut x600, x7, (arg2[7]));
  let mut x601: u32 = 0;
  let mut x602: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x601, &mut x602, x7, (arg2[6]));
  let mut x603: u32 = 0;
  let mut x604: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x603, &mut x604, x7, (arg2[5]));
  let mut x605: u32 = 0;
  let mut x606: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x605, &mut x606, x7, (arg2[4]));
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x607, &mut x608, x7, (arg2[3]));
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x609, &mut x610, x7, (arg2[2]));
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x611, &mut x612, x7, (arg2[1]));
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x613, &mut x614, x7, (arg2[0]));
  let mut x615: u32 = 0;
  let mut x616: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x615, &mut x616, 0x0, x614, x611);
  let mut x617: u32 = 0;
  let mut x618: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x617, &mut x618, x616, x612, x609);
  let mut x619: u32 = 0;
  let mut x620: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x619, &mut x620, x618, x610, x607);
  let mut x621: u32 = 0;
  let mut x622: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x621, &mut x622, x620, x608, x605);
  let mut x623: u32 = 0;
  let mut x624: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x623, &mut x624, x622, x606, x603);
  let mut x625: u32 = 0;
  let mut x626: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x625, &mut x626, x624, x604, x601);
  let mut x627: u32 = 0;
  let mut x628: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x627, &mut x628, x626, x602, x599);
  let x629: u32 = ((x628 as u32) + x600);
  let mut x630: u32 = 0;
  let mut x631: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x630, &mut x631, 0x0, x582, x613);
  let mut x632: u32 = 0;
  let mut x633: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x632, &mut x633, x631, x584, x615);
  let mut x634: u32 = 0;
  let mut x635: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x634, &mut x635, x633, x586, x617);
  let mut x636: u32 = 0;
  let mut x637: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x636, &mut x637, x635, x588, x619);
  let mut x638: u32 = 0;
  let mut x639: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x638, &mut x639, x637, x590, x621);
  let mut x640: u32 = 0;
  let mut x641: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x640, &mut x641, x639, x592, x623);
  let mut x642: u32 = 0;
  let mut x643: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x642, &mut x643, x641, x594, x625);
  let mut x644: u32 = 0;
  let mut x645: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x644, &mut x645, x643, x596, x627);
  let mut x646: u32 = 0;
  let mut x647: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x646, &mut x647, x645, x598, x629);
  let mut x648: u32 = 0;
  let mut x649: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x648, &mut x649, x630, 0x12547e1b);
  let mut x650: u32 = 0;
  let mut x651: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x650, &mut x651, x648, 0x10000000);
  let mut x652: u32 = 0;
  let mut x653: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x652, &mut x653, x648, 0x14def9de);
  let mut x654: u32 = 0;
  let mut x655: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x654, &mut x655, x648, 0xa2f79cd6);
  let mut x656: u32 = 0;
  let mut x657: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x656, &mut x657, x648, 0x5812631a);
  let mut x658: u32 = 0;
  let mut x659: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x658, &mut x659, x648, 0x5cf5d3ed);
  let mut x660: u32 = 0;
  let mut x661: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x660, &mut x661, 0x0, x659, x656);
  let mut x662: u32 = 0;
  let mut x663: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x662, &mut x663, x661, x657, x654);
  let mut x664: u32 = 0;
  let mut x665: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x664, &mut x665, x663, x655, x652);
  let x666: u32 = ((x665 as u32) + x653);
  let mut x667: u32 = 0;
  let mut x668: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x667, &mut x668, 0x0, x630, x658);
  let mut x669: u32 = 0;
  let mut x670: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x669, &mut x670, x668, x632, x660);
  let mut x671: u32 = 0;
  let mut x672: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x671, &mut x672, x670, x634, x662);
  let mut x673: u32 = 0;
  let mut x674: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x673, &mut x674, x672, x636, x664);
  let mut x675: u32 = 0;
  let mut x676: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x675, &mut x676, x674, x638, x666);
  let mut x677: u32 = 0;
  let mut x678: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x677, &mut x678, x676, x640, (0x0 as u32));
  let mut x679: u32 = 0;
  let mut x680: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x679, &mut x680, x678, x642, (0x0 as u32));
  let mut x681: u32 = 0;
  let mut x682: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x681, &mut x682, x680, x644, x650);
  let mut x683: u32 = 0;
  let mut x684: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x683, &mut x684, x682, x646, x651);
  let x685: u32 = ((x684 as u32) + (x647 as u32));
  let mut x686: u32 = 0;
  let mut x687: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x686, &mut x687, 0x0, x669, 0x5cf5d3ed);
  let mut x688: u32 = 0;
  let mut x689: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x688, &mut x689, x687, x671, 0x5812631a);
  let mut x690: u32 = 0;
  let mut x691: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x690, &mut x691, x689, x673, 0xa2f79cd6);
  let mut x692: u32 = 0;
  let mut x693: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x692, &mut x693, x691, x675, 0x14def9de);
  let mut x694: u32 = 0;
  let mut x695: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x694, &mut x695, x693, x677, (0x0 as u32));
  let mut x696: u32 = 0;
  let mut x697: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x696, &mut x697, x695, x679, (0x0 as u32));
  let mut x698: u32 = 0;
  let mut x699: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x698, &mut x699, x697, x681, (0x0 as u32));
  let mut x700: u32 = 0;
  let mut x701: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x700, &mut x701, x699, x683, 0x10000000);
  let mut x702: u32 = 0;
  let mut x703: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x702, &mut x703, x701, x685, (0x0 as u32));
  let mut x704: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x704, x703, x686, x669);
  let mut x705: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x705, x703, x688, x671);
  let mut x706: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x706, x703, x690, x673);
  let mut x707: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x707, x703, x692, x675);
  let mut x708: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x708, x703, x694, x677);
  let mut x709: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x709, x703, x696, x679);
  let mut x710: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x710, x703, x698, x681);
  let mut x711: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x711, x703, x700, x683);
  out1[0] = x704;
  out1[1] = x705;
  out1[2] = x706;
  out1[3] = x707;
  out1[4] = x708;
  out1[5] = x709;
  out1[6] = x710;
  out1[7] = x711;
}

/// The function fiat_25519_scalar_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_square(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element) -> () {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x9, &mut x10, x8, (arg1[7]));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x11, &mut x12, x8, (arg1[6]));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x13, &mut x14, x8, (arg1[5]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x15, &mut x16, x8, (arg1[4]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x17, &mut x18, x8, (arg1[3]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x19, &mut x20, x8, (arg1[2]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x21, &mut x22, x8, (arg1[1]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x23, &mut x24, x8, (arg1[0]));
  let mut x25: u32 = 0;
  let mut x26: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x40, &mut x41, x23, 0x12547e1b);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x42, &mut x43, x40, 0x10000000);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x44, &mut x45, x40, 0x14def9de);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x46, &mut x47, x40, 0xa2f79cd6);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x48, &mut x49, x40, 0x5812631a);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x50, &mut x51, x40, 0x5cf5d3ed);
  let mut x52: u32 = 0;
  let mut x53: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x52, &mut x53, 0x0, x51, x48);
  let mut x54: u32 = 0;
  let mut x55: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x54, &mut x55, x53, x49, x46);
  let mut x56: u32 = 0;
  let mut x57: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x56, &mut x57, x55, x47, x44);
  let x58: u32 = ((x57 as u32) + x45);
  let mut x59: u32 = 0;
  let mut x60: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x59, &mut x60, 0x0, x23, x50);
  let mut x61: u32 = 0;
  let mut x62: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x61, &mut x62, x60, x25, x52);
  let mut x63: u32 = 0;
  let mut x64: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x63, &mut x64, x62, x27, x54);
  let mut x65: u32 = 0;
  let mut x66: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x65, &mut x66, x64, x29, x56);
  let mut x67: u32 = 0;
  let mut x68: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x67, &mut x68, x66, x31, x58);
  let mut x69: u32 = 0;
  let mut x70: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x69, &mut x70, x68, x33, (0x0 as u32));
  let mut x71: u32 = 0;
  let mut x72: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x71, &mut x72, x70, x35, (0x0 as u32));
  let mut x73: u32 = 0;
  let mut x74: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x73, &mut x74, x72, x37, x42);
  let mut x75: u32 = 0;
  let mut x76: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x75, &mut x76, x74, x39, x43);
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x77, &mut x78, x1, (arg1[7]));
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x79, &mut x80, x1, (arg1[6]));
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x81, &mut x82, x1, (arg1[5]));
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x83, &mut x84, x1, (arg1[4]));
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x85, &mut x86, x1, (arg1[3]));
  let mut x87: u32 = 0;
  let mut x88: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x87, &mut x88, x1, (arg1[2]));
  let mut x89: u32 = 0;
  let mut x90: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x89, &mut x90, x1, (arg1[1]));
  let mut x91: u32 = 0;
  let mut x92: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x91, &mut x92, x1, (arg1[0]));
  let mut x93: u32 = 0;
  let mut x94: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x93, &mut x94, 0x0, x92, x89);
  let mut x95: u32 = 0;
  let mut x96: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x95, &mut x96, x94, x90, x87);
  let mut x97: u32 = 0;
  let mut x98: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x97, &mut x98, x96, x88, x85);
  let mut x99: u32 = 0;
  let mut x100: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x99, &mut x100, x98, x86, x83);
  let mut x101: u32 = 0;
  let mut x102: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x101, &mut x102, x100, x84, x81);
  let mut x103: u32 = 0;
  let mut x104: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x103, &mut x104, x102, x82, x79);
  let mut x105: u32 = 0;
  let mut x106: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x105, &mut x106, x104, x80, x77);
  let x107: u32 = ((x106 as u32) + x78);
  let mut x108: u32 = 0;
  let mut x109: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x108, &mut x109, 0x0, x61, x91);
  let mut x110: u32 = 0;
  let mut x111: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x110, &mut x111, x109, x63, x93);
  let mut x112: u32 = 0;
  let mut x113: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x112, &mut x113, x111, x65, x95);
  let mut x114: u32 = 0;
  let mut x115: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x114, &mut x115, x113, x67, x97);
  let mut x116: u32 = 0;
  let mut x117: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x116, &mut x117, x115, x69, x99);
  let mut x118: u32 = 0;
  let mut x119: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x118, &mut x119, x117, x71, x101);
  let mut x120: u32 = 0;
  let mut x121: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x120, &mut x121, x119, x73, x103);
  let mut x122: u32 = 0;
  let mut x123: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x122, &mut x123, x121, x75, x105);
  let mut x124: u32 = 0;
  let mut x125: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x124, &mut x125, x123, (x76 as u32), x107);
  let mut x126: u32 = 0;
  let mut x127: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x126, &mut x127, x108, 0x12547e1b);
  let mut x128: u32 = 0;
  let mut x129: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x128, &mut x129, x126, 0x10000000);
  let mut x130: u32 = 0;
  let mut x131: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x130, &mut x131, x126, 0x14def9de);
  let mut x132: u32 = 0;
  let mut x133: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x132, &mut x133, x126, 0xa2f79cd6);
  let mut x134: u32 = 0;
  let mut x135: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x134, &mut x135, x126, 0x5812631a);
  let mut x136: u32 = 0;
  let mut x137: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x136, &mut x137, x126, 0x5cf5d3ed);
  let mut x138: u32 = 0;
  let mut x139: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x138, &mut x139, 0x0, x137, x134);
  let mut x140: u32 = 0;
  let mut x141: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x140, &mut x141, x139, x135, x132);
  let mut x142: u32 = 0;
  let mut x143: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x142, &mut x143, x141, x133, x130);
  let x144: u32 = ((x143 as u32) + x131);
  let mut x145: u32 = 0;
  let mut x146: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x145, &mut x146, 0x0, x108, x136);
  let mut x147: u32 = 0;
  let mut x148: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x147, &mut x148, x146, x110, x138);
  let mut x149: u32 = 0;
  let mut x150: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x149, &mut x150, x148, x112, x140);
  let mut x151: u32 = 0;
  let mut x152: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x151, &mut x152, x150, x114, x142);
  let mut x153: u32 = 0;
  let mut x154: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x153, &mut x154, x152, x116, x144);
  let mut x155: u32 = 0;
  let mut x156: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x155, &mut x156, x154, x118, (0x0 as u32));
  let mut x157: u32 = 0;
  let mut x158: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x157, &mut x158, x156, x120, (0x0 as u32));
  let mut x159: u32 = 0;
  let mut x160: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x159, &mut x160, x158, x122, x128);
  let mut x161: u32 = 0;
  let mut x162: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x161, &mut x162, x160, x124, x129);
  let x163: u32 = ((x162 as u32) + (x125 as u32));
  let mut x164: u32 = 0;
  let mut x165: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x164, &mut x165, x2, (arg1[7]));
  let mut x166: u32 = 0;
  let mut x167: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x166, &mut x167, x2, (arg1[6]));
  let mut x168: u32 = 0;
  let mut x169: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x168, &mut x169, x2, (arg1[5]));
  let mut x170: u32 = 0;
  let mut x171: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x170, &mut x171, x2, (arg1[4]));
  let mut x172: u32 = 0;
  let mut x173: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x172, &mut x173, x2, (arg1[3]));
  let mut x174: u32 = 0;
  let mut x175: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x174, &mut x175, x2, (arg1[2]));
  let mut x176: u32 = 0;
  let mut x177: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x176, &mut x177, x2, (arg1[1]));
  let mut x178: u32 = 0;
  let mut x179: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x178, &mut x179, x2, (arg1[0]));
  let mut x180: u32 = 0;
  let mut x181: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x180, &mut x181, 0x0, x179, x176);
  let mut x182: u32 = 0;
  let mut x183: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x182, &mut x183, x181, x177, x174);
  let mut x184: u32 = 0;
  let mut x185: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x175, x172);
  let mut x186: u32 = 0;
  let mut x187: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x173, x170);
  let mut x188: u32 = 0;
  let mut x189: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x171, x168);
  let mut x190: u32 = 0;
  let mut x191: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x169, x166);
  let mut x192: u32 = 0;
  let mut x193: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x167, x164);
  let x194: u32 = ((x193 as u32) + x165);
  let mut x195: u32 = 0;
  let mut x196: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x195, &mut x196, 0x0, x147, x178);
  let mut x197: u32 = 0;
  let mut x198: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x197, &mut x198, x196, x149, x180);
  let mut x199: u32 = 0;
  let mut x200: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x199, &mut x200, x198, x151, x182);
  let mut x201: u32 = 0;
  let mut x202: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x201, &mut x202, x200, x153, x184);
  let mut x203: u32 = 0;
  let mut x204: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x203, &mut x204, x202, x155, x186);
  let mut x205: u32 = 0;
  let mut x206: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x205, &mut x206, x204, x157, x188);
  let mut x207: u32 = 0;
  let mut x208: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x207, &mut x208, x206, x159, x190);
  let mut x209: u32 = 0;
  let mut x210: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x209, &mut x210, x208, x161, x192);
  let mut x211: u32 = 0;
  let mut x212: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x211, &mut x212, x210, x163, x194);
  let mut x213: u32 = 0;
  let mut x214: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x213, &mut x214, x195, 0x12547e1b);
  let mut x215: u32 = 0;
  let mut x216: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x215, &mut x216, x213, 0x10000000);
  let mut x217: u32 = 0;
  let mut x218: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x217, &mut x218, x213, 0x14def9de);
  let mut x219: u32 = 0;
  let mut x220: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x219, &mut x220, x213, 0xa2f79cd6);
  let mut x221: u32 = 0;
  let mut x222: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x221, &mut x222, x213, 0x5812631a);
  let mut x223: u32 = 0;
  let mut x224: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x223, &mut x224, x213, 0x5cf5d3ed);
  let mut x225: u32 = 0;
  let mut x226: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x225, &mut x226, 0x0, x224, x221);
  let mut x227: u32 = 0;
  let mut x228: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x227, &mut x228, x226, x222, x219);
  let mut x229: u32 = 0;
  let mut x230: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x229, &mut x230, x228, x220, x217);
  let x231: u32 = ((x230 as u32) + x218);
  let mut x232: u32 = 0;
  let mut x233: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x232, &mut x233, 0x0, x195, x223);
  let mut x234: u32 = 0;
  let mut x235: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x234, &mut x235, x233, x197, x225);
  let mut x236: u32 = 0;
  let mut x237: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x199, x227);
  let mut x238: u32 = 0;
  let mut x239: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x201, x229);
  let mut x240: u32 = 0;
  let mut x241: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x203, x231);
  let mut x242: u32 = 0;
  let mut x243: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x205, (0x0 as u32));
  let mut x244: u32 = 0;
  let mut x245: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x207, (0x0 as u32));
  let mut x246: u32 = 0;
  let mut x247: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x246, &mut x247, x245, x209, x215);
  let mut x248: u32 = 0;
  let mut x249: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x248, &mut x249, x247, x211, x216);
  let x250: u32 = ((x249 as u32) + (x212 as u32));
  let mut x251: u32 = 0;
  let mut x252: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x251, &mut x252, x3, (arg1[7]));
  let mut x253: u32 = 0;
  let mut x254: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x253, &mut x254, x3, (arg1[6]));
  let mut x255: u32 = 0;
  let mut x256: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x255, &mut x256, x3, (arg1[5]));
  let mut x257: u32 = 0;
  let mut x258: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x257, &mut x258, x3, (arg1[4]));
  let mut x259: u32 = 0;
  let mut x260: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x259, &mut x260, x3, (arg1[3]));
  let mut x261: u32 = 0;
  let mut x262: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x261, &mut x262, x3, (arg1[2]));
  let mut x263: u32 = 0;
  let mut x264: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x263, &mut x264, x3, (arg1[1]));
  let mut x265: u32 = 0;
  let mut x266: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x265, &mut x266, x3, (arg1[0]));
  let mut x267: u32 = 0;
  let mut x268: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x267, &mut x268, 0x0, x266, x263);
  let mut x269: u32 = 0;
  let mut x270: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x264, x261);
  let mut x271: u32 = 0;
  let mut x272: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x262, x259);
  let mut x273: u32 = 0;
  let mut x274: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x260, x257);
  let mut x275: u32 = 0;
  let mut x276: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x275, &mut x276, x274, x258, x255);
  let mut x277: u32 = 0;
  let mut x278: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x277, &mut x278, x276, x256, x253);
  let mut x279: u32 = 0;
  let mut x280: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x279, &mut x280, x278, x254, x251);
  let x281: u32 = ((x280 as u32) + x252);
  let mut x282: u32 = 0;
  let mut x283: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x282, &mut x283, 0x0, x234, x265);
  let mut x284: u32 = 0;
  let mut x285: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x284, &mut x285, x283, x236, x267);
  let mut x286: u32 = 0;
  let mut x287: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x238, x269);
  let mut x288: u32 = 0;
  let mut x289: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x240, x271);
  let mut x290: u32 = 0;
  let mut x291: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x242, x273);
  let mut x292: u32 = 0;
  let mut x293: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x292, &mut x293, x291, x244, x275);
  let mut x294: u32 = 0;
  let mut x295: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x294, &mut x295, x293, x246, x277);
  let mut x296: u32 = 0;
  let mut x297: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x296, &mut x297, x295, x248, x279);
  let mut x298: u32 = 0;
  let mut x299: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x298, &mut x299, x297, x250, x281);
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x300, &mut x301, x282, 0x12547e1b);
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x302, &mut x303, x300, 0x10000000);
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x304, &mut x305, x300, 0x14def9de);
  let mut x306: u32 = 0;
  let mut x307: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x306, &mut x307, x300, 0xa2f79cd6);
  let mut x308: u32 = 0;
  let mut x309: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x308, &mut x309, x300, 0x5812631a);
  let mut x310: u32 = 0;
  let mut x311: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x310, &mut x311, x300, 0x5cf5d3ed);
  let mut x312: u32 = 0;
  let mut x313: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x312, &mut x313, 0x0, x311, x308);
  let mut x314: u32 = 0;
  let mut x315: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x314, &mut x315, x313, x309, x306);
  let mut x316: u32 = 0;
  let mut x317: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x316, &mut x317, x315, x307, x304);
  let x318: u32 = ((x317 as u32) + x305);
  let mut x319: u32 = 0;
  let mut x320: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x319, &mut x320, 0x0, x282, x310);
  let mut x321: u32 = 0;
  let mut x322: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x321, &mut x322, x320, x284, x312);
  let mut x323: u32 = 0;
  let mut x324: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x323, &mut x324, x322, x286, x314);
  let mut x325: u32 = 0;
  let mut x326: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x325, &mut x326, x324, x288, x316);
  let mut x327: u32 = 0;
  let mut x328: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x327, &mut x328, x326, x290, x318);
  let mut x329: u32 = 0;
  let mut x330: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x329, &mut x330, x328, x292, (0x0 as u32));
  let mut x331: u32 = 0;
  let mut x332: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x331, &mut x332, x330, x294, (0x0 as u32));
  let mut x333: u32 = 0;
  let mut x334: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x333, &mut x334, x332, x296, x302);
  let mut x335: u32 = 0;
  let mut x336: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x335, &mut x336, x334, x298, x303);
  let x337: u32 = ((x336 as u32) + (x299 as u32));
  let mut x338: u32 = 0;
  let mut x339: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x338, &mut x339, x4, (arg1[7]));
  let mut x340: u32 = 0;
  let mut x341: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x340, &mut x341, x4, (arg1[6]));
  let mut x342: u32 = 0;
  let mut x343: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x342, &mut x343, x4, (arg1[5]));
  let mut x344: u32 = 0;
  let mut x345: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x344, &mut x345, x4, (arg1[4]));
  let mut x346: u32 = 0;
  let mut x347: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x346, &mut x347, x4, (arg1[3]));
  let mut x348: u32 = 0;
  let mut x349: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x348, &mut x349, x4, (arg1[2]));
  let mut x350: u32 = 0;
  let mut x351: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x350, &mut x351, x4, (arg1[1]));
  let mut x352: u32 = 0;
  let mut x353: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x352, &mut x353, x4, (arg1[0]));
  let mut x354: u32 = 0;
  let mut x355: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x354, &mut x355, 0x0, x353, x350);
  let mut x356: u32 = 0;
  let mut x357: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x356, &mut x357, x355, x351, x348);
  let mut x358: u32 = 0;
  let mut x359: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x358, &mut x359, x357, x349, x346);
  let mut x360: u32 = 0;
  let mut x361: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x360, &mut x361, x359, x347, x344);
  let mut x362: u32 = 0;
  let mut x363: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x362, &mut x363, x361, x345, x342);
  let mut x364: u32 = 0;
  let mut x365: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x364, &mut x365, x363, x343, x340);
  let mut x366: u32 = 0;
  let mut x367: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x366, &mut x367, x365, x341, x338);
  let x368: u32 = ((x367 as u32) + x339);
  let mut x369: u32 = 0;
  let mut x370: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x369, &mut x370, 0x0, x321, x352);
  let mut x371: u32 = 0;
  let mut x372: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x371, &mut x372, x370, x323, x354);
  let mut x373: u32 = 0;
  let mut x374: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x373, &mut x374, x372, x325, x356);
  let mut x375: u32 = 0;
  let mut x376: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x375, &mut x376, x374, x327, x358);
  let mut x377: u32 = 0;
  let mut x378: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x377, &mut x378, x376, x329, x360);
  let mut x379: u32 = 0;
  let mut x380: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x379, &mut x380, x378, x331, x362);
  let mut x381: u32 = 0;
  let mut x382: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x381, &mut x382, x380, x333, x364);
  let mut x383: u32 = 0;
  let mut x384: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x383, &mut x384, x382, x335, x366);
  let mut x385: u32 = 0;
  let mut x386: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x337, x368);
  let mut x387: u32 = 0;
  let mut x388: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x387, &mut x388, x369, 0x12547e1b);
  let mut x389: u32 = 0;
  let mut x390: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x389, &mut x390, x387, 0x10000000);
  let mut x391: u32 = 0;
  let mut x392: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x391, &mut x392, x387, 0x14def9de);
  let mut x393: u32 = 0;
  let mut x394: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x393, &mut x394, x387, 0xa2f79cd6);
  let mut x395: u32 = 0;
  let mut x396: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x395, &mut x396, x387, 0x5812631a);
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x397, &mut x398, x387, 0x5cf5d3ed);
  let mut x399: u32 = 0;
  let mut x400: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x399, &mut x400, 0x0, x398, x395);
  let mut x401: u32 = 0;
  let mut x402: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x401, &mut x402, x400, x396, x393);
  let mut x403: u32 = 0;
  let mut x404: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x403, &mut x404, x402, x394, x391);
  let x405: u32 = ((x404 as u32) + x392);
  let mut x406: u32 = 0;
  let mut x407: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x406, &mut x407, 0x0, x369, x397);
  let mut x408: u32 = 0;
  let mut x409: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x408, &mut x409, x407, x371, x399);
  let mut x410: u32 = 0;
  let mut x411: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x410, &mut x411, x409, x373, x401);
  let mut x412: u32 = 0;
  let mut x413: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x412, &mut x413, x411, x375, x403);
  let mut x414: u32 = 0;
  let mut x415: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x414, &mut x415, x413, x377, x405);
  let mut x416: u32 = 0;
  let mut x417: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x416, &mut x417, x415, x379, (0x0 as u32));
  let mut x418: u32 = 0;
  let mut x419: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x418, &mut x419, x417, x381, (0x0 as u32));
  let mut x420: u32 = 0;
  let mut x421: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x420, &mut x421, x419, x383, x389);
  let mut x422: u32 = 0;
  let mut x423: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x422, &mut x423, x421, x385, x390);
  let x424: u32 = ((x423 as u32) + (x386 as u32));
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x425, &mut x426, x5, (arg1[7]));
  let mut x427: u32 = 0;
  let mut x428: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x427, &mut x428, x5, (arg1[6]));
  let mut x429: u32 = 0;
  let mut x430: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x429, &mut x430, x5, (arg1[5]));
  let mut x431: u32 = 0;
  let mut x432: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x431, &mut x432, x5, (arg1[4]));
  let mut x433: u32 = 0;
  let mut x434: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x433, &mut x434, x5, (arg1[3]));
  let mut x435: u32 = 0;
  let mut x436: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x435, &mut x436, x5, (arg1[2]));
  let mut x437: u32 = 0;
  let mut x438: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x437, &mut x438, x5, (arg1[1]));
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x439, &mut x440, x5, (arg1[0]));
  let mut x441: u32 = 0;
  let mut x442: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x441, &mut x442, 0x0, x440, x437);
  let mut x443: u32 = 0;
  let mut x444: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x443, &mut x444, x442, x438, x435);
  let mut x445: u32 = 0;
  let mut x446: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x445, &mut x446, x444, x436, x433);
  let mut x447: u32 = 0;
  let mut x448: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x447, &mut x448, x446, x434, x431);
  let mut x449: u32 = 0;
  let mut x450: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x449, &mut x450, x448, x432, x429);
  let mut x451: u32 = 0;
  let mut x452: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x451, &mut x452, x450, x430, x427);
  let mut x453: u32 = 0;
  let mut x454: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x453, &mut x454, x452, x428, x425);
  let x455: u32 = ((x454 as u32) + x426);
  let mut x456: u32 = 0;
  let mut x457: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x456, &mut x457, 0x0, x408, x439);
  let mut x458: u32 = 0;
  let mut x459: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x458, &mut x459, x457, x410, x441);
  let mut x460: u32 = 0;
  let mut x461: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x460, &mut x461, x459, x412, x443);
  let mut x462: u32 = 0;
  let mut x463: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x462, &mut x463, x461, x414, x445);
  let mut x464: u32 = 0;
  let mut x465: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x464, &mut x465, x463, x416, x447);
  let mut x466: u32 = 0;
  let mut x467: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x466, &mut x467, x465, x418, x449);
  let mut x468: u32 = 0;
  let mut x469: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x468, &mut x469, x467, x420, x451);
  let mut x470: u32 = 0;
  let mut x471: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x470, &mut x471, x469, x422, x453);
  let mut x472: u32 = 0;
  let mut x473: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x472, &mut x473, x471, x424, x455);
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x474, &mut x475, x456, 0x12547e1b);
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x476, &mut x477, x474, 0x10000000);
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x478, &mut x479, x474, 0x14def9de);
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x480, &mut x481, x474, 0xa2f79cd6);
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x482, &mut x483, x474, 0x5812631a);
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x484, &mut x485, x474, 0x5cf5d3ed);
  let mut x486: u32 = 0;
  let mut x487: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x486, &mut x487, 0x0, x485, x482);
  let mut x488: u32 = 0;
  let mut x489: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x488, &mut x489, x487, x483, x480);
  let mut x490: u32 = 0;
  let mut x491: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x490, &mut x491, x489, x481, x478);
  let x492: u32 = ((x491 as u32) + x479);
  let mut x493: u32 = 0;
  let mut x494: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x493, &mut x494, 0x0, x456, x484);
  let mut x495: u32 = 0;
  let mut x496: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x495, &mut x496, x494, x458, x486);
  let mut x497: u32 = 0;
  let mut x498: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x497, &mut x498, x496, x460, x488);
  let mut x499: u32 = 0;
  let mut x500: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x499, &mut x500, x498, x462, x490);
  let mut x501: u32 = 0;
  let mut x502: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x501, &mut x502, x500, x464, x492);
  let mut x503: u32 = 0;
  let mut x504: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x503, &mut x504, x502, x466, (0x0 as u32));
  let mut x505: u32 = 0;
  let mut x506: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x505, &mut x506, x504, x468, (0x0 as u32));
  let mut x507: u32 = 0;
  let mut x508: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x507, &mut x508, x506, x470, x476);
  let mut x509: u32 = 0;
  let mut x510: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x509, &mut x510, x508, x472, x477);
  let x511: u32 = ((x510 as u32) + (x473 as u32));
  let mut x512: u32 = 0;
  let mut x513: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x512, &mut x513, x6, (arg1[7]));
  let mut x514: u32 = 0;
  let mut x515: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x514, &mut x515, x6, (arg1[6]));
  let mut x516: u32 = 0;
  let mut x517: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x516, &mut x517, x6, (arg1[5]));
  let mut x518: u32 = 0;
  let mut x519: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x518, &mut x519, x6, (arg1[4]));
  let mut x520: u32 = 0;
  let mut x521: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x520, &mut x521, x6, (arg1[3]));
  let mut x522: u32 = 0;
  let mut x523: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x522, &mut x523, x6, (arg1[2]));
  let mut x524: u32 = 0;
  let mut x525: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x524, &mut x525, x6, (arg1[1]));
  let mut x526: u32 = 0;
  let mut x527: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x526, &mut x527, x6, (arg1[0]));
  let mut x528: u32 = 0;
  let mut x529: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x528, &mut x529, 0x0, x527, x524);
  let mut x530: u32 = 0;
  let mut x531: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x530, &mut x531, x529, x525, x522);
  let mut x532: u32 = 0;
  let mut x533: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x532, &mut x533, x531, x523, x520);
  let mut x534: u32 = 0;
  let mut x535: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x534, &mut x535, x533, x521, x518);
  let mut x536: u32 = 0;
  let mut x537: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x536, &mut x537, x535, x519, x516);
  let mut x538: u32 = 0;
  let mut x539: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x538, &mut x539, x537, x517, x514);
  let mut x540: u32 = 0;
  let mut x541: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x540, &mut x541, x539, x515, x512);
  let x542: u32 = ((x541 as u32) + x513);
  let mut x543: u32 = 0;
  let mut x544: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x543, &mut x544, 0x0, x495, x526);
  let mut x545: u32 = 0;
  let mut x546: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x545, &mut x546, x544, x497, x528);
  let mut x547: u32 = 0;
  let mut x548: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x547, &mut x548, x546, x499, x530);
  let mut x549: u32 = 0;
  let mut x550: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x549, &mut x550, x548, x501, x532);
  let mut x551: u32 = 0;
  let mut x552: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x551, &mut x552, x550, x503, x534);
  let mut x553: u32 = 0;
  let mut x554: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x553, &mut x554, x552, x505, x536);
  let mut x555: u32 = 0;
  let mut x556: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x555, &mut x556, x554, x507, x538);
  let mut x557: u32 = 0;
  let mut x558: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x557, &mut x558, x556, x509, x540);
  let mut x559: u32 = 0;
  let mut x560: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x559, &mut x560, x558, x511, x542);
  let mut x561: u32 = 0;
  let mut x562: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x561, &mut x562, x543, 0x12547e1b);
  let mut x563: u32 = 0;
  let mut x564: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x563, &mut x564, x561, 0x10000000);
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x565, &mut x566, x561, 0x14def9de);
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x567, &mut x568, x561, 0xa2f79cd6);
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x569, &mut x570, x561, 0x5812631a);
  let mut x571: u32 = 0;
  let mut x572: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x571, &mut x572, x561, 0x5cf5d3ed);
  let mut x573: u32 = 0;
  let mut x574: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x573, &mut x574, 0x0, x572, x569);
  let mut x575: u32 = 0;
  let mut x576: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x575, &mut x576, x574, x570, x567);
  let mut x577: u32 = 0;
  let mut x578: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x577, &mut x578, x576, x568, x565);
  let x579: u32 = ((x578 as u32) + x566);
  let mut x580: u32 = 0;
  let mut x581: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x580, &mut x581, 0x0, x543, x571);
  let mut x582: u32 = 0;
  let mut x583: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x582, &mut x583, x581, x545, x573);
  let mut x584: u32 = 0;
  let mut x585: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x584, &mut x585, x583, x547, x575);
  let mut x586: u32 = 0;
  let mut x587: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x586, &mut x587, x585, x549, x577);
  let mut x588: u32 = 0;
  let mut x589: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x588, &mut x589, x587, x551, x579);
  let mut x590: u32 = 0;
  let mut x591: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x590, &mut x591, x589, x553, (0x0 as u32));
  let mut x592: u32 = 0;
  let mut x593: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x592, &mut x593, x591, x555, (0x0 as u32));
  let mut x594: u32 = 0;
  let mut x595: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x594, &mut x595, x593, x557, x563);
  let mut x596: u32 = 0;
  let mut x597: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x596, &mut x597, x595, x559, x564);
  let x598: u32 = ((x597 as u32) + (x560 as u32));
  let mut x599: u32 = 0;
  let mut x600: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x599, &mut x600, x7, (arg1[7]));
  let mut x601: u32 = 0;
  let mut x602: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x601, &mut x602, x7, (arg1[6]));
  let mut x603: u32 = 0;
  let mut x604: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x603, &mut x604, x7, (arg1[5]));
  let mut x605: u32 = 0;
  let mut x606: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x605, &mut x606, x7, (arg1[4]));
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x607, &mut x608, x7, (arg1[3]));
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x609, &mut x610, x7, (arg1[2]));
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x611, &mut x612, x7, (arg1[1]));
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x613, &mut x614, x7, (arg1[0]));
  let mut x615: u32 = 0;
  let mut x616: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x615, &mut x616, 0x0, x614, x611);
  let mut x617: u32 = 0;
  let mut x618: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x617, &mut x618, x616, x612, x609);
  let mut x619: u32 = 0;
  let mut x620: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x619, &mut x620, x618, x610, x607);
  let mut x621: u32 = 0;
  let mut x622: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x621, &mut x622, x620, x608, x605);
  let mut x623: u32 = 0;
  let mut x624: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x623, &mut x624, x622, x606, x603);
  let mut x625: u32 = 0;
  let mut x626: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x625, &mut x626, x624, x604, x601);
  let mut x627: u32 = 0;
  let mut x628: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x627, &mut x628, x626, x602, x599);
  let x629: u32 = ((x628 as u32) + x600);
  let mut x630: u32 = 0;
  let mut x631: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x630, &mut x631, 0x0, x582, x613);
  let mut x632: u32 = 0;
  let mut x633: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x632, &mut x633, x631, x584, x615);
  let mut x634: u32 = 0;
  let mut x635: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x634, &mut x635, x633, x586, x617);
  let mut x636: u32 = 0;
  let mut x637: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x636, &mut x637, x635, x588, x619);
  let mut x638: u32 = 0;
  let mut x639: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x638, &mut x639, x637, x590, x621);
  let mut x640: u32 = 0;
  let mut x641: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x640, &mut x641, x639, x592, x623);
  let mut x642: u32 = 0;
  let mut x643: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x642, &mut x643, x641, x594, x625);
  let mut x644: u32 = 0;
  let mut x645: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x644, &mut x645, x643, x596, x627);
  let mut x646: u32 = 0;
  let mut x647: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x646, &mut x647, x645, x598, x629);
  let mut x648: u32 = 0;
  let mut x649: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x648, &mut x649, x630, 0x12547e1b);
  let mut x650: u32 = 0;
  let mut x651: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x650, &mut x651, x648, 0x10000000);
  let mut x652: u32 = 0;
  let mut x653: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x652, &mut x653, x648, 0x14def9de);
  let mut x654: u32 = 0;
  let mut x655: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x654, &mut x655, x648, 0xa2f79cd6);
  let mut x656: u32 = 0;
  let mut x657: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x656, &mut x657, x648, 0x5812631a);
  let mut x658: u32 = 0;
  let mut x659: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x658, &mut x659, x648, 0x5cf5d3ed);
  let mut x660: u32 = 0;
  let mut x661: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x660, &mut x661, 0x0, x659, x656);
  let mut x662: u32 = 0;
  let mut x663: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x662, &mut x663, x661, x657, x654);
  let mut x664: u32 = 0;
  let mut x665: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x664, &mut x665, x663, x655, x652);
  let x666: u32 = ((x665 as u32) + x653);
  let mut x667: u32 = 0;
  let mut x668: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x667, &mut x668, 0x0, x630, x658);
  let mut x669: u32 = 0;
  let mut x670: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x669, &mut x670, x668, x632, x660);
  let mut x671: u32 = 0;
  let mut x672: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x671, &mut x672, x670, x634, x662);
  let mut x673: u32 = 0;
  let mut x674: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x673, &mut x674, x672, x636, x664);
  let mut x675: u32 = 0;
  let mut x676: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x675, &mut x676, x674, x638, x666);
  let mut x677: u32 = 0;
  let mut x678: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x677, &mut x678, x676, x640, (0x0 as u32));
  let mut x679: u32 = 0;
  let mut x680: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x679, &mut x680, x678, x642, (0x0 as u32));
  let mut x681: u32 = 0;
  let mut x682: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x681, &mut x682, x680, x644, x650);
  let mut x683: u32 = 0;
  let mut x684: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x683, &mut x684, x682, x646, x651);
  let x685: u32 = ((x684 as u32) + (x647 as u32));
  let mut x686: u32 = 0;
  let mut x687: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x686, &mut x687, 0x0, x669, 0x5cf5d3ed);
  let mut x688: u32 = 0;
  let mut x689: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x688, &mut x689, x687, x671, 0x5812631a);
  let mut x690: u32 = 0;
  let mut x691: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x690, &mut x691, x689, x673, 0xa2f79cd6);
  let mut x692: u32 = 0;
  let mut x693: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x692, &mut x693, x691, x675, 0x14def9de);
  let mut x694: u32 = 0;
  let mut x695: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x694, &mut x695, x693, x677, (0x0 as u32));
  let mut x696: u32 = 0;
  let mut x697: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x696, &mut x697, x695, x679, (0x0 as u32));
  let mut x698: u32 = 0;
  let mut x699: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x698, &mut x699, x697, x681, (0x0 as u32));
  let mut x700: u32 = 0;
  let mut x701: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x700, &mut x701, x699, x683, 0x10000000);
  let mut x702: u32 = 0;
  let mut x703: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x702, &mut x703, x701, x685, (0x0 as u32));
  let mut x704: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x704, x703, x686, x669);
  let mut x705: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x705, x703, x688, x671);
  let mut x706: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x706, x703, x690, x673);
  let mut x707: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x707, x703, x692, x675);
  let mut x708: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x708, x703, x694, x677);
  let mut x709: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x709, x703, x696, x679);
  let mut x710: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x710, x703, x698, x681);
  let mut x711: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x711, x703, x700, x683);
  out1[0] = x704;
  out1[1] = x705;
  out1[2] = x706;
  out1[3] = x707;
  out1[4] = x708;
  out1[5] = x709;
  out1[6] = x710;
  out1[7] = x711;
}

/// The function fiat_25519_scalar_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_add(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x17, &mut x18, 0x0, x1, 0x5cf5d3ed);
  let mut x19: u32 = 0;
  let mut x20: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x19, &mut x20, x18, x3, 0x5812631a);
  let mut x21: u32 = 0;
  let mut x22: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x21, &mut x22, x20, x5, 0xa2f79cd6);
  let mut x23: u32 = 0;
  let mut x24: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x23, &mut x24, x22, x7, 0x14def9de);
  let mut x25: u32 = 0;
  let mut x26: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x25, &mut x26, x24, x9, (0x0 as u32));
  let mut x27: u32 = 0;
  let mut x28: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x27, &mut x28, x26, x11, (0x0 as u32));
  let mut x29: u32 = 0;
  let mut x30: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x29, &mut x30, x28, x13, (0x0 as u32));
  let mut x31: u32 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x31, &mut x32, x30, x15, 0x10000000);
  let mut x33: u32 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x33, &mut x34, x32, (x16 as u32), (0x0 as u32));
  let mut x35: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x35, x34, x17, x1);
  let mut x36: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x36, x34, x19, x3);
  let mut x37: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x37, x34, x21, x5);
  let mut x38: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x38, x34, x23, x7);
  let mut x39: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x39, x34, x25, x9);
  let mut x40: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x40, x34, x27, x11);
  let mut x41: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x41, x34, x29, x13);
  let mut x42: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x42, x34, x31, x15);
  out1[0] = x35;
  out1[1] = x36;
  out1[2] = x37;
  out1[3] = x38;
  out1[4] = x39;
  out1[5] = x40;
  out1[6] = x41;
  out1[7] = x42;
}

/// The function fiat_25519_scalar_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_sub(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, (x17 & 0x5cf5d3ed));
  let mut x20: u32 = 0;
  let mut x21: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x20, &mut x21, x19, x3, (x17 & 0x5812631a));
  let mut x22: u32 = 0;
  let mut x23: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x22, &mut x23, x21, x5, (x17 & 0xa2f79cd6));
  let mut x24: u32 = 0;
  let mut x25: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x24, &mut x25, x23, x7, (x17 & 0x14def9de));
  let mut x26: u32 = 0;
  let mut x27: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x26, &mut x27, x25, x9, (0x0 as u32));
  let mut x28: u32 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x11, (0x0 as u32));
  let mut x30: u32 = 0;
  let mut x31: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x13, (0x0 as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x15, (x17 & 0x10000000));
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/// The function fiat_25519_scalar_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_opp(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x1, &mut x2, 0x0, (0x0 as u32), (arg1[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x3, &mut x4, x2, (0x0 as u32), (arg1[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x5, &mut x6, x4, (0x0 as u32), (arg1[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x7, &mut x8, x6, (0x0 as u32), (arg1[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x9, &mut x10, x8, (0x0 as u32), (arg1[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x11, &mut x12, x10, (0x0 as u32), (arg1[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x13, &mut x14, x12, (0x0 as u32), (arg1[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x15, &mut x16, x14, (0x0 as u32), (arg1[7]));
  let mut x17: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, (x17 & 0x5cf5d3ed));
  let mut x20: u32 = 0;
  let mut x21: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x20, &mut x21, x19, x3, (x17 & 0x5812631a));
  let mut x22: u32 = 0;
  let mut x23: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x22, &mut x23, x21, x5, (x17 & 0xa2f79cd6));
  let mut x24: u32 = 0;
  let mut x25: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x24, &mut x25, x23, x7, (x17 & 0x14def9de));
  let mut x26: u32 = 0;
  let mut x27: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x26, &mut x27, x25, x9, (0x0 as u32));
  let mut x28: u32 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x28, &mut x29, x27, x11, (0x0 as u32));
  let mut x30: u32 = 0;
  let mut x31: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x13, (0x0 as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x15, (x17 & 0x10000000));
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/// The function fiat_25519_scalar_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_from_montgomery(out1: &mut fiat_25519_scalar_non_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element) -> () {
  let x1: u32 = (arg1[0]);
  let mut x2: u32 = 0;
  let mut x3: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x2, &mut x3, x1, 0x12547e1b);
  let mut x4: u32 = 0;
  let mut x5: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x4, &mut x5, x2, 0x10000000);
  let mut x6: u32 = 0;
  let mut x7: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x6, &mut x7, x2, 0x14def9de);
  let mut x8: u32 = 0;
  let mut x9: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x8, &mut x9, x2, 0xa2f79cd6);
  let mut x10: u32 = 0;
  let mut x11: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x10, &mut x11, x2, 0x5812631a);
  let mut x12: u32 = 0;
  let mut x13: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x12, &mut x13, x2, 0x5cf5d3ed);
  let mut x14: u32 = 0;
  let mut x15: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x14, &mut x15, 0x0, x13, x10);
  let mut x16: u32 = 0;
  let mut x17: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x16, &mut x17, x15, x11, x8);
  let mut x18: u32 = 0;
  let mut x19: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x18, &mut x19, x17, x9, x6);
  let mut x20: u32 = 0;
  let mut x21: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x20, &mut x21, 0x0, x1, x12);
  let mut x22: u32 = 0;
  let mut x23: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), x14);
  let mut x24: u32 = 0;
  let mut x25: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), x16);
  let mut x26: u32 = 0;
  let mut x27: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), x18);
  let mut x28: u32 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x28, &mut x29, 0x0, x22, (arg1[1]));
  let mut x30: u32 = 0;
  let mut x31: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x30, &mut x31, x29, x24, (0x0 as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x32, &mut x33, x31, x26, (0x0 as u32));
  let mut x34: u32 = 0;
  let mut x35: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x34, &mut x35, x28, 0x12547e1b);
  let mut x36: u32 = 0;
  let mut x37: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x36, &mut x37, x34, 0x10000000);
  let mut x38: u32 = 0;
  let mut x39: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x38, &mut x39, x34, 0x14def9de);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x40, &mut x41, x34, 0xa2f79cd6);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x42, &mut x43, x34, 0x5812631a);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x44, &mut x45, x34, 0x5cf5d3ed);
  let mut x46: u32 = 0;
  let mut x47: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x46, &mut x47, 0x0, x45, x42);
  let mut x48: u32 = 0;
  let mut x49: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x48, &mut x49, x47, x43, x40);
  let mut x50: u32 = 0;
  let mut x51: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x50, &mut x51, x49, x41, x38);
  let mut x52: u32 = 0;
  let mut x53: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x52, &mut x53, 0x0, x28, x44);
  let mut x54: u32 = 0;
  let mut x55: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x54, &mut x55, x53, x30, x46);
  let mut x56: u32 = 0;
  let mut x57: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x56, &mut x57, x55, x32, x48);
  let mut x58: u32 = 0;
  let mut x59: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x58, &mut x59, x57, ((x33 as u32) + ((x27 as u32) + ((x19 as u32) + x7))), x50);
  let mut x60: u32 = 0;
  let mut x61: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x60, &mut x61, 0x0, x5, x36);
  let mut x62: u32 = 0;
  let mut x63: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x62, &mut x63, 0x0, x54, (arg1[2]));
  let mut x64: u32 = 0;
  let mut x65: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x64, &mut x65, x63, x56, (0x0 as u32));
  let mut x66: u32 = 0;
  let mut x67: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x66, &mut x67, x65, x58, (0x0 as u32));
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x68, &mut x69, x62, 0x12547e1b);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x70, &mut x71, x68, 0x10000000);
  let mut x72: u32 = 0;
  let mut x73: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x72, &mut x73, x68, 0x14def9de);
  let mut x74: u32 = 0;
  let mut x75: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x74, &mut x75, x68, 0xa2f79cd6);
  let mut x76: u32 = 0;
  let mut x77: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x76, &mut x77, x68, 0x5812631a);
  let mut x78: u32 = 0;
  let mut x79: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x78, &mut x79, x68, 0x5cf5d3ed);
  let mut x80: u32 = 0;
  let mut x81: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x80, &mut x81, 0x0, x79, x76);
  let mut x82: u32 = 0;
  let mut x83: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x82, &mut x83, x81, x77, x74);
  let mut x84: u32 = 0;
  let mut x85: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x84, &mut x85, x83, x75, x72);
  let mut x86: u32 = 0;
  let mut x87: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x86, &mut x87, 0x0, x62, x78);
  let mut x88: u32 = 0;
  let mut x89: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x88, &mut x89, x87, x64, x80);
  let mut x90: u32 = 0;
  let mut x91: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x90, &mut x91, x89, x66, x82);
  let mut x92: u32 = 0;
  let mut x93: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x92, &mut x93, x91, ((x67 as u32) + ((x59 as u32) + ((x51 as u32) + x39))), x84);
  let mut x94: u32 = 0;
  let mut x95: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x94, &mut x95, 0x0, ((x61 as u32) + x37), x70);
  let mut x96: u32 = 0;
  let mut x97: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x96, &mut x97, 0x0, x88, (arg1[3]));
  let mut x98: u32 = 0;
  let mut x99: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x98, &mut x99, x97, x90, (0x0 as u32));
  let mut x100: u32 = 0;
  let mut x101: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x100, &mut x101, x99, x92, (0x0 as u32));
  let mut x102: u32 = 0;
  let mut x103: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x102, &mut x103, x96, 0x12547e1b);
  let mut x104: u32 = 0;
  let mut x105: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x104, &mut x105, x102, 0x10000000);
  let mut x106: u32 = 0;
  let mut x107: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x106, &mut x107, x102, 0x14def9de);
  let mut x108: u32 = 0;
  let mut x109: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x108, &mut x109, x102, 0xa2f79cd6);
  let mut x110: u32 = 0;
  let mut x111: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x110, &mut x111, x102, 0x5812631a);
  let mut x112: u32 = 0;
  let mut x113: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x112, &mut x113, x102, 0x5cf5d3ed);
  let mut x114: u32 = 0;
  let mut x115: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x114, &mut x115, 0x0, x113, x110);
  let mut x116: u32 = 0;
  let mut x117: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x116, &mut x117, x115, x111, x108);
  let mut x118: u32 = 0;
  let mut x119: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x118, &mut x119, x117, x109, x106);
  let mut x120: u32 = 0;
  let mut x121: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x120, &mut x121, 0x0, x96, x112);
  let mut x122: u32 = 0;
  let mut x123: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x122, &mut x123, x121, x98, x114);
  let mut x124: u32 = 0;
  let mut x125: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x124, &mut x125, x123, x100, x116);
  let mut x126: u32 = 0;
  let mut x127: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x126, &mut x127, x125, ((x101 as u32) + ((x93 as u32) + ((x85 as u32) + x73))), x118);
  let mut x128: u32 = 0;
  let mut x129: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x128, &mut x129, x127, x4, ((x119 as u32) + x107));
  let mut x130: u32 = 0;
  let mut x131: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x130, &mut x131, x129, x60, (0x0 as u32));
  let mut x132: u32 = 0;
  let mut x133: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x132, &mut x133, x131, x94, (0x0 as u32));
  let mut x134: u32 = 0;
  let mut x135: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x134, &mut x135, x133, ((x95 as u32) + x71), x104);
  let mut x136: u32 = 0;
  let mut x137: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x136, &mut x137, 0x0, x122, (arg1[4]));
  let mut x138: u32 = 0;
  let mut x139: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x138, &mut x139, x137, x124, (0x0 as u32));
  let mut x140: u32 = 0;
  let mut x141: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x140, &mut x141, x139, x126, (0x0 as u32));
  let mut x142: u32 = 0;
  let mut x143: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x142, &mut x143, x141, x128, (0x0 as u32));
  let mut x144: u32 = 0;
  let mut x145: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x144, &mut x145, x143, x130, (0x0 as u32));
  let mut x146: u32 = 0;
  let mut x147: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x146, &mut x147, x145, x132, (0x0 as u32));
  let mut x148: u32 = 0;
  let mut x149: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x148, &mut x149, x147, x134, (0x0 as u32));
  let mut x150: u32 = 0;
  let mut x151: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x150, &mut x151, x136, 0x12547e1b);
  let mut x152: u32 = 0;
  let mut x153: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x152, &mut x153, x150, 0x10000000);
  let mut x154: u32 = 0;
  let mut x155: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x154, &mut x155, x150, 0x14def9de);
  let mut x156: u32 = 0;
  let mut x157: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x156, &mut x157, x150, 0xa2f79cd6);
  let mut x158: u32 = 0;
  let mut x159: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x158, &mut x159, x150, 0x5812631a);
  let mut x160: u32 = 0;
  let mut x161: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x160, &mut x161, x150, 0x5cf5d3ed);
  let mut x162: u32 = 0;
  let mut x163: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x162, &mut x163, 0x0, x161, x158);
  let mut x164: u32 = 0;
  let mut x165: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x164, &mut x165, x163, x159, x156);
  let mut x166: u32 = 0;
  let mut x167: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x166, &mut x167, x165, x157, x154);
  let mut x168: u32 = 0;
  let mut x169: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x168, &mut x169, 0x0, x136, x160);
  let mut x170: u32 = 0;
  let mut x171: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x170, &mut x171, x169, x138, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x172, &mut x173, x171, x140, x164);
  let mut x174: u32 = 0;
  let mut x175: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x174, &mut x175, x173, x142, x166);
  let mut x176: u32 = 0;
  let mut x177: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x176, &mut x177, x175, x144, ((x167 as u32) + x155));
  let mut x178: u32 = 0;
  let mut x179: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x178, &mut x179, x177, x146, (0x0 as u32));
  let mut x180: u32 = 0;
  let mut x181: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x180, &mut x181, x179, x148, (0x0 as u32));
  let mut x182: u32 = 0;
  let mut x183: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x182, &mut x183, x181, ((x149 as u32) + ((x135 as u32) + x105)), x152);
  let mut x184: u32 = 0;
  let mut x185: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x184, &mut x185, 0x0, x170, (arg1[5]));
  let mut x186: u32 = 0;
  let mut x187: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x186, &mut x187, x185, x172, (0x0 as u32));
  let mut x188: u32 = 0;
  let mut x189: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x188, &mut x189, x187, x174, (0x0 as u32));
  let mut x190: u32 = 0;
  let mut x191: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x190, &mut x191, x189, x176, (0x0 as u32));
  let mut x192: u32 = 0;
  let mut x193: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x192, &mut x193, x191, x178, (0x0 as u32));
  let mut x194: u32 = 0;
  let mut x195: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x194, &mut x195, x193, x180, (0x0 as u32));
  let mut x196: u32 = 0;
  let mut x197: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x196, &mut x197, x195, x182, (0x0 as u32));
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x198, &mut x199, x184, 0x12547e1b);
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x200, &mut x201, x198, 0x10000000);
  let mut x202: u32 = 0;
  let mut x203: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x202, &mut x203, x198, 0x14def9de);
  let mut x204: u32 = 0;
  let mut x205: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x204, &mut x205, x198, 0xa2f79cd6);
  let mut x206: u32 = 0;
  let mut x207: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x206, &mut x207, x198, 0x5812631a);
  let mut x208: u32 = 0;
  let mut x209: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x208, &mut x209, x198, 0x5cf5d3ed);
  let mut x210: u32 = 0;
  let mut x211: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x210, &mut x211, 0x0, x209, x206);
  let mut x212: u32 = 0;
  let mut x213: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x212, &mut x213, x211, x207, x204);
  let mut x214: u32 = 0;
  let mut x215: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x214, &mut x215, x213, x205, x202);
  let mut x216: u32 = 0;
  let mut x217: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x216, &mut x217, 0x0, x184, x208);
  let mut x218: u32 = 0;
  let mut x219: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x218, &mut x219, x217, x186, x210);
  let mut x220: u32 = 0;
  let mut x221: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x220, &mut x221, x219, x188, x212);
  let mut x222: u32 = 0;
  let mut x223: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x222, &mut x223, x221, x190, x214);
  let mut x224: u32 = 0;
  let mut x225: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x224, &mut x225, x223, x192, ((x215 as u32) + x203));
  let mut x226: u32 = 0;
  let mut x227: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x226, &mut x227, x225, x194, (0x0 as u32));
  let mut x228: u32 = 0;
  let mut x229: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x228, &mut x229, x227, x196, (0x0 as u32));
  let mut x230: u32 = 0;
  let mut x231: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x230, &mut x231, x229, ((x197 as u32) + ((x183 as u32) + x153)), x200);
  let mut x232: u32 = 0;
  let mut x233: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x232, &mut x233, 0x0, x218, (arg1[6]));
  let mut x234: u32 = 0;
  let mut x235: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x234, &mut x235, x233, x220, (0x0 as u32));
  let mut x236: u32 = 0;
  let mut x237: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x236, &mut x237, x235, x222, (0x0 as u32));
  let mut x238: u32 = 0;
  let mut x239: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x238, &mut x239, x237, x224, (0x0 as u32));
  let mut x240: u32 = 0;
  let mut x241: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x240, &mut x241, x239, x226, (0x0 as u32));
  let mut x242: u32 = 0;
  let mut x243: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x242, &mut x243, x241, x228, (0x0 as u32));
  let mut x244: u32 = 0;
  let mut x245: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x244, &mut x245, x243, x230, (0x0 as u32));
  let mut x246: u32 = 0;
  let mut x247: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x246, &mut x247, x232, 0x12547e1b);
  let mut x248: u32 = 0;
  let mut x249: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x248, &mut x249, x246, 0x10000000);
  let mut x250: u32 = 0;
  let mut x251: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x250, &mut x251, x246, 0x14def9de);
  let mut x252: u32 = 0;
  let mut x253: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x252, &mut x253, x246, 0xa2f79cd6);
  let mut x254: u32 = 0;
  let mut x255: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x254, &mut x255, x246, 0x5812631a);
  let mut x256: u32 = 0;
  let mut x257: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x256, &mut x257, x246, 0x5cf5d3ed);
  let mut x258: u32 = 0;
  let mut x259: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x258, &mut x259, 0x0, x257, x254);
  let mut x260: u32 = 0;
  let mut x261: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x260, &mut x261, x259, x255, x252);
  let mut x262: u32 = 0;
  let mut x263: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x262, &mut x263, x261, x253, x250);
  let mut x264: u32 = 0;
  let mut x265: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x264, &mut x265, 0x0, x232, x256);
  let mut x266: u32 = 0;
  let mut x267: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x266, &mut x267, x265, x234, x258);
  let mut x268: u32 = 0;
  let mut x269: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x268, &mut x269, x267, x236, x260);
  let mut x270: u32 = 0;
  let mut x271: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x270, &mut x271, x269, x238, x262);
  let mut x272: u32 = 0;
  let mut x273: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x272, &mut x273, x271, x240, ((x263 as u32) + x251));
  let mut x274: u32 = 0;
  let mut x275: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x274, &mut x275, x273, x242, (0x0 as u32));
  let mut x276: u32 = 0;
  let mut x277: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x276, &mut x277, x275, x244, (0x0 as u32));
  let mut x278: u32 = 0;
  let mut x279: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x278, &mut x279, x277, ((x245 as u32) + ((x231 as u32) + x201)), x248);
  let mut x280: u32 = 0;
  let mut x281: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x280, &mut x281, 0x0, x266, (arg1[7]));
  let mut x282: u32 = 0;
  let mut x283: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x282, &mut x283, x281, x268, (0x0 as u32));
  let mut x284: u32 = 0;
  let mut x285: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x284, &mut x285, x283, x270, (0x0 as u32));
  let mut x286: u32 = 0;
  let mut x287: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x286, &mut x287, x285, x272, (0x0 as u32));
  let mut x288: u32 = 0;
  let mut x289: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x288, &mut x289, x287, x274, (0x0 as u32));
  let mut x290: u32 = 0;
  let mut x291: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x290, &mut x291, x289, x276, (0x0 as u32));
  let mut x292: u32 = 0;
  let mut x293: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x292, &mut x293, x291, x278, (0x0 as u32));
  let mut x294: u32 = 0;
  let mut x295: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x294, &mut x295, x280, 0x12547e1b);
  let mut x296: u32 = 0;
  let mut x297: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x296, &mut x297, x294, 0x10000000);
  let mut x298: u32 = 0;
  let mut x299: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x298, &mut x299, x294, 0x14def9de);
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x300, &mut x301, x294, 0xa2f79cd6);
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x302, &mut x303, x294, 0x5812631a);
  let mut x304: u32 = 0;
  let mut x305: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x304, &mut x305, x294, 0x5cf5d3ed);
  let mut x306: u32 = 0;
  let mut x307: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x306, &mut x307, 0x0, x305, x302);
  let mut x308: u32 = 0;
  let mut x309: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x308, &mut x309, x307, x303, x300);
  let mut x310: u32 = 0;
  let mut x311: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x310, &mut x311, x309, x301, x298);
  let mut x312: u32 = 0;
  let mut x313: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x312, &mut x313, 0x0, x280, x304);
  let mut x314: u32 = 0;
  let mut x315: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x314, &mut x315, x313, x282, x306);
  let mut x316: u32 = 0;
  let mut x317: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x316, &mut x317, x315, x284, x308);
  let mut x318: u32 = 0;
  let mut x319: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x318, &mut x319, x317, x286, x310);
  let mut x320: u32 = 0;
  let mut x321: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x320, &mut x321, x319, x288, ((x311 as u32) + x299));
  let mut x322: u32 = 0;
  let mut x323: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x322, &mut x323, x321, x290, (0x0 as u32));
  let mut x324: u32 = 0;
  let mut x325: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x324, &mut x325, x323, x292, (0x0 as u32));
  let mut x326: u32 = 0;
  let mut x327: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x326, &mut x327, x325, ((x293 as u32) + ((x279 as u32) + x249)), x296);
  let x328: u32 = ((x327 as u32) + x297);
  let mut x329: u32 = 0;
  let mut x330: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x329, &mut x330, 0x0, x314, 0x5cf5d3ed);
  let mut x331: u32 = 0;
  let mut x332: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x331, &mut x332, x330, x316, 0x5812631a);
  let mut x333: u32 = 0;
  let mut x334: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x333, &mut x334, x332, x318, 0xa2f79cd6);
  let mut x335: u32 = 0;
  let mut x336: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x335, &mut x336, x334, x320, 0x14def9de);
  let mut x337: u32 = 0;
  let mut x338: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x337, &mut x338, x336, x322, (0x0 as u32));
  let mut x339: u32 = 0;
  let mut x340: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x339, &mut x340, x338, x324, (0x0 as u32));
  let mut x341: u32 = 0;
  let mut x342: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x341, &mut x342, x340, x326, (0x0 as u32));
  let mut x343: u32 = 0;
  let mut x344: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x343, &mut x344, x342, x328, 0x10000000);
  let mut x345: u32 = 0;
  let mut x346: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x345, &mut x346, x344, (0x0 as u32), (0x0 as u32));
  let mut x347: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x347, x346, x329, x314);
  let mut x348: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x348, x346, x331, x316);
  let mut x349: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x349, x346, x333, x318);
  let mut x350: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x350, x346, x335, x320);
  let mut x351: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x351, x346, x337, x322);
  let mut x352: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x352, x346, x339, x324);
  let mut x353: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x353, x346, x341, x326);
  let mut x354: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x354, x346, x343, x328);
  out1[0] = x347;
  out1[1] = x348;
  out1[2] = x349;
  out1[3] = x350;
  out1[4] = x351;
  out1[5] = x352;
  out1[6] = x353;
  out1[7] = x354;
}

/// The function fiat_25519_scalar_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_to_montgomery(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_non_montgomery_domain_field_element) -> () {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x9, &mut x10, x8, 0x399411b);
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x11, &mut x12, x8, 0x7c309a3d);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x13, &mut x14, x8, 0xceec73d2);
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x15, &mut x16, x8, 0x17f5be65);
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x17, &mut x18, x8, 0xd00e1ba7);
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x19, &mut x20, x8, 0x68859347);
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x21, &mut x22, x8, 0xa40611e3);
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x23, &mut x24, x8, 0x449c0f01);
  let mut x25: u32 = 0;
  let mut x26: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let mut x39: u32 = 0;
  let mut x40: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x39, &mut x40, x23, 0x12547e1b);
  let mut x41: u32 = 0;
  let mut x42: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x41, &mut x42, x39, 0x10000000);
  let mut x43: u32 = 0;
  let mut x44: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x43, &mut x44, x39, 0x14def9de);
  let mut x45: u32 = 0;
  let mut x46: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x45, &mut x46, x39, 0xa2f79cd6);
  let mut x47: u32 = 0;
  let mut x48: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x47, &mut x48, x39, 0x5812631a);
  let mut x49: u32 = 0;
  let mut x50: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x49, &mut x50, x39, 0x5cf5d3ed);
  let mut x51: u32 = 0;
  let mut x52: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x51, &mut x52, 0x0, x50, x47);
  let mut x53: u32 = 0;
  let mut x54: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x53, &mut x54, x52, x48, x45);
  let mut x55: u32 = 0;
  let mut x56: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x55, &mut x56, x54, x46, x43);
  let mut x57: u32 = 0;
  let mut x58: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x57, &mut x58, 0x0, x23, x49);
  let mut x59: u32 = 0;
  let mut x60: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x59, &mut x60, x58, x25, x51);
  let mut x61: u32 = 0;
  let mut x62: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x61, &mut x62, x60, x27, x53);
  let mut x63: u32 = 0;
  let mut x64: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x63, &mut x64, x62, x29, x55);
  let mut x65: u32 = 0;
  let mut x66: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x65, &mut x66, x64, x31, ((x56 as u32) + x44));
  let mut x67: u32 = 0;
  let mut x68: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x67, &mut x68, x66, x33, (0x0 as u32));
  let mut x69: u32 = 0;
  let mut x70: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x69, &mut x70, x68, x35, (0x0 as u32));
  let mut x71: u32 = 0;
  let mut x72: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x71, &mut x72, x70, x37, x41);
  let mut x73: u32 = 0;
  let mut x74: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x73, &mut x74, x1, 0x399411b);
  let mut x75: u32 = 0;
  let mut x76: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x75, &mut x76, x1, 0x7c309a3d);
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x77, &mut x78, x1, 0xceec73d2);
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x79, &mut x80, x1, 0x17f5be65);
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x81, &mut x82, x1, 0xd00e1ba7);
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x83, &mut x84, x1, 0x68859347);
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x85, &mut x86, x1, 0xa40611e3);
  let mut x87: u32 = 0;
  let mut x88: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x87, &mut x88, x1, 0x449c0f01);
  let mut x89: u32 = 0;
  let mut x90: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x89, &mut x90, 0x0, x88, x85);
  let mut x91: u32 = 0;
  let mut x92: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x91, &mut x92, x90, x86, x83);
  let mut x93: u32 = 0;
  let mut x94: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x93, &mut x94, x92, x84, x81);
  let mut x95: u32 = 0;
  let mut x96: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x95, &mut x96, x94, x82, x79);
  let mut x97: u32 = 0;
  let mut x98: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x97, &mut x98, x96, x80, x77);
  let mut x99: u32 = 0;
  let mut x100: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x99, &mut x100, x98, x78, x75);
  let mut x101: u32 = 0;
  let mut x102: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x101, &mut x102, x100, x76, x73);
  let mut x103: u32 = 0;
  let mut x104: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x103, &mut x104, 0x0, x59, x87);
  let mut x105: u32 = 0;
  let mut x106: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x105, &mut x106, x104, x61, x89);
  let mut x107: u32 = 0;
  let mut x108: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x107, &mut x108, x106, x63, x91);
  let mut x109: u32 = 0;
  let mut x110: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x109, &mut x110, x108, x65, x93);
  let mut x111: u32 = 0;
  let mut x112: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x111, &mut x112, x110, x67, x95);
  let mut x113: u32 = 0;
  let mut x114: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x113, &mut x114, x112, x69, x97);
  let mut x115: u32 = 0;
  let mut x116: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x115, &mut x116, x114, x71, x99);
  let mut x117: u32 = 0;
  let mut x118: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x117, &mut x118, x116, (((x72 as u32) + ((x38 as u32) + x10)) + x42), x101);
  let mut x119: u32 = 0;
  let mut x120: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x119, &mut x120, x103, 0x12547e1b);
  let mut x121: u32 = 0;
  let mut x122: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x121, &mut x122, x119, 0x10000000);
  let mut x123: u32 = 0;
  let mut x124: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x123, &mut x124, x119, 0x14def9de);
  let mut x125: u32 = 0;
  let mut x126: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x125, &mut x126, x119, 0xa2f79cd6);
  let mut x127: u32 = 0;
  let mut x128: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x127, &mut x128, x119, 0x5812631a);
  let mut x129: u32 = 0;
  let mut x130: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x129, &mut x130, x119, 0x5cf5d3ed);
  let mut x131: u32 = 0;
  let mut x132: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x131, &mut x132, 0x0, x130, x127);
  let mut x133: u32 = 0;
  let mut x134: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x133, &mut x134, x132, x128, x125);
  let mut x135: u32 = 0;
  let mut x136: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x135, &mut x136, x134, x126, x123);
  let mut x137: u32 = 0;
  let mut x138: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x137, &mut x138, 0x0, x103, x129);
  let mut x139: u32 = 0;
  let mut x140: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x139, &mut x140, x138, x105, x131);
  let mut x141: u32 = 0;
  let mut x142: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x141, &mut x142, x140, x107, x133);
  let mut x143: u32 = 0;
  let mut x144: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x143, &mut x144, x142, x109, x135);
  let mut x145: u32 = 0;
  let mut x146: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x145, &mut x146, x144, x111, ((x136 as u32) + x124));
  let mut x147: u32 = 0;
  let mut x148: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x147, &mut x148, x146, x113, (0x0 as u32));
  let mut x149: u32 = 0;
  let mut x150: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x149, &mut x150, x148, x115, (0x0 as u32));
  let mut x151: u32 = 0;
  let mut x152: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x151, &mut x152, x150, x117, x121);
  let mut x153: u32 = 0;
  let mut x154: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x153, &mut x154, x2, 0x399411b);
  let mut x155: u32 = 0;
  let mut x156: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x155, &mut x156, x2, 0x7c309a3d);
  let mut x157: u32 = 0;
  let mut x158: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x157, &mut x158, x2, 0xceec73d2);
  let mut x159: u32 = 0;
  let mut x160: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x159, &mut x160, x2, 0x17f5be65);
  let mut x161: u32 = 0;
  let mut x162: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x161, &mut x162, x2, 0xd00e1ba7);
  let mut x163: u32 = 0;
  let mut x164: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x163, &mut x164, x2, 0x68859347);
  let mut x165: u32 = 0;
  let mut x166: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x165, &mut x166, x2, 0xa40611e3);
  let mut x167: u32 = 0;
  let mut x168: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x167, &mut x168, x2, 0x449c0f01);
  let mut x169: u32 = 0;
  let mut x170: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x169, &mut x170, 0x0, x168, x165);
  let mut x171: u32 = 0;
  let mut x172: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x171, &mut x172, x170, x166, x163);
  let mut x173: u32 = 0;
  let mut x174: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x173, &mut x174, x172, x164, x161);
  let mut x175: u32 = 0;
  let mut x176: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x175, &mut x176, x174, x162, x159);
  let mut x177: u32 = 0;
  let mut x178: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x177, &mut x178, x176, x160, x157);
  let mut x179: u32 = 0;
  let mut x180: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x179, &mut x180, x178, x158, x155);
  let mut x181: u32 = 0;
  let mut x182: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x181, &mut x182, x180, x156, x153);
  let mut x183: u32 = 0;
  let mut x184: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x183, &mut x184, 0x0, x139, x167);
  let mut x185: u32 = 0;
  let mut x186: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x185, &mut x186, x184, x141, x169);
  let mut x187: u32 = 0;
  let mut x188: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x187, &mut x188, x186, x143, x171);
  let mut x189: u32 = 0;
  let mut x190: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x189, &mut x190, x188, x145, x173);
  let mut x191: u32 = 0;
  let mut x192: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x191, &mut x192, x190, x147, x175);
  let mut x193: u32 = 0;
  let mut x194: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x193, &mut x194, x192, x149, x177);
  let mut x195: u32 = 0;
  let mut x196: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x195, &mut x196, x194, x151, x179);
  let mut x197: u32 = 0;
  let mut x198: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x197, &mut x198, x196, (((x152 as u32) + ((x118 as u32) + ((x102 as u32) + x74))) + x122), x181);
  let mut x199: u32 = 0;
  let mut x200: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x199, &mut x200, x183, 0x12547e1b);
  let mut x201: u32 = 0;
  let mut x202: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x201, &mut x202, x199, 0x10000000);
  let mut x203: u32 = 0;
  let mut x204: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x203, &mut x204, x199, 0x14def9de);
  let mut x205: u32 = 0;
  let mut x206: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x205, &mut x206, x199, 0xa2f79cd6);
  let mut x207: u32 = 0;
  let mut x208: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x207, &mut x208, x199, 0x5812631a);
  let mut x209: u32 = 0;
  let mut x210: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x209, &mut x210, x199, 0x5cf5d3ed);
  let mut x211: u32 = 0;
  let mut x212: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x211, &mut x212, 0x0, x210, x207);
  let mut x213: u32 = 0;
  let mut x214: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x213, &mut x214, x212, x208, x205);
  let mut x215: u32 = 0;
  let mut x216: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x215, &mut x216, x214, x206, x203);
  let mut x217: u32 = 0;
  let mut x218: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x217, &mut x218, 0x0, x183, x209);
  let mut x219: u32 = 0;
  let mut x220: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x219, &mut x220, x218, x185, x211);
  let mut x221: u32 = 0;
  let mut x222: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x221, &mut x222, x220, x187, x213);
  let mut x223: u32 = 0;
  let mut x224: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x223, &mut x224, x222, x189, x215);
  let mut x225: u32 = 0;
  let mut x226: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x225, &mut x226, x224, x191, ((x216 as u32) + x204));
  let mut x227: u32 = 0;
  let mut x228: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x227, &mut x228, x226, x193, (0x0 as u32));
  let mut x229: u32 = 0;
  let mut x230: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x229, &mut x230, x228, x195, (0x0 as u32));
  let mut x231: u32 = 0;
  let mut x232: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x231, &mut x232, x230, x197, x201);
  let mut x233: u32 = 0;
  let mut x234: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x233, &mut x234, x3, 0x399411b);
  let mut x235: u32 = 0;
  let mut x236: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x235, &mut x236, x3, 0x7c309a3d);
  let mut x237: u32 = 0;
  let mut x238: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x237, &mut x238, x3, 0xceec73d2);
  let mut x239: u32 = 0;
  let mut x240: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x239, &mut x240, x3, 0x17f5be65);
  let mut x241: u32 = 0;
  let mut x242: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x241, &mut x242, x3, 0xd00e1ba7);
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x243, &mut x244, x3, 0x68859347);
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x245, &mut x246, x3, 0xa40611e3);
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x247, &mut x248, x3, 0x449c0f01);
  let mut x249: u32 = 0;
  let mut x250: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x249, &mut x250, 0x0, x248, x245);
  let mut x251: u32 = 0;
  let mut x252: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x251, &mut x252, x250, x246, x243);
  let mut x253: u32 = 0;
  let mut x254: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x253, &mut x254, x252, x244, x241);
  let mut x255: u32 = 0;
  let mut x256: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x255, &mut x256, x254, x242, x239);
  let mut x257: u32 = 0;
  let mut x258: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x257, &mut x258, x256, x240, x237);
  let mut x259: u32 = 0;
  let mut x260: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x259, &mut x260, x258, x238, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x261, &mut x262, x260, x236, x233);
  let mut x263: u32 = 0;
  let mut x264: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x263, &mut x264, 0x0, x219, x247);
  let mut x265: u32 = 0;
  let mut x266: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x265, &mut x266, x264, x221, x249);
  let mut x267: u32 = 0;
  let mut x268: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x267, &mut x268, x266, x223, x251);
  let mut x269: u32 = 0;
  let mut x270: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x269, &mut x270, x268, x225, x253);
  let mut x271: u32 = 0;
  let mut x272: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x271, &mut x272, x270, x227, x255);
  let mut x273: u32 = 0;
  let mut x274: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x273, &mut x274, x272, x229, x257);
  let mut x275: u32 = 0;
  let mut x276: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x275, &mut x276, x274, x231, x259);
  let mut x277: u32 = 0;
  let mut x278: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x277, &mut x278, x276, (((x232 as u32) + ((x198 as u32) + ((x182 as u32) + x154))) + x202), x261);
  let mut x279: u32 = 0;
  let mut x280: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x279, &mut x280, x263, 0x12547e1b);
  let mut x281: u32 = 0;
  let mut x282: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x281, &mut x282, x279, 0x10000000);
  let mut x283: u32 = 0;
  let mut x284: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x283, &mut x284, x279, 0x14def9de);
  let mut x285: u32 = 0;
  let mut x286: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x285, &mut x286, x279, 0xa2f79cd6);
  let mut x287: u32 = 0;
  let mut x288: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x287, &mut x288, x279, 0x5812631a);
  let mut x289: u32 = 0;
  let mut x290: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x289, &mut x290, x279, 0x5cf5d3ed);
  let mut x291: u32 = 0;
  let mut x292: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x291, &mut x292, 0x0, x290, x287);
  let mut x293: u32 = 0;
  let mut x294: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x293, &mut x294, x292, x288, x285);
  let mut x295: u32 = 0;
  let mut x296: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x295, &mut x296, x294, x286, x283);
  let mut x297: u32 = 0;
  let mut x298: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x297, &mut x298, 0x0, x263, x289);
  let mut x299: u32 = 0;
  let mut x300: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x299, &mut x300, x298, x265, x291);
  let mut x301: u32 = 0;
  let mut x302: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x301, &mut x302, x300, x267, x293);
  let mut x303: u32 = 0;
  let mut x304: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x303, &mut x304, x302, x269, x295);
  let mut x305: u32 = 0;
  let mut x306: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x305, &mut x306, x304, x271, ((x296 as u32) + x284));
  let mut x307: u32 = 0;
  let mut x308: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x307, &mut x308, x306, x273, (0x0 as u32));
  let mut x309: u32 = 0;
  let mut x310: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x309, &mut x310, x308, x275, (0x0 as u32));
  let mut x311: u32 = 0;
  let mut x312: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x311, &mut x312, x310, x277, x281);
  let mut x313: u32 = 0;
  let mut x314: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x313, &mut x314, x4, 0x399411b);
  let mut x315: u32 = 0;
  let mut x316: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x315, &mut x316, x4, 0x7c309a3d);
  let mut x317: u32 = 0;
  let mut x318: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x317, &mut x318, x4, 0xceec73d2);
  let mut x319: u32 = 0;
  let mut x320: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x319, &mut x320, x4, 0x17f5be65);
  let mut x321: u32 = 0;
  let mut x322: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x321, &mut x322, x4, 0xd00e1ba7);
  let mut x323: u32 = 0;
  let mut x324: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x323, &mut x324, x4, 0x68859347);
  let mut x325: u32 = 0;
  let mut x326: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x325, &mut x326, x4, 0xa40611e3);
  let mut x327: u32 = 0;
  let mut x328: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x327, &mut x328, x4, 0x449c0f01);
  let mut x329: u32 = 0;
  let mut x330: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x329, &mut x330, 0x0, x328, x325);
  let mut x331: u32 = 0;
  let mut x332: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x331, &mut x332, x330, x326, x323);
  let mut x333: u32 = 0;
  let mut x334: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x333, &mut x334, x332, x324, x321);
  let mut x335: u32 = 0;
  let mut x336: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x335, &mut x336, x334, x322, x319);
  let mut x337: u32 = 0;
  let mut x338: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x337, &mut x338, x336, x320, x317);
  let mut x339: u32 = 0;
  let mut x340: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x339, &mut x340, x338, x318, x315);
  let mut x341: u32 = 0;
  let mut x342: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x341, &mut x342, x340, x316, x313);
  let mut x343: u32 = 0;
  let mut x344: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x343, &mut x344, 0x0, x299, x327);
  let mut x345: u32 = 0;
  let mut x346: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x345, &mut x346, x344, x301, x329);
  let mut x347: u32 = 0;
  let mut x348: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x347, &mut x348, x346, x303, x331);
  let mut x349: u32 = 0;
  let mut x350: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x349, &mut x350, x348, x305, x333);
  let mut x351: u32 = 0;
  let mut x352: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x351, &mut x352, x350, x307, x335);
  let mut x353: u32 = 0;
  let mut x354: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x353, &mut x354, x352, x309, x337);
  let mut x355: u32 = 0;
  let mut x356: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x355, &mut x356, x354, x311, x339);
  let mut x357: u32 = 0;
  let mut x358: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x357, &mut x358, x356, (((x312 as u32) + ((x278 as u32) + ((x262 as u32) + x234))) + x282), x341);
  let mut x359: u32 = 0;
  let mut x360: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x359, &mut x360, x343, 0x12547e1b);
  let mut x361: u32 = 0;
  let mut x362: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x361, &mut x362, x359, 0x10000000);
  let mut x363: u32 = 0;
  let mut x364: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x363, &mut x364, x359, 0x14def9de);
  let mut x365: u32 = 0;
  let mut x366: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x365, &mut x366, x359, 0xa2f79cd6);
  let mut x367: u32 = 0;
  let mut x368: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x367, &mut x368, x359, 0x5812631a);
  let mut x369: u32 = 0;
  let mut x370: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x369, &mut x370, x359, 0x5cf5d3ed);
  let mut x371: u32 = 0;
  let mut x372: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x371, &mut x372, 0x0, x370, x367);
  let mut x373: u32 = 0;
  let mut x374: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x373, &mut x374, x372, x368, x365);
  let mut x375: u32 = 0;
  let mut x376: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x375, &mut x376, x374, x366, x363);
  let mut x377: u32 = 0;
  let mut x378: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x377, &mut x378, 0x0, x343, x369);
  let mut x379: u32 = 0;
  let mut x380: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x379, &mut x380, x378, x345, x371);
  let mut x381: u32 = 0;
  let mut x382: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x381, &mut x382, x380, x347, x373);
  let mut x383: u32 = 0;
  let mut x384: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x383, &mut x384, x382, x349, x375);
  let mut x385: u32 = 0;
  let mut x386: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x385, &mut x386, x384, x351, ((x376 as u32) + x364));
  let mut x387: u32 = 0;
  let mut x388: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x387, &mut x388, x386, x353, (0x0 as u32));
  let mut x389: u32 = 0;
  let mut x390: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x389, &mut x390, x388, x355, (0x0 as u32));
  let mut x391: u32 = 0;
  let mut x392: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x391, &mut x392, x390, x357, x361);
  let mut x393: u32 = 0;
  let mut x394: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x393, &mut x394, x5, 0x399411b);
  let mut x395: u32 = 0;
  let mut x396: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x395, &mut x396, x5, 0x7c309a3d);
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x397, &mut x398, x5, 0xceec73d2);
  let mut x399: u32 = 0;
  let mut x400: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x399, &mut x400, x5, 0x17f5be65);
  let mut x401: u32 = 0;
  let mut x402: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x401, &mut x402, x5, 0xd00e1ba7);
  let mut x403: u32 = 0;
  let mut x404: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x403, &mut x404, x5, 0x68859347);
  let mut x405: u32 = 0;
  let mut x406: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x405, &mut x406, x5, 0xa40611e3);
  let mut x407: u32 = 0;
  let mut x408: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x407, &mut x408, x5, 0x449c0f01);
  let mut x409: u32 = 0;
  let mut x410: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x409, &mut x410, 0x0, x408, x405);
  let mut x411: u32 = 0;
  let mut x412: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x411, &mut x412, x410, x406, x403);
  let mut x413: u32 = 0;
  let mut x414: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x413, &mut x414, x412, x404, x401);
  let mut x415: u32 = 0;
  let mut x416: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x415, &mut x416, x414, x402, x399);
  let mut x417: u32 = 0;
  let mut x418: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x417, &mut x418, x416, x400, x397);
  let mut x419: u32 = 0;
  let mut x420: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x419, &mut x420, x418, x398, x395);
  let mut x421: u32 = 0;
  let mut x422: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x421, &mut x422, x420, x396, x393);
  let mut x423: u32 = 0;
  let mut x424: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x423, &mut x424, 0x0, x379, x407);
  let mut x425: u32 = 0;
  let mut x426: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x425, &mut x426, x424, x381, x409);
  let mut x427: u32 = 0;
  let mut x428: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x427, &mut x428, x426, x383, x411);
  let mut x429: u32 = 0;
  let mut x430: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x429, &mut x430, x428, x385, x413);
  let mut x431: u32 = 0;
  let mut x432: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x431, &mut x432, x430, x387, x415);
  let mut x433: u32 = 0;
  let mut x434: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x433, &mut x434, x432, x389, x417);
  let mut x435: u32 = 0;
  let mut x436: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x435, &mut x436, x434, x391, x419);
  let mut x437: u32 = 0;
  let mut x438: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x437, &mut x438, x436, (((x392 as u32) + ((x358 as u32) + ((x342 as u32) + x314))) + x362), x421);
  let mut x439: u32 = 0;
  let mut x440: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x439, &mut x440, x423, 0x12547e1b);
  let mut x441: u32 = 0;
  let mut x442: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x441, &mut x442, x439, 0x10000000);
  let mut x443: u32 = 0;
  let mut x444: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x443, &mut x444, x439, 0x14def9de);
  let mut x445: u32 = 0;
  let mut x446: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x445, &mut x446, x439, 0xa2f79cd6);
  let mut x447: u32 = 0;
  let mut x448: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x447, &mut x448, x439, 0x5812631a);
  let mut x449: u32 = 0;
  let mut x450: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x449, &mut x450, x439, 0x5cf5d3ed);
  let mut x451: u32 = 0;
  let mut x452: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x451, &mut x452, 0x0, x450, x447);
  let mut x453: u32 = 0;
  let mut x454: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x453, &mut x454, x452, x448, x445);
  let mut x455: u32 = 0;
  let mut x456: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x455, &mut x456, x454, x446, x443);
  let mut x457: u32 = 0;
  let mut x458: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x457, &mut x458, 0x0, x423, x449);
  let mut x459: u32 = 0;
  let mut x460: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x459, &mut x460, x458, x425, x451);
  let mut x461: u32 = 0;
  let mut x462: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x461, &mut x462, x460, x427, x453);
  let mut x463: u32 = 0;
  let mut x464: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x463, &mut x464, x462, x429, x455);
  let mut x465: u32 = 0;
  let mut x466: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x465, &mut x466, x464, x431, ((x456 as u32) + x444));
  let mut x467: u32 = 0;
  let mut x468: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x467, &mut x468, x466, x433, (0x0 as u32));
  let mut x469: u32 = 0;
  let mut x470: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x469, &mut x470, x468, x435, (0x0 as u32));
  let mut x471: u32 = 0;
  let mut x472: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x471, &mut x472, x470, x437, x441);
  let mut x473: u32 = 0;
  let mut x474: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x473, &mut x474, x6, 0x399411b);
  let mut x475: u32 = 0;
  let mut x476: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x475, &mut x476, x6, 0x7c309a3d);
  let mut x477: u32 = 0;
  let mut x478: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x477, &mut x478, x6, 0xceec73d2);
  let mut x479: u32 = 0;
  let mut x480: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x479, &mut x480, x6, 0x17f5be65);
  let mut x481: u32 = 0;
  let mut x482: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x481, &mut x482, x6, 0xd00e1ba7);
  let mut x483: u32 = 0;
  let mut x484: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x483, &mut x484, x6, 0x68859347);
  let mut x485: u32 = 0;
  let mut x486: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x485, &mut x486, x6, 0xa40611e3);
  let mut x487: u32 = 0;
  let mut x488: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x487, &mut x488, x6, 0x449c0f01);
  let mut x489: u32 = 0;
  let mut x490: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x489, &mut x490, 0x0, x488, x485);
  let mut x491: u32 = 0;
  let mut x492: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x491, &mut x492, x490, x486, x483);
  let mut x493: u32 = 0;
  let mut x494: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x493, &mut x494, x492, x484, x481);
  let mut x495: u32 = 0;
  let mut x496: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x495, &mut x496, x494, x482, x479);
  let mut x497: u32 = 0;
  let mut x498: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x497, &mut x498, x496, x480, x477);
  let mut x499: u32 = 0;
  let mut x500: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x499, &mut x500, x498, x478, x475);
  let mut x501: u32 = 0;
  let mut x502: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x501, &mut x502, x500, x476, x473);
  let mut x503: u32 = 0;
  let mut x504: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x503, &mut x504, 0x0, x459, x487);
  let mut x505: u32 = 0;
  let mut x506: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x505, &mut x506, x504, x461, x489);
  let mut x507: u32 = 0;
  let mut x508: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x507, &mut x508, x506, x463, x491);
  let mut x509: u32 = 0;
  let mut x510: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x509, &mut x510, x508, x465, x493);
  let mut x511: u32 = 0;
  let mut x512: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x511, &mut x512, x510, x467, x495);
  let mut x513: u32 = 0;
  let mut x514: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x513, &mut x514, x512, x469, x497);
  let mut x515: u32 = 0;
  let mut x516: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x515, &mut x516, x514, x471, x499);
  let mut x517: u32 = 0;
  let mut x518: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x517, &mut x518, x516, (((x472 as u32) + ((x438 as u32) + ((x422 as u32) + x394))) + x442), x501);
  let mut x519: u32 = 0;
  let mut x520: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x519, &mut x520, x503, 0x12547e1b);
  let mut x521: u32 = 0;
  let mut x522: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x521, &mut x522, x519, 0x10000000);
  let mut x523: u32 = 0;
  let mut x524: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x523, &mut x524, x519, 0x14def9de);
  let mut x525: u32 = 0;
  let mut x526: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x525, &mut x526, x519, 0xa2f79cd6);
  let mut x527: u32 = 0;
  let mut x528: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x527, &mut x528, x519, 0x5812631a);
  let mut x529: u32 = 0;
  let mut x530: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x529, &mut x530, x519, 0x5cf5d3ed);
  let mut x531: u32 = 0;
  let mut x532: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x531, &mut x532, 0x0, x530, x527);
  let mut x533: u32 = 0;
  let mut x534: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x533, &mut x534, x532, x528, x525);
  let mut x535: u32 = 0;
  let mut x536: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x535, &mut x536, x534, x526, x523);
  let mut x537: u32 = 0;
  let mut x538: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x537, &mut x538, 0x0, x503, x529);
  let mut x539: u32 = 0;
  let mut x540: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x539, &mut x540, x538, x505, x531);
  let mut x541: u32 = 0;
  let mut x542: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x541, &mut x542, x540, x507, x533);
  let mut x543: u32 = 0;
  let mut x544: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x543, &mut x544, x542, x509, x535);
  let mut x545: u32 = 0;
  let mut x546: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x545, &mut x546, x544, x511, ((x536 as u32) + x524));
  let mut x547: u32 = 0;
  let mut x548: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x547, &mut x548, x546, x513, (0x0 as u32));
  let mut x549: u32 = 0;
  let mut x550: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x549, &mut x550, x548, x515, (0x0 as u32));
  let mut x551: u32 = 0;
  let mut x552: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x551, &mut x552, x550, x517, x521);
  let mut x553: u32 = 0;
  let mut x554: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x553, &mut x554, x7, 0x399411b);
  let mut x555: u32 = 0;
  let mut x556: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x555, &mut x556, x7, 0x7c309a3d);
  let mut x557: u32 = 0;
  let mut x558: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x557, &mut x558, x7, 0xceec73d2);
  let mut x559: u32 = 0;
  let mut x560: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x559, &mut x560, x7, 0x17f5be65);
  let mut x561: u32 = 0;
  let mut x562: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x561, &mut x562, x7, 0xd00e1ba7);
  let mut x563: u32 = 0;
  let mut x564: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x563, &mut x564, x7, 0x68859347);
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x565, &mut x566, x7, 0xa40611e3);
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x567, &mut x568, x7, 0x449c0f01);
  let mut x569: u32 = 0;
  let mut x570: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x569, &mut x570, 0x0, x568, x565);
  let mut x571: u32 = 0;
  let mut x572: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x571, &mut x572, x570, x566, x563);
  let mut x573: u32 = 0;
  let mut x574: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x573, &mut x574, x572, x564, x561);
  let mut x575: u32 = 0;
  let mut x576: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x575, &mut x576, x574, x562, x559);
  let mut x577: u32 = 0;
  let mut x578: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x577, &mut x578, x576, x560, x557);
  let mut x579: u32 = 0;
  let mut x580: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x579, &mut x580, x578, x558, x555);
  let mut x581: u32 = 0;
  let mut x582: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x581, &mut x582, x580, x556, x553);
  let mut x583: u32 = 0;
  let mut x584: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x583, &mut x584, 0x0, x539, x567);
  let mut x585: u32 = 0;
  let mut x586: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x585, &mut x586, x584, x541, x569);
  let mut x587: u32 = 0;
  let mut x588: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x587, &mut x588, x586, x543, x571);
  let mut x589: u32 = 0;
  let mut x590: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x589, &mut x590, x588, x545, x573);
  let mut x591: u32 = 0;
  let mut x592: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x591, &mut x592, x590, x547, x575);
  let mut x593: u32 = 0;
  let mut x594: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x593, &mut x594, x592, x549, x577);
  let mut x595: u32 = 0;
  let mut x596: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x595, &mut x596, x594, x551, x579);
  let mut x597: u32 = 0;
  let mut x598: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x597, &mut x598, x596, (((x552 as u32) + ((x518 as u32) + ((x502 as u32) + x474))) + x522), x581);
  let mut x599: u32 = 0;
  let mut x600: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x599, &mut x600, x583, 0x12547e1b);
  let mut x601: u32 = 0;
  let mut x602: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x601, &mut x602, x599, 0x10000000);
  let mut x603: u32 = 0;
  let mut x604: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x603, &mut x604, x599, 0x14def9de);
  let mut x605: u32 = 0;
  let mut x606: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x605, &mut x606, x599, 0xa2f79cd6);
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x607, &mut x608, x599, 0x5812631a);
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_25519_scalar_mulx_u32(&mut x609, &mut x610, x599, 0x5cf5d3ed);
  let mut x611: u32 = 0;
  let mut x612: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x611, &mut x612, 0x0, x610, x607);
  let mut x613: u32 = 0;
  let mut x614: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x613, &mut x614, x612, x608, x605);
  let mut x615: u32 = 0;
  let mut x616: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x615, &mut x616, x614, x606, x603);
  let mut x617: u32 = 0;
  let mut x618: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x617, &mut x618, 0x0, x583, x609);
  let mut x619: u32 = 0;
  let mut x620: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x619, &mut x620, x618, x585, x611);
  let mut x621: u32 = 0;
  let mut x622: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x621, &mut x622, x620, x587, x613);
  let mut x623: u32 = 0;
  let mut x624: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x623, &mut x624, x622, x589, x615);
  let mut x625: u32 = 0;
  let mut x626: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x625, &mut x626, x624, x591, ((x616 as u32) + x604));
  let mut x627: u32 = 0;
  let mut x628: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x627, &mut x628, x626, x593, (0x0 as u32));
  let mut x629: u32 = 0;
  let mut x630: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x629, &mut x630, x628, x595, (0x0 as u32));
  let mut x631: u32 = 0;
  let mut x632: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x631, &mut x632, x630, x597, x601);
  let x633: u32 = (((x632 as u32) + ((x598 as u32) + ((x582 as u32) + x554))) + x602);
  let mut x634: u32 = 0;
  let mut x635: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x634, &mut x635, 0x0, x619, 0x5cf5d3ed);
  let mut x636: u32 = 0;
  let mut x637: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x636, &mut x637, x635, x621, 0x5812631a);
  let mut x638: u32 = 0;
  let mut x639: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x638, &mut x639, x637, x623, 0xa2f79cd6);
  let mut x640: u32 = 0;
  let mut x641: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x640, &mut x641, x639, x625, 0x14def9de);
  let mut x642: u32 = 0;
  let mut x643: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x642, &mut x643, x641, x627, (0x0 as u32));
  let mut x644: u32 = 0;
  let mut x645: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x644, &mut x645, x643, x629, (0x0 as u32));
  let mut x646: u32 = 0;
  let mut x647: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x646, &mut x647, x645, x631, (0x0 as u32));
  let mut x648: u32 = 0;
  let mut x649: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x648, &mut x649, x647, x633, 0x10000000);
  let mut x650: u32 = 0;
  let mut x651: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x650, &mut x651, x649, (0x0 as u32), (0x0 as u32));
  let mut x652: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x652, x651, x634, x619);
  let mut x653: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x653, x651, x636, x621);
  let mut x654: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x654, x651, x638, x623);
  let mut x655: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x655, x651, x640, x625);
  let mut x656: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x656, x651, x642, x627);
  let mut x657: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x657, x651, x644, x629);
  let mut x658: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x658, x651, x646, x631);
  let mut x659: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x659, x651, x648, x633);
  out1[0] = x652;
  out1[1] = x653;
  out1[2] = x654;
  out1[3] = x655;
  out1[4] = x656;
  out1[5] = x657;
  out1[6] = x658;
  out1[7] = x659;
}

/// The function fiat_25519_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_25519_scalar_nonzero(out1: &mut u32, arg1: &[u32; 8]) -> () {
  let x1: u32 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (arg1[7]))))))));
  *out1 = x1;
}

/// The function fiat_25519_scalar_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_25519_scalar_selectznz(out1: &mut [u32; 8], arg1: fiat_25519_scalar_u1, arg2: &[u32; 8], arg3: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_25519_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0x1fffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1f]]
#[inline]
pub fn fiat_25519_scalar_to_bytes(out1: &mut [u8; 32], arg1: &[u32; 8]) -> () {
  let x1: u32 = (arg1[7]);
  let x2: u32 = (arg1[6]);
  let x3: u32 = (arg1[5]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[3]);
  let x6: u32 = (arg1[2]);
  let x7: u32 = (arg1[1]);
  let x8: u32 = (arg1[0]);
  let x9: u8 = ((x8 & (0xff as u32)) as u8);
  let x10: u32 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u32)) as u8);
  let x12: u32 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u32)) as u8);
  let x14: u8 = ((x12 >> 8) as u8);
  let x15: u8 = ((x7 & (0xff as u32)) as u8);
  let x16: u32 = (x7 >> 8);
  let x17: u8 = ((x16 & (0xff as u32)) as u8);
  let x18: u32 = (x16 >> 8);
  let x19: u8 = ((x18 & (0xff as u32)) as u8);
  let x20: u8 = ((x18 >> 8) as u8);
  let x21: u8 = ((x6 & (0xff as u32)) as u8);
  let x22: u32 = (x6 >> 8);
  let x23: u8 = ((x22 & (0xff as u32)) as u8);
  let x24: u32 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u32)) as u8);
  let x26: u8 = ((x24 >> 8) as u8);
  let x27: u8 = ((x5 & (0xff as u32)) as u8);
  let x28: u32 = (x5 >> 8);
  let x29: u8 = ((x28 & (0xff as u32)) as u8);
  let x30: u32 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u32)) as u8);
  let x32: u8 = ((x30 >> 8) as u8);
  let x33: u8 = ((x4 & (0xff as u32)) as u8);
  let x34: u32 = (x4 >> 8);
  let x35: u8 = ((x34 & (0xff as u32)) as u8);
  let x36: u32 = (x34 >> 8);
  let x37: u8 = ((x36 & (0xff as u32)) as u8);
  let x38: u8 = ((x36 >> 8) as u8);
  let x39: u8 = ((x3 & (0xff as u32)) as u8);
  let x40: u32 = (x3 >> 8);
  let x41: u8 = ((x40 & (0xff as u32)) as u8);
  let x42: u32 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u32)) as u8);
  let x44: u8 = ((x42 >> 8) as u8);
  let x45: u8 = ((x2 & (0xff as u32)) as u8);
  let x46: u32 = (x2 >> 8);
  let x47: u8 = ((x46 & (0xff as u32)) as u8);
  let x48: u32 = (x46 >> 8);
  let x49: u8 = ((x48 & (0xff as u32)) as u8);
  let x50: u8 = ((x48 >> 8) as u8);
  let x51: u8 = ((x1 & (0xff as u32)) as u8);
  let x52: u32 = (x1 >> 8);
  let x53: u8 = ((x52 & (0xff as u32)) as u8);
  let x54: u32 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u32)) as u8);
  let x56: u8 = ((x54 >> 8) as u8);
  out1[0] = x9;
  out1[1] = x11;
  out1[2] = x13;
  out1[3] = x14;
  out1[4] = x15;
  out1[5] = x17;
  out1[6] = x19;
  out1[7] = x20;
  out1[8] = x21;
  out1[9] = x23;
  out1[10] = x25;
  out1[11] = x26;
  out1[12] = x27;
  out1[13] = x29;
  out1[14] = x31;
  out1[15] = x32;
  out1[16] = x33;
  out1[17] = x35;
  out1[18] = x37;
  out1[19] = x38;
  out1[20] = x39;
  out1[21] = x41;
  out1[22] = x43;
  out1[23] = x44;
  out1[24] = x45;
  out1[25] = x47;
  out1[26] = x49;
  out1[27] = x50;
  out1[28] = x51;
  out1[29] = x53;
  out1[30] = x55;
  out1[31] = x56;
}

/// The function fiat_25519_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1f]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0x1fffffff]]
#[inline]
pub fn fiat_25519_scalar_from_bytes(out1: &mut [u32; 8], arg1: &[u8; 32]) -> () {
  let x1: u32 = (((arg1[31]) as u32) << 24);
  let x2: u32 = (((arg1[30]) as u32) << 16);
  let x3: u32 = (((arg1[29]) as u32) << 8);
  let x4: u8 = (arg1[28]);
  let x5: u32 = (((arg1[27]) as u32) << 24);
  let x6: u32 = (((arg1[26]) as u32) << 16);
  let x7: u32 = (((arg1[25]) as u32) << 8);
  let x8: u8 = (arg1[24]);
  let x9: u32 = (((arg1[23]) as u32) << 24);
  let x10: u32 = (((arg1[22]) as u32) << 16);
  let x11: u32 = (((arg1[21]) as u32) << 8);
  let x12: u8 = (arg1[20]);
  let x13: u32 = (((arg1[19]) as u32) << 24);
  let x14: u32 = (((arg1[18]) as u32) << 16);
  let x15: u32 = (((arg1[17]) as u32) << 8);
  let x16: u8 = (arg1[16]);
  let x17: u32 = (((arg1[15]) as u32) << 24);
  let x18: u32 = (((arg1[14]) as u32) << 16);
  let x19: u32 = (((arg1[13]) as u32) << 8);
  let x20: u8 = (arg1[12]);
  let x21: u32 = (((arg1[11]) as u32) << 24);
  let x22: u32 = (((arg1[10]) as u32) << 16);
  let x23: u32 = (((arg1[9]) as u32) << 8);
  let x24: u8 = (arg1[8]);
  let x25: u32 = (((arg1[7]) as u32) << 24);
  let x26: u32 = (((arg1[6]) as u32) << 16);
  let x27: u32 = (((arg1[5]) as u32) << 8);
  let x28: u8 = (arg1[4]);
  let x29: u32 = (((arg1[3]) as u32) << 24);
  let x30: u32 = (((arg1[2]) as u32) << 16);
  let x31: u32 = (((arg1[1]) as u32) << 8);
  let x32: u8 = (arg1[0]);
  let x33: u32 = (x31 + (x32 as u32));
  let x34: u32 = (x30 + x33);
  let x35: u32 = (x29 + x34);
  let x36: u32 = (x27 + (x28 as u32));
  let x37: u32 = (x26 + x36);
  let x38: u32 = (x25 + x37);
  let x39: u32 = (x23 + (x24 as u32));
  let x40: u32 = (x22 + x39);
  let x41: u32 = (x21 + x40);
  let x42: u32 = (x19 + (x20 as u32));
  let x43: u32 = (x18 + x42);
  let x44: u32 = (x17 + x43);
  let x45: u32 = (x15 + (x16 as u32));
  let x46: u32 = (x14 + x45);
  let x47: u32 = (x13 + x46);
  let x48: u32 = (x11 + (x12 as u32));
  let x49: u32 = (x10 + x48);
  let x50: u32 = (x9 + x49);
  let x51: u32 = (x7 + (x8 as u32));
  let x52: u32 = (x6 + x51);
  let x53: u32 = (x5 + x52);
  let x54: u32 = (x3 + (x4 as u32));
  let x55: u32 = (x2 + x54);
  let x56: u32 = (x1 + x55);
  out1[0] = x35;
  out1[1] = x38;
  out1[2] = x41;
  out1[3] = x44;
  out1[4] = x47;
  out1[5] = x50;
  out1[6] = x53;
  out1[7] = x56;
}

/// The function fiat_25519_scalar_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_set_one(out1: &mut fiat_25519_scalar_montgomery_domain_field_element) -> () {
  out1[0] = 0x8d98951d;
  out1[1] = 0xd6ec3174;
  out1[2] = 0x737dcf70;
  out1[3] = 0xc6ef5bf4;
  out1[4] = 0xfffffffe;
  out1[5] = 0xffffffff;
  out1[6] = 0xffffffff;
  out1[7] = 0xfffffff;
}

/// The function fiat_25519_scalar_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_25519_scalar_msat(out1: &mut [u32; 9]) -> () {
  out1[0] = 0x5cf5d3ed;
  out1[1] = 0x5812631a;
  out1[2] = 0xa2f79cd6;
  out1[3] = 0x14def9de;
  out1[4] = (0x0 as u32);
  out1[5] = (0x0 as u32);
  out1[6] = (0x0 as u32);
  out1[7] = 0x10000000;
  out1[8] = (0x0 as u32);
}

/// The function fiat_25519_scalar_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_25519_scalar_divstep(out1: &mut u32, out2: &mut [u32; 9], out3: &mut [u32; 9], out4: &mut [u32; 8], out5: &mut [u32; 8], arg1: u32, arg2: &[u32; 9], arg3: &[u32; 9], arg4: &[u32; 8], arg5: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u32));
  let x3: fiat_25519_scalar_u1 = (((x1 >> 31) as fiat_25519_scalar_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_25519_scalar_u1));
  let mut x4: u32 = 0;
  let mut x5: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u32));
  let mut x6: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x6, x3, arg1, x4);
  let mut x7: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x14, x3, (arg2[7]), (arg3[7]));
  let mut x15: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x15, x3, (arg2[8]), (arg3[8]));
  let mut x16: u32 = 0;
  let mut x17: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x16, &mut x17, 0x0, (0x1 as u32), (!(arg2[0])));
  let mut x18: u32 = 0;
  let mut x19: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x18, &mut x19, x17, (0x0 as u32), (!(arg2[1])));
  let mut x20: u32 = 0;
  let mut x21: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x20, &mut x21, x19, (0x0 as u32), (!(arg2[2])));
  let mut x22: u32 = 0;
  let mut x23: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), (!(arg2[3])));
  let mut x24: u32 = 0;
  let mut x25: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), (!(arg2[4])));
  let mut x26: u32 = 0;
  let mut x27: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), (!(arg2[5])));
  let mut x28: u32 = 0;
  let mut x29: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), (!(arg2[6])));
  let mut x30: u32 = 0;
  let mut x31: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), (!(arg2[7])));
  let mut x32: u32 = 0;
  let mut x33: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), (!(arg2[8])));
  let mut x34: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x34, x3, (arg3[0]), x16);
  let mut x35: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x35, x3, (arg3[1]), x18);
  let mut x36: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x36, x3, (arg3[2]), x20);
  let mut x37: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x37, x3, (arg3[3]), x22);
  let mut x38: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x38, x3, (arg3[4]), x24);
  let mut x39: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x39, x3, (arg3[5]), x26);
  let mut x40: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x40, x3, (arg3[6]), x28);
  let mut x41: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x41, x3, (arg3[7]), x30);
  let mut x42: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x42, x3, (arg3[8]), x32);
  let mut x43: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x43, x3, (arg4[0]), (arg5[0]));
  let mut x44: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x44, x3, (arg4[1]), (arg5[1]));
  let mut x45: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x45, x3, (arg4[2]), (arg5[2]));
  let mut x46: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x46, x3, (arg4[3]), (arg5[3]));
  let mut x47: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x47, x3, (arg4[4]), (arg5[4]));
  let mut x48: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x48, x3, (arg4[5]), (arg5[5]));
  let mut x49: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x49, x3, (arg4[6]), (arg5[6]));
  let mut x50: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x50, x3, (arg4[7]), (arg5[7]));
  let mut x51: u32 = 0;
  let mut x52: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x51, &mut x52, 0x0, x43, x43);
  let mut x53: u32 = 0;
  let mut x54: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x53, &mut x54, x52, x44, x44);
  let mut x55: u32 = 0;
  let mut x56: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x55, &mut x56, x54, x45, x45);
  let mut x57: u32 = 0;
  let mut x58: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x57, &mut x58, x56, x46, x46);
  let mut x59: u32 = 0;
  let mut x60: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x59, &mut x60, x58, x47, x47);
  let mut x61: u32 = 0;
  let mut x62: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x61, &mut x62, x60, x48, x48);
  let mut x63: u32 = 0;
  let mut x64: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x63, &mut x64, x62, x49, x49);
  let mut x65: u32 = 0;
  let mut x66: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x65, &mut x66, x64, x50, x50);
  let mut x67: u32 = 0;
  let mut x68: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x67, &mut x68, 0x0, x51, 0x5cf5d3ed);
  let mut x69: u32 = 0;
  let mut x70: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x69, &mut x70, x68, x53, 0x5812631a);
  let mut x71: u32 = 0;
  let mut x72: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x71, &mut x72, x70, x55, 0xa2f79cd6);
  let mut x73: u32 = 0;
  let mut x74: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x73, &mut x74, x72, x57, 0x14def9de);
  let mut x75: u32 = 0;
  let mut x76: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x75, &mut x76, x74, x59, (0x0 as u32));
  let mut x77: u32 = 0;
  let mut x78: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x77, &mut x78, x76, x61, (0x0 as u32));
  let mut x79: u32 = 0;
  let mut x80: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x79, &mut x80, x78, x63, (0x0 as u32));
  let mut x81: u32 = 0;
  let mut x82: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x81, &mut x82, x80, x65, 0x10000000);
  let mut x83: u32 = 0;
  let mut x84: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x83, &mut x84, x82, (x66 as u32), (0x0 as u32));
  let x85: u32 = (arg4[7]);
  let x86: u32 = (arg4[6]);
  let x87: u32 = (arg4[5]);
  let x88: u32 = (arg4[4]);
  let x89: u32 = (arg4[3]);
  let x90: u32 = (arg4[2]);
  let x91: u32 = (arg4[1]);
  let x92: u32 = (arg4[0]);
  let mut x93: u32 = 0;
  let mut x94: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x93, &mut x94, 0x0, (0x0 as u32), x92);
  let mut x95: u32 = 0;
  let mut x96: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x95, &mut x96, x94, (0x0 as u32), x91);
  let mut x97: u32 = 0;
  let mut x98: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x97, &mut x98, x96, (0x0 as u32), x90);
  let mut x99: u32 = 0;
  let mut x100: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x99, &mut x100, x98, (0x0 as u32), x89);
  let mut x101: u32 = 0;
  let mut x102: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x101, &mut x102, x100, (0x0 as u32), x88);
  let mut x103: u32 = 0;
  let mut x104: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x103, &mut x104, x102, (0x0 as u32), x87);
  let mut x105: u32 = 0;
  let mut x106: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x105, &mut x106, x104, (0x0 as u32), x86);
  let mut x107: u32 = 0;
  let mut x108: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x107, &mut x108, x106, (0x0 as u32), x85);
  let mut x109: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x109, x108, (0x0 as u32), 0xffffffff);
  let mut x110: u32 = 0;
  let mut x111: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x110, &mut x111, 0x0, x93, (x109 & 0x5cf5d3ed));
  let mut x112: u32 = 0;
  let mut x113: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x112, &mut x113, x111, x95, (x109 & 0x5812631a));
  let mut x114: u32 = 0;
  let mut x115: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x114, &mut x115, x113, x97, (x109 & 0xa2f79cd6));
  let mut x116: u32 = 0;
  let mut x117: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x116, &mut x117, x115, x99, (x109 & 0x14def9de));
  let mut x118: u32 = 0;
  let mut x119: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x118, &mut x119, x117, x101, (0x0 as u32));
  let mut x120: u32 = 0;
  let mut x121: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x120, &mut x121, x119, x103, (0x0 as u32));
  let mut x122: u32 = 0;
  let mut x123: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x122, &mut x123, x121, x105, (0x0 as u32));
  let mut x124: u32 = 0;
  let mut x125: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x124, &mut x125, x123, x107, (x109 & 0x10000000));
  let mut x126: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x126, x3, (arg5[0]), x110);
  let mut x127: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x127, x3, (arg5[1]), x112);
  let mut x128: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x128, x3, (arg5[2]), x114);
  let mut x129: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x129, x3, (arg5[3]), x116);
  let mut x130: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x130, x3, (arg5[4]), x118);
  let mut x131: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x131, x3, (arg5[5]), x120);
  let mut x132: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x132, x3, (arg5[6]), x122);
  let mut x133: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x133, x3, (arg5[7]), x124);
  let x134: fiat_25519_scalar_u1 = ((x34 & (0x1 as u32)) as fiat_25519_scalar_u1);
  let mut x135: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x135, x134, (0x0 as u32), x7);
  let mut x136: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x136, x134, (0x0 as u32), x8);
  let mut x137: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x137, x134, (0x0 as u32), x9);
  let mut x138: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x138, x134, (0x0 as u32), x10);
  let mut x139: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x139, x134, (0x0 as u32), x11);
  let mut x140: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x140, x134, (0x0 as u32), x12);
  let mut x141: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x141, x134, (0x0 as u32), x13);
  let mut x142: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x142, x134, (0x0 as u32), x14);
  let mut x143: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x143, x134, (0x0 as u32), x15);
  let mut x144: u32 = 0;
  let mut x145: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x144, &mut x145, 0x0, x34, x135);
  let mut x146: u32 = 0;
  let mut x147: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x146, &mut x147, x145, x35, x136);
  let mut x148: u32 = 0;
  let mut x149: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x148, &mut x149, x147, x36, x137);
  let mut x150: u32 = 0;
  let mut x151: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x150, &mut x151, x149, x37, x138);
  let mut x152: u32 = 0;
  let mut x153: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x152, &mut x153, x151, x38, x139);
  let mut x154: u32 = 0;
  let mut x155: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x154, &mut x155, x153, x39, x140);
  let mut x156: u32 = 0;
  let mut x157: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x156, &mut x157, x155, x40, x141);
  let mut x158: u32 = 0;
  let mut x159: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x158, &mut x159, x157, x41, x142);
  let mut x160: u32 = 0;
  let mut x161: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x160, &mut x161, x159, x42, x143);
  let mut x162: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x162, x134, (0x0 as u32), x43);
  let mut x163: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x163, x134, (0x0 as u32), x44);
  let mut x164: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x164, x134, (0x0 as u32), x45);
  let mut x165: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x165, x134, (0x0 as u32), x46);
  let mut x166: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x166, x134, (0x0 as u32), x47);
  let mut x167: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x167, x134, (0x0 as u32), x48);
  let mut x168: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x168, x134, (0x0 as u32), x49);
  let mut x169: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x169, x134, (0x0 as u32), x50);
  let mut x170: u32 = 0;
  let mut x171: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x170, &mut x171, 0x0, x126, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x172, &mut x173, x171, x127, x163);
  let mut x174: u32 = 0;
  let mut x175: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x174, &mut x175, x173, x128, x164);
  let mut x176: u32 = 0;
  let mut x177: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x176, &mut x177, x175, x129, x165);
  let mut x178: u32 = 0;
  let mut x179: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x178, &mut x179, x177, x130, x166);
  let mut x180: u32 = 0;
  let mut x181: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x180, &mut x181, x179, x131, x167);
  let mut x182: u32 = 0;
  let mut x183: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x182, &mut x183, x181, x132, x168);
  let mut x184: u32 = 0;
  let mut x185: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x184, &mut x185, x183, x133, x169);
  let mut x186: u32 = 0;
  let mut x187: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x186, &mut x187, 0x0, x170, 0x5cf5d3ed);
  let mut x188: u32 = 0;
  let mut x189: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x188, &mut x189, x187, x172, 0x5812631a);
  let mut x190: u32 = 0;
  let mut x191: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x190, &mut x191, x189, x174, 0xa2f79cd6);
  let mut x192: u32 = 0;
  let mut x193: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x192, &mut x193, x191, x176, 0x14def9de);
  let mut x194: u32 = 0;
  let mut x195: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x194, &mut x195, x193, x178, (0x0 as u32));
  let mut x196: u32 = 0;
  let mut x197: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x196, &mut x197, x195, x180, (0x0 as u32));
  let mut x198: u32 = 0;
  let mut x199: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x198, &mut x199, x197, x182, (0x0 as u32));
  let mut x200: u32 = 0;
  let mut x201: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x200, &mut x201, x199, x184, 0x10000000);
  let mut x202: u32 = 0;
  let mut x203: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_subborrowx_u32(&mut x202, &mut x203, x201, (x185 as u32), (0x0 as u32));
  let mut x204: u32 = 0;
  let mut x205: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u32(&mut x204, &mut x205, 0x0, x6, (0x1 as u32));
  let x206: u32 = ((x144 >> 1) | ((x146 << 31) & 0xffffffff));
  let x207: u32 = ((x146 >> 1) | ((x148 << 31) & 0xffffffff));
  let x208: u32 = ((x148 >> 1) | ((x150 << 31) & 0xffffffff));
  let x209: u32 = ((x150 >> 1) | ((x152 << 31) & 0xffffffff));
  let x210: u32 = ((x152 >> 1) | ((x154 << 31) & 0xffffffff));
  let x211: u32 = ((x154 >> 1) | ((x156 << 31) & 0xffffffff));
  let x212: u32 = ((x156 >> 1) | ((x158 << 31) & 0xffffffff));
  let x213: u32 = ((x158 >> 1) | ((x160 << 31) & 0xffffffff));
  let x214: u32 = ((x160 & 0x80000000) | (x160 >> 1));
  let mut x215: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x215, x84, x67, x51);
  let mut x216: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x216, x84, x69, x53);
  let mut x217: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x217, x84, x71, x55);
  let mut x218: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x218, x84, x73, x57);
  let mut x219: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x219, x84, x75, x59);
  let mut x220: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x220, x84, x77, x61);
  let mut x221: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x221, x84, x79, x63);
  let mut x222: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x222, x84, x81, x65);
  let mut x223: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x223, x203, x186, x170);
  let mut x224: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x224, x203, x188, x172);
  let mut x225: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x225, x203, x190, x174);
  let mut x226: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x226, x203, x192, x176);
  let mut x227: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x227, x203, x194, x178);
  let mut x228: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x228, x203, x196, x180);
  let mut x229: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x229, x203, x198, x182);
  let mut x230: u32 = 0;
  fiat_25519_scalar_cmovznz_u32(&mut x230, x203, x200, x184);
  *out1 = x204;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out3[0] = x206;
  out3[1] = x207;
  out3[2] = x208;
  out3[3] = x209;
  out3[4] = x210;
  out3[5] = x211;
  out3[6] = x212;
  out3[7] = x213;
  out3[8] = x214;
  out4[0] = x215;
  out4[1] = x216;
  out4[2] = x217;
  out4[3] = x218;
  out4[4] = x219;
  out4[5] = x220;
  out4[6] = x221;
  out4[7] = x222;
  out5[0] = x223;
  out5[1] = x224;
  out5[2] = x225;
  out5[3] = x226;
  out5[4] = x227;
  out5[5] = x228;
  out5[6] = x229;
  out5[7] = x230;
}

/// The function fiat_25519_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_25519_scalar_divstep_precomp(out1: &mut [u32; 8]) -> () {
  out1[0] = 0x36a7cb92;
  out1[1] = 0xd70af844;
  out1[2] = 0xb0b8b159;
  out1[3] = 0x5f71c978;
  out1[4] = 0x74947f1a;
  out1[5] = 0xe76d8169;
  out1[6] = 0xf193e4ff;
  out1[7] = 0x19a2d36;
}
