# Jekyll Feed plugin

A Jekyll plugin to generate an Atom (RSS-like) feed of your Jekyll posts

[![Build Status](https://travis-ci.org/jekyll/jekyll-feed.svg)](https://travis-ci.org/jekyll/jekyll-feed) [![Gem Version](https://badge.fury.io/rb/jekyll-feed.svg)](http://badge.fury.io/rb/jekyll-feed)

## Installation

Add this line to your site's Gemfile:

```ruby
gem 'jekyll-feed'
```

And then add this line to your site's `_config.yml`:

```yml
gems:
  - jekyll-feed
```

## Usage

The plugin will automatically generate an Atom feed at `/feed.xml`.

### Optional configuration options

The plugin will automatically use any of the following configuration variables, if they are present in your site's `_config.yml` file.

* `name` - The title of the site, e.g., "My awesome site"
* `description` - A longer description of what your site is about, e.g., "Where I blog about Jekyll and other awesome things"
* `url` - The URL to your site, e.g., `http://example.com`. If none is provided, the plugin will try to use `site.github.url`.
* `author` - Your name, e.g., "Dr. Jekyll." This can be a string (with the author's name), or an object with the following properties:
  - `name` - **Required** Display name of the author
  - `email` - Email address of the author
  - `uri` - Webpage where more information about the author can be found

### Already have a feed path?

Do you already have an existing feed someplace other than `/feed.xml`, but are on a host like GitHub Pages that doesn't support machine-friendly redirects? If you simply swap out `jekyll-feed` for your existing template, your existing subscribers won't continue to get updates. Instead, you can specify a non-default path via your site's config.

```yml
feed:
  path: atom.xml
```

To note, you shouldn't have to do this unless you already have a feed you're using, and you can't or wish not to redirect existing subscribers.

### Optional front matter

The plugin will use the following post metadata, automatically generated by Jekyll, which you can override via a post's YAML front matter:

* `date`
* `title`
* `excerpt`
* `id`
* `category`
* `tags`

Additionally, the plugin will use the following values, if present in a post's YAML front matter:

* `author` - The author of the post, e.g., "Dr. Jekyll". If none is given, feed readers will look to the feed author as defined in `_config.yml`. Like the feed author, this can also be an object.

### Meta tags

The plugin exposes a helper tag to expose the appropriate meta tags to support automated discovery of your feed. Simply place `{% feed_meta %}` someplace in your template's `<head>` section, to output the necessary metadata.

## Why Atom, and not RSS?

Great question. In short, Atom is a better format. Think of it like RSS 3.0. For more information, see [this discussion on why we chose Atom over RSS 2.0](https://github.com/jekyll/jekyll-rss-feed/issues/2).

## Contributing

1. Fork it (https://github.com/jekyll/jekyll-feed/fork)
2. Create your feature branch (`git checkout -b my-new-feature`)
3. Commit your changes (`git commit -am 'Add some feature'`)
4. Push to the branch (`git push origin my-new-feature`)
5. Create a new Pull Request
