/* 
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 2 of the License, or 
*  (at your option) any later version. 
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _SEARCH_VIEW_H__
#define _SEARCH_VIEW_H__


#include <glib.h>
#include <gtk/gtk.h>

#include "libral.h"
#include "view.h"

G_BEGIN_DECLS


#define RUBRICA_SEARCH_VIEW_TYPE           (rubrica_search_view_get_type())

#define RUBRICA_SEARCH_VIEW(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),\
                                            RUBRICA_SEARCH_VIEW_TYPE,        \
                                            RubricaSearchView))

#define RUBRICA_SEARCH_VIEW_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),  \
                                            RUBRICA_SEARCH_VIEW_TYPE,       \
                                            RubricaSearchViewClass))

#define IS_RUBRICA_SEARCH_VIEW(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),\
                                            RUBRICA_SEARCH_VIEW_TYPE))

#define IS_RUBRICA_SEARCH_VIEW_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls), \
                                            RUBRICA_SEARCH_VIEW_TYPE))

#define RUBRICA_SEARCH_VIEW_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls), \
                                            RUBRICA_SEARCH_VIEW_TYPE,       \
                                            RubricaSearchViewClass)


typedef enum {
  SEARCH_ID_COLUMN = 0,
  SEARCH_CARD_COLUMN,
  SEARCH_BOOK_COLUMN,
  LAST_SEARCH_COLUMN
} RubricaSearchColumnType;


typedef struct _RubricaSearchView        RubricaSearchView;
typedef struct _RubricaSearchViewClass   RubricaSearchViewClass;
typedef struct _RubricaSearchViewPrivate RubricaSearchViewPrivate;


struct _RubricaSearchView 
{
  RubricaView parent;
  
  RubricaSearchViewPrivate* priv;
};


struct _RubricaSearchViewClass
{
  RubricaViewClass parent_class;  
};


GType         rubrica_search_view_get_type        (void);


GtkWidget*    rubrica_search_view_new             (void);
void          rubrica_search_view_free            (RubricaSearchView* view);

void          rubrica_search_view_set_addressbook (RubricaSearchView* view, 
						   RAbook *book);
void          rubrica_search_view_display_results (RubricaSearchView* view,
						   GList* results);


G_END_DECLS

#endif
