/*
*  RAL -- Rubrica Addressbook Library
*  file: types.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <glib.h>

#include "lookup.h"


gchar* 
r_lookup_table_enum2str (RLookupTable *table, gint value)
{
  return table[value].str;
}


gint   
r_lookup_table_str2enum (RLookupTable *table, gchar* str)
{
  gint i=0;
  
  for (; table[i].str; i++)
    {
      if (g_ascii_strcasecmp(str, table[i].str) == 0)
	break;
    }
  
  return table[i].val;
}

gchar* 
r_lookup_table_str2lbl  (RLookupTable *table, gchar* str)
{
  gint i=0;
  
  for (; table[i].str; i++)
    {
      if (g_ascii_strcasecmp(str, table[i].str) == 0)
	break;
    }
  
  return table[i].lbl;  
}


gchar* 
r_lookup_table_enum2lbl (RLookupTable *table, gint value)
{
  return table[value].lbl;
}


gint   
r_lookup_table_get_pair_left (RPairTable *table, gint item)
{
  gint i = 0;

  for (; table[i].str; i++)
    {
      if (table[i].right == item)
	break;
    }
  
  return table[i].left;
}



gint   
r_lookup_table_get_pair_right (RPairTable *table, gint item)
{
  gint i = 0;

  for (; table[i].str; i++)
    {
      if (table[i].left == item)
	break;
    }
  
  return table[i].right;
}

gchar* 
r_lookup_table_pair2str (RPairTable *table, gint item)
{
  return table[item].str;
}
