# ifndef _SKIT_COLOR_H
# define _SKIT_COLOR_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// COLOR: Define a color table
//        output in Postscript format
// 
// author: Pierre.Saramito@imag.fr
//
// date: 30 january 1997
//
# include "rheolef/skitbase.h"
namespace rheolef { 

struct color {
	Float r, g, b;
};
class palette {

        int first;
        int last;
        int medium;
        
	Float percent_green;
        int green_size;
        int fist_green;
        int last_green;

	Float min_;
	Float max_;
  public:
        palette() {}
        palette(Float min1, Float max1, int n, Float percent_green_default = 15.0);

	// index -> color
        Float red  (int i);
        Float green(int i);
        Float blue (int i);
	color  rgb  (int i);

	// value -> color
        int    color_index(Float x);
        color  rgb        (Float x);

	void postscript_print_color_def (std::ostream& s);
};
}// namespace rheolef
# endif /* _SKIT_COLOR_H */
