/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/


static char sccsid[] =
"$Id: log.c,v 1.10 1999/06/23 23:40:39 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";

#include	<stdio.h>
#include	<syslog.h>
#include	<time.h>
#include	<stdarg.h>
#include	<sys/types.h>

extern char	*radius_log;
extern char	*progname;

void		log_msg();

/*************************************************************************
 *
 *	Function: log_err
 *
 *	Purpose: Log the error message
 *
 *************************************************************************/

void
log_err(char * fmt, ...)
{
	va_list	args;

	va_start(args, fmt);
	log_msg(LOG_ERR, fmt, args);
	va_end(args);
}

/*************************************************************************
 *
 *	Function: log_debug
 *
 *	Purpose: Log the debug message
 *
 *************************************************************************/

void
log_debug(char * fmt, ...)
{
	va_list	args;
	
	va_start(args, fmt);
	log_msg(LOG_DEBUG, fmt, args);
	va_end(args);
}

/*************************************************************************
 *
 *	Function: log_msg
 *
 *	Purpose: Log the priority message
 *
 *************************************************************************/

void
log_msg(priority, fmt, args)
int priority;
char *fmt;
va_list args;
{
	FILE	*msgfd;
	int	vfprintf();
	pid_t	getpid();
	time_t	time();
	time_t	timeval;
	void	closelog();
	int	fclose();
	int	fflush();
#ifdef	VSYSLOG
	char buffer[1024];
	int	vsprintf();
#else
	void	vsyslog();
#endif /* VSYSLOG */

	if (radius_log) {
		/*
		 * use users option logfile [-l <logfile>]
		 */
		if((msgfd = fopen(radius_log, "a")) == (FILE *)NULL) {
			fprintf(stderr, "%s: could not open %s for logging\n",
					progname, radius_log);
			return;
		}
		timeval = time(0);
		fprintf(msgfd, "%-24.24s: [%d] ", ctime(&timeval),(int)getpid());
		vfprintf(msgfd, fmt, args);
		fflush(msgfd);
		fclose(msgfd);
	} else {
		/*
		 * use syslog
		 */
		openlog("radius", LOG_PID | LOG_CONS | LOG_NOWAIT, LOG_AUTH);
#ifdef VSYSLOG
		vsprintf(buffer, fmt, args);
		syslog(priority, buffer);
#else /* not VSYSLOG */
		vsyslog(priority, fmt, args);
#endif /* not VSYSLOG */
		closelog();
	}
	return;
}
