% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec.R
\name{exec}
\alias{exec}
\alias{exec_wait}
\alias{sys}
\alias{exec_background}
\alias{exec_internal}
\alias{exec_status}
\title{Running System Commands}
\usage{
exec_wait(cmd, args = NULL, std_out = stdout(), std_err = stderr(),
  std_in = NULL, timeout = 0)

exec_background(cmd, args = NULL, std_out = TRUE, std_err = TRUE,
  std_in = NULL)

exec_internal(cmd, args = NULL, std_in = NULL, error = TRUE,
  timeout = 0)

exec_status(pid, wait = TRUE)
}
\arguments{
\item{cmd}{the command to run. Either a full path or the name of a program on
the \code{PATH}. On Windows this is automatically converted to a short path using
\link{Sys.which}, unless wrapped in \code{\link[=I]{I()}}.}

\item{args}{character vector of arguments to pass. On Windows these automatically
get quoted using \link{windows_quote}, unless the value is wrapped in \code{\link[=I]{I()}}.}

\item{std_out}{if and where to direct child process \code{STDOUT}. Must be one of
\code{TRUE}, \code{FALSE}, filename, connection object or callback function. See section
on \emph{Output Streams} below for details.}

\item{std_err}{if and where to direct child process \code{STDERR}. Must be one of
\code{TRUE}, \code{FALSE}, filename, connection object or callback function. See section
on \emph{Output Streams} below for details.}

\item{std_in}{file path to map std_in}

\item{timeout}{maximum time in seconds}

\item{error}{automatically raise an error if the exit status is non-zero.}

\item{pid}{integer with a process ID}

\item{wait}{block until the process completes}
}
\value{
\code{exec_background} returns a pid. \code{exec_wait} returns an exit code.
\code{exec_internal} returns a list with exit code, stdout and stderr strings.
}
\description{
Powerful replacements for \link{system2} with support for interruptions, background
tasks and fine grained control over \code{STDOUT} / \code{STDERR} binary or text streams.
}
\details{
Each value within the \code{args} vector will automatically be quoted when needed;
you should not quote arguments yourself. Doing so anyway could lead to the value
being quoted twice on some platforms.

The \code{exec_wait} function runs a system command and waits for the child process
to exit. When the child process completes normally (either success or error) it
returns with the program exit code. Otherwise (if the child process gets aborted)
R raises an error. The R user can interrupt the program by sending SIGINT (press
ESC or CTRL+C) in which case the child process tree is properly terminated.
Output streams \code{STDOUT} and \code{STDERR} are piped back to the parent process and can
be sent to a connection or callback function. See the section on \emph{Output Streams}
below for details.

The \code{exec_background} function starts the program and immediately returns the
PID of the child process. This is useful for running a server daemon or background
process.
Because this is non-blocking, \code{std_out} and \code{std_out} can only be \code{TRUE}/\code{FALSE} or
a file path. The state of the process can be checked with \code{exec_status} which
returns the exit status, or \code{NA} if the process is still running. If \code{wait = TRUE}
then \code{exec_status} blocks until the process completes (but can be interrupted).
The child can be killed with \link[tools:pskill]{tools::pskill}.

The \code{exec_internal} function is a convenience wrapper around \code{exec_wait} which
automatically captures output streams and raises an error if execution fails.
Upon success it returns a list with status code, and raw vectors containing
stdout and stderr data (use \link{as_text} for converting to text).
}
\section{Output Streams}{


The \code{std_out} and \code{std_err} parameters are used to control how output streams
of the child are processed. Possible values for both foreground and background
processes are:
\itemize{
\item \code{TRUE}: print child output in R console
\item \code{FALSE}: suppress output stream
\item \emph{string}: name or path of file to redirect output
}

In addition the \code{exec_wait} function also supports the following \code{std_out} and \code{std_err}
types:
\itemize{
\item \emph{connection} a writable R \link{connection} object such as \link{stdout} or \link{stderr}
\item \emph{function}: callback function with one argument accepting a raw vector (use
\link{as_text} to convert to text).
}

When using \code{exec_background} with \code{std_out = TRUE} or \code{std_err = TRUE} on Windows,
separate threads are used to print output. This works in RStudio and RTerm but
not in RGui because the latter has a custom I/O mechanism. Directing output to a
file is usually the safest option.
}

\examples{
# Run a command (interrupt with CTRL+C)
status <- exec_wait("date")

# Capture std/out
out <- exec_internal("date")
print(out$status)
cat(as_text(out$stdout))

if(nchar(Sys.which("ping"))){

# Run a background process (daemon)
pid <- exec_background("ping", "localhost")

# Kill it after a while
Sys.sleep(2)
tools::pskill(pid)

# Cleans up the zombie proc
exec_status(pid)
rm(pid)
}
}
\seealso{
Base \link{system2} and \link{pipe} provide other methods for running a system
command with output.

Other sys: \code{\link{exec_r}}
}
\concept{sys}
