% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{use_latex_packages}
\alias{use_latex_packages}
\title{Declare LaTeX packages needed by kableExtra}
\usage{
use_latex_packages()
}
\description{
Declares all of the LaTeX packages that
may be used by \code{kableExtra} functions so that they
will be loaded when the document is produced.
}
\details{
When \code{kableExtra} loads, it calls this function if it
detects that \code{knitr} is running and producing
LaTeX output.  However, sometimes \code{kableExtra}
is loaded before \code{knitr} runs, and then these packages
can end up being missed, leading to LaTeX errors such as
"Undefined control sequence."  (See
Github issue #721 for an example.)

Our \code{kbl()} wrapper for \code{knitr::kable()} calls
this function for LaTeX output, so an explicit call
is not necessary.
}
\examples{
use_latex_packages()
}
