% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable-layouts.r
\name{gtable_row}
\alias{gtable_row}
\title{Create a single row gtable.}
\usage{
gtable_row(name, grobs, height = NULL, widths = NULL, z = NULL,
  vp = NULL)
}
\arguments{
\item{name}{a string giving the name of the table. This is used to name
the layout viewport}

\item{grobs}{a single grob or a list of grobs}

\item{height}{a unit vector giving the height of this row}

\item{widths}{a unit vector giving the width of each column}

\item{z}{a numeric vector giving the order in which the grobs should be
plotted.  Use \code{Inf} (the default) to plot above or \code{-Inf}
below all existing grobs. By default positions are on the integers,
giving plenty of room to insert new grobs between existing grobs.}

\item{vp}{a grid viewport object (or NULL).}
}
\value{
A gtable with a single row and the same number of columns as
elements in the grobs list
}
\description{
This function puts grobs in a list side-by-side in a single-row gtable from
left to right witrh the given widths and height.
}
\examples{
library(grid)
a <- rectGrob(gp = gpar(fill = "red"))
b <- circleGrob()
c <- linesGrob()
gt <- gtable_row("demo", list(a, b, c))
gt
plot(gt)
gtable_show_layout(gt)
}
\seealso{
Other gtable construction: \code{\link{gtable_col}},
  \code{\link{gtable_matrix}}, \code{\link{gtable_spacer}},
  \code{\link{gtable}}
}
\concept{gtable construction}
