% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gamma.R
\name{dist_gamma}
\alias{dist_gamma}
\title{The Gamma distribution}
\usage{
dist_gamma(shape, rate)
}
\arguments{
\item{shape}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}
}
\description{
\lifecycle{stable}
}
\details{
Several important distributions are special cases of the Gamma
distribution. When the shape parameter is \code{1}, the Gamma is an
exponential distribution with parameter \eqn{1/\beta}. When the
\eqn{shape = n/2} and \eqn{rate = 1/2}, the Gamma is a equivalent to
a chi squared distribution with n degrees of freedom. Moreover, if
we have \eqn{X_1} is \eqn{Gamma(\alpha_1, \beta)} and
\eqn{X_2} is \eqn{Gamma(\alpha_2, \beta)}, a function of these two variables
of the form \eqn{\frac{X_1}{X_1 + X_2}} \eqn{Beta(\alpha_1, \alpha_2)}.
This last property frequently appears in another distributions, and it
has extensively been used in multivariate methods. More about the Gamma
distribution will be added soon.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a Gamma random variable
with parameters
\code{shape} = \eqn{\alpha} and
\code{rate} = \eqn{\beta}.

\strong{Support}: \eqn{x \in (0, \infty)}

\strong{Mean}: \eqn{\frac{\alpha}{\beta}}

\strong{Variance}: \eqn{\frac{\alpha}{\beta^2}}

\strong{Probability density function (p.m.f)}:

\deqn{
    f(x) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1} e^{-\beta x}
  }{
    f(x) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1} e^{-\beta x}
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    f(x) = \frac{\Gamma(\alpha, \beta x)}{\Gamma{\alpha}}
  }{
    f(x) = \frac{\Gamma(\alpha, \beta x)}{\Gamma{\alpha}}
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \Big(\frac{\beta}{ \beta - t}\Big)^{\alpha}, \thinspace t < \beta
  }{
    E(e^(tX)) = \Big(\frac{\beta}{ \beta - t}\Big)^{\alpha}, \thinspace t < \beta
  }
}
\examples{
dist <- dist_gamma(shape = c(1,2,3,5,9,7.5,0.5), rate = c(0.5,0.5,0.5,1,2,1,1))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:GammaDist]{stats::GammaDist}
}
