% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_tidiers.R
\name{acf_tidiers}
\alias{acf_tidiers}
\alias{tidy.acf}
\title{Tidying method for the acf function}
\usage{
\method{tidy}{acf}(x, ...)
}
\arguments{
\item{x}{acf object}

\item{...}{(not used)}
}
\value{
\code{data.frame} with columns
 \item{lag}{lag values}
 \item{acf}{calucated correlation}
}
\description{
Tidy an "acf" object, which is the output of \code{acf} and the
related \code{pcf} and \code{ccf} functions.
}
\examples{

# acf
result <- acf(lh, plot=FALSE)
tidy(result)

# ccf
result <- ccf(mdeaths, fdeaths, plot=FALSE)
tidy(result)

# pcf
result <- pacf(lh, plot=FALSE)
tidy(result)

# lag plot
library(ggplot2)
result <- tidy(acf(lh, plot=FALSE))
p <- ggplot(result, aes(x=lag, y=acf)) + 
         geom_bar(stat='identity', width=0.1) +
         theme_bw()
p

# with confidence intervals 
conf.level <- 0.95
# from \\code{plot.acf} method
len.data <- length(lh) # same as acf$n.used
conf.int <- qnorm((1 + conf.level) / 2) / sqrt(len.data)
p + geom_hline(yintercept = c(-conf.int, conf.int),
               color='blue', linetype='dashed')

}
