% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpred.R
\name{get_refmodel.brmsfit}
\alias{get_refmodel.brmsfit}
\title{Projection Predictive Variable Selection: Get Reference Model}
\usage{
get_refmodel.brmsfit(object, newdata = NULL, resp = NULL, cvfun = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{cvfun}{Optional cross-validation function
(see \code{\link[projpred:get-refmodel]{get_refmodel}} for details).
If \code{NULL} (the default), \code{cvfun} is defined internally
based on \code{\link{kfold.brmsfit}}.}

\item{...}{Further arguments passed to 
\code{\link[projpred:get-refmodel]{init_refmodel}}.}
}
\value{
A \code{refmodel} object to be used in conjunction with the
  \pkg{projpred} package.
}
\description{
The \code{get_refmodel.brmsfit} method can be used to create the reference
model structure which is needed by the \pkg{projpred} package for performing
a projection predictive variable selection. This method is called
automatically when performing variable selection via
\code{\link[projpred:varsel]{varsel}} or
\code{\link[projpred:cv_varsel]{cv_varsel}}, so you will rarely need to call
it manually yourself.
}
\details{
Note that the \code{extract_model_data} function used internally by
  \code{get_refmodel.brmsfit} ignores arguments \code{wrhs}, \code{orhs}, and
  \code{extract_y}. This is relevant for
  \code{\link[projpred:predict.refmodel]{predict.refmodel}}, for example.
}
\examples{
\dontrun{
# fit a simple model
fit <- brm(count ~ zAge + zBase * Trt,
           data = epilepsy, family = poisson())
summary(fit)

# The following code requires the 'projpred' package to be installed:
library(projpred)

# perform variable selection without cross-validation
vs <- varsel(fit)
summary(vs)
plot(vs)

# perform variable selection with cross-validation
cv_vs <- cv_varsel(fit)
summary(cv_vs)
plot(cv_vs)
}
}
