% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnm.R, R/gnm.pdbs.R
\name{gnm}
\alias{gnm}
\alias{gnm.pdb}
\alias{gnm.pdbs}
\title{Gaussian Network Model}
\usage{
gnm(x, ...)

\method{gnm}{pdb}(x, inds = NULL, temp = 300, keep = NULL,
  outmodes = NULL, gamma = 1, cutoff = 8, check.connect = TRUE, ...)

\method{gnm}{pdbs}(x, fit = TRUE, full = FALSE, subspace = NULL,
  rm.gaps = TRUE, gc.first = TRUE, ncore = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{pdb} as obtained from function \code{\link{read.pdb}}.}

\item{...}{(in \code{gnm.pdbs}) additional arguments passed to \code{gnm.pdb}.}

\item{inds}{atom and xyz coordinate indices obtained from \code{\link{atom.select}} that 
selects the elements of \code{pdb} upon which the calculation should be based. 
If not provided the function will attempt to select all calpha atoms automatically.}

\item{temp}{numerical, temperature for which the amplitudes for scaling the atomic 
displacement vectors are calculated. Set \sQuote{temp=NULL} to avoid scaling.}

\item{keep}{numerical, final number of modes to be stored. Note that all subsequent analyses 
are limited to this subset of modes. This option is useful for very large structures and 
cases where memory may be limited.}

\item{outmodes}{atom indices as obtained from \code{\link{atom.select}} specifying the atoms 
to include in the resulting mode object.}

\item{gamma}{numerical, global scale of the force constant.}

\item{cutoff}{numerical, distance cutoff for pair-wise interactions.}

\item{check.connect}{logical, if TRUE check chain connectivity.}

\item{fit}{logical, if TRUE C-alpha coordinate based superposition is 
performed prior to normal mode calculations.}

\item{full}{logical, if TRUE return the complete, full structure,
\sQuote{nma} objects.}

\item{subspace}{number of eigenvectors to store for further analysis.}

\item{rm.gaps}{logical, if TRUE obtain the hessian matrices for only
atoms in the aligned positions (non-gap positions in all aligned
structures). Thus, gap positions are removed from output.}

\item{gc.first}{logical, if TRUE will call gc() first before mode calculation
for each structure. This is to avoid memory overload when 
\code{ncore > 1}.}

\item{ncore}{number of CPU cores used to do the calculation.}
}
\value{
Returns an object of class \sQuote{gnm} with the following components:
   \item{force.constants}{ numeric vector containing the force constants corresponding 
      to each mode. }
   \item{fluctuations}{ numeric vector of atomic fluctuations. }
   \item{U}{ numeric matrix with columns containing the raw eigenvectors. }
   \item{L}{ numeric vector containing the raw eigenvalues. }
   \item{xyz}{ numeric matrix of class \code{xyz} containing the Cartesian coordinates 
      in which the calculation was performed. }
   \item{temp}{ numerical, temperature for which the amplitudes for scaling the atomic 
      displacement vectors are calculated. }
   \item{triv.modes}{ number of trivial modes. }
   \item{natoms}{ number of C-alpha atoms. }
   \item{call}{ the matched call. }
}
\description{
Perform Gaussian network model (GNM) based normal mode analysis (NMA) for 
a protein structure.
}
\details{
This function builds a Gaussian network model (an isotropic elastic network 
   model) for C-alpha atoms and performs subsequent normal mode analysis (NMA). 
   The model employs a distance cutoff for the network construction: Atom pairs with 
   distance falling  within the cutoff have a harmonic interaction with a uniform force constant; 
   Otherwise atoms have no interaction. Output contains N-1 (N, the number of residues) 
   non-trivial modes (i.e. the degree of freedom is N-1), which can then be used to 
   calculate atomic fluctuations and covariance.
}
\examples{
   ## Fetch stucture
   pdb <- read.pdb( system.file("examples/1hel.pdb", package="bio3d") )
   
   ## Calculate normal modes
   modes <- gnm(pdb)
   
   ## Print modes
   print(modes)
   
   ## Plot modes
   plot(modes)

}
\author{
Xin-Qiu Yao & Lars Skjaerven
}
\references{
Bahar, I. et al. (1997) \emph{Folding Des.} \bold{2}, 173.
}
\seealso{
\code{\link{gnm.pdbs}}
}

