from distutils.core import setup, Extension

module1 = Extension ('chas_rx2',
	libraries = [':_quisk.so', 'm'],
	runtime_library_dirs = ['.'],
	sources = ['chas_rx2.c'],
	include_dirs = ['.', '..'],
	)

setup (
	name = 'charleston',
	version = 1.1,
	description = 'This module adds support for the Charleston RX-1 hardware to QUISK',
	long_description = """This module adds support for the Charleston Rx-1 SDR receiver.
The Rx-1 was designed by Dr. John Schwacke, of MUSC, in Charleston, SC, with
additional support provided by AMRAD, and WB4JFI.  It consists of a Digilent Nexys2
PFGA board with a special A/D module attached.  The A/D includes a preamp with gain
control, a LPF (both bypassable), and a TI AFEDRI8201 DDC chip.  The '8201 consists
of a 12-bit A/D (with a 76.8MHz clock), a frequency converter, a CIC filter, 
followed by two FIR filters.  The output of the '8201 is fed to the FPGA baord, 
which acts as a FIFO buffer and USB interface to the host computer""",
	author = 'Terry Fox',
	author_email = 'tfox@knology.net',
	url='www.amrad.org',
	license = "GPL",
	platforms = ['POSIX'],
	packages = ['charleston'],
	package_dir = {'charleston' : '.'},
	ext_modules = [module1],
	classifiers = [
		'Development Status :: 6 - Mature',
		'Environment :: X11 Applications',
		'Intended Audience :: End Users/Desktop',
		'License :: OSI Approved :: GNU General Public License (GPL)',
		'Natural Language :: English',
		'Operating System :: POSIX',
		'Programming Language :: Python',
		'Programming Language :: C',
		'Topic :: Communications :: Ham Radio',
	],
)
