/*
 * Copyright (C) 2009 Apple Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebGLActiveInfo_h
#define WebGLActiveInfo_h

#include "bindings/core/v8/ScriptWrappable.h"
#include "third_party/khronos/GLES2/gl2.h"

namespace blink {

class WebGLActiveInfo final : public GarbageCollectedFinalized<WebGLActiveInfo>,
                              public ScriptWrappable {
  DEFINE_WRAPPERTYPEINFO();

 public:
  static WebGLActiveInfo* create(const String& name, GLenum type, GLint size) {
    return new WebGLActiveInfo(name, type, size);
  }
  String name() const { return m_name; }
  GLenum type() const { return m_type; }
  GLint size() const { return m_size; }

  DEFINE_INLINE_TRACE() {}

 private:
  WebGLActiveInfo(const String& name, GLenum type, GLint size)
      : m_name(name), m_type(type), m_size(size) {
    ASSERT(name.length());
    ASSERT(type);
    ASSERT(size);
  }
  String m_name;
  GLenum m_type;
  GLint m_size;
};

}  // namespace blink

#endif  // WebGLActiveInfo_h
