#ifndef SPEAKER_H
#define SPEAKER_H
#include <QMetaType>
#include <QDomNode>
#include <QPainter>



class Speaker
{

public:
    Speaker();
    Speaker(const Speaker& copy);
    ~Speaker();

    bool operator!=(const Speaker& r) const;
    bool operator==(const Speaker& r) const;
    bool isValid(void) const;

    void setVendor(const QString& vnd);
    void setModel(const QString& mdl);

    void setFs(double val);
    void setVas(double val);
    void setRe(double val);
    void setQts(double val);
    void setSd(double val);
    void setXmax(double val);

    QString getVendor() const;
    QString getModel() const;

    double getFs(void) const;
    double getVas(void) const;
    double getRe(void) const;
    double getQts(void) const;
    double getSd(void) const;
    double getXmax() const;

    QDomElement toDomElement(QDomDocument& doc) const;
    void fromDomElement(const QDomElement& el);
    void render(QPainter *painter, const QRectF& area);

private:
    QString vendor;
    QString model;

    double fs; // Hz
    double vas; // L
    double re; // Ohm
    double qts; // unitless
    double sd; // m²
    double xmax; // mm
};

Q_DECLARE_METATYPE(Speaker)

#endif // SPEAKER_H
