# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicelinker import ServiceLinkerManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceLinkerManagementLinkersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceLinkerManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_dryrun(self, resource_group):
        response = self.client.linkers.list_dryrun(
            resource_uri="str",
            api_version="2024-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_dryrun(self, resource_group):
        response = self.client.linkers.get_dryrun(
            resource_uri="str",
            dryrun_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_dryrun(self, resource_group):
        response = self.client.linkers.begin_create_dryrun(
            resource_uri="str",
            dryrun_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "operationPreviews": [
                    {"action": "str", "description": "str", "name": "str", "operationType": "str", "scope": "str"}
                ],
                "parameters": "dryrun_parameters",
                "prerequisiteResults": ["dryrun_prerequisite_result"],
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update_dryrun(self, resource_group):
        response = self.client.linkers.begin_update_dryrun(
            resource_uri="str",
            dryrun_name="str",
            parameters={
                "operationPreviews": [
                    {"action": "str", "description": "str", "name": "str", "operationType": "str", "scope": "str"}
                ],
                "parameters": "dryrun_parameters",
                "prerequisiteResults": ["dryrun_prerequisite_result"],
                "provisioningState": "str",
            },
            api_version="2024-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_dryrun(self, resource_group):
        response = self.client.linkers.delete_dryrun(
            resource_uri="str",
            dryrun_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_generate_configurations(self, resource_group):
        response = self.client.linkers.generate_configurations(
            resource_uri="str",
            linker_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_dapr_configurations(self, resource_group):
        response = self.client.linkers.list_dapr_configurations(
            resource_uri="str",
            api_version="2024-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
