# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry.aio import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementTokensOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tokens_list(self, resource_group):
        response = self.client.tokens.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tokens_get(self, resource_group):
        response = await self.client.tokens.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            token_name="str",
            api_version="2025-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tokens_begin_create(self, resource_group):
        response = await (
            await self.client.tokens.begin_create(
                resource_group_name=resource_group.name,
                registry_name="str",
                token_name="str",
                token_create_parameters={
                    "creationDate": "2020-02-20 00:00:00",
                    "credentials": {
                        "certificates": [
                            {
                                "encodedPemCertificate": "str",
                                "expiry": "2020-02-20 00:00:00",
                                "name": "str",
                                "thumbprint": "str",
                            }
                        ],
                        "passwords": [
                            {
                                "creationTime": "2020-02-20 00:00:00",
                                "expiry": "2020-02-20 00:00:00",
                                "name": "str",
                                "value": "str",
                            }
                        ],
                    },
                    "id": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "scopeMapId": "str",
                    "status": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tokens_begin_update(self, resource_group):
        response = await (
            await self.client.tokens.begin_update(
                resource_group_name=resource_group.name,
                registry_name="str",
                token_name="str",
                token_update_parameters={
                    "credentials": {
                        "certificates": [
                            {
                                "encodedPemCertificate": "str",
                                "expiry": "2020-02-20 00:00:00",
                                "name": "str",
                                "thumbprint": "str",
                            }
                        ],
                        "passwords": [
                            {
                                "creationTime": "2020-02-20 00:00:00",
                                "expiry": "2020-02-20 00:00:00",
                                "name": "str",
                                "value": "str",
                            }
                        ],
                    },
                    "scopeMapId": "str",
                    "status": "str",
                },
                api_version="2025-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tokens_begin_delete(self, resource_group):
        response = await (
            await self.client.tokens.begin_delete(
                resource_group_name=resource_group.name,
                registry_name="str",
                token_name="str",
                api_version="2025-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
