///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2014) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/**
 * \file
 * \brief Contains forward declarations of OVITO's core classes and namespaces.
 */

#pragma once


// Sub-namespaces are only used for the documentation generated by Doxygen,
// because current C++ compilers do not fully support C++11 inline namespaces yet.
#define OVITO_BEGIN_INLINE_NAMESPACE(ns)
#define OVITO_END_INLINE_NAMESPACE

namespace Ovito {

	class Application;
	OVITO_BEGIN_INLINE_NAMESPACE(Util)
		OVITO_BEGIN_INLINE_NAMESPACE(IO)
			class FileManager;
			class ObjectSaveStream;
			class ObjectLoadStream;
			class CompressedTextReader;
			class CompressedTextWriter;
			OVITO_BEGIN_INLINE_NAMESPACE(Internal)
				class VideoEncoder;
				class SftpJob;
			OVITO_END_INLINE_NAMESPACE
		OVITO_END_INLINE_NAMESPACE
		OVITO_BEGIN_INLINE_NAMESPACE(Concurrency)
			class TaskManager;
			class AsynchronousTask;
			class SynchronousTask;
		OVITO_END_INLINE_NAMESPACE
		OVITO_BEGIN_INLINE_NAMESPACE(Mesh)
			class TriMesh;
			struct EmptyHalfEdgeMeshStruct;
			template<class EdgeBase = EmptyHalfEdgeMeshStruct, class FaceBase = EmptyHalfEdgeMeshStruct, class VertexBase = EmptyHalfEdgeMeshStruct>
			class HalfEdgeMesh;
		OVITO_END_INLINE_NAMESPACE
		OVITO_BEGIN_INLINE_NAMESPACE(Math)
		OVITO_END_INLINE_NAMESPACE
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(Anim)
		class Controller;
		class AnimationSettings;
		class LookAtController;
		class KeyframeController;
		class PRSTransformationController;
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(PluginSystem)
		class Plugin;
		class PluginManager;
		class AutoStartObject;
		OVITO_BEGIN_INLINE_NAMESPACE(Internal)
			class NativePlugin;
		OVITO_END_INLINE_NAMESPACE
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(ObjectSystem)
		class OvitoObject;
		class OvitoObjectType;
		class CloneHelper;
		class RefMaker;
		class RefTarget;
		class PropertyFieldDescriptor;
		class DataSet;
		class DataSetContainer;
		OVITO_BEGIN_INLINE_NAMESPACE(Units)
			class ParameterUnit;
		OVITO_END_INLINE_NAMESPACE
		OVITO_BEGIN_INLINE_NAMESPACE(Undo)
			class UndoStack;
			class UndoableOperation;
		OVITO_END_INLINE_NAMESPACE
		OVITO_BEGIN_INLINE_NAMESPACE(Scene)
			class SceneNode;
			class CompoundObject;
			class DataObject;
			class SceneRoot;
			class SelectionSet;
			class Modifier;
			class ModifierApplication;
			class ObjectNode;
			class PipelineEvalRequest;
			class PipelineFlowState;
			class PipelineObject;
			class DisplayObject;
			class AsynchronousDisplayObject;
			OVITO_BEGIN_INLINE_NAMESPACE(StdObj)
			OVITO_END_INLINE_NAMESPACE
		OVITO_END_INLINE_NAMESPACE
		OVITO_BEGIN_INLINE_NAMESPACE(Internal)
			class NativeOvitoObjectType;
		OVITO_END_INLINE_NAMESPACE
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(Rendering)
		class SceneRenderer;
		class ObjectPickInfo;
		class RenderSettings;
		class FrameBuffer;
		OVITO_BEGIN_INLINE_NAMESPACE(Internal)
		OVITO_END_INLINE_NAMESPACE
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(View)
		class Viewport;
		class ViewportConfiguration;
		class ViewportSettings;
		struct ViewProjectionParameters;
		class ViewportOverlay;
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(DataIO)
		class FileImporter;
		class FileExporter;
		class FileSource;
		class FileSourceImporter;
	OVITO_END_INLINE_NAMESPACE
	OVITO_BEGIN_INLINE_NAMESPACE(Gui)
		class MainWindow;
	OVITO_END_INLINE_NAMESPACE

	// This should only be visible to Doxygen:
#ifdef ONLY_FOR_DOXYGEN
	using namespace Util;
	using namespace Util::IO;
	using namespace Util::Math;
	using namespace Util::Mesh;
	using namespace Util::Concurrency;
	using namespace Rendering;
	using namespace View;
	using namespace DataIO;
	using namespace Anim;
	using namespace PluginSystem;
	using namespace ObjectSystem;
	using namespace ObjectSystem::Units;
	using namespace ObjectSystem::Undo;
	using namespace ObjectSystem::Scene;
	using namespace ObjectSystem::Scene::StdObj;
#endif
}


